/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* writerperfect
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2006 Ariya Hidayat (ariya@kde.org)
 * Copyright (C) 2006-2007 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

#include <stdio.h>
#include <string.h>

#include <libepubgen/libepubgen.h>

#include <libfreehand/libfreehand.h>

#include "EpubPackage.hxx"
#include "UsageHelper.hxx"

#define TOOLNAME "fh2epub"

class EpubOutputFileHelper
{
public:
	EpubOutputFileHelper(const char *outFileName) :
		m_fileName(outFileName) {}
	~EpubOutputFileHelper() {}

	bool convertDocument(librevenge::RVNGInputStream &input)
	{
		EpubPackage package(m_fileName);
		libepubgen::EPUBDrawingGenerator collector(&package);
		return libfreehand::FreeHandDocument::parse(&input, &collector);
	}
	bool isSupportedFormat(librevenge::RVNGInputStream &input)
	{
		return libfreehand::FreeHandDocument::isSupported(&input);
	}
private:
	const std::string m_fileName;
};

int printUsage(const char *name)
{
	fprintf(stderr, "Usage : %s <infile> <outfile>\n", name);
	fprintf(stderr, "\twhere <infile> is the Freehand source drawing\n");
	fprintf(stderr, "\tand <outfile> is the ePub target document.\n");
	return 1;
}

int main(int argc, char *argv[])
{
	char *szInputFile = 0;
	char *szOutFile = 0;

	for (int i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "--version")==0)
			return UsageHelper::printVersion(TOOLNAME);
		else if (strcmp(argv[i], "--help")==0)
			return printUsage(TOOLNAME);
		else if (!szInputFile && strncmp(argv[i], "--", 2))
			szInputFile = argv[i];
		else if (szInputFile && !szOutFile && strncmp(argv[i], "--", 2))
			szOutFile = argv[i];
		else
			return printUsage(TOOLNAME);
	}

	if (!szInputFile || !szOutFile)
		return printUsage(TOOLNAME);

	EpubOutputFileHelper helper(szOutFile);
	librevenge::RVNGFileStream input(szInputFile);
	if (!helper.isSupportedFormat(input))
	{
		fprintf(stderr, "ERROR: We have no confidence that you are giving us a valid Freehand drawing.\n");
		return 1;
	}

	if (!helper.convertDocument(input))
	{
		fprintf(stderr, "ERROR : Couldn't write convert the document\n");
		return 1;
	}

	return 0;
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
