/* Copyright 2001 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM Time Scale Modification for Audio.

   MFFM Time Scale Modification for Audio is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM Time Scale Modification for Audio is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM Time Scale Modification for Audio
 */
#include <stdlib.h>

#include <mffm/libSndFileWrapper.H>

#include "WSOLA.H"

void exitRoutine(void){std::cout<<std::endl;}

int main(int argc, char *argv[]){

  atexit(exitRoutine);

  std::cout<<"Author : mffm <flatmax@ieee.org>"<<std::endl;

  if (argc<4){
    std::cerr<<"Useage :\n"<<argv[0]<<" inputFile outputFile factor"<<std::endl;
    exit(-1);
  }

  double tau=atof(argv[3]);
  std::cout<<"Factor="<<tau<<std::endl;

  int cnt, fs, channels;
  short int *input=readWav(argv[1], &cnt, &fs, &channels);
  if (channels<1){
    std::cerr<<argv[0]<<":: channels must be more then 1"<<std::endl;
    exit(-1);
  }
  std::cout<<"Processing for "<<channels<<" channels at "<<fs<<" Hz"<<std::endl;

  int windowSize=channels*HANNING_LENGTH(fs);
  WSOLA wsola(windowSize, fs, channels);//Version 2 instantiation
  //  WSOLA wsola(windowSize, fs);//Version 1 instantiation
  //std::cout<<"processing begun"<<std::endl;
  wsola.process(input, channels*cnt, tau);
  //std::cout<<"processing finished"<<std::endl;

  writeWav(argv[2], (int)roundD((double)cnt*tau), &wsola[0], fs, channels, 16);
  std::cout<<"Output written as "<<argv[2]<<std::endl;
  
  delete [] input;
  return 1;
}
