/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "PTTPreferences.h"
#include "SerialPTT.h"

const int NO_PTT = 9999;

const int BORDER_SIZE = 5;

CPTTPreferences::CPTTPreferences(wxWindow* parent, int id, const wxString& type, const wxString& device) :
wxPanel(parent, id),
m_device(NULL)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* deviceSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* label = new wxStaticText(this, -1, wxT("Device"));
	deviceSizer->Add(label, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_RIGHT, BORDER_SIZE);

	m_device = new wxChoice(this, -1, wxDefaultPosition, wxSize(200, -1));

	m_device->Append(wxT("[none]"));
	m_device->SetSelection(0);

	wxArrayString devices = CSerialPTT::getDevices();

	for (unsigned int n = 0; n < devices.GetCount(); n++) {
		wxString dev = devices.Item(n);

		m_device->Append(dev);

		if (type.IsSameAs(wxT("serial"))) {
			if (dev.IsSameAs(device))
				m_device->SetSelection(n + 1);
		}
	}

	deviceSizer->Add(m_device, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(deviceSizer);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CPTTPreferences::~CPTTPreferences()
{
}

wxString CPTTPreferences::getType() const
{
	wxASSERT(m_device != NULL);

	int n = m_device->GetSelection();

	return (n == -1 || n == 0) ? wxT("none") : wxT("serial");
}

wxString CPTTPreferences::getDevice() const
{
	wxASSERT(m_device != NULL);

	int n = m_device->GetSelection();

	if (n == -1 || n == 0)
		return wxEmptyString;

	return CSerialPTT::getDevices().Item(n - 1);
}
