/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef Send_H
#define	Send_H

#include "Thread.h"
#include "SoundDev.h"
#include "PTTPort.h"

class CSend : public CThread {

    public:
	CSend(const wxString& name, ISoundDev* soundDev, CPTTPort* pttPort);
	virtual ~CSend();

	virtual void     setMessage(const wxString& message);
	virtual wxString getMessage() { return m_message; }

	virtual ISoundDev* getSoundDevice() { return m_soundDev; }
	virtual CPTTPort*  getPTTPort()     { return m_pttPort; }

    private:
	ISoundDev* m_soundDev;
	CPTTPort*  m_pttPort;
	wxString   m_message;
};

#endif
