/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Thread.h"
#include "Exception.h"

#include <wx/debug.h>
#include <wx/log.h>

CThread::CThread(const wxString& name) :
wxThread(wxTHREAD_DETACHED),
m_name(name),
m_stopped(true),
m_killed(false),
m_mutex(),
m_condition(NULL)
{
	m_condition = new wxCondition(m_mutex);

	if (!m_condition->IsOk())
		throw CException(wxT("Error initialising wxCondition"));
}

CThread::~CThread()
{
	delete m_condition;
}

void* CThread::Entry()
{
	wxASSERT(m_condition != NULL);

	m_mutex.Lock();

	reset(true);

	while (!m_killed) {
		if (m_stopped) {
			m_condition->Wait();
			m_stopped = false;
		}

		if (m_killed)
			break;

		try {
			run();
		}
		catch (CException& e) {
			error(e.getMessage().c_str());
		}
		catch (...) {
			error(wxT("An exception occured in Thread"));
		}

		reset(false);

		m_stopped = true;
	}

	return NULL;
}

void CThread::start()
{
	wxASSERT(m_condition != NULL);

	if (m_stopped)
		m_condition->Signal();
}

void CThread::stop()
{
	m_stopped = true;
}

void CThread::kill()
{
	m_killed = true;

	start();
}

bool CThread::isStopped() const
{
	return m_stopped;
}

bool CThread::isRunning() const
{
	return !m_stopped;
}

wxString CThread::getName() const
{
	return m_name;
}

void CThread::reset(bool firstTime)
{
}
