/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441LevelGraph.h"

#include "FSK441Defs.h"

BEGIN_EVENT_TABLE(CFSK441LevelGraph, wxWindow)
	EVT_PAINT(CFSK441LevelGraph::onPaint)
END_EVENT_TABLE()

CFSK441LevelGraph::CFSK441LevelGraph(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) :
wxWindow(parent, id, pos, size, style, name),
m_bitmap(NULL)
{
	m_bitmap = new wxBitmap(FSK441_LEVEL_WIDTH, FSK441_GRAPH_HEIGHT);

	// Flood the graph area with black to start with
	clearGraph();
}

CFSK441LevelGraph::~CFSK441LevelGraph()
{
	delete m_bitmap;
}

void CFSK441LevelGraph::addData(CFSK441Levels* levels)
{
	wxASSERT(levels != NULL);

	clearGraph();

	wxMemoryDC memoryDC;
	memoryDC.SelectObject(*m_bitmap);
	memoryDC.BeginDrawing();

	int lastAudioX = 0;
	int lastAudioY = 0;

	for (int x = 0; x < FSK441_LEVEL_WIDTH; x++) {
		double audio = levels->getAudioData(x);

		int yAudio = int(audio * double(FSK441_GRAPH_HEIGHT));

		if (yAudio > FSK441_GRAPH_HEIGHT)
			yAudio = FSK441_GRAPH_HEIGHT - 1;

		int y = FSK441_GRAPH_HEIGHT - yAudio;

		if (x > 0) {
			memoryDC.SetPen(*wxGREEN_PEN);
			memoryDC.DrawLine(lastAudioX, lastAudioY, x, y);
		}

		lastAudioX = x;
		lastAudioY = y;
	}

	memoryDC.EndDrawing();
	memoryDC.SelectObject(wxNullBitmap);

	wxClientDC clientDC(this);
	show(clientDC);
}

void CFSK441LevelGraph::onPaint(wxPaintEvent& event)
{
	wxPaintDC dc(this);

	show(dc);
}

void CFSK441LevelGraph::show(wxDC& dc)
{
	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CFSK441LevelGraph::clearGraph()
{
	// Flood the graph area with black to start with
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);
	dc.BeginDrawing();

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	dc.EndDrawing();
}
