/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44LevelGraph.h"

#include "JT44Defs.h"

BEGIN_EVENT_TABLE(CJT44LevelGraph, wxWindow)
	EVT_PAINT(CJT44LevelGraph::onPaint)
END_EVENT_TABLE()

CJT44LevelGraph::CJT44LevelGraph(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) :
wxWindow(parent, id, pos, size, style, name),
m_bitmap(NULL)
{
	m_bitmap = new wxBitmap(JT44_GRAPH_WIDTH, JT44_GRAPH_HEIGHT);

	// Flood the graph area with black to start with
	clearGraph();
}

CJT44LevelGraph::~CJT44LevelGraph()
{
	delete m_bitmap;
}

void CJT44LevelGraph::addData(CJT44Levels* levels)
{
	wxASSERT(levels != NULL);

	clearGraph();

	wxMemoryDC memoryDC;
	memoryDC.SelectObject(*m_bitmap);
	memoryDC.BeginDrawing();

	int thirdHeight = JT44_GRAPH_HEIGHT / 3;

	int lastDFX = 0,       lastDFY = JT44_GRAPH_HEIGHT - 1 * thirdHeight;
	int lastDtX = 0,       lastDtY = JT44_GRAPH_HEIGHT - 2 * thirdHeight;
	int lastAudioX = 0, lastAudioY = JT44_GRAPH_HEIGHT - 0 * thirdHeight;

	for (int x = 0; x < JT44_GRAPH_WIDTH; x++) {
		if (x > 0 && levels->getDFData(x) > 0.0) {
			double DF = levels->getDFData(x);
			int   yDF = (1 * thirdHeight) + int(DF * double(thirdHeight));

			if (yDF > (2 * thirdHeight))
				yDF = 2 * thirdHeight - 1;

			int y = JT44_GRAPH_HEIGHT - yDF;

			memoryDC.SetPen(*wxRED_PEN);
			memoryDC.DrawLine(lastDFX, lastDFY, x, y);

			lastDFX = x;
			lastDFY = y;
		}

		if (x > 0 && levels->getDtData(x) > 0.0) {
			double Dt = levels->getDtData(x);
			int   yDt = (2 * thirdHeight) + int(Dt * double(thirdHeight));

			if (yDt > (3 * thirdHeight))
				yDt = 3 * thirdHeight - 1;

			int y = JT44_GRAPH_HEIGHT - yDt;

			memoryDC.SetPen(*wxCYAN_PEN);
			memoryDC.DrawLine(lastDtX, lastDtY, x, y);

			lastDtX = x;
			lastDtY = y;
		}

		double audio = levels->getAudioData(x);
		int   yAudio = (0 * thirdHeight) + int(audio * double(thirdHeight));

		if (yAudio > (1 * thirdHeight))
			yAudio = 1 * thirdHeight - 1;

		int y = JT44_GRAPH_HEIGHT - yAudio;

		if (x > 0) {
			memoryDC.SetPen(*wxGREEN_PEN);
			memoryDC.DrawLine(lastAudioX, lastAudioY, x, y);
		}

		lastAudioX = x;
		lastAudioY = y;
	}

	memoryDC.EndDrawing();
	memoryDC.SelectObject(wxNullBitmap);

	wxClientDC clientDC(this);
	show(clientDC);
}

void CJT44LevelGraph::onPaint(wxPaintEvent& event)
{
	wxPaintDC dc(this);

	show(dc);
}

void CJT44LevelGraph::show(wxDC& dc)
{
	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CJT44LevelGraph::clearGraph()
{
	// Flood the graph area with black to start with
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);
	dc.BeginDrawing();

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	dc.EndDrawing();
}
