/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MFrame_H
#define	JT6MFrame_H

#include <wx/wx.h>
#include <wx/listctrl.h>
#include <wx/notebook.h>

#include "common/RecordControl.h"
#include "common/TransmitControl.h"
#include "common/RemoteControl.h"
#include "common/MessageControl.h"
#include "common/LevelEvent.h"
#include "common/ErrorEvent.h"
#include "common/ClockPanel.h"

#include "JT6MLevels.h"
#include "JT6MMessage.h"
#include "JT6MDisplay.h"
#include "JT6MLevelEvent.h"
#include "JT6MMessageEvent.h"

class CJT6MFrame : public wxFrame {
    public:
	CJT6MFrame();
	virtual ~CJT6MFrame();

	virtual void onOpen(const wxCommandEvent& event);
	virtual void onSaving(const wxCommandEvent& event);
	virtual void onDelete(const wxCommandEvent& event);
	virtual void onQuit(const wxCommandEvent& event);
	virtual void onPreferences(const wxCommandEvent& event);
	virtual void onAbout(const wxCommandEvent& event);

	virtual void onRecord(const wxCommandEvent& event);
	virtual void onTXOrder(const wxCommandEvent& event);
	virtual void onTXEnable(const wxCommandEvent& event);
	virtual void onUpdate(const wxCommandEvent& event);
	virtual void onText(const wxCommandEvent& event);
	virtual void onChoice(const wxCommandEvent& event);

	virtual void onLevels(const CJT6MLevelEvent& event);
	virtual void onMessage(const CJT6MMessageEvent& event);
	virtual void onAudio(const CLevelEvent& event);

	virtual void onError(const CErrorEvent& event);

	virtual void showLevels(CJT6MLevels* levels, EWho who);
	virtual void showMessage(CJT6MMessage* message, EWho who);
	virtual void showAudio(double audio, EWho who);

	virtual void error(const wxString& error);

    private:
	CJT6MDisplay*         m_firstDisplay;
	CJT6MDisplay*         m_secondDisplay;
	CJT6MDisplay*         m_fileDisplay;
	CRecordControl*       m_record;
	CTransmitControl*     m_transmit;
	CRemoteControl*       m_remote;
	CClockPanel*          m_clock;
	CMessageControl*      m_message;
	int                   m_messageNo;

	DECLARE_EVENT_TABLE()

	wxMenuBar* createMenuBar();
};

#endif
