/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MLevelEvent.h"

CJT6MLevelEvent::CJT6MLevelEvent(CJT6MLevels* levels, EWho who, wxEventType type, int id) :
wxEvent(id, type),
m_levels(levels),
m_who(who)
{
}

CJT6MLevelEvent::CJT6MLevelEvent(const CJT6MLevelEvent& event) :
wxEvent(event),
m_levels(event.m_levels),
m_who(event.m_who)
{
}

CJT6MLevelEvent::~CJT6MLevelEvent()
{
}

CJT6MLevels* CJT6MLevelEvent::getLevels() const
{
	return m_levels;
}

EWho CJT6MLevelEvent::getWho() const
{
	return m_who;
}

wxEvent* CJT6MLevelEvent::Clone() const
{
	return new CJT6MLevelEvent(*this);
}
