/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	NoisyNCO_H
#define	NoisyNCO_H

#include "Gaussian.h"

#include <complex>
using namespace std;

class CNoisyNCO {

    public:
	CNoisyNCO(int rate, double stdDev, double volume = 1.0);
	virtual ~CNoisyNCO();

	virtual void generate(double frequency, double* output, int length);
	virtual void generate(double frequency, complex<double>* output, int length);

    private:
	int       m_rate;
	double    m_stdDev;
	double    m_volume;
	double    m_dds;
	CGaussian m_gaussian;
};

#endif
