.TH LISTRES 1 "Release 5" "X Version 11"
.SH NAME
listres - list resources in widgets
.SH SYNOPSIS
.B "listres"
[-option ...]
.SH DESCRIPTION
.PP
The \fIlistres\fP program generates a list of a widget's resource database.  
The class in which each resource is first defined, the instance and class
name, and the type of each resource is listed.  If no specific widgets
or the \fI-all\fP switch are given, a two-column list of widget names and
their class hierarchies is printed.
.SH OPTIONS
\fIListres\fP accepts all of the standard toolkit command line options along
with those listed below:
.TP 8
.B \-all
This option indicates that \fIlistres\fP should print information for all
known widgets and objects. 
.TP 8
.B \-nosuper
This option indicates that resources that are inherited from a superclass
should not be listed.  This is useful for determining which resources are
new to a subclass.
.TP 8
.B \-variable
This option indicates that widgets should be identified by the names of the
class record variables rather than the class name given in the variable.  This
is useful for distinguishing subclasses that have the same class name as their
superclasses.
.TP 8
.B \-top \fIname\fP
This option specifies the name of the widget to be treated as the top of the
hierarchy.  Case is not significant, and the name may match either the class
variable name or the class name.  The default is ``core''.
.TP 8
.B \-format \fIprintf\-string\fP
This option specifies the \fIprintf\fP-style format string to be used to print
out the name, instance, class, and type of each resource.
.SH "X DEFAULTS"
To be written.
.SH "SEE ALSO"
X(1), xrdb(1), appropriate widget documents
.SH "BUGS"
On operating systems that do not support dynamic linking of run-time routines,
this program must have all of its known widgets compiled in.  The sources
provide several tools for automating this process for various widget sets.
.SH COPYRIGHT
Copyright 1989, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHOR
Jim Fulton, MIT X Consortium
