/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BinaryExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import org.xml.sax.SAXException;

class BooleanExpression
extends BinaryExpression {
    public BooleanExpression() {
    }

    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Value evaluate(Context context) throws SAXException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    public boolean evaluateAsBoolean(Context context) throws SAXException {
        switch (this.operator) {
            case 19: {
                return this.p1.evaluateAsBoolean(context) && this.p2.evaluateAsBoolean(context);
            }
            case 18: {
                return this.p1.evaluateAsBoolean(context) || this.p2.evaluateAsBoolean(context);
            }
        }
        throw new SAXException("Unknown operator in boolean expression");
    }

    public int getDataType() {
        return 1;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((this.getDependencies() & n) != 0) {
            BooleanExpression booleanExpression = new BooleanExpression(this.p1.reduce(n, context), this.operator, this.p2.reduce(n, context));
            booleanExpression.setStaticContext(this.getStaticContext());
            return ((Expression)booleanExpression).simplify();
        }
        return this;
    }
}

