/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.ParserManager;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.tree.CommentImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.ElementWithAttributes;
import com.icl.saxon.tree.NamePool;
import com.icl.saxon.tree.NodeFactory;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import com.icl.saxon.tree.ProcInstImpl;
import com.icl.saxon.tree.Stripper;
import com.icl.saxon.tree.TextImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.ParserAdapter;

public class Builder
implements ContentHandler,
LexicalHandler,
ErrorHandler,
DTDHandler,
Locator {
    private static AttributeCollection emptyAttributeCollection = new AttributeCollection();
    private static int nextSequenceNr = 0;
    private Writer errorOutput;
    private Stripper stripper;
    private PreviewManager previewManager = null;
    private boolean discardComments = false;
    private static final Vector emptyVector = new Vector(0);
    private ParentNodeImpl currentNode;
    private DocumentImpl currentDocument;
    private XMLReader parser = null;
    private ErrorHandler errorHandler;
    private Locator locator = this;
    private String baseURI = null;
    private NodeFactory nodeFactory;
    private NamePool namePool = new NamePool();
    private String[] namespaces = new String[20];
    private int namespacesUsed = 0;
    private int[] size = new int[100];
    private int depth = 0;
    private Vector arrays = new Vector();
    private boolean previousText;
    private int nodeSequenceNr;
    protected boolean failed = false;
    private boolean started = false;
    private StringBuffer charBuffer;
    private int estimatedLength;
    private boolean inDTD = false;
    private boolean lineNumbering = false;
    private long startTime;

    public Builder() {
        this.errorHandler = this;
        this.errorOutput = new PrintWriter(System.err);
        this.nodeFactory = new DefaultNodeFactory();
        Boolean bl = Boolean.TRUE;
        synchronized (bl) {
            this.nodeSequenceNr = nextSequenceNr;
        }
    }

    public void setParser(Parser parser) {
        this.parser = new ParserAdapter(parser);
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.parser = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.parser;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void setStripper(Stripper stripper) {
        this.stripper = stripper;
    }

    public void setStripAll() {
        this.stripper = new AllElementsStripper();
    }

    public void setPreviewManager(PreviewManager previewManager) {
        this.previewManager = previewManager;
    }

    public void setDiscardCommentsAndPIs(boolean bl) {
        this.discardComments = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public DocumentImpl build(InputSource inputSource) throws SAXException {
        String string;
        this.failed = true;
        this.started = false;
        this.baseURI = string = inputSource.getSystemId();
        if (inputSource instanceof ExtendedInputSource) {
            this.estimatedLength = ((ExtendedInputSource)inputSource).getEstimatedLength();
            if (this.estimatedLength < 1) {
                this.estimatedLength = 4096;
            }
            if (this.estimatedLength > 1000000) {
                this.estimatedLength = 1000000;
            }
        } else {
            this.estimatedLength = 4096;
        }
        if (this.parser == null) {
            this.parser = ParserManager.makeParser();
        }
        try {
            if (this.stripper != null && !this.stripper.getPreserveAll()) {
                this.parser.setContentHandler(this.stripper);
                this.stripper.setNextHandler(this);
                if (!this.discardComments) {
                    this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this.stripper);
                }
            } else {
                this.parser.setContentHandler(this);
                if (!this.discardComments) {
                    this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        this.parser.setDTDHandler(this);
        this.parser.setErrorHandler(this.errorHandler);
        try {
            this.parser.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (!this.started) {
            throw new SAXException("Source document not supplied");
        }
        if (this.failed) {
            throw new SAXException("XML Parsing failed");
        }
        return this.currentDocument;
    }

    public DocumentImpl getCurrentDocument() {
        return this.currentDocument;
    }

    public void startDocument() throws SAXException {
        this.failed = false;
        this.started = true;
        this.currentDocument = new DocumentImpl();
        this.currentDocument.setSystemId(this.baseURI);
        this.currentNode = this.currentDocument;
        this.depth = 0;
        this.size[this.depth] = 0;
        this.previousText = false;
        this.currentDocument.sequence = this.nodeSequenceNr++;
        this.charBuffer = new StringBuffer(this.estimatedLength);
        this.currentDocument.setCharacterBuffer(this.charBuffer);
        if (this.lineNumbering) {
            this.currentDocument.setLineNumbering();
        }
    }

    public void endDocument() throws SAXException {
        this.currentNode.compact(this.size[this.depth]);
        this.currentNode = null;
        this.previousText = false;
        Boolean bl = Boolean.TRUE;
        synchronized (bl) {
            nextSequenceNr = this.nodeSequenceNr + 1;
        }
        this.arrays = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.namespaces.length < this.namespacesUsed + 2) {
            String[] stringArray = new String[this.namespaces.length * 2];
            System.arraycopy(this.namespaces, 0, stringArray, 0, this.namespacesUsed);
            this.namespaces = stringArray;
        }
        this.namespaces[this.namespacesUsed++] = string;
        this.namespaces[this.namespacesUsed++] = string2;
    }

    public void endPrefixMapping(String string) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        AttributeCollection attributeCollection;
        String string4 = this.rawNameToPrefix(string3);
        String string5 = string2.intern();
        if (string5 == "") {
            string5 = this.rawNameToLocalName(string3);
        }
        Name name = this.namePool.allocate(string4, string.intern(), string5);
        int n = attributes.getLength();
        if (n == 0) {
            attributeCollection = emptyAttributeCollection;
        } else {
            attributeCollection = new AttributeCollection(n);
            int n2 = 0;
            while (n2 < n) {
                object = this.rawNameToPrefix(attributes.getQName(n2));
                String string6 = attributes.getLocalName(n2);
                String string7 = attributes.getURI(n2);
                String string8 = attributes.getType(n2);
                String string9 = attributes.getValue(n2);
                attributeCollection.addAttribute((String)object, string7, string6, string8, string9);
                ++n2;
            }
        }
        ElementImpl elementImpl = this.nodeFactory.makeElementNode(this.currentNode, name, attributeCollection, this.namespaces, this.namespacesUsed, this.locator, this.nodeSequenceNr++);
        while (this.depth >= this.arrays.size()) {
            this.arrays.addElement(new NodeImpl[20]);
        }
        elementImpl.useChildrenArray((NodeImpl[])this.arrays.elementAt(this.depth));
        int n3 = this.depth;
        int n4 = this.size[n3];
        this.size[n3] = n4 + 1;
        this.currentNode.addChild(elementImpl, n4);
        if (this.depth >= this.size.length - 1) {
            object = new int[this.size.length * 2];
            System.arraycopy(this.size, 0, object, 0, this.size.length);
            this.size = (int[])object;
        }
        this.size[++this.depth] = 0;
        this.namespacesUsed = 0;
        if (this.currentNode instanceof DocumentInfo) {
            ((DocumentImpl)this.currentNode).setDocumentElement(elementImpl);
        }
        this.currentNode = elementImpl;
        this.previousText = false;
    }

    private String rawNameToPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    private String rawNameToLocalName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string.intern();
        }
        return string.substring(n + 1).intern();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentNode.compact(this.size[this.depth]);
        if (this.previewManager != null && this.previewManager.isPreviewElement(this.currentNode.getExpandedName())) {
            Controller controller = this.previewManager.getController();
            Context context = controller.makeContext(this.currentNode);
            controller.applyTemplates(context, new SingletonNodeSet(this.currentNode), controller.getRuleManager().getMode(this.previewManager.getPreviewMode()), null);
            this.currentNode.dropChildren();
        }
        --this.depth;
        this.currentNode = (ParentNodeImpl)this.currentNode.getParentNode();
        this.previousText = false;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 > 0) {
            int n3 = this.charBuffer.length();
            this.charBuffer.append(cArray, n, n2);
            if (this.previousText) {
                TextImpl textImpl = (TextImpl)this.currentNode.getAllChildNodes()[this.size[this.depth] - 1];
                textImpl.increaseLength(n2);
            } else {
                TextImpl textImpl = new TextImpl(this.currentDocument, n3, n2);
                int n4 = this.depth;
                int n5 = this.size[n4];
                this.size[n4] = n5 + 1;
                this.currentNode.addChild(textImpl, n5);
                this.previousText = true;
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) {
        if (!this.discardComments) {
            if (string == null) {
                CommentImpl commentImpl = new CommentImpl(string2);
                int n = this.depth;
                int n2 = this.size[n];
                this.size[n] = n2 + 1;
                this.currentNode.addChild(commentImpl, n2);
            } else {
                ProcInstImpl procInstImpl = new ProcInstImpl(string.intern(), string2);
                int n = this.depth;
                int n3 = this.size[n];
                this.size[n] = n3 + 1;
                this.currentNode.addChild(procInstImpl, n3);
                if (this.locator != null) {
                    procInstImpl.setLocation(this.locator.getSystemId(), this.locator.getLineNumber());
                }
            }
            this.previousText = false;
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.discardComments && !this.inDTD) {
            CommentImpl commentImpl = new CommentImpl(new String(cArray, n, n2));
            int n3 = this.depth;
            int n4 = this.size[n3];
            this.size[n3] = n4 + 1;
            this.currentNode.addChild(commentImpl, n4);
            this.previousText = false;
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void graftElement(ElementImpl elementImpl) throws SAXException {
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(elementImpl, n2);
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, false);
        this.failed = true;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, true);
        this.failed = true;
        throw sAXParseException;
    }

    private void reportError(SAXParseException sAXParseException, boolean bl) {
        try {
            String string = bl ? "Fatal error" : "Error";
            this.errorOutput.write(string + " reported by XML parser: " + sAXParseException.getMessage() + "\n");
            this.errorOutput.write("  URL:    " + sAXParseException.getSystemId() + "\n");
            this.errorOutput.write("  Line:   " + sAXParseException.getLineNumber() + "\n");
            this.errorOutput.write("  Column: " + sAXParseException.getColumnNumber() + "\n");
            this.errorOutput.flush();
        }
        catch (Exception exception) {
            System.err.println(sAXParseException);
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = string3;
        if (this.locator != null) {
            try {
                String string6 = this.locator.getSystemId();
                URL uRL = new URL(new URL(string6), string3);
                string5 = uRL.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentDocument.setUnparsedEntity(string, string5);
    }

    public void setSystemId(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    private class AllElementsStripper
    extends Stripper {
        private AllElementsStripper() {
        }

        public boolean isSpacePreserving(Name name) {
            return false;
        }

        public boolean getPreserveAll() {
            return false;
        }
    }

    private class DefaultNodeFactory
    implements NodeFactory {
        private DefaultNodeFactory() {
        }

        public ElementImpl makeElementNode(NodeInfo nodeInfo, Name name, AttributeCollection attributeCollection, String[] stringArray, int n, Locator locator, int n2) throws SAXException {
            if (attributeCollection.getLength() == 0 && n == 0) {
                ElementImpl elementImpl = new ElementImpl();
                String string = null;
                int n3 = -1;
                if (locator != null) {
                    string = locator.getSystemId();
                    n3 = locator.getLineNumber();
                }
                elementImpl.initialise(name, attributeCollection, nodeInfo, string, n3, n2);
                return elementImpl;
            }
            ElementWithAttributes elementWithAttributes = new ElementWithAttributes();
            String string = null;
            int n4 = -1;
            if (locator != null) {
                string = locator.getSystemId();
                n4 = locator.getLineNumber();
            }
            elementWithAttributes.setNamespaceDeclarations(stringArray, n);
            elementWithAttributes.initialise(name, attributeCollection, nodeInfo, string, n4, n2);
            return elementWithAttributes;
        }
    }
}

