/*
 * file client.h - communication interface for clients
 *
 * $Id: client.h,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef XBLAST_CLIENT_H
#define XBLAST_CLIENT_H

#include "player.h"
#include "network.h"

/*
 * global types
 */
typedef struct _xb_network_game {
  char           *host;      /* address of server */
  unsigned short  port;      /* port for game */
  int             ping;      /* ping time */
  char           *version;   /* version string */
  char           *game;      /* name of the game */
  int             numLives;  /* number of lives */
  int             numWins;   /* number of levels to win */
  int             frameRate; /* frame per second */
} XBNetworkGame;

/*
 * global prototypes
 */
extern XBBool Client_Connect (CFGGameHost *);
extern void Client_Disconnect (void);
extern void Client_SetDisconnected (void);
extern void Client_SendSync (XBNetworkEvent);
extern void Client_NotifyError (void);

extern void Client_ReceiveGameConfig (unsigned, const char *data);
extern void Client_ReceivePlayerConfig (unsigned, unsigned, const char *data);
extern void Client_ReceiveLevelConfig (unsigned, const char *data);
extern void Client_ReceiveDisconnect (unsigned);
extern void Client_ReceiveDgramPort (unsigned id, unsigned short);
extern void Client_ReceiveStart (unsigned);
extern void Client_ReceiveRandomSeed (unsigned);
extern void Client_ReceiveSync (XBNetworkEvent);
extern void Client_ReceiveHostState (unsigned, XBBool);
extern void Client_ReceiveTeamState (unsigned, unsigned);

extern void Client_ReceivePlayerAction (int, const PlayerAction *);
extern void Client_ReceiveFinish (void);
extern void Client_ReceivePingTime (unsigned clientID, int pingTime);
extern void Client_GetPlayerAction (int, PlayerAction *);
extern int  Client_GetPingTime (unsigned clientID);

extern void   Client_ResetPlayerAction (void);
extern void   Client_SendPlayerAction (int, const PlayerAction *);
extern void   Client_FinishPlayerAction (int gameTime);
extern XBBool Client_FlushPlayerAction (void);

extern void   Client_StartQuery (void);
extern void   Client_StartCentralQuery (void); // XBCC
extern void   Client_RestartQuery (void);
extern void   Client_StopQuery (void);
extern void   Client_ReceiveReply (const char *host, unsigned short port, int ping, const char *version, 
				   const char *game, int numLives , int numWins , int frameRate);
extern const XBNetworkGame * Client_NextNetworkGame (void);

#endif 
/*
 * end of file client.h
 */
