/*
 * file com_newGame.c - client newGamees for local network game
 *
 * $Id: com_newgame.c,v 1.6 2004/07/07 10:24:20 iskywalker Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 * Added by Koen De Raedt for central support
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "com_newgame.h"

#include "com_browse.h"
#include "client.h"
#include "gui.h"
#include "str_util.h"
#include "version.h"

#ifdef WMS
#include "timeval.h"
#endif

/*
 * local types
 */
typedef struct {
  XBCommBrowse   browse;
  unsigned short port;
  unsigned short gameport;
  unsigned char  serial;
  int            gameID;
  char          *addrBroadcast;
  char           *game;
  int             numLives;
  int             numWins;
  int             frameRate;
  struct timeval tvSend;
} XBCommNewGame;

/*
 * local 
 */
/* GAMEONFIX */
void
NewGame_Send (XBComm *comm, const struct timeval *tv, const char *busy)
/* GAMEONFIX */
{
  XBBrowseTeleNewGame tele;
  XBCommNewGame *qComm = (XBCommNewGame *) comm;
  char *msgString = " PLAYING";
  char tempString[48];
  assert (NULL != qComm);
  assert (NULL != tv);
  /* send cyclic datagram */
  tele.any.type   = XBBT_NewGame;
  tele.any.serial = ++ qComm->serial;
  tele.gameID     = qComm->gameID;
  tele.port       = qComm->gameport;
  tele.version[0] = VERSION_MAJOR;
  tele.version[1] = VERSION_MINOR;
  tele.version[2] = VERSION_PATCH;
  tele.numLives   = qComm->numLives;
  tele.numWins    = qComm->numWins;
  tele.frameRate  = qComm->frameRate;
  strncpy (tele.game, qComm->game, sizeof (tele.game));  
  /* GAMEBUSY */
  if(strlen(busy)>0) {
    if(strlen(busy)<48){
      strcpy (tempString,busy);
      strncpy(tempString+strlen(busy),tele.game,48-strlen(busy));
      strncpy(tele.game,tempString,48);
    }
    tele.frameRate = 0;
  }
  /* send data */
  Browse_Send (&qComm->browse, qComm->addrBroadcast, qComm->port, XBTrue, &tele.any);
  /* mark time */
  Dbg_Out("Send game config to central at %s:%i\n",qComm->addrBroadcast, qComm->port);
  qComm->tvSend = *tv;
} /* NewGame_Poll */

void
NewGame_Close (XBComm *comm, const struct timeval *tv)
{
  XBBrowseTeleNewGameOK tele;
  XBCommNewGame *qComm = (XBCommNewGame *) comm;

  assert (NULL != qComm);
  assert (NULL != tv);
  /* send cyclic datagram */
  tele.any.type   = XBBT_NewGameOK;
  tele.any.serial = ++ qComm->serial;
  tele.gameID     = qComm->gameID;
  /* send data */
  Browse_Send (&qComm->browse, qComm->addrBroadcast, qComm->port, XBTrue, &tele.any);
  /* mark time */
  Dbg_Out("Send start/close to central at %s:%i\n",qComm->addrBroadcast, qComm->port);
  qComm->tvSend = *tv;
} /* NewGame_Poll */

/*
 * ein server hat eine Antwort geschickt
 */
static void
HandleReply (XBCommNewGame *qComm, const XBBrowseTeleNewGameOK *tele, const char *host)
{
  long  msec;
  struct timeval tv;

  /* calculate sping time */
  gettimeofday (&tv, NULL);
  msec = (tv.tv_sec - qComm->tvSend.tv_sec) * 1000L + (tv.tv_usec - qComm->tvSend.tv_usec) / 1000L;
  /* inform application */
  Dbg_Out ("NewGame response from %s (%ld msec), game id = %i\n", host, msec, tele->gameID);
  qComm->gameID=tele->gameID;
} /* HandleReply */

/*
 * receive newGame data 
 */
static void
ReceiveNewGame (XBCommBrowse *bComm, const XBBrowseTele *tele, const char *host, unsigned short port)
{
  assert (NULL != bComm);
  assert (NULL != tele);
  assert (NULL != host);
  switch (tele->type) {
  case XBBT_NewGameOK: HandleReply ((XBCommNewGame *) bComm, &tele->newGameOK, host); break;  
  default:         break;
  }
} /* ReceiveNewGame */

/*
 *
 */
static XBCommResult 
DeleteNewGame (XBComm *comm)
{
  XBCommNewGame *qComm = (XBCommNewGame *) comm;
  /* */
  assert (NULL != qComm);
  Browse_Finish (&qComm->browse);
  assert (NULL != qComm->addrBroadcast);
  free (qComm->addrBroadcast);
  free (qComm);
  qComm = NULL;
  return XCR_OK;
} /* DeleteNewGame  */

/*
 * create broadcast socket to newGame for network games
 */
XBComm *
NewGame_CreateComm (const char *addrDevice, unsigned short port, const char *addrBroadcast, const CFGGameHost *cfg, const CFGGameSetup *setup)
{
  XBSocket      *pSocket;
  XBCommNewGame *cComm;

  assert (NULL != addrBroadcast);
  /* create socket */
  pSocket = Net_BindUdp (addrDevice, 0);
  if (NULL == pSocket) {
    return NULL;
  }
  /* create communication data structure */
  cComm = calloc (1, sizeof (*cComm));
  assert (NULL != cComm);
  /* set values */
  Browse_CommInit (&cComm->browse, COMM_NewGame, pSocket, ReceiveNewGame, DeleteNewGame);
  cComm->port           = port;
  cComm->serial         = 0;
  cComm->gameID         = -1;
  cComm->addrBroadcast  = DupString (addrBroadcast);
  cComm->tvSend.tv_sec  = 0;
  cComm->tvSend.tv_usec = 0;
  cComm->gameport      = cfg->port;
  cComm->game      = DupString (cfg->game);
  cComm->numLives  = setup->numLives;
  cComm->numWins   = setup->numWins;
  cComm->frameRate = setup->frameRate;

  /* that's all ? */
  return &cComm->browse.comm;
} /* C4S_CreateComm */

/*
 * end of file com_newGame.c
 */
