/*
 * file com_reply.c - server answers to broadcasts by clients
 *
 * $Id: com_reply.c,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "com_reply.h"

#include "com_browse.h"
#include "version.h"
#include "str_util.h"

/*
 * local types
 */
typedef struct {
  XBCommBrowse    browse;
  unsigned short  port;
  char           *game;
  int             numLives;
  int             numWins;
  int             frameRate;
} XBCommReply;

/*
 * ein server hat eine Antwort geschickt
 */
static void
HandleQuery (XBCommReply *rComm, const XBBrowseTeleQuery *query, const char *host, unsigned short port)
{
  XBBrowseTeleReply tele;
     
  memset (&tele, 0, sizeof (tele));
  /* build reply */
  tele.any.type   = XBBT_Reply;
  tele.any.serial = query->any.serial;
  tele.port       = rComm->port;
  tele.version[0] = VERSION_MAJOR;
  tele.version[1] = VERSION_MINOR;
  tele.version[2] = VERSION_PATCH;
  tele.numLives   = rComm->numLives;
  tele.numWins    = rComm->numWins;
  tele.frameRate  = rComm->frameRate;
  strncpy (tele.game, rComm->game, sizeof (tele.game));
  strncpy (tele.host, "", sizeof (tele.host)); // XBCC
  /* send it */
  Browse_Send (&rComm->browse, host, port, XBFalse, &tele.any);
  /* --- */
  Dbg_Out ("client found at %s:%hu\n", host, port);
} /* HandleQuery */

/*
 * receive reply data 
 */
static void
ReceiveReply (XBCommBrowse *bComm, const XBBrowseTele *tele, const char *host, unsigned short port)
{
  assert (NULL != bComm);
  assert (NULL != tele);
  assert (NULL != host);
  switch (tele->type) {
  case XBBT_Query: HandleQuery ((XBCommReply *) bComm, &tele->query, host, port); break;
  default:         break;
  }
} /* ReceiveReply */

/*
 *
 */
static XBCommResult 
DeleteReply (XBComm *comm)
{
  XBCommReply *rComm = (XBCommReply *) comm;
  /* */
  assert (NULL != rComm);
  Browse_Finish (&rComm->browse);
  free (rComm);
  rComm = NULL;
  return XCR_OK;
} /* DeleteReply  */

/*
 * create udp socket waiting for clients' queries
 */
XBComm*
Reply_CreateComm (unsigned short port, const CFGGameHost *cfg, const CFGGameSetup *setup)
{
  XBSocket    *pSocket;
  XBCommReply *rComm;

  assert (NULL != cfg);
  assert (NULL != setup);
  /* create socket */
  pSocket = Net_BindUdp (NULL, port);
  if (NULL == pSocket) {
    return NULL;
  }
  /* create communication data structure */
  rComm = calloc (1, sizeof (*rComm));
  assert (NULL != rComm);
  /* set values */
  Browse_CommInit (&rComm->browse, COMM_Reply, pSocket, ReceiveReply, DeleteReply);
  rComm->port      = cfg->port;
  rComm->game      = DupString (cfg->game);
  rComm->numLives  = setup->numLives;
  rComm->numWins   = setup->numWins;
  rComm->frameRate = setup->frameRate;
  /* that's all ? */
  return &rComm->browse.comm;
} /* Reply_CreateComm */

/*
 * end of file com_reply.c
 */
