/*
 * file com_stream.c - base struct und functions for stream connections
 *
 * $Id: com_stream.c,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "com_stream.h"

/*
 * try to read telegrams from server
 */
static XBCommResult 
ReadStream (XBComm *comm)
{
  XBTeleResult  result;
  XBTelegram   *tele;
  XBCommResult  cResult;
  XBCommStream *stream = (XBCommStream *) comm;

  assert (NULL != stream);
  result = Net_Receive (stream->rcvQueue, stream->comm.socket);
  if (result == XBT_R_IOError) {
    /* break down in communivation */
    Dbg_Out ("i/o-error write to fd=%d\n", Socket_Fd (stream->comm.socket));
    assert (stream->errorFunc != NULL);
    (*stream->errorFunc) (stream);
    return XCR_Error;
  } else if (result == XBT_R_EndOfFile) {
    Dbg_Out ("end of file for fd=%d\n", Socket_Fd (stream->comm.socket));
    return XCR_Finished;
  }
  assert (stream->handleFunc != NULL);
  while (NULL != (tele = Net_ReceiveTelegram (stream->rcvQueue) ) ) {
    cResult = (*stream->handleFunc) (stream, tele);
    Net_DeleteTelegram (tele);
    if (cResult != XCR_OK) {
      return cResult;
    }
  }
  return XCR_OK;
} /* ReadStream */

/*
 * write telegram to server
 */
static XBCommResult 
WriteStream (XBComm *comm)
{ 
  XBTeleResult result;
  XBCommStream *stream = (XBCommStream *) comm;

  assert (NULL != stream);

  result = Net_Send (stream->sndQueue, stream->comm.socket);
  /* no telegrams left, we do need to know when socket becomes writable */
  switch (result) {
    /* telegram has been send completely */
  case XBT_R_Complete:
    Socket_UnregisterWrite (CommSocket (&stream->comm));
    /* check if communication shutdown is wanted */
    if (stream->prepFinish) {
      Socket_ShutdownWrite (CommSocket (&stream->comm));
    }
    return XCR_OK;
    /* error while sending telegram */
  case XBT_R_IOError:
    Dbg_Out ("i/o-error write to fd=%d\n", Socket_Fd (stream->comm.socket));
    assert (stream->errorFunc != NULL);
    (*stream->errorFunc) (stream);
    return XCR_Error;
    /* anything else */
  default:
    return XCR_OK;
  }
} /* WriteStream */

/*
 *
 */
void
Stream_CommFinish (XBCommStream *stream)
{
  CommFinish (&stream->comm);
  Net_DeleteSndQueue (stream->sndQueue);
  Net_DeleteRcvQueue (stream->rcvQueue);
} /* Stream_CommFinish */

/*
 * 
 */
void
Stream_CommInit (XBCommStream *stream, XBCommType commType, XBSocket *pSocket, HandleFunc handleFunc, 
		 ErrorFunc errorFunc, XBCommFunc deleteFunc)
{
  assert (stream != NULL);
  /* set values */
  CommInit (&stream->comm, COMM_ToServer, pSocket, ReadStream, WriteStream, deleteFunc);
  stream->handleFunc = handleFunc;
  stream->errorFunc  = errorFunc;
  /* create tele lists */
  stream->sndQueue = Net_CreateSndQueue (commType == COMM_ToClient);
  stream->rcvQueue = Net_CreateRcvQueue (commType == COMM_ToClient);
  assert (NULL != stream->sndQueue);
  assert (NULL != stream->rcvQueue);
} /* CommCreateToServer */

/*
 * end of file com_stream.c
 */
