/*
 * file com_stream.h - base struct und functions for stream connections
 *
 * $Id: com_stream.h,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef XBLAST_COM_STREAM_H
#define XBLAST_COM_STREAM_H

#include "com_base.h"

/*
 * type definitions
 */

/* forward declaration */
typedef struct _xb_comm_stream XBCommStream;

/*callback for handling incoming telegrams */
typedef XBCommResult (*HandleFunc) (XBCommStream *, const XBTelegram *tele);
typedef void         (*ErrorFunc)  (XBCommStream *); 

/* base structure for all stream bases communications */
struct _xb_comm_stream {
  XBComm      comm;
  XBBool      prepFinish;
  XBSndQueue *sndQueue;
  XBRcvQueue *rcvQueue;
  HandleFunc  handleFunc;
  ErrorFunc   errorFunc;
};

/*
 * global prototypes
 */
extern void Stream_CommInit (XBCommStream *, XBCommType, XBSocket *, HandleFunc, ErrorFunc, XBCommFunc);
extern void Stream_CommFinish (XBCommStream *stream);

#endif
/*
 * end of file com_stream.h
 */
