/*
 * file str_util.c - some own string routines
 *
 * $Id: str_util.c,v 1.3 2004/05/14 10:00:35 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "str_util.h"

#include "xblast.h"

/*
 * duplicate string (some systems do not have strdup)
 */
char *
DupString (const char* ptr) 
{
  char   *result;
  size_t  length;
  
  assert (ptr != NULL);
  /* alloc data */
  length = strlen (ptr);
  result = malloc (length+1);
  assert (result != NULL);
  /* copy data */
  memcpy (result, ptr, length+1);
  /* --- */
  return result;
} /* DupString */

/*
 * duplicate string (some systems do not have strdup)
 */
char *
DupStringNum (const char* ptr, size_t length) 
{
  char   *result;
  
  assert (ptr != NULL);
  /* alloc data */
  result = malloc (length+1);
  assert (result != NULL);
  /* copy data */
  memcpy (result, ptr, length);
  result[length] = 0;
  /* --- */
  return result;
} /* DupString */

/*
 * public function split_string
 */
char ** 
SplitString (const char *string, int *largc)
{
  void  *ptr;
  char  *buf;
  char **argv;
  int    i, length, size, argc;
  XBBool flag;

  /* get number of words */
  flag   = XBTrue;
  *largc = 0;
  size   = 0;
  length = strlen (string);
  for (i=0; i<length; i++) {
    if (isspace (string[i])) {
      flag = XBTrue;
    } else {
      if (flag) {
	(*largc) ++;
	flag = XBFalse;
      }
      size ++;
    }
  }
  /* alloc array */
  ptr = malloc ( ((*largc)+1) * sizeof(char *) + (size+(*largc)) * sizeof(char) );
  assert (ptr != NULL);
  
  /* now store strings */
  buf  = (char *) ((char **)ptr + ((*largc)+1));
  argv = (char **) ptr;
  argc = 0;
  flag = XBTrue;
  for (i=0; i<length; i++) {
    if (isspace(string[i])) {
      if (!flag) {
	flag = XBTrue;
	*buf = '\0';
	buf++;
      }
    } else {
      if (flag) {
	argv[argc]=buf;
	argc++;
	flag = XBFalse;
      }
      *buf = string[i];
      buf++;
    }
  }
  *buf       = '\0';
  argv[argc] = NULL;

  return argv;
} /* SplitString */

/*
 * create a date string for XBlast
 */
const char *
DateString (time_t t)
{
  static char tmp[128];

  strftime (tmp, sizeof (tmp), "%b %d %Y  %H:%M", localtime (&t));
  return tmp;
} /* DateString */

/*
 * end of file str_util.c
 */
