 /*
 * file      : about_xcfa.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"
#include "interface.h"

#include <stdlib.h>

#include "global.h"
#include "web.h"
#include "utils.h"
#include "win_control.h"
#include "about_xcfa.h"

typedef struct {
	GtkWidget *AdrWin;
} VAR_ABOUT;

VAR_ABOUT VarAbout;

void AboutXcfa_quit (void)
{
	gtk_widget_destroy(VarAbout.AdrWin);
	wincontrol_remove_last ();
}

gboolean AboutXcfa_delete_event (void)
{
	AboutXcfa_quit ();
	return FALSE;
}
gboolean AboutXcfa_destroy_event (void)
{
	AboutXcfa_quit ();
	return FALSE;
}
void AboutXcfa_button_ok_about_clicked (void)
{
	AboutXcfa_quit ();
}

void AboutXcfa_image_about_realize (GtkWidget *widget)
{
	gchar     *LineCommand = NULL;

	LineCommand = utils_get_pathname ("about.png");
	gtk_image_set_from_file (GTK_IMAGE (widget), LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
}
void AboutXcfa_label_xcfa_about_realize (GtkWidget *widget)
{
	gchar     *str = NULL;

	str = g_strdup_printf (
		/*"\n<b>X</b>  <b>C</b>onvert  <b>F</b>ile  <b>A</b>udio\n"*/
		"\n"
		"GTK+ implementation of the GNU shell command.\n"
		"version %s\n"
		"\n"
		"(<i>%d CPU %d bits</i>)\n",
		VERSION,
		HostConf.NbCpu,
		HostConf.TypeCpu);
	gtk_label_set_justify (GTK_LABEL(widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL(widget), str);
	g_free (str);
	str = NULL;
}
void AboutXcfa_label_author_about_realize (GtkWidget *widget)
{
	gtk_label_set_justify (GTK_LABEL(widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL(widget), "\nCopyright © 2003-2009  -  Bulin Claude  -  fr\n");
}
void AboutXcfa_label_contrib_about_realize (GtkWidget *widget)
{
#define TEXTE _("\n<span foreground=\"#00000F\" weight=\"normal\"><i>" \
		"<b>Au tout debut:</b>\n\n" \
		"Serres Patrick, Hamann Regis, Fabien Gregis, @Dzef, @alteo_gange, \n" \
		"@Leonux, @zarer, @Shankarius, @bishop, @Ludo, @Patachonf,\n" \
		"...  ;-)\n\n" \
		"</i></span>")

	gtk_label_set_use_markup (GTK_LABEL (widget), TRUE);
	gtk_label_set_justify (GTK_LABEL (widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL (widget), TEXTE);
}
void AboutXcfa_textview_label_license_about_realize (GtkWidget *widget)
{
	gtk_text_view_set_editable (GTK_TEXT_VIEW (widget), FALSE);
	gtk_text_view_set_justification (GTK_TEXT_VIEW (widget), GTK_JUSTIFY_CENTER);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (widget), FALSE);
	gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget)),
	"\n\nLicense 2003,2004,2005,2006,2007,2008,2009 Claude Bulin\n\n\nThis program is free software;"
	" you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\n"
	"the Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n \n"
	"This program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; "
	"without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  "
	"See the\nGNU General Public License for more details.\n \nYou should have received a copy of the GNU General Public License\n"
	/*
	"along with this program; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place - Suite 330, Boston, "
	"MA 02111-1307, USA.\n\n------------\n\nPermission  est  donnee  a  tout  individu  ou  institution d'utiliser,\n"
	
	Il faut remplacer l'adresse de la FSF (qui a changé depuis juillet 2005) dans le fichier copyright.
	Ancienne adresse: 59 Temple Place - Suite 330, Boston, MA 02111-1307 USA
	Nouvelel adresse: 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
	*/
	"along with this program; if not, write to the Free Software\nFoundation, Inc., 51 Franklin Street, Fifth Floor, Boston, "
	"MA 02110-1301, USA.\n\n------------\n\nPermission  est  donnee  a  tout  individu  ou  institution d'utiliser,\n"
	
	"copier, ou redistribuer ce logiciel des  lors  que  tous  les  fichiers\nd'origine  sont  inclus,  que ce n'est pas vendu"
	" pour des benefices, et\nque cette notice sur le copyright est incluse.\n\nCe programme est un logiciel libre; vous pouvez le  "
	"redistribuer  et/ou\nle modifier sous les termes de la licence GNU GPL telle que publiee par\nla Free Software Foundation; "
	"soit la version 2, soit  (a  votre  conve-\nnance) toute version ulterieure.\n\nCe  programme  est  distribue dans l'espoir "
	"qu'il soit utile, mais SANS\nAUCUNE GARANTIE; meme sans la garantie implicite  de  UTILISABILITE  ou\nd'ADAPTATION  A  UN "
	"USAGE PRECIS. Lisez la licence GNU GPL pour plus de\ndetails.\n", -1);
}
void AboutXcfa_label_button_pagexcfa_about_realize (GtkWidget *widget)
{
	gtk_label_set_markup (GTK_LABEL (widget), _("<span foreground=\"#0000FF\">  Xcfa sur le web</span>"));
}
void AboutXcfa_button_contrib_about_clicked (GtkButton *button)
{
	typedef struct {
		gchar  *NameWidget;
		gchar  *Url;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_PAGE_WEB 20
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_PAGE_WEB ] = {
	{"button_pagexcfa_about",		"http://www.xcfa.tuxfamily.org"},
	{"button01_contrib_about",		"http://www.jesuislibre.org"},
	{"button02_contrib_about",		"http://e17blog.tuxfamily.org/index.php"},
	{"button03_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?page=plan"},
	{"button04_contrib_about",		"http://bapoumba.wordpress.com"},
	{"button05_contrib_about",		"http://xavier.hatot.club.fr/Joomla/index.php"},
	{"button06_contrib_about",		"http://www.tuxfamily.org"},
	{"button07_contrib_about",		"http://www.framasoft.net/article4492.html"},
	{"button08_contrib_about",		"http://ekd.tuxfamily.org"},
	{"button09_contrib_about",		"http://defis-libristes.tuxfamily.org/viewforum.php?id=2"},
	{"button10_contrib_about",		"http://doc.ubuntu-fr.org/xcfa"},
	{"button11_contrib_about",		"http://unm.arcis.free.fr/spip.php?article109"},
	{"button12_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article168"},
	{"button13_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article159"},
	{"button14_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article30"},
	{"button15_contrib_about",		"http://linuxerie.midiblogs.com/"},
	{"button16_contrib_about",		"http://www.debian-multimedia.org/"},
	{"button17_contrib_about",		"http://frugalware.org/"},
	{"button20_contrib_about",		"http://opera-info.de/forum/thread.php?threadid=20506"},
	{"button21_contrib_about",		"http://linuxforen.de/forums/showthread.php?p=1693658"},
	};

	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_PAGE_WEB; cpt ++) {
		if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (VarAbout.AdrWin, TypeButton [ cpt ].NameWidget)))) {
			web_goto_xcfa_page (TypeButton [ cpt ].Url);
			break;
		}
	}
}

void AboutXcfa_Create_Windows (void)
{
	VarAbout.AdrWin = create_wind_about ();
	wincontrol_set_adr (
		VarAbout.AdrWin,		/* Window adress                */
		"About",			/* Window name			*/
		TRUE,				/* gtk_window_set_transient_for */
		TRUE				/* gtk_window_set_modal         */
		);
	utils_set_default_icone_xcfa (VarAbout.AdrWin);
	gtk_widget_show_all (VarAbout.AdrWin);
}


