 /*
 * file      : cd_audio.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __cd_audio_h__
#define __cd_audio_h__ 1

#include "tags.h"

typedef enum {
	TYPE_CUE_NONE = 0,
	TYPE_CUE_CD,
	TYPE_CUE_FILE
} TYPE_CUE;


typedef enum {
	EXTRACT_WITH_CDPARANOIA = 0,
	EXTRACT_WITH_CDPARANOIA_EXPERT,
	EXTRACT_WITH_CDDA2WAV
} EXTRACT_WITH;


typedef struct {

	GtkComboBox		*Adr_combobox_normalise_cd;		/* Adresse */
	
	GtkComboBox		*Adr_Combo_Box;				/* Adresse */
	GtkComboBox		*Adr_combobox_serveur;			/* Adresse */
	GtkWidget		*Adr_frame_action_cd;			/* Adresse */
	GtkWidget		*Adr_button_applique_change;		/* Adresse */
	GtkWidget		*Adr_Button_Cancel_cddb;		/* Adresse */
	GtkWidget		*Adr_Button_Raffraichir;		/* Adresse */
	GtkWidget		*Adr_Label_Duree;			/* Adresse */
	GtkWidget		*Adr_Label_Titre;			/* Adresse */
	GtkWidget		*Adr_Label_Statusbar;			/* Adresse */
	GtkButton		*Adr_Button_Destination;		/* Adresse */
	GtkWidget		*Adr_Progressbar;			/* Adresse */

	GtkWidget		*Adr_scroll;				/* Adresse */

	GtkListStore		*Adr_List_Store;			/* Adresse */
	GtkTreeModel		*Adr_Tree_Model;			/* Adresse */
	GtkTreeSelection	*Adr_Line_Selected;			/* Adresse */
	GtkWidget		*Adr_TreeView;				/* Adresse */

	GdkPixbuf		*Pixbuf_Coche;				/* coche.png */
	GdkPixbuf		*Pixbuf_Coche_exist;			/* coche_exist.png */
	GdkPixbuf		*Pixbuf_Selected;			/* selected.png */
	GdkPixbuf		*Pixbuf_Selected_exist;			/* selected_exist.png */
	GdkPixbuf		*Pixbuf_Selected_expert;		/* selected_expert.png */
	GdkPixbuf		*Pixbuf_Selected_expert_exist;		/* selected_expert_exist.png */
	GdkPixbuf		*Pixbuf_CdPlay;				/* play.png */
	GdkPixbuf		*Pixbuf_CdStop;				/* sol.png */
	GdkPixbuf		*Pixbuf_Normalize;			/* normalize1.png */
	GdkPixbuf		*Pixbuf_Normalize_Coche;		/* normalize2.png */
	GdkPixbuf		*Pixbuf_NotInstall;			/* not_install.png */

	gboolean		 Bool_create_file_m3u;			/**/
	gchar			*Pathname_m3u;				/**/
	gchar			*Pathname_xspf;				/**/

	gint			 cursor_on_num_file;			/*  */
	gboolean		 bool_dedans;				/*  */
	
	GtkWidget		*Adr_Expander;				/*  */
	GtkWidget		*Adr_notebook;				/*  */
	GtkWidget		*Adr_entry_tag_titre_album;		/*  */
	GtkWidget		*Adr_entry_tag_nom_artiste;		/*  */
	GtkComboBox		*Adr_combobox_tag_genre_cd;		/*  */
	GtkWidget		*Adr_spinbutton_tag_annee;		/*  */
	GtkWidget		*Adr_entry_new_titre_cdaudio;		/*  */
	GtkWidget		*Adr_entry_tag_titre_chanson;		/*  */
	GtkWidget		*Adr_entry_tag_titre_fichier;		/*  */
	GtkWidget		*Adr_entry_tag_commentaire;		/*  */
	GtkWidget		*Adr_spinbutton_tag_piste;		/*  */
	
	GtkWidget		*Adr_entry_stockage_cdaudio;		/*  */
	GtkWidget		*Adr_label_stockage_cdaudio;		/*  */
	
	GtkWidget		*Adr_entry_name_file_cue;		/*  */

	TYPE_CUE		 TypeCreateCue;				/* TYPE_CUE_NONE | TYPE_CUE_CD | TYPE_CUE_FILE */

	GtkTreeViewColumn	*Adr_Column_Play;
	GtkTreeViewColumn	*Adr_Column_Flac;
	GtkTreeViewColumn	*Adr_Column_Wav;
	GtkTreeViewColumn	*Adr_Column_Mp3;
	GtkTreeViewColumn	*Adr_Column_Ogg;
	GtkTreeViewColumn	*Adr_Column_M4a;
	GtkTreeViewColumn	*Adr_Column_Aac;
	GtkTreeViewColumn	*Adr_Column_Mpc;
	GtkTreeViewColumn	*Adr_Column_Ape;
	GtkTreeViewColumn	*Adr_Column_Wavpack;
	GtkTreeViewColumn	*Adr_Column_Num;
	GtkTreeViewColumn	*Adr_Column_Time;
	GtkTreeViewColumn	*Adr_Column_Normalise;
	GtkCellRenderer		*renderer;
	GtkTreeViewColumn	*Adr_Column_Nom;
		
	guint			 handler_timeout_read_toc_cd;
	gboolean		 bool_thread_read_toc_cd;
	gboolean		 bool_timeout_read_toc_cd;
	
	/* PLAYER ONGLET CD */
	/*
	GtkObject         *AdrAdjustCD;
	GtkWidget         *AdrHscaleCD;
	GtkWidget         *AdrLabelTimeCD;
	GtkWidget         *AdrButtonStopCD;
	*/
	
} VAR_CD;

extern VAR_CD var_cd;

typedef enum {			/* Pour extraction / conversion */

	NONE,			/* Aucune demande */
	WAITING,		/* En attente */
	CONV_OK			/* Fait */

} ETAT_CONV;

typedef enum {
	CD_ETAT_NONE = 0,
	CD_ETAT_PRG_ABSENT,
	CD_ETAT_ATTENTE,
	CD_ETAT_ATTENTE_EXIST,
	
	CD_ETAT_SELECT,
	CD_ETAT_SELECT_EXPERT,
	CD_ETAT_SELECT_EXIST,
	CD_ETAT_SELECT_EXPERT_EXIST

} ETAT_SELECTION_CD;


typedef enum {
	CD_ETAT_PLAY_NONE = 0,
	CD_ETAT_PLAY_PRG_ABSENT,
	CD_ETAT_PLAY_ATTENTE,
	CD_ETAT_PLAY
} ETAT_PLAY_CD;


typedef enum {
	CD_NORM_PEAK_NONE = 0,
	CD_NORM_PEAK,						/* INDIVIDUEL   ajustement maximal du volume	*/
	CD_NORM_PEAK_WAITING					/* COLLECTIF 	ajustement maximal du volume	*/
} ETAT_NORMALISE_CD;


typedef enum {
	NUM_WAV = 0,
	NUM_WAV_EXPERT_1,
	NUM_WAV_EXPERT_2,
	NUM_FLAC,
	NUM_APE,
	NUM_WAVPACK,
	NUM_OGG,
	NUM_M4A,
	NUM_AAC,
	NUM_MPC,
	NUM_MP3,
	NUM_TOTAL
} NUM_TYPE;

typedef struct {
	GList			*list;
	gboolean	 	 WithCommandLineUser;
	size_t			 Size;
} LIST_CONV;

typedef struct {
	gchar			*Name1;
	gchar			*Name2;
} EXTRACT_EXPERT;

typedef struct {
	LIST_CONV		*ListConv;
	
	ETAT_PLAY_CD		 EtatPlay;			/*  */

	gboolean		 Bool_Delette_Flac;		/* Le fichier provisoir doit etre efface */
	gboolean		 Bool_Delette_Wav;		/* idem */
	gboolean		 Bool_Delette_Mp3;		/* idem */
	gboolean		 Bool_Delette_Ogg;		/* idem */
	gboolean		 Bool_Delette_M4a;		/* idem */
	gboolean		 Bool_Delette_Aac;		/* idem */
	gboolean		 Bool_Delette_Mpc;		/* idem */
	gboolean		 Bool_Delette_Ape;		/* idem */
	gboolean		 Bool_Delette_WavPack;		/* idem */

	ETAT_SELECTION_CD	 EtatSelection_Flac;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Wav;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Mp3;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Ogg;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_M4a;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Aac;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Mpc;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_Ape;		/*  */
	ETAT_SELECTION_CD	 EtatSelection_WavPack;		/*  */

	gint			 Num_Track;			/* Numero de piste */
	gchar			*Str_Track;			/**/
	gchar			*NameSong;			/* Le nom du futur fichier */
	gchar			*Duree;				/* La duree d'ecoute */

	ETAT_CONV		 Etat_Flac;			/* Pour extraction / conversion */
	ETAT_CONV		 Etat_Wav;			/**/
	ETAT_CONV		 Etat_Mp3;			/**/
	ETAT_CONV		 Etat_Ogg;			/**/
	ETAT_CONV		 Etat_m4a;			/**/
	ETAT_CONV		 Etat_Aac;			/**/
	ETAT_CONV		 Etat_Mpc;			/**/
	ETAT_CONV		 Etat_Ape;			/**/
	ETAT_CONV		 Etat_WavPack;			/**/
	ETAT_CONV		 Etat_Sox;
	
	gboolean		 EtatNormalise;
	ETAT_NORMALISE_CD	 EtatPeak;
	
	gchar			*PathName_Dest_Flac;		/* Emplacement du fichier */
	gchar			*PathName_Dest_Wav;		/**/
	gchar			*PathName_Dest_Mp3;		/**/
	gchar			*PathName_Dest_Ogg;		/**/
	gchar			*PathName_Dest_M4a;		/**/
	gchar			*PathName_Dest_Aac;		/**/
	gchar			*PathName_Dest_Mpc;		/**/
	gchar			*PathName_Dest_Ape;		/**/
	gchar			*PathName_Dest_WavPack;		/**/
		
	TAGS			*tags;				/* Tags */
	gboolean		 BoolM3uForWav;
	
	EXTRACT_EXPERT		 ExtractExpert;
	

} AUDIO;

typedef struct {

	gchar			*TitleCD;			/* Titre integral du CD */
	gchar			*Title;				/* Titre du CD */
	gchar			*Artiste;			/* Nom de l'artiste */
	
	gboolean		 BoolMultiArtiste;

	gchar			*Duree_cd;			/* Duree totale du cd */

	unsigned long		 Num_ID_CD;			/* ID du cd en numerique */
	gchar			 Str_ID_CD [ 20 ];		/* ID du cd en chaine */

	gint			 TotalTracks;			/* Nombre total de pistes trouvees */

	gint			 NumGenre;			/* Genre en numerique */
	gchar			*StrGenre;			/* Genre en chaine */

	gint			 NumYear;			/* Annee du cd en numerique */
	gchar			*StrYear;			/* Annee du cd en chaine */

	gboolean		 Bool_Connected;		/* TRUE : Connected ELSE FALSE */

	GList			*GList_Audio_cd;		/* Une structures AUDIO par piste */

	gboolean		 Bool_Read_Infos_cd;		/* TRUE or FALSE */
	gchar			*Message;			/* Message pour l'utilisateur */

	gchar			*NameCD_Device;			/* Pointeur sur le device en selection  */

	gchar			 Str_Nice [ 10 ];		/* Priorite systeme */
	gchar			 Str_Bitrate_Lame [ 10 ];	/* Bitrate pour Lame */
	gchar			 Str_Bitrate_oggenc [ 10 ]; 	/* Bitrate pour Oggenc */
	
	gchar			*StrMemoTagComment;		/* Memorisation du commentaire	*/

} ENTETE_CD;

extern ENTETE_CD EnteteCD;


typedef enum {		/**/
	_SHOW_,		/* Statusbar visible */
	_HIDE_		/* Statusbar cachee */
} STATUS_LABEL;		/**/

typedef enum {		/**/
	_DUREE_,	/* Statusbar 'duree' */
	_TITRE_,	/* Statusbar 'titre' */
	_INFO_		/* Statusbar 'info' */
} TYPE_LABEL;

/*
*---------------------------------------------------------------------------
* CD_AUDIO.C
*---------------------------------------------------------------------------
*/
void      cdaudio_put_label_status_bar_cd (TYPE_LABEL TypeLabel, STATUS_LABEL HideShow, gchar *Messag);
void      cdaudio_scrolledwindow_cd_realize (GtkWidget *widget);
void      cdaudio_deallocate_glist_cd (void);
void      cdaudio_button_destination_cd_clicked (void);

gchar    *cdaudio_get_result_destination (TAGS *tags);

void      cdaudio_set_flag_buttons_audio_cd (void);
void      cdaudio_affiche_glist_audio_cd (void);
void      cdaudio_update_glist_audio_cd (void);

void      cdaudio_checkbutton_numerate_name_file_clicked (void);
void      cdaudio_set_titre_chanson (void);

void      cdaudio_combobox_serie_unique_changed (void);
void      cdaudio_combobox_serie_unique_realize (GtkWidget *widget);
void      cdaudio_set_cancel_cddb (void);
void      cdaudio_clear_all_pixbuf_cd_play (void);
void      cdaudio_affiche_all_pixbuf_cd_play (void);
void      cdaudio_combobox_serveur_cd_realize (GtkWidget *widget);
gint      cdaudio_get_val_serveur_cd (void);
void      cdaudio_applique_change (void);
gchar    *cdaudio_get_TitleCD (void);

void      cdaudio_update_glist_audio_cd (void);

void      cdaudio_set_string_example (void);

void      cdaudio_entry_tag_titre_disque_realize (GtkWidget *widget);
void      cdaudio_entry_tag_titre_disque_changed (void);
void      cdaudio_set_entry_tag_titre_disque (gchar *titre);
void      cdaudio_entry_tag_nom_artiste_realize (GtkWidget *widget);
void      cdaudio_entry_tag_nom_artiste_changed (void);
void      cdaudio_set_entry_tag_nom_artiste (gchar *artiste);

AUDIO    *cdaudio_get_line_selected (void);
void      cdaudio_entry_stockage_cdaudio_changed (void);

void      cdaudio_set_etat_music_pixbuf_with_detail (AUDIO *p_audio, ETAT_PLAY_CD EtatPlay);
GList    *cdaudio_get_glist_play (void);

void      cdaudio_change_all_flags_normalise_verticaly (gboolean BoolSelect);


void      cdaudio_deselect_all_flags_extract (void);
void      cdaudio_de_select_verticaly_all_flags_extract (gboolean BoolSelect, gboolean BoolSelectExpert, TYPE_FILE_IS TypeFileIs);
void      cdaudio_de_select_horizontaly_all_flags_extract (AUDIO *p_Audio, gboolean BoolSelect, gboolean BoolSelectExpert);

void      cdaudio_combobox_normalise_cd_realize (GtkWidget *widget);
void      cdaudio_combobox_normalise_cd_changed (void);
gint      cdaudio_get_value_normalise_cd (void);
void      cdaudio_deallocate_glist_context (void);
gboolean  cdaudio_get_bool_is_wav_extract_to_cue (void);

/*
*---------------------------------------------------------------------------
* CD_EXPANDER.C
*---------------------------------------------------------------------------
*/
/*void      cdexpander_hbox_expander_cdaudio_realize (GtkWidget *widget);*/
void      cdexpander_set_entry_tag_titre_album (void);
void      cdexpander_set_entry_tag_nom_artiste (void);
void      cdexpander_set_spinbutton_tag_annee (void);
void      cdexpander_set_entry_tag_titre_chanson (void);
void      cdexpander_set_new_genre (void);
void      cdexpander_set_entry_new_titre_cdaudio (gchar *p_str);
void      cdexpander_set_entry_tag_commentaire (void);
void      cdexpander_set_spinbutton_tag_piste (void);
void      cdexpander_set_entry_tag_titre_fichier_m3u (void);
void      cdexpander_set_sensitive_notebook (void);


void      cdexpander_entry_tag_titre_chanson_changed (void);
void      cdexpander_entry_tag_titre_album_changed (void);
void      cdexpander_entry_tag_nom_artiste_changed (void);
void      cdexpander_entry_tag_commentaire_changed (void);
void      cdexpander_entry_copy_tag_commentaire (void);
void      cdexpander_entry_paste_tag_commentaire (void);
void      cdexpander_spinbutton_tag_annee_value_changed (void);
void      cdexpander_spinbutton_tag_piste_value_changed (void);
void      cdexpander_entry_tag_titre_fichier_m3u_changed (void);
void      cdexpander_combobox_tag_genre_cd_changed (void);
void      cdexpander_entry_new_titre_cdaudio_changed (void);

void      cdexpander_entry_tag_titre_chanson_realize (GtkWidget *widget);
void      cdexpander_entry_tag_titre_album_realize (GtkWidget *widget);
void      cdexpander_entry_tag_nom_artiste_realize (GtkWidget *widget);
void      cdexpander_entry_tag_commentaire_realize (GtkWidget *widget);
void      cdexpander_spinbutton_tag_annee_realize (GtkWidget *widget);
void      cdexpander_spinbutton_tag_piste_realize (GtkWidget *widget);
void      cdexpander_entry_tag_titre_fichier_m3u_realize (GtkWidget *widget);
void      cdexpander_combobox_tag_genre_cd_realize (GtkWidget *widget);
void      cdexpander_entry_new_titre_cdaudio_realize (GtkWidget *widget);
void      cdexpander_expander_cd_realize (GtkWidget *widget);
void      cdexpander_notebook_expander_cd_realize (GtkWidget *widget);


/*
*---------------------------------------------------------------------------
* CD_ADIO_TOCC
*---------------------------------------------------------------------------
*/
void      cdaudiotoc_reffresh_list_cd (void);
void      cdaudiotoc_button_eject_cd_clicked (void);


#endif






