 /*
 * file      : cd_db.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <string.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>

#include "utils.h"
#include "global.h"
#include "cd_audio.h"
#include "info_song.h"
#include "cdtoc.h"
#include "get.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

int strcasecmp (const char *s1, const char *s2);
int strncasecmp (const char *s1, const char *s2, size_t n);


static gchar *discdb_genres[]=
{
/* 00 */  "unknown",
/* 01 */  "blues",
/* 02 */  "classical",
/* 03 */  "country",
/* 04 */  "data",
/* 05 */  "folk",
/* 06 */  "jazz",
/* 07 */  "misc",
/* 08 */  "newage",
/* 09 */  "reggae",
/* 10 */  "rock",
/* 11 */  "soundtrack"
};

gchar *prog_name = PACKAGE;		/* Name of package */
gchar *prog_version = VERSION;		/* Version of package */

gboolean bool_cancel_cddb = FALSE;	/* FALSE = continue ELSE STOP */

/*
GList *ListChoice = NULL;
*/


/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/


/* Si 'FLAG == FALSE', force l'arret de la recherche sur le serveur freedb
*  --
*  entree :
*      gboolean FLAG : TRUE or FALSE
*  retour : -
*/
void cddb_set_bool_cancel_cddb (gboolean FLAG)
{
	/*PRINT_FUNC_LF();*/
	bool_cancel_cddb = FLAG;
}

/* Cherche et renvoie 'genre' ou 'unknown' si la limite est depassee
*  Search and return genre in base else return("unknown")
*  --
*  entree :
*      gint genre :
*  retour :
*     gchar * :
*/
gchar *cddb_disc_db_genre (gint genre)
{
	/*PRINT_FUNC_LF();*/
	return (discdb_genres[ genre > 11 ? 0 : genre ]);
}

/* Si la chaine genre est dans la base, renvoie sa position sinon renvoie 0
*  --
*  entree :
*      gchar *genre :
*  retour :
*     gint :
*/
gint cddb_disc_db_genreValue (gchar *genre)
{
	gint pos;

	/*PRINT_FUNC_LF();*/
	for (pos = 0; pos < 12; pos++)
		if (!strcmp (genre, discdb_genres[ pos ])) return (pos);
	return (0);
}

/* Construction d'une chaine de demande d'informations pour 'FreeDB'
*  --
*  entree :
*      gchar *cmd : string
*  retour :
*      GString * :
*
*  DOC :
*  --
*  http://www.freedb.org/modules.php?name=Sections&sop=listarticles&secid=2
*  http://fdeport.free.fr/democddbconnect.htm
*
*  Serveurs FreeDB :
*  http://freedb.freedb.org/~cddb
*  http://freedb.freedb.de/~cddb
*  http://at.freedb.org/~cddb
*  http://ca.freedb.org/~cddb
*  http://de.freedb.org/~cddb
*  http://fi.freedb.org/~cddb
*  http://fr.freedb.org/~cddb
*  http://no.freedb.org/~cddb
*  http://uk.freedb.org/~cddb
*  http://us.freedb.org/~cddb
*
*  Serveurs CDDB (Payants) :
*  http://us.cddb.com/~cddb
*  http://us.cddb.com/~cddb
*  http://sc.ca.us.cddb.com/~cddb
*  http://sc2.ca.us.cddb.com/~cddb
*  http://sj.ca.us.cddb.com/~cddb
*  http://sj2.ca.us.cddb.com/~cddb
*/
GString *cddb_disc_db_make_uri(gchar *cmd)
{
	GString *uri;
	gchar   *ptrlang = NULL;
	gchar   begin [ 50 ];

	/*PRINT_FUNC_LF();*/

	switch (cdaudio_get_val_serveur_cd ()) {
	case 0 :
		ptrlang = g_strdup (gtk_set_locale ());
		break;
	case 1 :
		ptrlang = g_strdup ("at");
		break;
	case 2 :
		ptrlang = g_strdup ("ca");
		break;
	case 3 :
		ptrlang = g_strdup ("de");
		break;
	case 4 :
		ptrlang = g_strdup ("fi");
		break;
	case 5 :
		ptrlang = g_strdup ("fr");
		break;
	case 6 :
		ptrlang = g_strdup ("no");
		break;
	case 7 :
		ptrlang = g_strdup ("uk");
		break;
	case 8 :
		ptrlang = g_strdup ("us");
		break;
	}
	if (*ptrlang == 'a' && *(ptrlang+1) == 't')      strcpy (begin, "http://at.freedb.org/~cddb");
	else if (*ptrlang == 'c' && *(ptrlang+1) == 'a') strcpy (begin, "http://ca.freedb.org/~cddb");
	else if (*ptrlang == 'd' && *(ptrlang+1) == 'e') strcpy (begin, "http://de.freedb.org/~cddb");
	else if (*ptrlang == 'f' && *(ptrlang+1) == 'i') strcpy (begin, "http://fi.freedb.org/~cddb");
	else if (*ptrlang == 'f' && *(ptrlang+1) == 'r') strcpy (begin, "http://fr.freedb.org/~cddb");
	else if (*ptrlang == 'n' && *(ptrlang+1) == 'o') strcpy (begin, "http://no.freedb.org/~cddb");
	else if (*ptrlang == 'u' && *(ptrlang+1) == 'k') strcpy (begin, "http://uk.freedb.org/~cddb");
	else if (*ptrlang == 'u' && *(ptrlang+1) == 's') strcpy (begin, "http://us.freedb.org/~cddb");
	else						 strcpy (begin, "http://fr.freedb.org/~cddb");
	
	/*
	Freedb server:
		http://freedb2.org:80/~cddb/cddb.cgi
	Username:
		anonymous
	Hostname:
		my_secret.com
		
	Definition sous RubbyRipper
	---------------------------
	
	strcpy (begin, "http://freedb2.org:80/~cddb");
	*/

	g_free (ptrlang);
	ptrlang = NULL;

	uri = g_string_new(NULL);
	g_string_sprintf (
			uri,
			"%s/cddb.cgi?cmd=%s&hello=private+free.the.cddb+%s+%s&proto=6",
			begin,
			cmd,
			prog_name,
			prog_version);
	g_print("\nuri=\n%s\n", uri->str);
	return (uri);
}

gboolean cddb_is_ok (gchar *name)
{
	FILE      *fp = NULL;
	gchar     *buf = NULL;
	size_t     size = 0;
	gboolean   RetFunc = TRUE;

	if (infosong_get_size_file (name) == 0) return (FALSE);;
	
	if ((fp = fopen (name, "r"))) {
		size = infosong_get_size_file (name);
		if ((buf = (gchar *)g_malloc0 (sizeof (gchar) * (size + 10))) == NULL) {
			fclose (fp);
			return (FALSE);
		}
		
		fread (buf, 1, size, fp);
		fclose (fp);
		
		if (strstr (buf, "Not Found")) RetFunc = FALSE;
		g_free (buf);
		buf = NULL;
	}
	else {
		RetFunc = FALSE;
	}
	
	return (RetFunc);
}


gboolean cddb_test_access_web (void)
{
	static gboolean   bool_access_ok = FALSE;

	if (utils_scan_by_which ("wget", NULL) == FALSE) {
		g_print ("CURL absent !\n");
		return (bool_access_ok);
	}
	
	get_with_wget ();
	bool_access_ok = cddb_is_ok ("/tmp/index.html");
	infosong_delete_file ("/tmp/index.html");
	
	return (bool_access_ok);
}

/* Positionne le pointeur dans le buffer sur la ligne suivante
*  --
*  entree :
*      gchar **dataptr :
*  retour :
*     gchar * :
*/
static gchar *cddb_line_next (gchar **dataptr)
{
	gchar *data=*dataptr;
	gchar *pos;
	gint   i;

	/*PRINT_FUNC_LF();*/
	if(!data || !*data || *data=='.') {
		*dataptr = NULL;
		return (NULL);
	}

	for(i = 0, pos = data; *pos; i++, pos++) {
		/* CORRECTIF DU 13 12 2005 */
		/* if (*pos=='/') *pos='-'; */

		if (*pos == '\r') {
			*pos = '\0';
			continue;
		}
		if(*pos == '\n') {
			*pos = '\0';
			*dataptr = pos +1;
			return (data);
		}
	}
	*dataptr = NULL;

	return (data);
}

typedef enum {
	DO_FALSE,
	DO_TRUE,
	DO_ENCORE,
	DO_NO_MATCH_FOUND
} DO_QUERY;


gint cddb_call (GList *p_list)
{
	gchar  *args[ 50 ];
	gint    pos = 0;
	pid_t   pidt;
	gint    ret_exec = -1;
	gint    status = 0;
	GList  *list = NULL;
	
	PRINT_FUNC_LF();
	
	list = g_list_first (p_list);
	while (list) {
		args [ pos++ ] = list->data;
		list = g_list_next (list);
	}
	/* qui doit se finir par NULL */
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;

	/* Affichage en console de la liste */
	g_print ("!-----------------------------------!\n");
	g_print ("!               %s\n", args [0] );
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	
	/* Creation d'un fork () ... */
	if ((pidt = fork ()) == 0) {
		ret_exec = execvp (args[0], args);
		exit (2);
	}

	/* Attendre la fin du processus */
	waitpid (pidt, &status, WUNTRACED);

	return ( WEXITSTATUS (status));
}

/* Interroge la base sur le type de cd
*  --
*  entree :
*      CD_TOC *CdToc :
*  retour :
*     DO_QUERY :
*/
DO_QUERY cddb_disc_db_do_query (CD_TOC *CdToc)
{
	gchar   *result = NULL;
	gchar   *dataptr = NULL;
	gchar   *inbuffer = NULL;
	gint     index;
	long     sw;
	gchar   *PathCurl = NULL;
	gchar   *PathName = NULL;
	GList	*LIST = NULL;
	GList	*list = NULL;
	
	if (!CdToc) return (DO_FALSE);
	
	PRINT_FUNC_LF();
	/* Premiere allocation */
	conv.ArgConv = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * 100);

	GDK_THREADS_ENTER();
	
	LIST = g_list_append (LIST, g_strdup ("cddb-tool"));
	LIST = g_list_append (LIST, g_strdup ("query"));
	LIST = g_list_append (LIST, g_strdup ("http://freedb.freedb.org/~cddb/cddb.cgi"));
	LIST = g_list_append (LIST, g_strdup ("6"));
	LIST = g_list_append (LIST, g_strdup ("cat"));
	LIST = g_list_append (LIST, g_strdup ("cat-desktop"));
	LIST = g_list_append (LIST, g_strdup_printf ("%08lx", CdToc->Num_ID_CD));
	LIST = g_list_append (LIST, g_strdup_printf ("%d", CdToc->TotalTracks));
	for (index = 0; index < CdToc->TotalTracks; index++) {
		LIST = g_list_append (LIST, g_strdup_printf ("%d", CdToc->TimeTrack[ index ].SumCent));
	}
	LIST = g_list_append (LIST, g_strdup_printf ("%d", CdToc->TimeTrack[ CdToc->TotalTracks ].SumMin * 60 + CdToc->TimeTrack[ CdToc->TotalTracks ].SumSec));
	
	GDK_THREADS_LEAVE();

	conv_exec (FALSE, CDDB_TOOL, LIST, "CDDB_TOOL");
	
	list = LIST = filelc_remove_glist (LIST);
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	result = utils_get_datas_on_disk ();
	
	g_free (PathCurl);
	PathCurl = NULL;
	g_free (PathName);
	PathName = NULL;

	if (cddb_test_access_web () == FALSE || result == NULL) {
		g_free (result);
		result = NULL;
		return (DO_FALSE);
	}

	if(!result) {
		/*
		g_print (">\n");
		g_print ("\7!------------------------------------------------!\7\n");
		g_print ("\7! cddb_disc_db_do_query::VOUS N ETES PAS CONNECTE AU WEB !\7\n");
		g_print ("\7!------------------------------------------------!\7\n");
		*/
		return (DO_FALSE);
	} else {
		/*
		g_print ("!------------------------------------------!\n");
		g_print ("! cddb_disc_db_do_query::VOUS ETES CONNECTE AU WEB !\n");
		g_print ("!------------------------------------------!\n");
		*/
	}

	dataptr = result;
/*
PRINT_FUNC_LF();
g_print("%s\n",result);
*/
	inbuffer = cddb_line_next (&dataptr);
	sw = strtol(strtok(inbuffer," "), NULL, 10);

	switch (sw) {

	/* 200 - Found exact match
	*/
	case 200:
		index = cddb_disc_db_genreValue(g_strstrip(strtok(NULL," ")));
		CdToc->NumGenre = index;
		break;

	/* No match found
	*/
	case 202:
		g_free (result);
		result = NULL;
		return (DO_NO_MATCH_FOUND);

	/* 210 - multiple exact matches
	*        category list follows (until terminating marker)
	*/
	case 210:
		/*
		210 Found exact matches, list follows (until terminating `.')
		jazz 6f11b918 Frank Sinatra / My Way - The Best of Frank Sinatra - CD 1
		misc 6f11b918 Frank Sinatra / My Way - The Best of Frank Sinatra CD 1
		rock 6f11b918 frank sinatra / frank sinatra
		blues 6f11b918 Frank Sinatra / My Way - The Best Of Frank Sinatra CD 1
		newage 6f11b918 Frank Sinatra / My Way - The Best Of Frank Sinatra (Disc 1)
		soundtrack 6f11b918 frank sinatra / frank sinatra
		.

		210 Found exact matches, list follows (until terminating `.')
		jazz cf0d080c Diana Krall / The Girl In The Other Room
		blues cf0d080c Diana Krall / The girl in the other room
		.		
		*/
/*g_print ("inbuffer = %s\n", inbuffer);*/
		inbuffer = cddb_line_next (&dataptr);
		index = cddb_disc_db_genreValue(g_strstrip(strtok(inbuffer," ")));
		CdToc->NumGenre = index;
/*g_print (">inbuffer = %s\n", inbuffer);*/
		inbuffer = cddb_line_next (&dataptr);
/*g_print (">inbuffer = %s\n", inbuffer);*/
		inbuffer = cddb_line_next (&dataptr);
/*g_print (">inbuffer = %s\n", inbuffer);*/


		break;

	/* 211 - inexact match
	*        list follows (until terminating `.'
	*/
	case 211:
		PRINT_FUNC_LF();
		g_print ("\t211 - inexact match\n\tlist follows (until terminating `.'\n");
		g_print ("\tdataptr=\n\t%s\n", dataptr);
		/*
		211 Found inexact matches, list follows (until terminating `.')
		classical 3710de15 Enrico Caruso / The Legendary Enrico Caruso 21 Favorite Arias
		*/
		inbuffer = cddb_line_next (&dataptr);
		while (*inbuffer != ' ') inbuffer ++;
		inbuffer ++;
		CdToc->Str_ID_CD [ 0 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 1 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 2 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 3 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 4 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 5 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 6 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 7 ] = *inbuffer ++;
		CdToc->Str_ID_CD [ 8 ] = '\0';
		CdToc->Num_ID_CD = g_ascii_strtoull (CdToc->Str_ID_CD, NULL, 16);
		/*
		g_print ("CdToc->Num_ID_CD = %08lx\n", CdToc->Num_ID_CD);
		g_print ("CdToc->Str_ID_CD = %s\n", CdToc->Str_ID_CD);
		*/
		g_free (result);
		result = NULL;
		return (DO_ENCORE);

	/* No match
	*/
	default:
		g_free (result);
		result = NULL;
		return (DO_FALSE);
	}

	g_free (result);
	result = NULL;

	return (DO_TRUE);
}

/* Process a line of input data
 */
void cddb_disc_db_process_line(CD_TOC *CdToc, gchar *inbuffer)
{
	int      track;
	char    *st;

	/*PRINT_FUNC_LF();*/
	if (!CdToc) return;

	if(!strncasecmp(inbuffer,"# Revision: ",12)) {
		/* data->revision=atoi(inbuffer+12);
		*/
	}
	else if (!strncasecmp(inbuffer,"DISCID",6)) {
	}
	else if (!strncasecmp(inbuffer,"DTITLE",6)) {
		/* len=strlen(data->data_title);
		 * g_snprintf(data->data_title+len,256-len,"%s",g_strstrip(inbuffer+7));
		 * g_strdup_printf ("%s/", getenv ("HOME"));
		 */
		CdToc->TitleCD = g_strdup (inbuffer+7);
	}
	else if(!strncasecmp(inbuffer,"DYEAR",5)) {
		/* strtok(inbuffer,"=");
		 * st = strtok(NULL, "");
		 * if(st == NULL) return;
		 * data->data_year=atoi(g_strstrip(st));
		 */
		CdToc->NumYear = atoi (inbuffer+6);
		CdToc->StrYear = g_strdup (inbuffer+6);
	}
	else if(!strncasecmp(inbuffer,"DGENRE",6)) {
		/* strtok(inbuffer,"=");
		 * st = strtok(NULL, "");
		 * if(st == NULL) return;
		 * st=g_strstrip(st);
		 * if(*st) {
		 * 	data->data_genre=cddb_disc_db_genreValue(g_strstrip(st));
		 * 	data->data_id3genre=ID3GenreValue(g_strstrip(st));
		 * }
		 *
		 * CdToc->NumGenre = atoi (inbuffer+7);
		 */
		CdToc->StrGenre = g_strdup (inbuffer+7);
		CdToc->NumGenre = infosong_get_genre_by_value (CdToc->StrGenre);
	}
	else if(!strncasecmp(inbuffer,"DID3",4)) {
		/* strtok(inbuffer,"=");
		 * st = strtok(NULL, "");
		 * if(st == NULL) return;
		 * data->data_id3genre=atoi(g_strstrip(st));
		 */
	}
	else if(!strncasecmp(inbuffer,"TTITLE",6)) {
		st = strchr (inbuffer, '=');
		st++;
		track = atoi(strtok(inbuffer+6,"="));
		/* g_print (" : %s\n", st);
		*/
		CdToc->TimeTrack [ track ].TitleTrack = g_strdup (st);
		/* if(track<numtracks)
		 * 	len=strlen(data->data_track[track].track_name);
		 * g_snprintf(data->data_track[track].track_name+len,256-len,"%s", g_strstrip(strtok(NULL,"")));
		 */
	}
	else if(!strncasecmp(inbuffer,"TARTIST",7)) {
		/* data->data_multi_artist=TRUE;
		 * track=atoi(strtok(inbuffer+7,"="));
		 * if(track<numtracks)
		 * 	len=strlen(data->data_track[track].track_artist);
		 * st = strtok(NULL, "");
		 * if(st == NULL) return;
		 * g_snprintf(data->data_track[track].track_artist+len,256-len,"%s", g_strstrip(st));
		 */
	}
	else if(!strncasecmp(inbuffer,"EXTD",4)) {
		/* len=strlen(data->data_extended);
		 * g_snprintf(data->data_extended+len,4096-len,"%s",g_strstrip(inbuffer+5));
		 */
	}
	else if(!strncasecmp(inbuffer,"EXTT",4)) {
		/* track=atoi(strtok(inbuffer+4,"="));
		 * if(track<numtracks)
		 * len=strlen(data->data_track[track].track_extended);
		 * st = strtok(NULL, "");
		 * if(st == NULL) return;
		 * g_snprintf(data->data_track[track].track_extended+len,4096-len,"%s", g_strstrip(st));
		 */
	}
	else if(!strncasecmp(inbuffer,"PLAYORDER",5)) {
		/* len=strlen(data->data_playlist);
		 * g_snprintf(data->data_playlist+len,256-len,"%s",g_strstrip(inbuffer+10));
		 */
	}
}


/* Interroge la base sur la composition du cd
 */
gboolean cddb_disc_db_read (CD_TOC *CdToc)
{
	gchar   *result = NULL;
	gchar   *inbuffer = NULL;
	gchar   *dataptr = NULL;
	gchar   *PathCurl = NULL;
	gchar   *PathName = NULL;
	GList   *LIST = NULL;
	GList   *list = NULL;
	
/*
	PRINT_FUNC_LF();

g_print("CdToc->NumGenre = %d\n",CdToc->NumGenre);
g_print("cddb_disc_db_genre (CdToc->NumGenre) = %s\n",cddb_disc_db_genre (CdToc->NumGenre));
*/
	/* Premiere allocation */
	conv.ArgConv = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * 100);

	GDK_THREADS_ENTER();

	LIST = g_list_append (LIST, g_strdup ("cddb-tool"));
	LIST = g_list_append (LIST, g_strdup ("read"));
	LIST = g_list_append (LIST, g_strdup ("http://freedb.freedb.org/~cddb/cddb.cgi"));
	LIST = g_list_append (LIST, g_strdup ("6"));
	LIST = g_list_append (LIST, g_strdup ("cat"));
	LIST = g_list_append (LIST, g_strdup ("cat-desktop"));
	LIST = g_list_append (LIST, g_strdup_printf ("%s", cddb_disc_db_genre (CdToc->NumGenre)));
	LIST = g_list_append (LIST, g_strdup_printf ("%08lx", CdToc->Num_ID_CD));
	
	GDK_THREADS_LEAVE();

	conv_exec (FALSE, CDDB_TOOL, LIST, "CDDB_TOOL");
	list = LIST = filelc_remove_glist (LIST);
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	result = utils_get_datas_on_disk ();
	g_free (PathName);
	PathName = NULL;
	g_free (PathCurl);
	PathCurl = NULL;
/*
PRINT_FUNC_LF();
g_print("%s\n",result);
*/
	if(!result) {
		/*
		g_print ("\7!---------------------------------------------!\7\n");
		g_print ("\7! cddb_disc_db_read::VOUS N ETES PAS CONNECTE AU WEB !\7\n");
		g_print ("\7!---------------------------------------------!\7\n");
		*/
		return FALSE;
	} else {
		/*
		g_print ("!---------------------------------------!\n");
		g_print ("! cddb_disc_db_read::VOUS ETES CONNECTE AU WEB !\n");
		g_print ("!---------------------------------------!\n");
		g_print ("%s\n", result);
		*/
	}	

	dataptr = result;

	inbuffer = cddb_line_next (&dataptr);

	CdToc->BoolMultiArtiste = FALSE;
	
	while ((inbuffer = cddb_line_next (&dataptr))) {
		if (strstr (inbuffer, "TTITLE") && strstr (inbuffer, " / ")) {
			CdToc->BoolMultiArtiste = TRUE;
		}
		
		cddb_disc_db_process_line (CdToc, inbuffer);
		
	}


	if (CdToc->StrGenre == NULL) {
		if (CdToc->NumGenre < 0 ) CdToc->NumGenre = 0;
		CdToc->StrGenre = g_strdup_printf ("Blues");
	}
	else {
		CdToc->NumGenre = infosong_get_genre_by_value (CdToc->StrGenre);
	}
	
	g_free (result);
	result = NULL;
	
	return (TRUE);
}

/*
*/
CD_TOC *cddb_get_datas_cddb (CD_TOC *CdToc)
{
	DO_QUERY   DoQuery;
	gint       Pass = 0;

	while ((DoQuery = cddb_disc_db_do_query (CdToc)) == DO_ENCORE) {
		if (bool_cancel_cddb == TRUE) {
			g_print ("\n");
			PRINT_FUNC_LF();
			g_print ("DEMANDE D'ANNULATION DE LA BASE CDBB\n");
			return (CdToc);
		}
				
		/* IF FAUT LIMITER LE NOMBRE DE PASSAGES !!!
		*/
		if (Pass ++ > 2) {
			DoQuery = DO_FALSE;
			break;
		}
	}

	if (bool_cancel_cddb == TRUE) {
		g_print ("\n");
		PRINT_FUNC_LF();
		g_print ("DEMANDE D'ANNULATION DE LA BASE CDBB\n");
		return (CdToc);
	}

	if (DoQuery == DO_TRUE) {
		if (bool_cancel_cddb == TRUE) {
			g_print ("\n");
			PRINT_FUNC_LF();
			g_print ("DEMANDE D'ANNULATION DE LA BASE CDBB\n");
			return (CdToc);
		}
		if (cddb_test_access_web () == TRUE) {
			CdToc->Bool_Connected = CONNECT_IS_TRUE;
			cddb_disc_db_read (CdToc);
		}
		else {
			CdToc->Bool_Connected = CONNECT_IS_FALSE;
		}
	}
	if (DoQuery == DO_NO_MATCH_FOUND) {
		CdToc->Bool_Connected = CONNECT_IS_NO_MATCH_FOUND;
	}
	
	if (CdToc->TitleCD == NULL)	CdToc->TitleCD = g_strdup ("");
	
	/*
	g_print ("CdToc->TitleCD         = %s\n", CdToc->TitleCD);
	g_print ("CdToc->TT_Min          = %d\n", CdToc->TT_Min);
	g_print ("CdToc->TT_Sec          = %d\n", CdToc->TT_Sec);
	g_print ("CdToc->Str_ID_CD       = %s\n", CdToc->Str_ID_CD);
	g_print ("CdToc->TotalTracks     = %d\n", CdToc->TotalTracks);
	g_print ("CdToc->NumGenre        = %d\n", CdToc->NumGenre);
	g_print ("CdToc->StrGenre        = %s\n", CdToc->StrGenre);
	g_print ("CdToc->NumYear         = %d\n", CdToc->NumYear);
	g_print ("CdToc->StrYear         = %s\n", CdToc->StrYear);

	g_print ("CdToc->Bool_Connected  = ");
	if (CdToc->Bool_Connected == CONNECT_IS_TRUE)			g_print ("CONNECT_IS_TRUE\n");
	else if (CdToc->Bool_Connected == CONNECT_IS_FALSE)		g_print ("CONNECT_IS_FALSE\n");
	else if (CdToc->Bool_Connected == CONNECT_IS_NO_MATCH_FOUND)	g_print ("CONNECT_IS_NO_MATCH_FOUND\n");
	else {							g_print ("ERREUR: CODE A VERIFIER :(\n");
		gint i;
		for (i = 0; i < CdToc->TotalTracks; i++)
			if (CdToc->TimeTrack [ i ].TitleTrack)
				g_print ("TITLE_%d = %s\n", i, CdToc->TimeTrack [ i ].TitleTrack);
	}

	{
	gint i;
	for (i = 0; i < CdToc->TotalTracks; i++)
		if (CdToc->TimeTrack [ i ].TitleTrack)
			g_print ("TITLE_%02d = %s\n", i, CdToc->TimeTrack [ i ].TitleTrack);
	}
	*/

	return (CdToc);
}







