 /*
 * file      : config_user.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gprintf.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <string.h>

#include "global.h"
#include "utils.h"
#include "info_song.h"
#include "file.h"
#include "fileselect.h"
#include "prg_navigator.h"
#include "prg_postscript.h"
#include "showhide_treeview.h"
#include "config_user.h"
#include "prg_audio.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/* 'ConfigUserSave' est utilise pour la remise par defaut des options
*/
CONFIG_USER ConfigUserSave = {NULL, FALSE, FALSE, -1};

/* 'Config_User' contiendra les différentes valeurs des options
*/
CONFIG_USER Config_User = {
	NULL,     /* Numero de version							*/
	FALSE,    /* BoolNewVersion							*/
	FALSE,    /* Bool_Config_Ok							*/
	0,        /* Window Position X							*/
	0,        /* Window Position Y							*/
	0,        /* Window Width							*/
	0,        /* Window Height							*/

	0,        /* Priorite systeme: 0..19						*/

	{
	1,        /* Bitrate Lame,     par defaut ABR					*/
	12,       /* If_abr            par defaut 256					*/
	8,        /* If_cbr            par defaut preset insane				*/
	1,        /* If_vbr            par defaut preset standard			*/
	1,        /* If_vbr_new        par defaut preset standard			*/
	0,        /* Mode Lame,        par defaut 'Stereo'				*/
	15,       /* Bitrate Oggenc,   par defaut '256'					*/
	1,        /* Managed Oggenc							*/
	1,        /* Downmix Oggenc							*/
	},
	{
	1,        /* Bitrate Lame,     par defaut ABR					*/
	12,       /* If_abr            par defaut 256					*/
	8,        /* If_cbr            par defaut preset insane				*/
	1,        /* If_vbr            par defaut preset standard			*/
	1,        /* If_vbr_new        par defaut preset standard			*/
	0,        /* Mode Lame,        par defaut 'Stereo'				*/
	15,       /* Bitrate Oggenc,   par defaut '256'					*/
	1,        /* Managed Oggenc							*/
	1,        /* Downmix Oggenc							*/
	},
	
	NULL,     /* Dest of extracting CD						*/
	NULL,     /* Dest of extracting DVD						*/
	NULL,     /* Dest of converting file						*/
	NULL,     /* Dest of converting file wav					*/
	NULL,     /* Dest of converting file mp3ogg					*/
	NULL,     /* Dest of converting file split					*/
	NULL,     /* Path of load file							*/
	NULL,     /* Path of load file to SOX						*/
	NULL,     /* Path of load file to MP3OGG					*/
	NULL,     /* Path of load file SPLIT to MP3OGG					*/
	NULL,     /* Path load of image							*/
	NULL,     /* Path_Load_file_CUE							*/
	NULL,     /* Path Stocke of poche-image						*/
	NULL,     /* Path Dest File PostScript						*/
	NULL,     /* Path Load File DVD							*/
	NULL,     /* Path d'extractions / conversions					*/

	NULL,    /* Nom du fichier m3u							*/
	
	TRUE,    /* TRUE if set tag artist						*/
	TRUE,    /* TRUE if set tag title						*/
	TRUE,    /* TRUE if set tag album						*/
	TRUE,    /* TRUE if set tag numerate						*/
	TRUE,    /* TRUE if set tag genre						*/
	TRUE,    /* TRUE if set tag year						*/
	TRUE,    /* TRUE if set tag comment						*/

	0,        /* auto, at, ca, de, fi, fr, no, uk, us				*/
	TRUE,     /* TRUE = ioctl, FALSE = cdparanoia					*/
	0,        /* Extract_cd_with: cdparanoia=0, icedax=1, CdparanoiaExpert=2	*/
	5,        /* compression_level_flac in 0 .. 12					*/
	1,        /* compression_level_ape in 0 .. 4 					*/

	5,        /* quality_mppenc							*/
	0,        /* compression_wavpack						*/
	1,        /* sound_wavpack							*/
	0,        /* wavpack_mode_hybride						*/
	0,        /* wavpack_correction_file						*/
	0,        /* wavpack_maximum_compression					*/
	0,        /* wavpack_signature_md5						*/
	0,        /* wavpack_extra_encoding						*/

	0,        /* faac_conteneur							*/
	0,        /* faac_choice_vbr_abr						*/
	6,        /* faac_set_choice_vbr						*/
	0,        /* faac_set_choice_abr						*/

	7,        /* aacplusenc_choice_mono						*/
	4,        /* aacplusenc_choice_stereo						*/

	TRUE,     /* GoTo tongle							*/

	FALSE,     /* TRUE = Load images ELSE FALSE = none				*/

	50,       /* Valeur de FIX onglet dvd-audio					*/
	50,       /* Valeur de FIX onglet cd-audio					*/
	50,       /* Valeur de FIX onglet fichiers					*/

	NULL,     /* Chaine des templates						*/
	NULL,     /* Dossier de sauvegarde des fichiers cdaudio				*/

	2,        /* Value_choice_file_dest						*/
	2,        /* Value_choice_file_dest_wav						*/
	2,        /* Value_choice_file_mp3ogg_dest					*/
	2,        /* Value_choice_split							*/

	NULL,     /* String_expander_Lame						*/
	NULL,     /* String_expander_Oggenc						*/
	NULL,     /* String_expander_Flac						*/
	NULL,     /* String_expander_Faac						*/
	NULL,     /* String_expander_Mppenc						*/
	NULL,     /* String_expander_Mac						*/
	NULL,     /* String_expander_Wavpack						*/

	0,        /* Gestionnaire de paquets: 0 = apt-get, 1 = aptitude			*/

	TRUE,     /* Bool_save_pos_notebook						*/
	0,        /* notebook_general							*/
	0,        /* notebook_expander_cd						*/
	0,        /* notebook_file							*/
	0,        /* notebook_options							*/
	0,        /* notebook_pochette							*/
	0,        /* notebook_logs							*/
	0 ,       /* notebook_app							*/

	NULL,     /* *StringBoolFieldsIsVisible						*/
	"111111", /* gchar StringPosFieldsName [ 16 ];					*/
		  /* dvd,cd,files,wav,mp3ogg,split: 0=left, 1=center, 2=right		*/
	
	TRUE,     /* BoolEtatExpanderFile  -> TRUE is open else FALSE			*/
	TRUE,     /* BoolEtatExpanderCd    -> TRUE is open else FALSE			*/
	0         /* IntSelectCd           -> 0=entry is one, etc ...			*/
};

#define PATH_XCFA_CONF     ".config/xcfa"
#define PATHNAME_XCFA_CONF ".config/xcfa/xcfa.conf"

typedef enum {
_VERSION_ = 0,
_NEW_VERSION_,
WIN_POS_X,
WIN_POS_Y,
WIN_WIDTH,
WIN_HEIGHT,
NICE,

OPTIONS_BITRATE_LAME,
OPTIONS_VALUE_ABR,
OPTIONS_VALUE_CBR,
OPTIONS_VALUE_VBR,
OPTIONS_VALUE_VBR_NEW,
OPTIONS_BITRATE_OGGENC,
OPTIONS_MANAGED_OGGENC,
OPTIONS_DOWNMIX_OGGENC,
OPTIONS_MODE_LAME,

FILE_BITRATE_LAME,
FILE_VALUE_ABR,
FILE_VALUE_CBR,
FILE_VALUE_VBR,
FILE_VALUE_VBR_NEW,
FILE_BITRATE_OGGENC,
FILE_MANAGED_OGGENC,
FILE_DOWNMIX_OGGENC,
FILE_MODE_LAME,

PATH_DESTINATION_CD,
PATH_DESTINATION_DVD,
PATH_DESTINATION_FILE,
PATH_DESTINATION_FILE_WAV,
PATH_DESTINATION_FILE_MP3OGG,
PATH_DESTINATION_SPLIT,
PATH_LOAD_FILE,
PATH_IMPORT_FILE_WAV,
PATH_IMPORT_FILE_MP3OGG,
PATH_IMPORT_FILE_SPLIT_MP3OGG,
PATH_LOAD_IMAGES,
PATH_LOAD_FILE_CUE,
PATH_STOCKE_POCHE_IMAGES,
PATH_DEST_FILE_POSTSCRIPT,
PATH_LOAD_FILE_DVD,
PATH_TMP,
NAME_FILE_M3U,
IS_TAG_ARTIST,
IS_TAG_TITLE,
IS_TAG_ALBUM,
IS_TAG_NUMERATE,
IS_TAG_GENRE,
IS_TAG_YEAR,
IS_TAG_COMMENT,
FILE_POSTSCRIPT,
NAVIGATORS_ACTIF,
NAVIGATORS,
LECTEUR_AUDIO_ACTIF,
LECTEUR_AUDIO,
PARAM_LECTEUR_AUDIO,
READDIR_CDAUDIO_BY_IOCTL,
EXTRACT_CD_WITH,
COMPRESSION_LEVEL_FLAC,
COMPRESSION_LEVEL_APE,
QUALITY_MPPENC,
COMPRESSION_WAVPACK,
WAVPACK_SOUND,
WAVPACK_MODE_HYBRIDE,
WAVPACK_CORRECTION_FILE,
WAVPACK_MAXIMUM_COMPRESSION,
WAVPACK_SIGNATURE_MD5,
WAVPACK_EXTRA_ENCODING,
FAAC_CONTENEUR,
FAAC_CHOICE_VBR_ABR,
FAAC_SET_CHOICE_VBR,
FAAC_SET_CHOICE_ABR,
AACPLUSENC_CHOICE_MONO,
AACPLUSENC_CHOICE_STEREO,
GOTO_TONGLE_FILE_IMPORT,
SERVER_FREECDDB,
INIT_LOAD_IMG_XCFA,
VALUE_FIX_DVDAUDIO,
VALUE_FIX_CDAUDIO,
VALUE_FIX_FICHIERS,
TEMPLATE_TITLE_CDAUDIO,
TEMPLATE_REP_CDAUDIO,
VALUE_CHOICE_FILE_DEST,
VALUE_CHOICE_FILE_DEST_WAV,
VALUE_CHOICE_FILE_MP3OGG_DEST,
VALUE_CHOICE_SPLIT,
String_expander_Lame,
String_expander_Oggenc,
String_expander_Flac,
String_expander_Faac,
String_expander_Mppenc,
String_expander_Mac,
String_expander_Wavpack,
ADMINISTRATOR_OF_PACKETS,
BOOL_SAVE_POS_NOTEBOOK,
POS_NOTEBOOK_GENERAL,
POS_NOTEBOOK_EXPANDER_CD,
POS_NOTEBOOK_FILE,
POS_NOTEBOOK_OPTIONS,
POS_NOTEBOOK_POCHETTE,
POS_NOTEBOOK_LOGS,
POS_NOTEBOOK_APP,
STRING_BOOL_FIELD_IS_VISIBLE,
STRING_POS_FIELDS_NAME,
BOOL_ETAT_EXPANDER_FILE,
BOOL_ETAT_EXPANDER_CD,

INT_SELECT_CD,

NONE_MOTS_CLEFS,

ALL_MOTS_CLEFS

} DEFS_MOTS;



typedef struct {
	gchar		*str;		/* Nom				*/
	DEFS_MOTS	 num;		/* Numero			*/
	gboolean	 BoolPass;	/* TRUE is OK else FALSE	*/
} MOTS_CLEFS;


MOTS_CLEFS mots_clefs[] = {
{"VERSION",				_VERSION_,			FALSE },
{"NEW_VERSION",				_NEW_VERSION_,			FALSE },
{"WIN_POS_X",				WIN_POS_X,			FALSE },
{"WIN_POS_Y",				WIN_POS_Y,			FALSE },
{"WIN_WIDTH",				WIN_WIDTH,			FALSE },
{"WIN_HEIGHT",				WIN_HEIGHT,			FALSE },
{"NICE",				NICE,				FALSE },

{"OPTIONS_BITRATE_LAME",		OPTIONS_BITRATE_LAME,		FALSE },
{"OPTIONS_VALUE_ABR",			OPTIONS_VALUE_ABR,		FALSE },
{"OPTIONS_VALUE_CBR",			OPTIONS_VALUE_CBR,		FALSE },
{"OPTIONS_VALUE_VBR",			OPTIONS_VALUE_VBR,		FALSE },
{"OPTIONS_VALUE_VBR_NEW",		OPTIONS_VALUE_VBR_NEW,		FALSE },
{"OPTIONS_BITRATE_OGGENC",		OPTIONS_BITRATE_OGGENC,		FALSE },
{"OPTIONS_MANAGED_OGGENC",		OPTIONS_MANAGED_OGGENC,		FALSE },
{"OPTIONS_DOWNMIX_OGGENC",		OPTIONS_DOWNMIX_OGGENC,		FALSE },
{"OPTIONS_MODE_LAME",			OPTIONS_MODE_LAME,		FALSE },

{"FILE_BITRATE_LAME",			FILE_BITRATE_LAME,		FALSE },
{"FILE_VALUE_ABR",			FILE_VALUE_ABR,			FALSE },
{"FILE_VALUE_CBR",			FILE_VALUE_CBR,			FALSE },
{"FILE_VALUE_VBR",			FILE_VALUE_VBR,			FALSE },
{"FILE_VALUE_VBR_NEW",			FILE_VALUE_VBR_NEW,		FALSE },
{"FILE_BITRATE_OGGENC",			FILE_BITRATE_OGGENC,		FALSE },
{"FILE_MANAGED_OGGENC",			FILE_MANAGED_OGGENC,		FALSE },
{"FILE_DOWNMIX_OGGENC",			FILE_DOWNMIX_OGGENC,		FALSE },
{"FILE_MODE_LAME",			FILE_MODE_LAME,			FALSE },

{"PATH_DESTINATION_CD",			PATH_DESTINATION_CD,		FALSE },
{"PATH_DESTINATION_DVD",		PATH_DESTINATION_DVD,		FALSE },
{"PATH_DESTINATION_FILE",		PATH_DESTINATION_FILE,		FALSE },
{"PATH_DESTINATION_FILE_WAV",		PATH_DESTINATION_FILE_WAV,	FALSE },
{"PATH_DESTINATION_FILE_MP3OGG",	PATH_DESTINATION_FILE_MP3OGG,	FALSE },
{"PATH_DESTINATION_SPLIT",		PATH_DESTINATION_SPLIT,		FALSE },
{"PATH_LOAD_FILE",			PATH_LOAD_FILE,			FALSE },
{"PATH_IMPORT_FILE_WAV",		PATH_IMPORT_FILE_WAV,		FALSE },
{"PATH_IMPORT_FILE_MP3OGG",		PATH_IMPORT_FILE_MP3OGG,	FALSE },
{"PATH_IMPORT_FILE_SPLIT_MP3OGG",	PATH_IMPORT_FILE_SPLIT_MP3OGG,	FALSE },
{"PATH_LOAD_IMAGES",			PATH_LOAD_IMAGES,		FALSE },

{"PATH_LOAD_FILE_CUE",			PATH_LOAD_FILE_CUE,		FALSE },

{"PATH_STOCKE_POCHE_IMAGES",		PATH_STOCKE_POCHE_IMAGES,	FALSE },
{"PATH_DEST_FILE_POSTSCRIPT",		PATH_DEST_FILE_POSTSCRIPT,	FALSE },
{"PATH_LOAD_FILE_DVD",			PATH_LOAD_FILE_DVD,		FALSE },
{"PATH_TMP",				PATH_TMP,			FALSE },
{"NAME_FILE_M3U",			NAME_FILE_M3U,			FALSE },
{"IS_TAG_ARTIST",			IS_TAG_ARTIST,			FALSE },
{"IS_TAG_TITLE",			IS_TAG_TITLE,			FALSE },
{"IS_TAG_ALBUM",			IS_TAG_ALBUM,			FALSE },
{"IS_TAG_NUMERATE",			IS_TAG_NUMERATE,		FALSE },
{"IS_TAG_GENRE",			IS_TAG_GENRE,			FALSE },
{"IS_TAG_YEAR",				IS_TAG_YEAR,			FALSE },
{"IS_TAG_COMMENT",			IS_TAG_COMMENT,			FALSE },
{"FILE_POSTSCRIPT",			FILE_POSTSCRIPT,		FALSE },
{"NAVIGATORS_ACTIF",			NAVIGATORS_ACTIF,		FALSE },
{"NAVIGATORS",				NAVIGATORS,			FALSE },
{"LECTEUR_AUDIO_ACTIF",			LECTEUR_AUDIO_ACTIF,		FALSE },
{"LECTEUR_AUDIO",			LECTEUR_AUDIO,			FALSE },
{"PARAM_LECTEUR_AUDIO",			PARAM_LECTEUR_AUDIO,		FALSE },
{"READDIR_CDAUDIO_BY_IOCTL",		READDIR_CDAUDIO_BY_IOCTL,	FALSE },
{"EXTRACT_CD_WITH",			EXTRACT_CD_WITH,		FALSE },
{"COMPRESSION_LEVEL_FLAC",		COMPRESSION_LEVEL_FLAC,		FALSE },
{"COMPRESSION_LEVEL_APE",		COMPRESSION_LEVEL_APE,		FALSE },
{"QUALITY_MPPENC",			QUALITY_MPPENC,			FALSE },
{"COMPRESSION_WAVPACK",			COMPRESSION_WAVPACK,		FALSE },
{"WAVPACK_SOUND",			WAVPACK_SOUND,			FALSE },
{"WAVPACK_MODE_HYBRIDE",		WAVPACK_MODE_HYBRIDE,		FALSE },
{"WAVPACK_CORRECTION_FILE",		WAVPACK_CORRECTION_FILE,	FALSE },
{"WAVPACK_MAXIMUM_COMPRESSION",		WAVPACK_MAXIMUM_COMPRESSION,	FALSE },
{"WAVPACK_SIGNATURE_MD5",		WAVPACK_SIGNATURE_MD5,		FALSE },
{"WAVPACK_EXTRA_ENCODING",		WAVPACK_EXTRA_ENCODING,		FALSE },

{"FAAC_CONTENEUR",			FAAC_CONTENEUR,			FALSE },
{"FAAC_CHOICE_VBR_ABR",			FAAC_CHOICE_VBR_ABR,		FALSE },
{"FAAC_SET_CHOICE_VBR",			FAAC_SET_CHOICE_VBR,		FALSE },
{"FAAC_SET_CHOICE_ABR",			FAAC_SET_CHOICE_ABR,		FALSE },

{"AACPLUSENC_CHOICE_MONO",		AACPLUSENC_CHOICE_MONO,		FALSE },
{"AACPLUSENC_CHOICE_STEREO",		AACPLUSENC_CHOICE_STEREO,	FALSE },

{"GOTO_TONGLE_FILE_IMPORT",		GOTO_TONGLE_FILE_IMPORT,	FALSE },
{"SERVER_FREECDDB",			SERVER_FREECDDB,		FALSE },
{"INIT_LOAD_IMG_XCFA",			INIT_LOAD_IMG_XCFA,		FALSE },
{"VALUE_FIX_DVDAUDIO",			VALUE_FIX_DVDAUDIO,		FALSE },
{"VALUE_FIX_CDAUDIO",			VALUE_FIX_CDAUDIO,		FALSE },
{"VALUE_FIX_FICHIERS",			VALUE_FIX_FICHIERS,		FALSE },
{"TEMPLATE_TITLE_CDAUDIO",		TEMPLATE_TITLE_CDAUDIO,		FALSE },
{"TEMPLATE_REP_CDAUDIO",		TEMPLATE_REP_CDAUDIO,		FALSE },
{"VALUE_CHOICE_FILE_DEST",		VALUE_CHOICE_FILE_DEST,		FALSE },
{"VALUE_CHOICE_FILE_DEST_WAV",		VALUE_CHOICE_FILE_DEST_WAV,	FALSE },
{"VALUE_CHOICE_FILE_MP3OGG_DEST",	VALUE_CHOICE_FILE_MP3OGG_DEST,	FALSE },
{"VALUE_CHOICE_SPLIT",			VALUE_CHOICE_SPLIT,		FALSE },
{"String_expander_Lame",		String_expander_Lame,		FALSE },
{"String_expander_Oggenc",		String_expander_Oggenc,		FALSE },
{"String_expander_Flac",		String_expander_Flac,		FALSE },
{"String_expander_Faac",		String_expander_Faac,		FALSE },
{"String_expander_Mppenc",		String_expander_Mppenc,		FALSE },
{"String_expander_Mac",			String_expander_Mac,		FALSE },
{"String_expander_Wavpack",		String_expander_Wavpack,	FALSE },
{"ADMINISTRATOR_OF_PACKETS",		ADMINISTRATOR_OF_PACKETS,	FALSE },
{"BOOL_SAVE_POS_NOTEBOOK",		BOOL_SAVE_POS_NOTEBOOK,		FALSE },
{"POS_NOTEBOOK_GENERAL",		POS_NOTEBOOK_GENERAL,		FALSE },
{"POS_NOTEBOOK_EXPANDER_CD",		POS_NOTEBOOK_EXPANDER_CD,	FALSE },
{"POS_NOTEBOOK_FILE",			POS_NOTEBOOK_FILE,		FALSE },
{"POS_NOTEBOOK_OPTIONS",		POS_NOTEBOOK_OPTIONS,		FALSE },
{"POS_NOTEBOOK_POCHETTE",		POS_NOTEBOOK_POCHETTE,		FALSE },
{"POS_NOTEBOOK_LOGS",			POS_NOTEBOOK_LOGS,		FALSE },
{"POS_NOTEBOOK_APP",			POS_NOTEBOOK_APP,		FALSE },
{"STRING_BOOL_FIELD_IS_VISIBLE",	STRING_BOOL_FIELD_IS_VISIBLE,	FALSE },
{"STRING_POS_FIELDS_NAME",		STRING_POS_FIELDS_NAME,		FALSE },
{"BOOL_ETAT_EXPANDER_FILE",		BOOL_ETAT_EXPANDER_FILE,	FALSE },
{"BOOL_ETAT_EXPANDER_CD",		BOOL_ETAT_EXPANDER_CD,		FALSE },
{"INT_SELECT_CD",			INT_SELECT_CD,			FALSE },

{"",					NONE_MOTS_CLEFS,		FALSE }
};




DEFS_MOTS configuser_get_mot_clef (gchar *mot)
{
	gint i;

	for (i = 0; i < ALL_MOTS_CLEFS; i ++) {
		if (strcmp (mot, mots_clefs[i].str) == 0) {
			return (mots_clefs[i].num);
		}
	}
	return (NONE_MOTS_CLEFS);
}

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

/* Search 'mot' and 'value' in '*line'
*  Return TRUE if find else return FALSE
*  --
*  entree :
*      gchar *line  : pointeur sur le texte initial
*      gchar *mot   : mot cle
*      gchar *value : valeur du mot cle
*      gint MaxCars : longueur maxi de 'gchar *line' a traiter
*
*  retour :
*      Le type de mot-cle trouves
*
*  info :
*      MOT=VALUE
*
*  GOOD example (BON exemple):
*      WIN_POS_X=105
*      PATH_DESTINATION_CD=/home/user/Musique
*
*  BAD example (MAUVAIS exemple) :
*      WIN_POS_X = 105
*            Space on rigth sign ' = '
*      PATH_DESTINATION_CD= /home/user/Musique
*            Space on rigth sign '= '
*
*      ==> NO SPACE ON RIGTH SIGN (=)
*/
DEFS_MOTS configuser_analyse_line_buf (gchar *line, gchar *mot, gchar *value, gint MaxCars)
{
	gint        Indice;
	DEFS_MOTS   def_mot = NONE_MOTS_CLEFS;
	gchar      *ptrmot = mot;

	/* PRINT_FUNC_LF(); */

	/**/
	if (value == NULL || mot == NULL) return (NONE_MOTS_CLEFS);

	/* test source */
	if (line == NULL || *line == '\0' || *line == '\n') return (NONE_MOTS_CLEFS);

	/* Si pas de signe '=' retour */
	if (strchr (line, '=') == NULL) return (NONE_MOTS_CLEFS);

	/* init strings */
	*mot = '\0';
	*value = '\0';

	/* aller au premier caractere valide pour MOT */
	while (*line) {
		if (*line == '#') return (NONE_MOTS_CLEFS);
		if (*line != ' ' && *line != '\t') break;
		line ++;
	}

	/* Stocker MOT */
	Indice = 1;
	while (*line) {
		if (Indice >= MaxCars) break;
		if (*line == '#') return (NONE_MOTS_CLEFS);
		if (*line == ' ' || *line == '\t' || *line == '=') break;
		*ptrmot ++ = *line ++;
	}
	*ptrmot = '\0';

	/* aller au premier caractere valide pour VALUE */
	while (*line) {
		if (*line == '#') return (NONE_MOTS_CLEFS);
		if (*line == '=') {
			line ++;
			break;
		}
		line ++;
	}
	/***
	Ne pas prendre en compte les espaces et tabulations apres les signe '='

	while (*line) {
		if (*line != ' ' && *line != '\t') break;
		line ++;
	}
	***/
	/***
	Tous les caracteres apres le signe '=' sont pris en compte
	----------------------------------------------------------
	***/

	/* Stocker VALUE */
	Indice = 1;
	while (*line) {
		if (Indice >= MaxCars) break;
		if (*line == '#') break;
		if (*line == '\n') break;
		if (*line == '\r') break;

		*value ++ = *line ++;
	}
	*value = '\0';
	
	def_mot = configuser_get_mot_clef (mot);

	return (def_mot);
}

/* Le contenu de '*value' est convertit en majuscule. Si ce contenu
*  est egale a 'TRUE' renvoie TRUE sinon FALSE
*  --
*  entree :
*      gchar *value :
*  retour :
*      TRUE  : si '*value' est egale a la chaine 'TRUE'
*      FALSE :
*/
gboolean configuser_get_bool (gchar *value)
{
	gchar *ptr = value;

	/* PRINT_FUNC_LF(); */

	while (*ptr) {
		*ptr = toupper (*ptr);
		ptr++;
	}
	return (!strncmp (value, "TRUE", strlen ("TRUE")) ? TRUE : FALSE);
}

/* Set new parameter if find
*  Test si les parametres sont coherants et au besoin les rectifient
*  --
*  entree :
*      gchar *mot   : mot cle
*      gchar *value : valeur du mot cle
*  retour : -
*/
void configuser_change_parameters (DEFS_MOTS def_mot, gchar *value)
{
	gchar		 str [ 512 ];
	PRGAUDIO_SAVE	*PrgAudioSave = NULL;

	/*PRINT_FUNC_LF();*/

	strcpy (str, mots_clefs[ def_mot ].str);
	while (strlen (str) < 30) strcat (str, " ");
	strcat (str, "= ");
	strcat (str, value);
	g_print ("%s\n", str);
	
	mots_clefs[ def_mot ].BoolPass = TRUE;
	
	switch (def_mot) {

	case _VERSION_ :
		Config_User.Version = g_strdup (value);
		break;
	case _NEW_VERSION_ :
		break;
		
	case WIN_POS_X :
		Config_User.WinPos_X = atoi (value);
		if (Config_User.WinPos_X < 0) Config_User.WinPos_X = 0;
		break;
	case WIN_POS_Y :
		Config_User.WinPos_Y = atoi (value);
		if (Config_User.WinPos_Y < 0) Config_User.WinPos_Y = 0;
		break;
	case WIN_WIDTH :
		Config_User.Win_Width = atoi (value);
		if (Config_User.Win_Width == 0) Config_User.Win_Width = 20;
		break;
	case WIN_HEIGHT :
		Config_User.Win_Height = atoi (value);
		if (Config_User.Win_Height == 0) Config_User.Win_Height = 20;
		break;
	case NICE :
		Config_User.Nice = atoi (value);
		if (Config_User.Nice < 0 || Config_User.Nice > 19) Config_User.Nice = 0;
		break;
	
	
	case OPTIONS_BITRATE_LAME :
		Config_User.RateMp3OggOptions.Bitrate_type_Lame = atoi (value);
		if (Config_User.RateMp3OggOptions.Bitrate_type_Lame < 0 || Config_User.RateMp3OggOptions.Bitrate_type_Lame > 3)
			Config_User.RateMp3OggOptions.Bitrate_type_Lame = 0;
		break;
	case OPTIONS_VALUE_ABR :
		Config_User.RateMp3OggOptions.If_abr = atoi (value);
		if (Config_User.RateMp3OggOptions.If_abr < 0 || Config_User.RateMp3OggOptions.If_abr > 13) Config_User.RateMp3OggOptions.If_abr = 12;
		break;
	case OPTIONS_VALUE_CBR :
		Config_User.RateMp3OggOptions.If_cbr = atoi (value);
		if (Config_User.RateMp3OggOptions.If_cbr < 0 || Config_User.RateMp3OggOptions.If_cbr > 14) Config_User.RateMp3OggOptions.If_cbr = 14;
		break;
	case OPTIONS_VALUE_VBR :
		Config_User.RateMp3OggOptions.If_vbr = atoi (value);
		if (Config_User.RateMp3OggOptions.If_vbr < 0 || Config_User.RateMp3OggOptions.If_vbr > 14) Config_User.RateMp3OggOptions.If_vbr = 1;
		break;
	case OPTIONS_VALUE_VBR_NEW :
		Config_User.RateMp3OggOptions.If_vbr_new = atoi (value);
		if (Config_User.RateMp3OggOptions.If_vbr_new < 0 || Config_User.RateMp3OggOptions.If_vbr_new > 15) Config_User.RateMp3OggOptions.If_vbr_new = 1;
		break;
	case OPTIONS_BITRATE_OGGENC :
		Config_User.RateMp3OggOptions.Bitrate_Oggenc = atoi (value);
		if (Config_User.RateMp3OggOptions.Bitrate_Oggenc < 0 || Config_User.RateMp3OggOptions.Bitrate_Oggenc > 22)
			Config_User.RateMp3OggOptions.Bitrate_Oggenc = 0;
		break;
	case OPTIONS_MANAGED_OGGENC :
		Config_User.RateMp3OggOptions.Managed_Oggenc = atoi (value);
		if (Config_User.RateMp3OggOptions.Managed_Oggenc < 0 || Config_User.RateMp3OggOptions.Managed_Oggenc > 1)
			Config_User.RateMp3OggOptions.Managed_Oggenc = 0;
		break;
	case OPTIONS_DOWNMIX_OGGENC :
		Config_User.RateMp3OggOptions.Downmix_Oggenc = atoi (value);
		if (Config_User.RateMp3OggOptions.Downmix_Oggenc < 0 || Config_User.RateMp3OggOptions.Downmix_Oggenc > 1)
			Config_User.RateMp3OggOptions.Downmix_Oggenc = 0;
		break;
	case OPTIONS_MODE_LAME :
		Config_User.RateMp3OggOptions.Mode_Lame = atoi (value);
		if (Config_User.RateMp3OggOptions.Mode_Lame < 0 || Config_User.RateMp3OggOptions.Mode_Lame > 5) Config_User.RateMp3OggOptions.Mode_Lame = 0;
		break;
	
	
	case FILE_BITRATE_LAME :
		Config_User.RateMp3OggFile.Bitrate_type_Lame = atoi (value);
		if (Config_User.RateMp3OggFile.Bitrate_type_Lame < 0 || Config_User.RateMp3OggFile.Bitrate_type_Lame > 3)
			Config_User.RateMp3OggFile.Bitrate_type_Lame = 0;
		break;
	case FILE_VALUE_ABR :
		Config_User.RateMp3OggFile.If_abr = atoi (value);
		if (Config_User.RateMp3OggFile.If_abr < 0 || Config_User.RateMp3OggFile.If_abr > 13) Config_User.RateMp3OggFile.If_abr = 12;
		break;
	case FILE_VALUE_CBR :
		Config_User.RateMp3OggFile.If_cbr = atoi (value);
		if (Config_User.RateMp3OggFile.If_cbr < 0 || Config_User.RateMp3OggFile.If_cbr > 14) Config_User.RateMp3OggFile.If_cbr = 14;
		break;
	case FILE_VALUE_VBR :
		Config_User.RateMp3OggFile.If_vbr = atoi (value);
		if (Config_User.RateMp3OggFile.If_vbr < 0 || Config_User.RateMp3OggFile.If_vbr > 14) Config_User.RateMp3OggFile.If_vbr = 1;
		break;
	case FILE_VALUE_VBR_NEW :
		Config_User.RateMp3OggFile.If_vbr_new = atoi (value);
		if (Config_User.RateMp3OggFile.If_vbr_new < 0 || Config_User.RateMp3OggFile.If_vbr_new > 15) Config_User.RateMp3OggFile.If_vbr_new = 1;
		break;
	case FILE_BITRATE_OGGENC :
		Config_User.RateMp3OggFile.Bitrate_Oggenc = atoi (value);
		if (Config_User.RateMp3OggFile.Bitrate_Oggenc < 0 || Config_User.RateMp3OggFile.Bitrate_Oggenc > 22)
			Config_User.RateMp3OggFile.Bitrate_Oggenc = 0;
		break;
	case FILE_MANAGED_OGGENC :
		Config_User.RateMp3OggFile.Managed_Oggenc = atoi (value);
		if (Config_User.RateMp3OggFile.Managed_Oggenc < 0 || Config_User.RateMp3OggFile.Managed_Oggenc > 1)
			Config_User.RateMp3OggFile.Managed_Oggenc = 0;
		break;
	case FILE_DOWNMIX_OGGENC :
		Config_User.RateMp3OggFile.Downmix_Oggenc = atoi (value);
		if (Config_User.RateMp3OggFile.Downmix_Oggenc < 0 || Config_User.RateMp3OggFile.Downmix_Oggenc > 1)
			Config_User.RateMp3OggFile.Downmix_Oggenc = 0;
		break;
	case FILE_MODE_LAME :
		Config_User.RateMp3OggFile.Mode_Lame = atoi (value);
		if (Config_User.RateMp3OggFile.Mode_Lame < 0 || Config_User.RateMp3OggFile.Mode_Lame > 5) Config_User.RateMp3OggFile.Mode_Lame = 0;
		break;




	case PATH_DESTINATION_CD :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_CD) {
			g_free (Config_User.Path_Destination_CD);
			Config_User.Path_Destination_CD = NULL;
		}
		Config_User.Path_Destination_CD = g_strdup (value);
		break;
	case PATH_DESTINATION_DVD :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_DVD) {
			g_free (Config_User.Path_Destination_DVD);
			Config_User.Path_Destination_DVD = NULL;
		}
		Config_User.Path_Destination_DVD = g_strdup (value);
		break;
	case PATH_DESTINATION_FILE :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_file) {
			g_free (Config_User.Path_Destination_file);
			Config_User.Path_Destination_file = NULL;
		}
		Config_User.Path_Destination_file = g_strdup (value);
		break;
	case PATH_DESTINATION_FILE_WAV :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_file_wav) {
			g_free (Config_User.Path_Destination_file_wav);
			Config_User.Path_Destination_file_wav = NULL;
		}
		Config_User.Path_Destination_file_wav = g_strdup (value);
		break;
	case PATH_DESTINATION_FILE_MP3OGG :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_file_mp3ogg) {
			g_free (Config_User.Path_Destination_file_mp3ogg);
			Config_User.Path_Destination_file_mp3ogg = NULL;
		}
		Config_User.Path_Destination_file_mp3ogg = g_strdup (value);
		break;
	case PATH_DESTINATION_SPLIT :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Destination_split) {
			g_free (Config_User.Path_Destination_split);
			Config_User.Path_Destination_split = NULL;
		}
		Config_User.Path_Destination_split = g_strdup (value);
		break;
	
	case PATH_LOAD_FILE :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Load_file) {
			g_free (Config_User.Path_Load_file);
			Config_User.Path_Load_file = NULL;
		}
		Config_User.Path_Load_file = g_strdup (value);
		break;
	case PATH_IMPORT_FILE_WAV :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Import_File_WAV) {
			g_free (Config_User.Path_Import_File_WAV);
			Config_User.Path_Import_File_WAV = NULL;
		}
		Config_User.Path_Import_File_WAV = g_strdup (value);
		break;
	case PATH_IMPORT_FILE_MP3OGG :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Import_File_MP3OGG) {
			g_free (Config_User.Path_Import_File_MP3OGG);
			Config_User.Path_Import_File_MP3OGG = NULL;
		}
		Config_User.Path_Import_File_MP3OGG = g_strdup (value);
		break;
	
	case PATH_IMPORT_FILE_SPLIT_MP3OGG :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Import_FileSplit) {
			g_free (Config_User.Path_Import_FileSplit);
			Config_User.Path_Import_FileSplit = NULL;
		}
		Config_User.Path_Import_FileSplit = g_strdup (value);
		break;
		
	case PATH_LOAD_IMAGES :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Load_Images) {
			g_free (Config_User.Path_Load_Images);
			Config_User.Path_Load_Images = NULL;
		}
		Config_User.Path_Load_Images = g_strdup (value);
		break;

	case PATH_LOAD_FILE_CUE :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Load_file_CUE) {
			g_free (Config_User.Path_Load_file_CUE);
			Config_User.Path_Load_file_CUE = NULL;
		}
		Config_User.Path_Load_file_CUE = g_strdup (value);
		break;
		
		
		
	case PATH_STOCKE_POCHE_IMAGES :
		/*if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));*/
		if (!infosong_file_is_dir (value)) g_sprintf (value, "/tmp");
		if (Config_User.Path_Stocke_Images_Pochette) {
			g_free (Config_User.Path_Stocke_Images_Pochette);
			Config_User.Path_Stocke_Images_Pochette = NULL;
		}
		Config_User.Path_Stocke_Images_Pochette = g_strdup (value);
		break;
	case PATH_DEST_FILE_POSTSCRIPT :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Dest_File_PostScript) {
			g_free (Config_User.Path_Dest_File_PostScript);
			Config_User.Path_Dest_File_PostScript = NULL;
		}
		Config_User.Path_Dest_File_PostScript = g_strdup (value);
		break;
	case PATH_LOAD_FILE_DVD :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "%s", getenv ("HOME"));
		if (Config_User.Path_Load_File_DVD) {
			g_free (Config_User.Path_Load_File_DVD);
			Config_User.Path_Load_File_DVD = NULL;
		}
		Config_User.Path_Load_File_DVD = g_strdup (value);
		break;
	case PATH_TMP :
		if (!infosong_file_is_dir (value)) g_sprintf (value, "/tmp");
		if (Config_User.Path_TMP) {
			g_free (Config_User.Path_TMP);
			Config_User.Path_TMP = NULL;
		}
		Config_User.Path_TMP = g_strdup (value);
		break;
		
	case NAME_FILE_M3U :
		if (Config_User.Name_file_m3u == NULL) {
			Config_User.Name_file_m3u = g_strdup (value);
		}
		break;
		
	case IS_TAG_ARTIST :
		Config_User.Bool_artist_tag = configuser_get_bool (value);
		break;
	case IS_TAG_TITLE :
		Config_User.Bool_title_tag = configuser_get_bool (value);
		break;
	case IS_TAG_ALBUM :
		Config_User.Bool_album_tag = configuser_get_bool (value);
		break;
	case IS_TAG_NUMERATE :
		Config_User.Bool_numerate_tag = configuser_get_bool (value);
		break;
	case IS_TAG_GENRE :
		Config_User.Bool_genre_tag = configuser_get_bool (value);
		break;
	case IS_TAG_YEAR :
		Config_User.Bool_year_tag = configuser_get_bool (value);
		break;
	case IS_TAG_COMMENT :
		Config_User.Bool_comment_tag = configuser_get_bool (value);
		break;
	case FILE_POSTSCRIPT :
		prgpostscript_add_glist (value);
		break;
	case NAVIGATORS_ACTIF :
		var_prgnavi.Navi_actif = g_strdup (value);
		break;
	case NAVIGATORS :
		var_prgnavi.List_navi = g_list_append (var_prgnavi.List_navi, g_strdup (value));
		break;
	
	
	case LECTEUR_AUDIO_ACTIF :
		VarPrgAudio.LecteurActif = g_strdup (value);
		break;
	case LECTEUR_AUDIO :
		PrgAudioSave = (PRGAUDIO_SAVE *)g_malloc0 (sizeof(PRGAUDIO_SAVE));
		PrgAudioSave->Name  = g_strdup (value);
		PrgAudioSave->Param = g_strdup ("");
		VarPrgAudio.ListLecteurs = g_list_append (VarPrgAudio.ListLecteurs, PrgAudioSave);
		break;
	case PARAM_LECTEUR_AUDIO :
		VarPrgAudio.ListLecteurs = g_list_last (VarPrgAudio.ListLecteurs);
		PrgAudioSave = (PRGAUDIO_SAVE *)VarPrgAudio.ListLecteurs->data;
		if (PrgAudioSave && PrgAudioSave->Param != NULL) {
			g_free (PrgAudioSave->Param);
			PrgAudioSave->Param = NULL;
		}
		if (PrgAudioSave)
			PrgAudioSave->Param = g_strdup (value);
		break;

	case READDIR_CDAUDIO_BY_IOCTL :
		Config_User.Bool_directory_by_ioctl = configuser_get_bool (value);
		break;

	case EXTRACT_CD_WITH :
		Config_User.Extract_cd_with = atoi (value);
		break;

	case COMPRESSION_LEVEL_FLAC :
		Config_User.compression_level_flac = atoi (value);
		break;
	case COMPRESSION_LEVEL_APE :
		Config_User.compression_level_ape = atoi (value);
		break;
	case QUALITY_MPPENC :
		Config_User.quality_mppenc = atoi (value);
		break;
	case COMPRESSION_WAVPACK :
		Config_User.compression_wavpack = atoi (value);
		break;
	case WAVPACK_SOUND :
		Config_User.sound_wavpack = atoi (value);
		break;
	case WAVPACK_MODE_HYBRIDE :
		Config_User.wavpack_mode_hybride = atoi (value);
		break;
	case WAVPACK_CORRECTION_FILE :
		Config_User.wavpack_correction_file = atoi (value);
		break;
	case WAVPACK_MAXIMUM_COMPRESSION :
		Config_User.wavpack_maximum_compression = atoi (value);
		break;
	case WAVPACK_SIGNATURE_MD5 :
		Config_User.wavpack_signature_md5 = atoi (value);
		break;
	case WAVPACK_EXTRA_ENCODING :
		Config_User.wavpack_extra_encoding = atoi (value);
		break;


	case FAAC_CONTENEUR :
		Config_User.faac_conteneur = atoi (value);
		break;
	case FAAC_CHOICE_VBR_ABR :
		Config_User.faac_choice_vbr_abr = atoi (value);
		break;
	case FAAC_SET_CHOICE_VBR :
		Config_User.faac_set_choice_vbr = atoi (value);
		break;
	case FAAC_SET_CHOICE_ABR :
		Config_User.faac_set_choice_abr = atoi (value);
		break;

	case AACPLUSENC_CHOICE_MONO :
		Config_User.aacplusenc_choice_mono = atoi (value);
		break;
	case AACPLUSENC_CHOICE_STEREO :
		Config_User.aacplusenc_choice_stereo = atoi (value);
		break;

	case GOTO_TONGLE_FILE_IMPORT :
		Config_User.Bool_GoTo_Togle_Import_File = configuser_get_bool (value);
		break;
	case SERVER_FREECDDB :
		Config_User.serveur_cddb = atoi (value);
		break;
	case INIT_LOAD_IMG_XCFA :
		Config_User.Bool_init_img_xcfa = configuser_get_bool (value);
		break;
	case VALUE_FIX_DVDAUDIO :
		Config_User.Value_fix_dvdaudio = atoi (value);
		if (Config_User.Value_fix_dvdaudio < 1 || Config_User.Value_fix_dvdaudio > 99) Config_User.Value_fix_dvdaudio = 50;
		break;
	case VALUE_FIX_CDAUDIO :
		Config_User.Value_fix_cdaudio = atoi (value);
		if (Config_User.Value_fix_cdaudio < 1 || Config_User.Value_fix_cdaudio > 99) Config_User.Value_fix_cdaudio = 50;
		break;
	case VALUE_FIX_FICHIERS :
		Config_User.Value_fix_fichiers = atoi (value);
		if (Config_User.Value_fix_fichiers < 1 || Config_User.Value_fix_fichiers > 99) Config_User.Value_fix_fichiers = 50;
		break;
	case TEMPLATE_TITLE_CDAUDIO :
		Config_User.Templates_title_cdaudio = g_strdup (value);
		break;
	case TEMPLATE_REP_CDAUDIO :
		Config_User.Templates_rep_cdaudio = g_strdup (value);
		break;	
	case VALUE_CHOICE_FILE_DEST :
		Config_User.Value_choice_file_dest = atoi (value);
		break;
	case VALUE_CHOICE_FILE_DEST_WAV :
		Config_User.Value_choice_file_dest_wav = atoi (value);
		break;
	case VALUE_CHOICE_FILE_MP3OGG_DEST :
		Config_User.Value_choice_file_mp3ogg_dest = atoi (value);
		break;
	case VALUE_CHOICE_SPLIT :
		Config_User.Value_choice_split = atoi (value);
		break;
		
	case String_expander_Lame :
		g_free (Config_User.String_expander_Lame);
		Config_User.String_expander_Lame = NULL;
		Config_User.String_expander_Lame = g_strdup (value);
		break;
	case String_expander_Oggenc :
		g_free (Config_User.String_expander_Oggenc);
		Config_User.String_expander_Oggenc = NULL;
		Config_User.String_expander_Oggenc = g_strdup (value);
		break;
	case String_expander_Flac :
		g_free (Config_User.String_expander_Flac);
		Config_User.String_expander_Flac = NULL;
		Config_User.String_expander_Flac = g_strdup (value);
		break;
	case String_expander_Faac :
		g_free (Config_User.String_expander_Faac);
		Config_User.String_expander_Faac = NULL;
		Config_User.String_expander_Faac = g_strdup (value);
		break;
	case String_expander_Mppenc :
		g_free (Config_User.String_expander_Mppenc);
		Config_User.String_expander_Mppenc = NULL;
		Config_User.String_expander_Mppenc = g_strdup (value);
		break;
	case String_expander_Mac :
		g_free (Config_User.String_expander_Mac);
		Config_User.String_expander_Mac = NULL;
		Config_User.String_expander_Mac = g_strdup (value);
		break;
	case String_expander_Wavpack :
		g_free (Config_User.String_expander_Wavpack);
		Config_User.String_expander_Wavpack = NULL;
		Config_User.String_expander_Wavpack = g_strdup (value);
		break;
	case ADMINISTRATOR_OF_PACKETS :
		Config_User.AdministratorOfPackets = atoi (value);
		break;
	case BOOL_SAVE_POS_NOTEBOOK :
		Config_User.Bool_save_pos_notebook = configuser_get_bool (value);
		break;
	case POS_NOTEBOOK_GENERAL :
		Config_User.notebook_general = atoi (value);
		break;
	case POS_NOTEBOOK_EXPANDER_CD :
		Config_User.notebook_expander_cd = atoi (value);
		break;
	case POS_NOTEBOOK_FILE :
		Config_User.notebook_file = atoi (value);
		break;
	case POS_NOTEBOOK_OPTIONS :
		Config_User.notebook_options = atoi (value);
		break;
	case POS_NOTEBOOK_POCHETTE :
		Config_User.notebook_pochette = atoi (value);
		break;
	case POS_NOTEBOOK_LOGS :
		Config_User.notebook_logs = atoi (value);
		break;
	case POS_NOTEBOOK_APP :
		Config_User.notebook_app = atoi (value);
		break;
	case STRING_BOOL_FIELD_IS_VISIBLE :
		/*Config_User.StringBoolFieldsIsVisible = g_strdup (value);*/
		Config_User.StringBoolFieldsIsVisible = g_strnfill (100, '1');
		strcpy (Config_User.StringBoolFieldsIsVisible, value);
		break;
	case STRING_POS_FIELDS_NAME :
		strcpy (Config_User.StringPosFieldsName, value);
		break;
	case BOOL_ETAT_EXPANDER_FILE :
		Config_User.BoolEtatExpanderFile = configuser_get_bool (value);
		break;
	case BOOL_ETAT_EXPANDER_CD :
		Config_User.BoolEtatExpanderCd = configuser_get_bool (value);
		break;
	case INT_SELECT_CD :
		Config_User.IntSelectCd = atoi (value);
		break;
	
	case NONE_MOTS_CLEFS :
	case ALL_MOTS_CLEFS :
		break;
	}
}

/*******************************************************************
*  gchar *configuser_get_pathname_xcfa_conf (void)
*-------------------------------------------------------------------
*  call   :  Creation du chemin et du nom du fichier de sauvegarde et
*            retourne un pointeur sur le nom
*  action :
*
*  return : un pointeur sur le chemin + nom
*******************************************************************/
gchar *configuser_get_pathname_xcfa_conf (void)
{
	return ((gchar *)g_strdup_printf ("%s/%s", getenv ("HOME"), PATHNAME_XCFA_CONF));
}

/* Creation du repertoire de sauvegarde du fichier de configuration SI BESOIN
*  --
*  entree : -
*  retour :
*      TRUE  : Creation OK
*      FALSE : No creation
*/
gboolean configuser_create_rep_xcfa_conf (void)
{
	gchar    *NamePath = NULL;
	gchar    *NameFile = NULL;
	gboolean  bool = FALSE;

	NamePath = infosong_create_rep (PATH_XCFA_CONF);
	g_free (NamePath);
	NamePath = NULL;

	NameFile = configuser_get_pathname_xcfa_conf ();
	bool = infosong_file_is_reg (NameFile);
	if (bool == FALSE) {
		g_print ("\nCREATION DE: %s\n\n", NameFile);
	}
	g_free (NameFile);
	NameFile = NULL;

	return (bool);
}

/* Verification de la validite de tous les parametres
*  --
*  entree : -
*  retour : -
*/
void configuser_verify_parameters (void)
{
	gint i;
	
	/* PRINT_FUNC_LF(); */
	
	for (i = 0; i < ALL_MOTS_CLEFS; i ++) {
		
		switch (mots_clefs[i].num) {
		
		case _VERSION_ :
			if (!Config_User.Version) Config_User.Version = g_strdup ("");
			break;
		case _NEW_VERSION_ :
			break;
		
		case WIN_POS_X :
			if (Config_User.WinPos_X < 0) Config_User.WinPos_X = 0;
			break;
		case WIN_POS_Y :
			if (Config_User.WinPos_Y < 0) Config_User.WinPos_Y = 0;
			break;
		case WIN_WIDTH :
			if (Config_User.Win_Width < 0) Config_User.Win_Width = 0;
			break;
		case WIN_HEIGHT :
			if (Config_User.Win_Height < 0) Config_User.Win_Height = 0;
			break;
		case NICE :
			if (Config_User.Nice < 0 || Config_User.Nice > 19) Config_User.Nice = 0;
			break;
		
		
		
		case OPTIONS_BITRATE_LAME :
			if (Config_User.RateMp3OggOptions.Bitrate_type_Lame < 0 || Config_User.RateMp3OggOptions.Bitrate_type_Lame > 3)
				Config_User.RateMp3OggOptions.Bitrate_type_Lame = 0;
			break;
		case OPTIONS_VALUE_ABR :
			if (Config_User.RateMp3OggOptions.If_abr < 0 || Config_User.RateMp3OggOptions.If_abr > 13) Config_User.RateMp3OggOptions.If_abr = 12;
			break;
		case OPTIONS_VALUE_CBR :
			if (Config_User.RateMp3OggOptions.If_cbr < 0 || Config_User.RateMp3OggOptions.If_cbr > 14) Config_User.RateMp3OggOptions.If_cbr = 14;
			break;
		case OPTIONS_VALUE_VBR :
			if (Config_User.RateMp3OggOptions.If_vbr < 0 || Config_User.RateMp3OggOptions.If_vbr > 14) Config_User.RateMp3OggOptions.If_vbr = 1;
			break;
		case OPTIONS_VALUE_VBR_NEW :
			if (Config_User.RateMp3OggOptions.If_vbr_new < 0 || Config_User.RateMp3OggOptions.If_vbr_new > 15) Config_User.RateMp3OggOptions.If_vbr_new = 1;
			break;
		case OPTIONS_BITRATE_OGGENC :
			if (Config_User.RateMp3OggOptions.Bitrate_Oggenc < 0 || Config_User.RateMp3OggOptions.Bitrate_Oggenc > 22) Config_User.RateMp3OggOptions.Bitrate_Oggenc = 0;
			break;
		case OPTIONS_MANAGED_OGGENC :
			if (Config_User.RateMp3OggOptions.Managed_Oggenc < 0 || Config_User.RateMp3OggOptions.Managed_Oggenc > 1) Config_User.RateMp3OggOptions.Managed_Oggenc = 0;
			break;
		case OPTIONS_DOWNMIX_OGGENC :
			if (Config_User.RateMp3OggOptions.Downmix_Oggenc < 0 || Config_User.RateMp3OggOptions.Downmix_Oggenc > 1) Config_User.RateMp3OggOptions.Downmix_Oggenc = 0;
			break;
		case OPTIONS_MODE_LAME :
			if (Config_User.RateMp3OggOptions.Mode_Lame < 0 || Config_User.RateMp3OggOptions.Mode_Lame > 5) Config_User.RateMp3OggOptions.Mode_Lame = 0;
			break;
		
		
		case FILE_BITRATE_LAME :
			if (Config_User.RateMp3OggFile.Bitrate_type_Lame < 0 || Config_User.RateMp3OggFile.Bitrate_type_Lame > 3) Config_User.RateMp3OggFile.Bitrate_type_Lame = 0;
			break;
		case FILE_VALUE_ABR :
			if (Config_User.RateMp3OggFile.If_abr < 0 || Config_User.RateMp3OggFile.If_abr > 13) Config_User.RateMp3OggFile.If_abr = 12;
			break;
		case FILE_VALUE_CBR :
			if (Config_User.RateMp3OggFile.If_cbr < 0 || Config_User.RateMp3OggFile.If_cbr > 14) Config_User.RateMp3OggFile.If_cbr = 14;
			break;
		case FILE_VALUE_VBR :
			if (Config_User.RateMp3OggFile.If_vbr < 0 || Config_User.RateMp3OggFile.If_vbr > 14) Config_User.RateMp3OggFile.If_vbr = 1;
			break;
		case FILE_VALUE_VBR_NEW :
			if (Config_User.RateMp3OggFile.If_vbr_new < 0 || Config_User.RateMp3OggFile.If_vbr_new > 15) Config_User.RateMp3OggFile.If_vbr_new = 1;
			break;
		case FILE_BITRATE_OGGENC :
			if (Config_User.RateMp3OggFile.Bitrate_Oggenc < 0 || Config_User.RateMp3OggFile.Bitrate_Oggenc > 22) Config_User.RateMp3OggFile.Bitrate_Oggenc = 0;
			break;
		case FILE_MANAGED_OGGENC :
			if (Config_User.RateMp3OggFile.Managed_Oggenc < 0 || Config_User.RateMp3OggFile.Managed_Oggenc > 1) Config_User.RateMp3OggFile.Managed_Oggenc = 0;
			break;
		case FILE_DOWNMIX_OGGENC :
			if (Config_User.RateMp3OggFile.Downmix_Oggenc < 0 || Config_User.RateMp3OggFile.Downmix_Oggenc > 1) Config_User.RateMp3OggFile.Downmix_Oggenc = 0;
			break;
		case FILE_MODE_LAME :
			if (Config_User.RateMp3OggFile.Mode_Lame < 0 || Config_User.RateMp3OggFile.Mode_Lame > 5) Config_User.RateMp3OggFile.Mode_Lame = 0;
			break;
		
		
		
		
		case PATH_DESTINATION_CD :
			if (!Config_User.Path_Destination_CD)
				Config_User.Path_Destination_CD = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_DESTINATION_DVD :
			if (!Config_User.Path_Destination_DVD)
				Config_User.Path_Destination_DVD = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_DESTINATION_FILE :
			if (!Config_User.Path_Destination_file)
				Config_User.Path_Destination_file = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_DESTINATION_FILE_WAV :
			if (!Config_User.Path_Destination_file_wav)
				Config_User.Path_Destination_file_wav = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_DESTINATION_FILE_MP3OGG :
			if (!Config_User.Path_Destination_file_mp3ogg)
				Config_User.Path_Destination_file_mp3ogg = g_strdup_printf ("%s", getenv ("HOME"));
			break;
	
		case PATH_DESTINATION_SPLIT :
			if (!Config_User.Path_Destination_split)
				Config_User.Path_Destination_split = g_strdup_printf ("%s", getenv ("HOME"));
			break;


		case PATH_LOAD_FILE :
			if (!Config_User.Path_Load_file)
				Config_User.Path_Load_file = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_IMPORT_FILE_WAV :
			if (!Config_User.Path_Import_File_WAV)
				Config_User.Path_Import_File_WAV = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_IMPORT_FILE_MP3OGG :
			if (!Config_User.Path_Import_File_MP3OGG)
				Config_User.Path_Import_File_MP3OGG = g_strdup_printf ("%s", getenv ("HOME"));
			break;

		case PATH_IMPORT_FILE_SPLIT_MP3OGG :
			if (!Config_User.Path_Import_FileSplit)
				Config_User.Path_Import_FileSplit = g_strdup_printf ("%s", getenv ("HOME"));
			break;


		case PATH_LOAD_IMAGES :
			if (!Config_User.Path_Load_Images)
				Config_User.Path_Load_Images = g_strdup_printf ("%s", getenv ("HOME"));
			break;

		case PATH_LOAD_FILE_CUE :
			if (!Config_User.Path_Load_file_CUE)
				Config_User.Path_Load_file_CUE = g_strdup_printf ("%s", getenv ("HOME"));
			break;








		case PATH_STOCKE_POCHE_IMAGES :
			if (!Config_User.Path_Stocke_Images_Pochette)
				Config_User.Path_Stocke_Images_Pochette = g_strdup_printf ("/tmp");
			break;
		case PATH_DEST_FILE_POSTSCRIPT :
			if (!Config_User.Path_Dest_File_PostScript)
				Config_User.Path_Dest_File_PostScript = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_LOAD_FILE_DVD :
			if (!Config_User.Path_Load_File_DVD)
				Config_User.Path_Load_File_DVD = g_strdup_printf ("%s", getenv ("HOME"));
			break;
		case PATH_TMP :
			if (!Config_User.Path_TMP) {
				Config_User.Path_TMP = g_strdup ("/tmp");
			}
			break;
		
		case NAME_FILE_M3U :
		break;
		case IS_TAG_ARTIST :
		break;
		case IS_TAG_TITLE :
		break;
		case IS_TAG_ALBUM :
		break;
		case IS_TAG_NUMERATE :
		break;
		case IS_TAG_GENRE :
		break;
		case IS_TAG_YEAR :
		break;
		case IS_TAG_COMMENT :
		break;
		case FILE_POSTSCRIPT :
		break;
		
		case NAVIGATORS_ACTIF :
			if (var_prgnavi.Navi_actif == NULL) var_prgnavi.Navi_actif = g_strdup ("");
			break;
		case NAVIGATORS :
		break;
		case LECTEUR_AUDIO_ACTIF :
		break;
		
		case LECTEUR_AUDIO :
			break;
		case PARAM_LECTEUR_AUDIO :
			break;
		
		case READDIR_CDAUDIO_BY_IOCTL :
		break;

		case EXTRACT_CD_WITH :
			if (Config_User.Extract_cd_with < 0 || Config_User.Extract_cd_with > 2)
				Config_User.Extract_cd_with = 0;
		break;

		case COMPRESSION_LEVEL_FLAC :
			if (Config_User.compression_level_flac < 0 || Config_User.compression_level_flac > 12)
				Config_User.compression_level_flac = 0;
			break;
		case COMPRESSION_LEVEL_APE :
			if (Config_User.compression_level_ape < 0 || Config_User.compression_level_ape > 4)
				Config_User.compression_level_ape = 0;
			break;
		
		case QUALITY_MPPENC :
		break;
		case COMPRESSION_WAVPACK :
		break;
		case WAVPACK_SOUND :
		break;
		case WAVPACK_MODE_HYBRIDE :
		break;
		case WAVPACK_CORRECTION_FILE :
		break;
		case WAVPACK_MAXIMUM_COMPRESSION :
		break;
		case WAVPACK_SIGNATURE_MD5 :
		break;
		case WAVPACK_EXTRA_ENCODING :
		break;

	case FAAC_CONTENEUR :
		/*Config_User.faac_conteneur = atoi (value);*/
		break;
	case FAAC_CHOICE_VBR_ABR :
		/*Config_User.faac_choice_vbr_abr = atoi (value);*/
		break;
	case FAAC_SET_CHOICE_VBR :
		if (Config_User.faac_set_choice_vbr < 0 || Config_User.faac_set_choice_vbr > 13)
			Config_User.faac_set_choice_vbr = 6;
		break;
	case FAAC_SET_CHOICE_ABR :
		if (Config_User.faac_set_choice_abr < 0 || Config_User.faac_set_choice_abr > 5)
			Config_User.faac_set_choice_abr = 0;
		break;
	case AACPLUSENC_CHOICE_MONO :
		if (Config_User.aacplusenc_choice_mono < 0 || Config_User.aacplusenc_choice_mono > 7)
			Config_User.aacplusenc_choice_mono = 0;
		break;
	case AACPLUSENC_CHOICE_STEREO :
		if (Config_User.aacplusenc_choice_stereo < 0 || Config_User.aacplusenc_choice_stereo > 4)
			Config_User.aacplusenc_choice_stereo = 0;
		break;


		case GOTO_TONGLE_FILE_IMPORT :
		break;
		
		case SERVER_FREECDDB :
			if (Config_User.serveur_cddb < 0 || Config_User.serveur_cddb > 9)
				Config_User.serveur_cddb = 0;
			break;
		case INIT_LOAD_IMG_XCFA :
		break;
		case VALUE_FIX_DVDAUDIO :
			if (Config_User.Value_fix_dvdaudio < 1 || Config_User.Value_fix_dvdaudio > 99) Config_User.Value_fix_dvdaudio = 50;
			break;
		case VALUE_FIX_CDAUDIO :
			if (Config_User.Value_fix_cdaudio < 1 || Config_User.Value_fix_cdaudio > 99) Config_User.Value_fix_cdaudio = 50;
			break;
		case VALUE_FIX_FICHIERS :
			if (Config_User.Value_fix_fichiers < 1 || Config_User.Value_fix_fichiers > 99) Config_User.Value_fix_fichiers = 50;
			break;
		case TEMPLATE_TITLE_CDAUDIO :
			if (Config_User.Templates_title_cdaudio == NULL) {
				Config_User.Templates_title_cdaudio = g_strdup ("%c %d");
			}
			else if (*Config_User.Templates_title_cdaudio == '\0') {
				g_free (Config_User.Templates_title_cdaudio);
				Config_User.Templates_title_cdaudio = NULL;
				Config_User.Templates_title_cdaudio = g_strdup ("%c %d");
			}
			break;
		case TEMPLATE_REP_CDAUDIO :
			if (Config_User.Templates_rep_cdaudio == NULL) {
				Config_User.Templates_rep_cdaudio = g_strdup ("%b");
			}
			else if (*Config_User.Templates_rep_cdaudio == '\0') {
				g_free (Config_User.Templates_rep_cdaudio);
				Config_User.Templates_rep_cdaudio = NULL;
				Config_User.Templates_rep_cdaudio = g_strdup ("%d");
			}
			break;
		case VALUE_CHOICE_FILE_DEST :
			if (Config_User.Value_choice_file_dest != 0 && Config_User.Value_choice_file_dest != 2)
				Config_User.Value_choice_file_dest = 0;
			break;
		case VALUE_CHOICE_FILE_DEST_WAV :
			if (Config_User.Value_choice_file_dest_wav != 0 && Config_User.Value_choice_file_dest_wav != 2)
				Config_User.Value_choice_file_dest_wav = 0;
			break;
		case VALUE_CHOICE_FILE_MP3OGG_DEST :
			if (Config_User.Value_choice_file_mp3ogg_dest != 0 && Config_User.Value_choice_file_mp3ogg_dest != 2)
				Config_User.Value_choice_file_mp3ogg_dest = 0;
			break;
		case VALUE_CHOICE_SPLIT :
			if (Config_User.Value_choice_split != 0 && Config_User.Value_choice_split != 2)
				Config_User.Value_choice_split = 0;
			break;

		case String_expander_Lame :
			if (Config_User.String_expander_Lame == NULL)
				Config_User.String_expander_Lame = g_strdup ("");
			break;
		case String_expander_Oggenc :
			if (Config_User.String_expander_Oggenc == NULL)
				Config_User.String_expander_Oggenc = g_strdup ("");
			break;
		case String_expander_Flac :
			if (Config_User.String_expander_Flac == NULL)
				Config_User.String_expander_Flac = g_strdup ("");
			break;
		case String_expander_Faac :
			if (Config_User.String_expander_Faac == NULL)
				Config_User.String_expander_Faac = g_strdup ("");
			break;
		case String_expander_Mppenc :
			if (Config_User.String_expander_Mppenc == NULL)
				Config_User.String_expander_Mppenc = g_strdup ("");
			break;
		case String_expander_Mac :
			if (Config_User.String_expander_Mac == NULL)
				Config_User.String_expander_Mac = g_strdup ("");
			break;
		case String_expander_Wavpack :
			if (Config_User.String_expander_Wavpack == NULL)
				Config_User.String_expander_Wavpack = g_strdup ("");
			break;
		
		case ADMINISTRATOR_OF_PACKETS :
		break;
		case BOOL_SAVE_POS_NOTEBOOK :
		break;
		case POS_NOTEBOOK_GENERAL :
		break;
		case POS_NOTEBOOK_EXPANDER_CD :
		break;
		case POS_NOTEBOOK_FILE :
		break;
		case POS_NOTEBOOK_OPTIONS :
		break;
		case POS_NOTEBOOK_POCHETTE :
		break;
		case POS_NOTEBOOK_LOGS :
		break;
		case POS_NOTEBOOK_APP :
		break;
		
		case STRING_BOOL_FIELD_IS_VISIBLE :
			if (Config_User.StringBoolFieldsIsVisible == NULL) {
				Config_User.StringBoolFieldsIsVisible = g_strnfill (100, '1');
			}
			break;
		case STRING_POS_FIELDS_NAME :
		break;
		case BOOL_ETAT_EXPANDER_FILE :
		break;		
		case BOOL_ETAT_EXPANDER_CD :
		break;
		case INT_SELECT_CD :
		break;
		case NONE_MOTS_CLEFS :
		break;
		case ALL_MOTS_CLEFS :
		break;
		}
	}
}

/* Lecture du fichier de configuration. Si le fichier n'existe pas, il est cree
*  --
*  entree : -
*  retour : -
*/
void configuser_read_file_config (void)
{
	gchar      *NameFile = NULL;
	FILE       *fp;
#define MAX_CARS 255
	gchar       buf   [ MAX_CARS +1 ];
	gchar       mot   [ MAX_CARS +1 ];
	gchar       value [ MAX_CARS +1 ];
	DEFS_MOTS   def_mot = NONE_MOTS_CLEFS;

	/* Copie de l'integralite du buffer des options par defaut pour une restitution eventuelle
	*/
	if (ConfigUserSave.WinPos_X == -1) {
		g_memmove (&ConfigUserSave, &Config_User, sizeof (CONFIG_USER));
	}

	g_print ("------------------------------------------------------------------------\n");
	PRINT_FUNC_LF();
	g_print ("------------------------------------------------------------------------\n");

	/* Si fichier 'HOME/.config/xcfa/xcfa.conf' absent alors creation
	*/
	if (!configuser_create_rep_xcfa_conf ()) {
		configuser_save_file_config ();
	}

	/* Ouverture de 'xcfa.conf' et analyse
	*/
	NameFile = configuser_get_pathname_xcfa_conf ();
	fp = fopen (NameFile, "r");
	while (fgets (buf, MAX_CARS, fp) != NULL) {

		/* Si commentaire ou ligne vide alors ligne suivante */
		if (buf[0] == '#' || buf[0] == '\n') continue;
		/*g_print ("%s", buf);*/

		/* Init variables et analyse la ligne lue */
		mot [ 0 ] = '\0';
		value [ 0 ] = '\0';
		if ((def_mot = configuser_analyse_line_buf (buf, &mot[0], &value[0], MAX_CARS)) != NONE_MOTS_CLEFS) configuser_change_parameters (def_mot, value);
	}
	/* TO DEBUG - TO DEBUG - TO DEBUG */
	g_print ("------------------------------------------------------------------------\n\n");

	fclose (fp);

	g_free (NameFile);
	NameFile = NULL;

	configuser_verify_parameters ();

	if (mots_clefs[ BOOL_SAVE_POS_NOTEBOOK ].BoolPass == FALSE) {
		mots_clefs[ BOOL_SAVE_POS_NOTEBOOK ].BoolPass = TRUE;
		Config_User.Bool_save_pos_notebook = TRUE;
	}
}

/* Cette fonction effectue une sauvegarde les principaux parametres qui
*  seront recupperes lors de la prochaine session.
*  --
*  entree : -
*  retour : -
*/
void configuser_save_file_config (void)
{
	FILE		*fp;
	gchar		*Name = NULL;
	GList		*list = NULL;
	gchar		*ptr = NULL;
	PRGAUDIO_SAVE	*PrgAudioSave = NULL;

	PRINT_FUNC_LF();

	configuser_create_rep_xcfa_conf ();

	/* Creation du fichier 'xcfa.conf'
	*/
	Name = configuser_get_pathname_xcfa_conf ();
	fp = fopen (Name, "w");

	fprintf (fp,   "############################################################################\n");
	fprintf (fp,   "## Fichier de configuration pour : %s %s\n", Name, VERSION);
	fprintf (fp,   "## Vous pouvez editer ce fichier en faisant attention ;-)\n");
	fprintf (fp,   "##--------------------------------------------------------------------------\n");
	fprintf (fp,   "## File of configuration to : %s %s\n", Name, VERSION);
	fprintf (fp,   "## You can edit this file but warning ;-)\n");
	fprintf (fp,   "############################################################################\n");

	fprintf (fp,   "\n");
	fprintf (fp,   "# Version number\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "VERSION  =%s\n", Config_User.Version);

	fprintf (fp,   "\n");
	fprintf (fp,   "# X Window Position\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "WIN_POS_X  =%d\n", Config_User.WinPos_X);
	fprintf (fp,   "WIN_POS_Y  =%d\n", Config_User.WinPos_Y);
	fprintf (fp,   "WIN_WIDTH  =%d\n", Config_User.Win_Width);
	fprintf (fp,   "WIN_HEIGHT =%d\n", Config_User.Win_Height);

	fprintf (fp,   "\n");
	fprintf (fp,   "# System priority: 0 .. 19\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "NICE =%d\n", Config_User.Nice);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Bitrates Lame and Oggenc :: Options\n");
	fprintf (fp,   "OPTIONS_BITRATE_LAME   =%d\n", Config_User.RateMp3OggOptions.Bitrate_type_Lame);
	fprintf (fp,   "OPTIONS_VALUE_ABR      =%d\n", Config_User.RateMp3OggOptions.If_abr);
	fprintf (fp,   "OPTIONS_VALUE_CBR      =%d\n", Config_User.RateMp3OggOptions.If_cbr);
	fprintf (fp,   "OPTIONS_VALUE_VBR      =%d\n", Config_User.RateMp3OggOptions.If_vbr);
	fprintf (fp,   "OPTIONS_VALUE_VBR_NEW  =%d\n", Config_User.RateMp3OggOptions.If_vbr_new);
	fprintf (fp,   "OPTIONS_BITRATE_OGGENC =%d\n", Config_User.RateMp3OggOptions.Bitrate_Oggenc);
	fprintf (fp,   "OPTIONS_MANAGED_OGGENC =%d\n", Config_User.RateMp3OggOptions.Managed_Oggenc);
	fprintf (fp,   "OPTIONS_DOWNMIX_OGGENC =%d\n", Config_User.RateMp3OggOptions.Downmix_Oggenc);
	fprintf (fp,   "OPTIONS_MODE_LAME      =%d\n", Config_User.RateMp3OggOptions.Mode_Lame);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Bitrates Lame and Oggenc :: Fichiers\n");
	fprintf (fp,   "FILE_BITRATE_LAME      =%d\n", Config_User.RateMp3OggFile.Bitrate_type_Lame);
	fprintf (fp,   "FILE_VALUE_ABR         =%d\n", Config_User.RateMp3OggFile.If_abr);
	fprintf (fp,   "FILE_VALUE_CBR         =%d\n", Config_User.RateMp3OggFile.If_cbr);
	fprintf (fp,   "FILE_VALUE_VBR         =%d\n", Config_User.RateMp3OggFile.If_vbr);
	fprintf (fp,   "FILE_VALUE_VBR_NEW     =%d\n", Config_User.RateMp3OggFile.If_vbr_new);
	fprintf (fp,   "FILE_BITRATE_OGGENC    =%d\n", Config_User.RateMp3OggFile.Bitrate_Oggenc);
	fprintf (fp,   "FILE_MANAGED_OGGENC    =%d\n", Config_User.RateMp3OggFile.Managed_Oggenc);
	fprintf (fp,   "FILE_DOWNMIX_OGGENC    =%d\n", Config_User.RateMp3OggFile.Downmix_Oggenc);
	fprintf (fp,   "FILE_MODE_LAME         =%d\n", Config_User.RateMp3OggFile.Mode_Lame);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Pathnames\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "PATH_DESTINATION_CD           =%s\n", Config_User.Path_Destination_CD);
	fprintf (fp,   "PATH_DESTINATION_DVD          =%s\n", Config_User.Path_Destination_DVD);
	fprintf (fp,   "PATH_DESTINATION_FILE         =%s\n", Config_User.Path_Destination_file);
	fprintf (fp,   "PATH_DESTINATION_FILE_WAV     =%s\n", Config_User.Path_Destination_file_wav);
	fprintf (fp,   "PATH_DESTINATION_FILE_MP3OGG  =%s\n", Config_User.Path_Destination_file_mp3ogg);
	fprintf (fp,   "PATH_DESTINATION_SPLIT        =%s\n", Config_User.Path_Destination_split);
	fprintf (fp,   "PATH_LOAD_FILE                =%s\n", Config_User.Path_Load_file);
	fprintf (fp,   "PATH_IMPORT_FILE_WAV          =%s\n", Config_User.Path_Import_File_WAV);
	fprintf (fp,   "PATH_IMPORT_FILE_MP3OGG       =%s\n", Config_User.Path_Import_File_MP3OGG);
	fprintf (fp,   "PATH_IMPORT_FILE_SPLIT_MP3OGG =%s\n", Config_User.Path_Import_FileSplit);	
	fprintf (fp,   "PATH_LOAD_IMAGES              =%s\n", Config_User.Path_Load_Images);
	fprintf (fp,   "PATH_LOAD_FILE_CUE            =%s\n", Config_User.Path_Load_file_CUE);
	fprintf (fp,   "PATH_STOCKE_POCHE_IMAGES      =%s\n", Config_User.Path_Stocke_Images_Pochette);
	fprintf (fp,   "PATH_DEST_FILE_POSTSCRIPT     =%s\n", Config_User.Path_Dest_File_PostScript);
	fprintf (fp,   "PATH_LOAD_FILE_DVD            =%s\n", Config_User.Path_Load_File_DVD);
	fprintf (fp,   "PATH_TMP                      =%s\n", Config_User.Path_TMP);

	fprintf (fp,   "\n");
	fprintf (fp,   "# M3U file\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "NAME_FILE_M3U =%s\n", Config_User.Name_file_m3u ? Config_User.Name_file_m3u : "");

	fprintf (fp,   "\n");
	fprintf (fp,   "# Tags\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "IS_TAG_ARTIST   =%s\n", Config_User.Bool_artist_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_TITLE    =%s\n", Config_User.Bool_title_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_ALBUM    =%s\n", Config_User.Bool_album_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_NUMERATE =%s\n", Config_User.Bool_numerate_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_GENRE    =%s\n", Config_User.Bool_genre_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_YEAR     =%s\n", Config_User.Bool_year_tag ? "TRUE" : "FALSE");
	fprintf (fp,   "IS_TAG_COMMENT  =%s\n", Config_User.Bool_comment_tag ? "TRUE" : "FALSE");

	fprintf (fp,   "\n");
	fprintf (fp,   "# List of file PostScript\n");
	fprintf (fp,   "#\n");

	list = prgpostscript_get_glist_prog_ps ();
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			fprintf (fp,   "FILE_POSTSCRIPT =%s\n", ptr);
			/*g_print ("FILE_POSTSCRIPT = %s\n", ptr);*/
		}
		list = g_list_next(list);
	}
	list = NULL;

	/*
	NAVIGATORS_ACTIF
	NAVIGATORS
	*/
	fprintf (fp,   "\n");
	fprintf (fp,   "# List of Navigators\n");
	fprintf (fp,   "#\n");
	/* Le navigateur actif */
	ptr = prgnavigator_get_name_is_actived ();
	fprintf (fp,   "NAVIGATORS_ACTIF =%s\n", ptr == NULL ? "" : ptr);
	/* liste des navigateurs */
	list = prgnavigator_get_glist_prog (list);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			fprintf (fp,   "NAVIGATORS =%s\n", ptr);
		}
		list = g_list_next(list);
	}
	list = prgnavigator_remove_glist_prog (list);

	/*
	LECTEUR_AUDIO_ACTIF
	LECTEUR_AUDIO
	*/
	fprintf (fp,   "\n");
	fprintf (fp,   "# List of SongReader and Parameters\n");
	fprintf (fp,   "#\n");
	/* Le lecteurs audio actif */
	ptr = prgaudio_get_name_is_actived ();
	fprintf (fp,   "LECTEUR_AUDIO_ACTIF =%s\n", ptr == NULL ? "" : ptr);
	/* liste des lecteurs audio */
	list = prgaudio_get_glist_prog (list);
	while (list) {
		if ((PrgAudioSave = (PRGAUDIO_SAVE *)list->data)) {
			if (strcmp (READER_AUDIO_XCFA, PrgAudioSave->Name) != 0) {
				fprintf (fp,   "LECTEUR_AUDIO       =%s\n", PrgAudioSave->Name);
				fprintf (fp,   "PARAM_LECTEUR_AUDIO =%s\n", PrgAudioSave->Param);
			}
		}
		list = g_list_next(list);
	}
	list = prgaudio_remove_glist_prog (list);
	
	fprintf (fp,   "\n");
	fprintf (fp,   "# Read directory cdaudio by ioctl or cdparabnoia\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "READDIR_CDAUDIO_BY_IOCTL =%s\n", Config_User.Bool_directory_by_ioctl ? "TRUE" : "FALSE");

	fprintf (fp,   "\n");
	fprintf (fp,   "# Extract CD with cdparabnoia or cdda2wav\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "EXTRACT_CD_WITH =%d\n", Config_User.Extract_cd_with);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Compression level flac\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "COMPRESSION_LEVEL_FLAC =%d\n", Config_User.compression_level_flac);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Compression level ape\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "COMPRESSION_LEVEL_APE =%d\n", Config_User.compression_level_ape);

	/* quality_mppenc	*/
	fprintf (fp,   "\n");
	fprintf (fp,   "# Quality mppenc\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "QUALITY_MPPENC =%d\n", Config_User.quality_mppenc);

	/* WAVPACK OPTIONS */
	fprintf (fp,   "\n");
	fprintf (fp,   "# wavpack options\n");
	fprintf (fp,   "#\n");
	/* compression_wavpack */
	fprintf (fp,   "COMPRESSION_WAVPACK         =%d\n", Config_User.compression_wavpack);
	/* sound_wavpack */
	fprintf (fp,   "WAVPACK_SOUND               =%d\n", Config_User.sound_wavpack);
	/* wavpack_mode_hybride */
	fprintf (fp,   "WAVPACK_MODE_HYBRIDE        =%d\n", Config_User.wavpack_mode_hybride);
	/* wavpack_correction_file */
	fprintf (fp,   "WAVPACK_CORRECTION_FILE     =%d\n", Config_User.wavpack_correction_file);
	/* wavpack_maximum_compression */
	fprintf (fp,   "WAVPACK_MAXIMUM_COMPRESSION =%d\n", Config_User.wavpack_maximum_compression);
	/* wavpack_signature_md5 */
	fprintf (fp,   "WAVPACK_SIGNATURE_MD5       =%d\n", Config_User.wavpack_signature_md5);
	/* wavpack_extra_encoding */
	fprintf (fp,   "WAVPACK_EXTRA_ENCODING      =%d\n", Config_User.wavpack_extra_encoding);

	
	/* FAAC OPTIONS */
	fprintf (fp,   "\n");
	fprintf (fp,   "# faac options\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "FAAC_CONTENEUR              =%d\n", Config_User.faac_conteneur);
	fprintf (fp,   "FAAC_CHOICE_VBR_ABR         =%d\n", Config_User.faac_choice_vbr_abr);
	fprintf (fp,   "FAAC_SET_CHOICE_VBR         =%d\n", Config_User.faac_set_choice_vbr);
	fprintf (fp,   "FAAC_SET_CHOICE_ABR         =%d\n", Config_User.faac_set_choice_abr);


	/* AACPLUSENC OPTIONS */
	fprintf (fp,   "\n");
	fprintf (fp,   "# aacplusenc options\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "AACPLUSENC_CHOICE_MONO     =%d\n", Config_User.aacplusenc_choice_mono);
	fprintf (fp,   "AACPLUSENC_CHOICE_STEREO   =%d\n", Config_User.aacplusenc_choice_stereo);
	

	fprintf (fp,   "\n");
	fprintf (fp,   "# Rapport bad file import\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "GOTO_TONGLE_FILE_IMPORT =%s\n", Config_User.Bool_GoTo_Togle_Import_File ? "TRUE" : "FALSE");

	fprintf (fp,   "\n");
	fprintf (fp,   "# Value server freecddb\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "SERVER_FREECDDB =%d\n", Config_User.serveur_cddb);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Init load images xcfa\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "INIT_LOAD_IMG_XCFA =%s\n", Config_User.Bool_init_img_xcfa ? "TRUE" : "FALSE");

	fprintf (fp,   "\n");
	fprintf (fp,   "# FIX val for dvd-audio & cd-audio & fichiers\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "VALUE_FIX_DVDAUDIO  =%d\n", Config_User.Value_fix_dvdaudio);
	fprintf (fp,   "VALUE_FIX_CDAUDIO   =%d\n", Config_User.Value_fix_cdaudio);
	fprintf (fp,   "VALUE_FIX_FICHIERS  =%d\n", Config_User.Value_fix_fichiers);

	fprintf (fp,   "\n");
	fprintf (fp,   "# String of templates\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "TEMPLATE_TITLE_CDAUDIO =");
	ptr = Config_User.Templates_title_cdaudio;
	if (ptr == NULL) {
		fprintf (fp, "%%c %%d");
	}
	else {
		while (ptr && *ptr) {
			if (*ptr == '%')	fprintf (fp, "%%");
			else			fprintf (fp, "%c", *ptr);
			ptr++;
		}
	}
	fprintf (fp,   "\n");

	fprintf (fp,   "TEMPLATE_REP_CDAUDIO   =");
	ptr = Config_User.Templates_rep_cdaudio;
	if (ptr == NULL) {
		fprintf (fp, "%%b");
	}
	else {
		while (ptr && *ptr) {
			if (*ptr == '%')	fprintf (fp, "%%");
			else			fprintf (fp, "%c", *ptr);
			ptr++;
		}
	}

	fprintf (fp,   "\n\n");
	fprintf (fp,   "# Save destination choice\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "VALUE_CHOICE_FILE_DEST        =%d\n", Config_User.Value_choice_file_dest);
	fprintf (fp,   "VALUE_CHOICE_FILE_DEST_WAV    =%d\n", Config_User.Value_choice_file_dest_wav);
	fprintf (fp,   "VALUE_CHOICE_FILE_MP3OGG_DEST =%d\n", Config_User.Value_choice_file_mp3ogg_dest);
	fprintf (fp,   "VALUE_CHOICE_SPLIT            =%d\n", Config_User.Value_choice_split);
	fprintf (fp,   "\n");
	fprintf (fp,   "# Strings Expander: Lame Oggenc Flac Faac Mppenc Mac Wavpack\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "String_expander_Lame       =%s\n", Config_User.String_expander_Lame ? Config_User.String_expander_Lame : "");
	fprintf (fp,   "String_expander_Oggenc     =%s\n", Config_User.String_expander_Oggenc ? Config_User.String_expander_Oggenc : "");
	fprintf (fp,   "String_expander_Flac       =%s\n", Config_User.String_expander_Flac ? Config_User.String_expander_Flac : "");
	fprintf (fp,   "String_expander_Faac       =%s\n", Config_User.String_expander_Faac ? Config_User.String_expander_Faac : "");
	fprintf (fp,   "String_expander_Mppenc     =%s\n", Config_User.String_expander_Mppenc ? Config_User.String_expander_Mppenc : "");
	fprintf (fp,   "String_expander_Mac        =%s\n", Config_User.String_expander_Mac ? Config_User.String_expander_Mac : "");
	fprintf (fp,   "String_expander_Wavpack    =%s\n", Config_User.String_expander_Wavpack ? Config_User.String_expander_Wavpack : "");

	fprintf (fp,   "\n");
	fprintf (fp,   "# Administrator Of Packets: 0 = apt-get, 1 = aptitude\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "ADMINISTRATOR_OF_PACKETS =%d\n", Config_User.AdministratorOfPackets);

	fprintf (fp,   "\n");
	fprintf (fp,   "# Pos of Notebooks\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "BOOL_SAVE_POS_NOTEBOOK   =%s\n", Config_User.Bool_save_pos_notebook ? "TRUE" : "FALSE");
	fprintf (fp,   "POS_NOTEBOOK_GENERAL     =%d\n", Config_User.notebook_general);
	fprintf (fp,   "POS_NOTEBOOK_EXPANDER_CD =%d\n", Config_User.notebook_expander_cd);
	fprintf (fp,   "POS_NOTEBOOK_FILE        =%d\n", Config_User.notebook_file);
	fprintf (fp,   "POS_NOTEBOOK_OPTIONS     =%d\n", Config_User.notebook_options);
	fprintf (fp,   "POS_NOTEBOOK_POCHETTE    =%d\n", Config_User.notebook_pochette);
	fprintf (fp,   "POS_NOTEBOOK_LOGS        =%d\n", Config_User.notebook_logs);
	fprintf (fp,   "POS_NOTEBOOK_APP         =%d\n", Config_User.notebook_app);

	fprintf (fp,   "\n");
	fprintf (fp,   "# StringBoolFieldsIsVisible: %d entries, 0=FALSE 1=TRUE\n", showhidetreeview_get_etat_fields ());
	fprintf (fp,   "#\n");
	fprintf (fp,   "STRING_BOOL_FIELD_IS_VISIBLE =%s\n", Config_User.StringBoolFieldsIsVisible);

	fprintf (fp,   "\n");
	fprintf (fp,   "# StringPosFieldsName: 0:Left, 1:Center, 2:Right\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "STRING_POS_FIELDS_NAME       =%s\n", Config_User.StringPosFieldsName);

	fprintf (fp,   "\n");
	fprintf (fp,   "# File expander\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "BOOL_ETAT_EXPANDER_FILE =%s\n", Config_User.BoolEtatExpanderFile ? "TRUE" : "FALSE");
	
	fprintf (fp,   "\n");
	fprintf (fp,   "# File expander\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "BOOL_ETAT_EXPANDER_CD =%s\n", Config_User.BoolEtatExpanderCd ? "TRUE" : "FALSE");


	fprintf (fp,   "\n");
	fprintf (fp,   "# Select cd drive\n");
	fprintf (fp,   "#\n");
	fprintf (fp,   "INT_SELECT_CD =%d\n", Config_User.IntSelectCd);


	fprintf (fp,   "\n");
	fclose (fp);

	g_free (Name);
	Name = NULL;
}

void configuser_remove_struct (void)
{
	g_free (Config_User.Version);
	g_free (Config_User.Path_Destination_CD);
	g_free (Config_User.Path_Destination_DVD);
	g_free (Config_User.Path_Destination_file);
	g_free (Config_User.Path_Destination_file_mp3ogg);
	g_free (Config_User.Path_Load_file);
	g_free (Config_User.Path_Import_File_WAV);
	g_free (Config_User.Path_Import_File_MP3OGG);
	g_free (Config_User.Path_Load_Images);
	g_free (Config_User.Path_Load_file_CUE);
	g_free (Config_User.Path_Stocke_Images_Pochette);
	g_free (Config_User.Path_Dest_File_PostScript);
	g_free (Config_User.Path_Load_File_DVD);
	g_free (Config_User.Path_TMP);
	g_free (Config_User.Name_file_m3u);
	g_free (Config_User.Templates_title_cdaudio);
	g_free (Config_User.Templates_rep_cdaudio);
	g_free (Config_User.String_expander_Lame);
	g_free (Config_User.String_expander_Oggenc);
	g_free (Config_User.String_expander_Flac);
	g_free (Config_User.String_expander_Faac);
	g_free (Config_User.String_expander_Mppenc);
	g_free (Config_User.String_expander_Mac);
	g_free (Config_User.String_expander_Wavpack);
	g_free (Config_User.StringBoolFieldsIsVisible);
}
