 /*
 * file      : file_mp3ogg_conv.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"

#include <pthread.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>

#include "global.h"
#include "utils.h"
#include "info_song.h"
#include "options.h"
#include "file.h"
#include "conv.h"
#include "prg_init.h"
#include "win_control.h"
#include "secu.h"





/*
*---------------------------------------------------------------------------
*
*---------------------------------------------------------------------------
*/


/* Ce thread active les conversions de fichiers lorsque les extraction sont terminees
*  --
*  entree :
*      void *arg : NULL
*  retour : -
*/
static void filemp3oggconv_do_conversion_file_to_mp3ogg (void *arg)
{
	GList           *list = NULL;
	GList		*listmplayer = NULL;
	DETAIL          *detail = NULL;
	FIC_MP3OGG      *fic = NULL;
	TYPE_FILE_IS     type = FILE_IS_NONE;
	gchar           *str = NULL;
	PARAM_FILELC     param_filelc;

	g_print ("\n");
	g_print ("!-------------------------------------------------!\n");
	g_print ("! CONVERSION(S) DEPUIS L'ONGLET 'ANALYZE MP3-OGG' !\n");
	g_print ("!-------------------------------------------------!\n");
	g_print ("\n");

	conv.bool_thread_conv  = TRUE;

	list = g_list_first (entetefile);
	while (!conv.bool_stop && list) {
		if ((detail = (DETAIL *)list->data)) {
			if((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
			if (fic->Bool_Conv == TRUE) {

				type = infosong_get_type_file_is (detail->namefile);
				if (type == FILE_IS_MP3) {

					INFO_MP3 *info = (INFO_MP3 *)detail->info;
					GList *list = NULL;

					/* mpg321 SOURCE MP3 -> DESTINATION WAV
					*  ------------------------------------
					*/
					g_print ("SOURCE MP3<%s>\n", detail->namefile);
					g_print ("DEST   WAV<%s>\n", fic->destwav);
					/*
					conv_product_name_for_label (fic->destwav);
					conv.type_conv = MPG321_MP3_TO_WAV;
					conv.bool_reset_conv = TRUE;

				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("mpg321"));
					list = g_list_append (list, g_strdup ("--stereo"));
					list = g_list_append (list, g_strdup ("-v"));
					list = g_list_append (list, g_strdup ("-w"));
					list = g_list_append (list, g_strdup_printf ("%s", fic->destwav));
					list = g_list_append (list, g_strdup_printf ("%s", detail->namefile));
				GDK_THREADS_LEAVE();
					
					conv.ArgConv = conv_alloc_arg (list);
					conv_exec (FALSE, MPG321_MP3_TO_WAV, list, "MPG321_MP3_TO_WAV");
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					*/
					conv_product_name_for_label (fic->destwav);
					conv.type_conv = MPLAYER_WAV_TO_WAV;
					conv.bool_reset_conv = TRUE;
				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("mplayer"));
					list = g_list_append (list, g_strdup ("-nojoystick"));
					list = g_list_append (list, g_strdup ("-nolirc"));
					list = g_list_append (list, g_strdup (detail->namefile));
					list = g_list_append (list, g_strdup ("-ao"));
					list = g_list_append (list, g_strdup ("pcm"));
					list = g_list_append (list, g_strdup ("-ao"));
					list = g_list_append (list, g_strdup_printf ("pcm:file=%s", fic->destwav));
					list = g_list_append (list, g_strdup ("-af"));
					list = g_list_append (list, g_strdup ("channels=2"));
					list = g_list_append (list, g_strdup ("-srate"));
					list = g_list_append (list, g_strdup ("44100"));
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (FALSE, MPLAYER_WAV_TO_WAV, list, "MPLAYER_WAV_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv.encode_completed ++;

					/* SOX wav TO soxwav
					*  RENAME soxwav TO wav
					*/
					if (info->mpeg_is != MPEG_1) {

						/*
						GList *ListSox = NULL;

						g_print ("SOURCE MP3<%s>\n", fic->destwav);
						g_print ("DEST   WAV<%s>\n", fic->destsox);
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

						ListSox = conv_with_sox_get_param (fic->destwav, fic->destsox, "44100", "2", "16");
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;

						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						conv.encode_completed ++;

						infosong_rename_file (fic->destsox, fic->destwav);
						*/
						conv.encode_completed ++;
					}


					/* lame SOURCE WAV -> DESTINATION MP3
					*  ----------------------------------
					*/
					g_print ("SOURCE WAV%s>\n", fic->destwav);
					g_print ("DEST   MP3<%s>\n", fic->destmp3);
					conv_product_name_for_label (fic->destmp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;

					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = fic->destwav;
					param_filelc.filedest             = fic->destmp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = TRUE;

				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
				GDK_THREADS_LEAVE();
					conv.ArgConv = conv_alloc_arg (list);
					conv_exec (FALSE, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					g_free (str);
					str = NULL;

					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv.encode_completed ++;

					/* copy SOURCE MP3 -> DESTINATION MP3
					*  ----------------------------------
					*/
					if (!conv.bool_stop) {
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = COPY_FILE;

						conv_copy_src_to_dest (fic->destmp3, fic->destfile);

						conv.encode_completed ++;
						conv_remove_name_for_label (_CONV_);
						conv.type_conv = NONE_CONV;
					}
				}
				else if (type == FILE_IS_OGG) {

					INFO_OGG *info = (INFO_OGG *)detail->info;
					GList *list = NULL;

					/* ogg123 SOURCE OGG -> DESTINATION WAV
					*  ------------------------------------
					*/
					g_print ("SOURCE MP3<%s>\n", detail->namefile);
					g_print ("DEST   WAV<%s>\n", fic->destwav);
					conv_product_name_for_label (fic->destwav);
					/*
					conv.type_conv = OGG123_OGG_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("ogg123"));
					list = g_list_append (list, g_strdup ("-d"));
					list = g_list_append (list, g_strdup ("wav"));
					list = g_list_append (list, g_strdup ("-f"));
					list = g_list_append (list, g_strdup_printf ("%s", fic->destwav));
					list = g_list_append (list, g_strdup_printf ("%s", detail->namefile));
				GDK_THREADS_LEAVE();
					
					conv.ArgConv = conv_alloc_arg (list);
					conv_exec (FALSE, OGG123_OGG_TO_WAV, list, "OGG123_OGG_TO_WAV");
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv.encode_completed ++;
					*/
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_OGG_TO_WAV;
					conv.bool_reset_conv = TRUE;
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("%d", options_get_val_nice ()));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("%s", detail->namefile));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->destwav));

					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPLAYER_OGG_TO_WAV, listmplayer, "MPLAYER_OGG_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv.encode_completed ++;
					
					/* oggenc SOURCE WAV -> DESTINATION OGG
					*  ----------------------------------
					*/
					g_print ("SOURCE WAV%s>\n", fic->destwav);
					g_print ("DEST   MP3<%s>\n", fic->destogg);
					conv_product_name_for_label (fic->destogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;

					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = fic->destwav;
					param_filelc.filedest             = fic->destogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = TRUE;

				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
				GDK_THREADS_LEAVE();
					conv.ArgConv = conv_alloc_arg (list);
					conv_exec (FALSE, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv.encode_completed ++;

					/* copy SOURCE OGG -> DESTINATION MP3
					*  ----------------------------------
					*/
					if (!conv.bool_stop) {
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = COPY_FILE;

						conv_copy_src_to_dest (fic->destogg, fic->destfile);

						conv.encode_completed ++;
						conv_remove_name_for_label (_CONV_);
						conv.type_conv = NONE_CONV;
					}
				}

				infosong_delete_file (fic->destwav);
				infosong_delete_file (fic->destmp3);
				infosong_delete_file (fic->destogg);
				infosong_delete_file (fic->destsox);
			}
			}
		}
		list = g_list_next(list);
	}

	close(conv.tube_conv [ 0 ]);
	conv.bool_thread_conv = FALSE;
	secu_thread_sub ();
	pthread_exit(0);
}

/* Cette fonction est activee avec 'gtk_timeout_add ()' et gere les retours
*  des threads d'extraction et de conversion puis se desactive grace au flag
*  'bool_thread_conv_Conversion_file' lorsqu'il est a FALSE
*  --
*  entree :
*      gpointer data :
*  retour :
*      TRUE : Lorsque l'action du timeout est terminee
*/
static gint filemp3oggconv_call_update_mp3ogg (gpointer data)
{
	if (conv.bool_reset_conv) {
		conv_activate_progressBar (conv.Adr_progressbar_conversion);
		conv_set_label_conversion ();
		conv_set_label_total (_CONV_);
		conv.bool_reset_conv = FALSE;
	}

	else if (conv.bool_percent_conv) {
		conv_set_data_progressBar (conv.Adr_progressbar_conversion, conv.conversion_percent);
		conv_set_data_progressBar (conv.Adr_progressbar_total, conv.total_percent);
		conv.bool_percent_conv = FALSE;
	}
	
	else if (conv.bool_thread_conv == FALSE) {
		GList           *list = NULL;
		DETAIL          *detail = NULL;
		FIC_MP3OGG      *fic = NULL;

		/* free mem */
		list = g_list_first (entetefile);
		while (list) {
			if ((detail = (DETAIL *)list->data)) {
				if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
				g_free (fic->destwav);  fic->destwav = NULL;
				g_free (fic->destmp3);  fic->destmp3 = NULL;
				g_free (fic->destogg);  fic->destogg = NULL;
				g_free (fic->destsox);  fic->destsox = NULL;
				g_free (fic->destfile); fic->destfile = NULL;
				fic->Bool_Conv = FALSE;
				}
			}
			list = g_list_next(list);
		}

		/* Delete temporary rep */
		if (conv.TmpRep)  {
			conv.TmpRep  = utils_remove_temporary_rep (conv.TmpRep);
		}

		conv_remove_name_for_label (_CONV_);
		gtk_timeout_remove (conv.handler_timeout_conv);
		conv_close_window ();

		fileanalyze_update_info ();
		file_set_flag_buttons_audio_file ();
		file_update_glist_file_MP3OGG ();
		conv_set_struct_not_used ();
	}

	return (TRUE);
}


/* Initialisation des variables avant l'activation des threads d'extraction et de conversion
*  --
*  entree : -
*  retour : -
*/
void filemp3oggconv_set_flags_before_conversion (void)
{
	GList           *list = NULL;
	DETAIL          *detail = NULL;
	FIC_MP3OGG      *fic = NULL;
	gchar           *ptr = NULL;

	/* recup du niveau de gentillesse */
	g_snprintf (conv.valuenice , 4, "%d", options_get_val_nice ());
	/*strcpy (conv.modelame, optionsLame_get_str_val_mode_lame ());*/

	/* Create temporary rep */
	if (!conv.TmpRep)  {
		conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOFILEMP3OGG);
	}

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {

				g_free (fic->destwav);  fic->destwav = NULL;
				g_free (fic->destsox);  fic->destsox = NULL;
				g_free (fic->destmp3);  fic->destmp3 = NULL;
				g_free (fic->destogg);  fic->destogg = NULL;
				g_free (fic->destfile); fic->destfile = NULL;

				fic->Bool_Conv = FALSE;
				
				if ((fic->Lame.type != -1 && fic->Lame.debit != -1 && fic->Lame.mode != -1) ||
				    (fic->Oggenc.type != -1 && fic->Oggenc.debit != -1 && fic->Oggenc.mode != -1)) {

					detail->modif = TRUE;

					conv.total_convert += 2;

					if (detail->type_infosong_file_is == FILE_IS_MP3) {
						INFO_MP3 *info = (INFO_MP3 *)detail->info;

						if (info && info->mpeg_is != MPEG_1) {
							conv.total_convert ++;
						}
					}
					
					if (detail->type_infosong_file_is == FILE_IS_OGG) {
						conv.total_convert ++;
					}
					

					fic->Bool_Conv = TRUE;

					ptr = strrchr (detail->namefile, '/');
					ptr ++;

					fic->destwav  = g_strdup_printf ("%s/%s12345678", conv.TmpRep, ptr);
					fic->destsox  = g_strdup_printf ("%s/%s12345678", conv.TmpRep, ptr);
					fic->destmp3  = g_strdup_printf ("%s/%s12345678", conv.TmpRep, ptr);
					fic->destogg  = g_strdup_printf ("%s/%s12345678", conv.TmpRep, ptr);
					fic->destfile = g_strdup_printf ("%s/%s", file_make_pathname_file (detail, FALSE), ptr);
					
					ptr = strrchr (fic->destwav, '.');
					ptr ++;
					*(ptr +0) = 'w';
					*(ptr +1) = 'a';
					*(ptr +2) = 'v';
					*(ptr +3) ='\0';

					ptr = strrchr (fic->destsox, '.');
					*(ptr +0) = '_';
					*(ptr +1) = 's';
					*(ptr +2) = '.';
					*(ptr +3) = 'w';
					*(ptr +4) = 'a';
					*(ptr +5) = 'v';
					*(ptr +6) ='\0';

					ptr = strrchr (fic->destmp3, '.');
					ptr ++;
					*(ptr +0) = 'm';
					*(ptr +1) = 'p';
					*(ptr +2) = '3';
					*(ptr +3) ='\0';

					ptr = strrchr (fic->destogg, '.');
					ptr ++;
					*(ptr +0) = 'o';
					*(ptr +1) = 'g';
					*(ptr +2) = 'g';
					*(ptr +3) ='\0';
				}
			}
		}
		list = g_list_next(list);
	}
}

gboolean filemp3oggconv_is_regul_ok (void) {
	GList           *list = NULL;
	DETAIL          *detail = NULL;
	FIC_MP3OGG      *fic = NULL;
	gboolean         bool_mp3 = FALSE;
	gboolean         bool_ogg = FALSE;
	gchar           *str = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if((fic = (FIC_MP3OGG *)detail->fic_mp3ogg)) {
				if (detail->type_infosong_file_is == FILE_IS_MP3) {
					if (fic->Lame.type != -1 && fic->Lame.debit != -1 && fic->Lame.mode != -1) {
						bool_mp3 = TRUE;
					}
				}
				else if (detail->type_infosong_file_is == FILE_IS_OGG) {
					if (fic->Oggenc.type != -1 && fic->Oggenc.debit != -1 && fic->Oggenc.mode != -1) {
						bool_ogg = TRUE;
					}
				}
			}
		}
		list = g_list_next(list);
	}

	if (bool_mp3 && bool_ogg) {
		if (!PrgInit.bool_mplayer || !PrgInit.bool_lame || !PrgInit.bool_oggenc)
		str = g_strdup_printf (_("ATTENTION: Il faut installer%s%s%s"),
					!PrgInit.bool_mplayer ? " MPLAYER" : "",
					!PrgInit.bool_lame    ? " LAME"    : "",
					!PrgInit.bool_oggenc  ? " OGGENC"  : ""
					);
	}
	else if (bool_mp3) {
		if (!PrgInit.bool_mplayer || !PrgInit.bool_lame)
		str = g_strdup_printf (_("ATTENTION: Il faut installer%s%s"),
					!PrgInit.bool_mplayer ? " MPLAYER" : "",
					!PrgInit.bool_lame    ? " LAME"    : ""
					);
	}
	else if (bool_ogg) {
		if (!PrgInit.bool_oggenc)
		str = g_strdup_printf (_("ATTENTION: Il faut installer%s"),
					!PrgInit.bool_oggenc ? " OGGENC"  : ""
					);
	}
	if (str) {
		utils_puts_statusbar_global (str);
		g_free (str);
		str = NULL;
		return (FALSE);
	}

	return (TRUE);
}

void filemp3oggconv_apply_regul_mp3ogg_by_conv (void)
{
	pthread_t nmr_tid;

	/*PRINT_FUNC_LF();*/

	utils_puts_statusbar_global ("");

	if (filemp3oggconv_is_regul_ok ()) {
		conv_reset_struct ();
		filemp3oggconv_set_flags_before_conversion ();
		conv_create_window (_("Modification bitrate"));
		conv_activate_progressBar (conv.Adr_progressbar_conversion);
		conv_activate_progressBar (conv.Adr_progressbar_total);
		conv.bool_thread_conv = TRUE;
 		secu_thread_add ();
		pthread_create (&nmr_tid, NULL ,(void *)filemp3oggconv_do_conversion_file_to_mp3ogg, (void *)NULL);
 		conv.handler_timeout_conv = gtk_timeout_add (100, filemp3oggconv_call_update_mp3ogg, 0);
	}
}




