 /*
 * file      : level.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "global.h"
#include "file.h"
#include "prg_init.h"
#include "config_user.h"
#include "level.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {
	int            signal_numchildren;
	int            tube [ 2 ];
	pid_t          code_fork;
	TYPE_FILE_IS   TypeFileIs;
	gchar         *file;
	guint          handler_timeout;
	gboolean       bool_in_thread;
	gboolean       bool_percent;
} VAR_LEVEL;

VAR_LEVEL var_level;

/*
*---------------------------------------------------------------------------
* FONCTION
*---------------------------------------------------------------------------
*/
/*
*---------------------------------------------------------------------------
* SIGNAL ET EXTRACTION
*---------------------------------------------------------------------------
*/
extern float roundf(float x);

void level_sigchld (gint signum)
{
        gint status;
        wait(&status);

	var_level.signal_numchildren --;
        if (var_level.signal_numchildren > 0)
        {
                /* re-install the signal handler */
                signal (SIGCHLD, level_sigchld);
        }
}

gint level_exec (gchar **args, pid_t *p, gint p_output)
{
	if (pipe (var_level.tube) != 0)
	{
		fprintf (stderr, "error: pipe\n");
		exit (1);
	}
	if ((*p = fork()) == 0)
	{
		dup2 (var_level.tube [ 1 ], p_output);
		close (var_level.tube [ 1 ]);
		execvp (args[0], args);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	var_level.signal_numchildren ++;
	signal (SIGCHLD, level_sigchld);
	close(var_level.tube [ 1 ]);
	return (var_level.tube [ 0 ]);
}

gint level_get_from (TYPE_FILE_IS TypeFileIs, gchar *file)
{
	gint   pos = 0;
	gchar *args [ 20 ];
	gint   fd;
	gint   size = -1;
	gchar  buf [ 1024 + 10 ];
	gint   arrondit = -1;
	

	if (TypeFileIs == FILE_IS_WAV || TypeFileIs == FILE_IS_MP3) {
		/*
		normalize-audio -n ./kill_bill.wav
		*/
		// args[pos++] = PrgInit.name_normalize;
		args[pos++] = prginit_get_name (NMR_normalize);
		args[pos++] = "-n";
		args[pos++] = file;
		args[pos++] = NULL;
	}
	else if (TypeFileIs == FILE_IS_OGG) {
		/*
		normalize-ogg -n ./kill_bill.ogg
		*/
		args[pos++] = "normalize-ogg";
		args[pos++] = "-n";
		args[pos++] = file;
		args[pos++] = NULL;
	}

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!  NORMALISE -n %s\n", args[ 0 ]);
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = level_exec (args, &var_level.code_fork, STDOUT_FILENO);

	do {
		pos = -1;
		do {
			pos++;
			if (pos >= 1024) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= 1024\n", pos);
				pos --;
			}
			size = read(fd, &buf[pos], 1);
			
		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		pos ++;
		buf[ pos ] = '\0';

		var_level.bool_percent = TRUE;
		
		if (strstr (buf, "dBFS")) {
			/* g_print ("dBFS\n"); */
			/* g_print ("buf = %s\n", buf); */
			/* g_print ("%f\n", atof(buf)); */
			arrondit = (gint)roundf(atof(buf));
			/* g_print ("%d\n", arrondit); */
		}
		
	} while (size != 0);

	close(fd);
	var_level.code_fork = -1;
	return (arrondit);
}

gboolean level_bool_percent (void)
{
	return (var_level.bool_percent);
}

/* Retourne, en KiloOctet la place disponible du dossier temporaire
*/
glong level_df (void)
{
	gint   pos = 0;
	gchar *args [ 20 ];
	gint   fd;
	gint   size = -1;
	gchar  buf [ 1024 + 10 ];
	gchar *Path = g_strdup_printf ("%s/", Config_User.Path_TMP);
	glong  Size = 0;
	gchar *Ptr = NULL;
	
	args[pos++] = "df";
	args[pos++] = "--block-size=K";
	args[pos++] = Path;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!  NORMALISE -n %s\n", args[ 0 ]);
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	
	fd = level_exec (args, &var_level.code_fork, STDOUT_FILENO);

	do {
		pos = -1;
		do {
			pos++;
			if (pos >= 1024) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= 1024\n", pos);
				pos --;
			}
			size = read(fd, &buf[pos], 1);
			
		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		pos ++;
		buf[ pos ] = '\0';

		if (strstr (buf, "/dev/")) {
			/* 
			buf=/dev/sda5            19686772K  4080996K 14605736K  22% /
			*/
			/* g_print("buf=%s\n", buf); */
			Ptr = strchr (buf, 'K');
			Ptr ++;
			Ptr = strchr (Ptr, 'K');
			Ptr ++;
			while (*Ptr == ' ') Ptr ++;
			/* g_print("Ptr  = '%s'\n", Ptr); */
			Size = (glong)atol (Ptr);
			/* g_print("Size = %lu\n", Size); */
		}

	} while (size != 0);
	
	g_free (Path);
	Path = NULL;

	close(fd);
	var_level.code_fork = -1;
	return (Size);
}

