 /*
 * file      : logs.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <sys/utsname.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "config_user.h"
#include "options.h"
#include "logs.h"


VAR_LOGS var_logs;



gboolean logs_get_checkbutton_goto_files_import (void)
{
	return (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (var_logs.Adr_checkbutton_goto_files_import)));
}
void logs_checkbutton_goto_files_import_clicked (void)
{
	Config_User.Bool_GoTo_Togle_Import_File = logs_get_checkbutton_goto_files_import ();
}
void logs_set_checkbutton_goto_files_import (void)
{
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_logs.Adr_checkbutton_goto_files_import),
									Config_User.Bool_GoTo_Togle_Import_File);
}

void logs_label_computer_add (gchar *text)
{
	gchar *save = NULL;
	
	save = g_strdup_printf ("%s%s", gtk_label_get_label (GTK_LABEL(var_logs.Adr_label_computer)), text);
	
	gtk_label_set_use_markup (GTK_LABEL (var_logs.Adr_label_computer), TRUE);
	gtk_label_set_justify (GTK_LABEL (var_logs.Adr_label_computer), GTK_JUSTIFY_LEFT);
	gtk_label_set_markup (GTK_LABEL (var_logs.Adr_label_computer), save);
	gtk_widget_show (var_logs.Adr_label_computer);
	
	g_free (save);
	save = NULL;
}

void logs_label_import_file_add (gchar *text)
{
	gchar *save = NULL;
	
	gchar *NewText = NULL;
	gchar *PtrNewText = NULL;
	gchar *PtrText = NULL;
	
	NewText = g_strnfill (strlen (text) * 3, '\0');
	for (PtrText = text, PtrNewText = NewText; *PtrText; PtrText ++, PtrNewText ++) {
		*PtrNewText = *PtrText;
		if (*PtrText == '&') {
			 PtrNewText ++;
			*PtrNewText ++ = 'a';
			*PtrNewText ++ = 'm';
			*PtrNewText ++ = 'p';
			*PtrNewText    = ';';
		}
	}

	save = g_strdup_printf ("%s%s", gtk_label_get_label (GTK_LABEL(var_logs.Adr_label_import_file)), NewText);
	g_free (NewText);
	NewText = NULL;
	PtrText = NULL;
	
	gtk_label_set_use_markup (GTK_LABEL (var_logs.Adr_label_import_file), TRUE);
	gtk_label_set_justify (GTK_LABEL (var_logs.Adr_label_import_file), GTK_JUSTIFY_LEFT);

	gtk_label_set_markup (GTK_LABEL (var_logs.Adr_label_import_file), save);
	gtk_widget_show (var_logs.Adr_label_import_file);
	
	g_free (save);
	save = NULL;
}

void logs_add_datas_system (gchar *data)
{
	FILE *fp = NULL;
	
	fp = fopen ("/tmp/data.txt", "a");
	fprintf (fp, "%s", data);
	fclose (fp);
}
gboolean logs_set_datas_system (void)
{
	GString   *gstr = g_string_new (NULL);
	FILE      *fp = NULL;
#define MAX_CARS 255
	gchar      buf   [ MAX_CARS +4 ];
	gboolean   BoolRet = FALSE;
	
	/*PRINT_FUNC_LF();*/
	
	if ((fp = fopen ("/tmp/data.txt", "r")) != NULL) {
		
		g_string_append_printf (gstr, "%s", gtk_label_get_label (GTK_LABEL(var_logs.Adr_label_import_file)));
		
		while (fgets (buf, MAX_CARS, fp) != NULL) {
			g_string_append_printf (gstr, "%s", buf);
		}
		fclose (fp);
	
		gtk_label_set_use_markup (GTK_LABEL (var_logs.Adr_label_import_file), TRUE);
		gtk_label_set_justify (GTK_LABEL (var_logs.Adr_label_import_file), GTK_JUSTIFY_LEFT);
		gtk_label_set_markup (GTK_LABEL (var_logs.Adr_label_import_file), gstr->str);
		gtk_widget_show (var_logs.Adr_label_import_file);
		
		BoolRet = TRUE;
	}
	g_string_free (gstr, TRUE);
	infosong_delete_file ("/tmp/data.txt");
	
	return (BoolRet);
}

void logs_trace_datas (gchar *data)
{
	/*
	FILE *fp = NULL;

	fp = fopen ("/tmp/trace_xcfa.txt", "a");
	fprintf (fp, "%s", data);
	fclose (fp);
	*/
	if (infosong_file_is_reg ("/tmp/trace_xcfa.txt") == TRUE) {
		infosong_delete_file ("/tmp/trace_xcfa.txt");
	}
}













