 /*
 * file      : main.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <glib.h>
#include <gdk/gdk.h>

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <locale.h>
#include <unistd.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "global.h"
#include "config_user.h"
#include "prg_init.h"
#include "utils.h"
#include "file.h"
#include "options.h"
#include "cd_audio.h"
#include "logs.h"
#include "win_control.h"
#include "poche.h"
#include "prg_navigator.h"
#include "scan_cd.h"
#include "dvd_audio.h"
#include "split.h"
#include "showhide_treeview.h"
#include "player.h"
#include "info_song.h"
#include "prg_audio.h"
#include "process.h"
#include "fileselect.h"
#include "split_shuttle.h"



/*
*---------------------------------------------------------------------------
* VARIABLE GLOBALE
*---------------------------------------------------------------------------
*/

GtkWidget	*wind_main;
HOST_CONF	 HostConf;

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

typedef struct {
	gchar Mess_1 [ 100 ];
	gchar Mess_2 [ 100 ];
	gchar Mess_3 [ 100 ];
} ERROR;

ERROR error;

void segfault_handler_mess_error (gchar *p_mess)
{
	strcpy (error.Mess_3, error.Mess_2);
	strcpy (error.Mess_2, error.Mess_1);
	strcpy (error.Mess_1, p_mess);
}

/* Install un 'handler' sur une mauvaise allocation memoire
*  --
*  entree : int sig :
*  retour : -
*/
void segfault_handler(int sig)
{
	/* PRINT_FUNC_LF(); */
	g_print ("\n=========================================================\n");
	g_print ("=  Segmentation fault\n");
	g_print (_("=  Adressage memoire invalide\n"));
	g_print ("=-------------------------------------------------------=\n");
	g_print ("=      You've probably found a bug in XCFA\n");
	g_print (_("=      Vous avez probablement trouve un bug dans XCFA\n"));
	if (error.Mess_1[ 0 ] != '\0') {
		g_print ("=-------------------------------------------------------=\n");
		g_print ("%s\n", error.Mess_1);
		g_print ("%s\n", error.Mess_2);
		g_print ("%s\n", error.Mess_3);
	}
	g_print ("=========================================================\n\n");
	
	infosong_delete_file (XCFA_FILE_LOAD);
	infosong_delete_file (XCFA_PROCESS);
	
	exit (EXIT_FAILURE);
}

/* Affiche la version
*  --
*  entree : -
*  retour : -
*/
void Version (void)
{
	/* PRINT_FUNC_LF(); */
	g_print ("\nVERSION = %s %s\n\n", PACKAGE, VERSION);
}


/* Affiche l'usage et sortie
*  --
*  entree : -
*  retour : -
*/
void Usage (void)
{
	/* PRINT_FUNC_LF(); */
	g_print ("USAGE\n");
	g_print ("-h -H --help     Help of this application\n");
	g_print ("-v -V --version  Version of application\n");
	g_print ("--no_cd_dvd      Desactivation de la reconnaissance du/des lecteurs cd-dvd\n");
	g_print ("*.ogg            Charge tous les fichiers ogg\n");
	g_print ("\n");

	exit (EXIT_SUCCESS);
}

/* Definition de la structure de la ligne de commande
*/
struct option long_options[] =
{
	{"help",      0, 0, 0},
	{"version",   0, 0, 0},
	{"no_cd_dvd", 0, 0, 0},
	{0, 0, 0, 0}
};


/* Analyse des option passees sur la ligne de commande
*  --
*  entree :
*      int argc
*      gchar *argv[]
*  retour : -
*/
void AnalyseCommandLine_getopt_long (int argc, gchar *argv[])
{
	gint    c, o;

	// PRINT_FUNC_LF();

	while ((c = getopt_long(argc, argv, "*HhVv?", long_options, &o)) != -1)
	{
		switch (c)
		{
		case 0:
			switch (o)
			{
			case 0:
				g_print ("--help\n");
				Usage ();
				break;
			case 1:
				g_print ("--version\n");
				Version ();
				Usage ();
				break;
			
			case 2:
				g_print ("--no_cd_dvd\n");
				scancd_set_bool_scan (FALSE);
				break;

			default :
				g_print ("DEBUG COMMAND LINE\n");
			}
			break;

		case 'h':
		case 'H':
			g_print ("-h\n");
			Usage ();
			break;
		case 'v':
		case 'V':
			g_print ("-v\n");
			Version ();
			Usage ();
			break;
		case '?' :
			g_print ("-?\n");
			Usage ();
			break;

		default :
			g_print ("Commande inconnue\n");
			Usage ();
		}
	}
}
void AnalyseCommandLine_set_argv (int argc, gchar *argv[])
{
	gint	 i;
	gchar	*str_current_dir = g_get_current_dir();
	FILE	*fp = NULL;
	
	/* Creation du fichier */
	fp = fopen (XCFA_FILE_LOAD, "a");
	
	for (i = optind; i < argc; i++)
	{
		if (argv[i][0] == '/') {

			/*g_print ("'%s'\n", argv[i]);*/
			/*fileanalyze_create_glist_analyze_file (argv[i], FALSE);*/

			fprintf (fp, "%s\n", argv[ i ]);
		}
		else {
			gchar *str = NULL;
			
			str = g_strdup_printf ("%s/%s", str_current_dir, argv[i]);

			/*g_print (">%s\n", str);*/
			/*fileanalyze_create_glist_analyze_file (str, FALSE);*/

			fprintf (fp, "%s\n", str);
			g_free (str);
			str = NULL;
		}
	}
	g_print ("\n");
		
	g_free (str_current_dir);
	str_current_dir = NULL;
	
	/* Fermeture du fichier */
	fclose (fp);
}

void set_computer_information (void)
{
	gchar *ptr = NULL;
	
	ptr = utils_get_infos_ordi (TRUE, FALSE, TRUE);
	logs_label_computer_add ("\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;
	
	logs_label_computer_add ("<span foreground=\"#0000FF\"><b>Depots Debian-multimedia</b></span>\n\n");
	logs_label_computer_add (

		"\tdeb http://www.debian-multimedia.org sid main\n"
		"\tdeb-src http://www.debian-multimedia.org sid main\n"
		"\n<span foreground=\"#0000FF\"><b><i>Ou</i></b></span>"
		"\tdeb http://www.debian-multimedia.org testing main\n"
		"\tdeb-src http://www.debian-multimedia.org testing main\n"
		"\n"
		);
	
	logs_label_computer_add ("<span foreground=\"#0000FF\"><b>Depots TuxFamily</b></span>\n\n");
	logs_label_computer_add (

		"\tdeb http://download.tuxfamily.org/xcfaudio/xcfa dev contrib\n"
		"\tdeb-src http://download.tuxfamily.org/xcfaudio/xcfa dev contrib\n"
		"\n"
		);

	logs_label_computer_add ("<span foreground=\"#0000FF\"><b>XCFA exist dans les depots Frugalware  :-)</b></span>\n\n");
	
	ptr = g_strdup ("<span foreground=\"#F00000\"><b><i>NOTE:\nSi sox ne vous donne pas satisfaction:</i></b></span>\n\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;
	logs_label_computer_add (
		"\t<b># (sudo) apt-get install libsox-fmt-all</b>\n"
		"\n"
		);
	
	ptr = g_strdup ("<span foreground=\"#0000FF\"><b>Dernieres modifications</b></span>\n\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;
	
	logs_label_computer_add (

		"\t<span foreground=\"#0000FF\"><b>3.4.1</b></span>\n"
		
		"\t<b>bug resolu:</b> Utilisation correcte du navigateur opera\n"
		"\t<b>bug resolu:</b> Modif algo d'extraction/conversion cd audio\n"
		"\t<b>Traduction</b> vers l'Allemand par Karsten Mehrhoff\n"
		"\t<b>Traduction</b> vers l'Anglais par Guillaume\n"
		"\t<b>Preferences</b> Choix du player audio\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.4.2</b></span>\n"
		
		"\t<b>bug resolu:</b> Les options sont affichees correctement\n"
		"\t<b>bug resolu:</b> Les lettres accentuees des tags sont affichees correctement\n"
		"\t<b>bug resolu:</b> Les fichiers *.oga sont analyses et l'extention est corrigee si besoin\n"
		"\t<b>Creation</b> de fichier Xspf avec le fichier M3u\n"
		"\t<b>Ajout</b> de copy / paste pour le tags commentaire cd audio\n"
		"\t<b>Correction</b> d'une limitation d'espace disque pour Normalise->Peak/Album\n"
		"\t<b>Ajout</b> du template %f dans les tags cd audio lors de la saisie d'un nom xspf ou m3u\n"
		"\t<b>Dzef:</b>\n"
		"\t\t<b>Ajout en cours</b> du mode expert pour l'extracteur cdparanoia \n"
		"\t\tXcfa essayes de reprendre quelques fonctionnalites interessantes de 'rubyripper' et\n"
		"\t\tc'est ce que Dzef et moi appelons 'mode expert de cdparanoia'\n"
		"\t\tSi une erreur de comparaison est trouvee, jusqu'a 4 fois 2 re-lectures de segments sont possibles\n"
		"\t\thttp://code.google.com/p/rubyripper/ \n"
		"\t<b>Correction</b> de l'analyse des fichiers de type aac\n"
		"\t<b>Correction</b> de l'enregistrement des tags avec l'utf8 en extraction et conversion\n"
		"\t<b>Integration</b> dans About des pages de forum:\n"
		"\t\thttp://opera-info.de/forum/thread.php?threadid=20506\n"
		"\t\thttp://linuxforen.de/forums/showthread.php?p=1693658\n"
		"\t<b>Correction</b> Modif algo de conversion\n"
		"\t<b>Correction</b> Prise en compte du format AAC depuis le WMA\n"
		"\t<b>Correction</b> de l'affichage du bouton d'annulation CDDB\n"
		"\t<b>Correction</b> conversion WAV vers ...\n"
		"\t<b>Correction</b> production de CUE file\n"
		"\t<b>Correction</b> scroll onglet dvd\n"
		"\t<b>Ajout</b> Prise en compte des extentions de fichiers en majuscule\n"
		"\t<b>Correction</b> algo de detection entete OGG\n"
		"\t<b>Correction</b> kbit/s est generalise\n"
		"\t<b>Correction</b> des underlines\n"
		"\t<b>Modif</b> mplayer remplace mpg321 pour les conversions: mp3 vers wav\n"
		"\t<b>Modif</b> du code pour les traductions\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.4.3</b></span>\n"
		
		"\t<b>Correction</b> Installation de Wavsplit\n"
		"\t<b>Amelioration</b> du code de file.c\n"
		"\t<b>Bug resolu</b> depuis SPLIT: les noms de fichiers possedent maintenant un numero de plage plus un numero d'increment si le fichier existe\n"
		"\t<b>Bug resolu</b> depuis SPLIT: le caractere / est interdit dans les noms de fichiers\n"
		"\t<b>Correction</b> des templates pour le cd-audio qui sont par defaut: %c %d\n"
		"\t<b>Ajout</b> La traduction Allemande et Anglaise continue son bonhomme de chemin ...\n"
		"\t<b>Bug resolu</b> La correction des mauvaises extensions de fichiers est automatique\n"
		"\t<b>Correction</b> de quelques pixels pour la traduction Allemande\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.4.9</b></span>\n"
		
		"\t<b>Ajout</b> d'une gestion des tags pour une exportation vers les formats ouverts\n"
		"\t<b>Correction</b> du fichier xcfa.desktop\n"
		"\t<b>Ajout</b> sur les tranches de la pochette du titre de l'album\n"
		"\t<b>Remplacement</b> de ogg123 par mplayer pour les convertions: ogg vers wav\n"
		"\t<b>Ajout</b> depuis l'onglet CD d'une possibilite de multi-creation de dossiers\n"
		"\t<b>Ajout</b> d'une sauvegarde/restitution du lecteur de cd en cours\n"
		"\t<b>Ajout</b> du chargement de multi fichiers pour une session XCFA via le menu contectuel depuis le bureau\n"
		"\t<b>Amelioration</b> du module d'import des fichiers\n"
		"\t<b>Redefinition</b> du module SPLIT\n"
		"\t<b>Dzef:</b>\n"
		"\t<b>RESOLU</b> > Si je veux normaliser et convertir un wav 48 kHz en ogg, xcfa me crée un ogg en 44.1 kHz... Pas normal, hein ?\n"
		
		"\n"
		);
	
	ptr = g_strdup ("<span foreground=\"#0000FF\"><b>En cours ...</b></span>\n\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;
	logs_label_computer_add (
		"\t<b>Traduction</b> vers l'Italien par ???\n"
		"\t<b>patachonf:</b>\n"
		"\t\t> Ajout onglet fichiers: conversion real (rm) vers wav, ...\n"
		"\t<b>Claude:</b>\n"
		"\t\t> Depuis l'onglet fichiers: Ajouter le dernier dossier d'import a la destination\n"
		"\t\t> Ajout d'un onglet: Join : assembler des fichiers\n"
		"\t<b>Shankarius:</b>\n"
		"\t\t> J'en profite pour te faire un petit rappel concernant les copies temporaires inutiles. ;)\n"
		"\n"
		);
	ptr = g_strdup_printf ("<span foreground=\"#0000FF\"><b>TODO  --  A faire</b></span>\n\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;

/*
Salut la horde, salut Claude,
Je sais plus trop où on en est sur la todo liste, donc excusez moi en cas de redondance :
	
	- Onglet fichiers. Si je converti en flac et que je fais une normalisation
	  peak/groupe vers un dossier différent de celui des fichiers sources, Xcfa
	  copie les wav normalisés vers ce dossier. Est ce bien utile ?
	
	- Dans ce même onglet, on devrait pouvoir choisir les modes peak &
	  peak/group sans avoir à scanner.
	  
Bon ben c'est tout pour l'instant. Si je vois autre chose, je sonne...
*/
	logs_label_computer_add (
		"\t<b>b52:</b>\n"
		"\t\t<b>Nouvel onglet:</b> Extraction bande son depuis un film\n"
		"\n"
		);

	ptr = g_strdup_printf ("<span foreground=\"#0000FF\"><b>DE GRANDS MERCIS ...\nTHANK YOU ...\n</b></span>\n");
	logs_label_computer_add (ptr);
	g_free (ptr);
	ptr = NULL;

	logs_label_computer_add (

		"\t... <b><i>a tous pour le temps consacre au developpement + tests d'Xcfa</i></b>\n"
		"\t... <b><i>for all time spent on developing + Xcfa tests</i></b>\n"
		"\t<b><i>;-)</i></b>"
		"\n"
		);
}

void put_display (void)
{
        const char *display_name;
        display_name = gdk_display_get_name (gdk_display_get_default ());
	g_print ("display_name = %s\n", display_name);
}




/* gint main (gint argc, gchar *argv[], gchar **envp)
 *
 * argc  désigne le nombre d'arguments transmis au moment du lancement de l'exécutable
 * argv  désigne le vecteur contenant les différents arguments
 * envp  désigne le vecteur contenant les informations sur l'environnement
 */
gint main (gint argc, gchar *argv[], gchar **envp)
{
	/*
	g_mem_set_vtable (glib_mem_profiler_table);
	g_mem_profile ();
	*/
	FILE	*fp = NULL;
	
	if ((fp = fopen (XCFA_PROCESS, "r")) != NULL) {		/* Test if XCFA_PROCESS exist			*/
		fclose (fp);					/* YES						*/
	
		var_process.bool_read_access = FALSE;			/* No access for XCFA_PROCESS file	*/
		fp = fopen (XCFA_PROCESS, "w");				/* Open XCFA_PROCESS			*/
		fprintf (fp, "2");					/* 1=original else 2=other process	*/
		fclose (fp);						/* Close XCFA_PROCESS			*/
		
		AnalyseCommandLine_set_argv (argc, &argv[0]);		/* Get and save param-file		*/
		
		fp = fopen (XCFA_PROCESS, "w");				/* Open XCFA_PROCESS			*/
		fprintf (fp, "1");					/* 1=original else 2=other process	*/
		fclose (fp);						/* Close XCFA_PROCESS			*/

		var_process.bool_read_access = TRUE;			/* access for XCFA_PROCESS file	is OK	*/
		
		return (EXIT_SUCCESS);					/* Quit process				*/
	}
	else							/* XCFA_PROCESS NOT exist			*/
	{
		fp = fopen (XCFA_FILE_LOAD, "w");			/* Clean XCFA_FILE_LOAD file		*/
		fclose (fp);						/* Close XCFA_FILE_LOAD			*/
		
		fp = fopen (XCFA_PROCESS, "w");				/* Open XCFA_PROCESS			*/
		fprintf (fp, "1");					/* 1=original else 2=other process	*/
		fclose (fp);						/* Close XCFA_PROCESS			*/
		
		AnalyseCommandLine_getopt_long (argc, &argv[0]);	/* Get options for original process	*/
		AnalyseCommandLine_set_argv (argc, &argv[0]);		/* Get and save param-file		*/
	}
	var_process.bool_action_is_ready = FALSE;
	
	g_print ("\n");
	g_print ("***************************\n");
	g_print ("%s %s\n", PACKAGE, VERSION);
	g_print ("***************************\n");
	g_print ("%s %s compiled at %s %s\n", PACKAGE, VERSION, __DATE__, __TIME__);
	g_print ("Compiler: gcc %s\n", __VERSION__);
	g_print ("***************************\n");
	g_print ("Gtk version  = %d.%d.%d\n", GTK_MAJOR_VERSION, GTK_MICRO_VERSION, GTK_MINOR_VERSION);
	g_print ("Glib version = %d.%d.%d\n", GLIB_MAJOR_VERSION, GLIB_MICRO_VERSION, GLIB_MINOR_VERSION);
	g_print ("***************************\n");
	
	strcpy (error.Mess_1, "");
	utils_infos_ordi ();
	g_print ("HostConf.NbCpu   = %d CPU\n", HostConf.NbCpu);
	g_print ("HostConf.TypeCpu = %d Bits\n", HostConf.TypeCpu);
	g_print ("HostConf.Machine = %s\n", HostConf.Machine);
	g_print ("\n");
		
	/* IF Segmentation fault */
	signal (SIGSEGV, segfault_handler);

	/* Ignore Ctrl-C.
	 *
	 *  signal (SIGINT, SIG_IGN);
	 */

#ifdef ENABLE_NLS
	g_print ("ENABLE_NLS OK\n");
	g_print ("\tGETTEXT_PACKAGE    = %s\n", GETTEXT_PACKAGE);
	g_print ("\tPACKAGE_LOCALE_DIR = %s\n", PACKAGE_LOCALE_DIR);

	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#else
	g_error ("ENABLE_NLS IS NOT OK\n\n");
#endif
	g_print ("\tDATA_DIR           = %s\n", DATA_DIR);

	gtk_set_locale ();
	/*setlocale (LC_ALL, "fr");*/

	/* THREAD INIT
	*/
	g_thread_init (NULL);
	if (g_thread_supported()) {
		g_print ("\ng_thread_supported: YES\n\n");
	} else {
		g_print ("\ng_thread_supported: NO\n");
		g_print ("Desole les thread ne sont pas supportes pas votre plate-forme.\n"
			 "Il vous faut un systeme linux base sur la libc5 ainsi que GLIB & GTK+\n\n");

		g_print ("Sorry, threads isn't supported on your platform.\n"
			 "If you're on a libc5 based linux system and installed GLIB & GTK+ before you\n"
			 "installed LinuxThreads you need to recompile GLIB & GTK+\n\n");

		g_error ("\n");
	}
	gdk_threads_init ();
	gdk_threads_enter ();
	
	gtk_init (&argc, &argv);

	/* LE PID EST L ORIGINAL DONC CE PROCESS SERA ACTIVE */
	fileselect_clear_glist ();
	process_goto_timeout ();

	/* add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps"); */
	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

	g_print ("\tPACKAGE_DATA_DIR   = %s\n", PACKAGE_DATA_DIR);

	g_print ("gtk_set_locale () = %s\n\n", gtk_set_locale ());

	var_options.ColorLineCommand = COLOR_INIT;

	/* Lecture de la configuration */
	configuser_read_file_config ();
	showhidetreeview_set_etat_fields ();

	/* Creation de la fenetre principale */
	wind_main = create_wind_main ();
	wincontrol_set_adr (wind_main, "wind_main", FALSE, FALSE);

	/* Le titre de la fenetre */
	gtk_window_set_title (GTK_WINDOW (wind_main), "X Convert File Audio ");

	/* Redimensionner la fenetre */
	gtk_window_resize(GTK_WINDOW(wind_main), Config_User.Win_Width, Config_User.Win_Height);
	/* Placer la fenetre */
	gtk_window_move(GTK_WINDOW(wind_main), Config_User.WinPos_X, Config_User.WinPos_Y);

	utils_set_default_icone_xcfa (wind_main);

	/* Affichage */
	gtk_widget_show (wind_main);
	gtk_widget_show_all (wind_main);
	
// while (gtk_events_pending()) gtk_main_iteration(); 

	/* PRG_EXTERNES */
	/*
	notebook_general
	*/
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGAUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGPOSTSCRIPT);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGNAVIGATOR);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGEXTERNES);
	
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_type_deb_other")),
					NOTEBOOK_OPTIONS_TYPE_OTHER);
			gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_type_deb_other")),
					NOTEBOOK_OPTIONS_TYPE_DEB);
	
			if (var_options.Type_Package == _DEBIAN_) {
				gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_type_deb_other")),
						NOTEBOOK_OPTIONS_TYPE_DEB);
			}
			else {
				gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_type_deb_other")),
						NOTEBOOK_OPTIONS_TYPE_OTHER);
			}
	
	/* OPTIONS */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_OPTIONS);
		
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_EXPORT_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_AACPLUSENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_FAAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_MUSEPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_WAVPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_MAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_FLAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_OGGENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_LAME);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")),
				NOTEBOOK_OPTIONS_GENERAL);
	
	/* LOGS */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_LOGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")),
				NOTEBOOK_LOGS_FILE_IMPORT);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")),
				NOTEBOOK_LOGS_COMPUTER);

	/* POCHETTE */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_POCHETTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_pochette")),
				NOTEBOOK_POCHETTE_TEXTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_pochette")),
				NOTEBOOK_POCHETTE_TITRE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_pochette")),
				NOTEBOOK_POCHETTE_IMAGE);

	/* NOTEBOOK_SPLIT */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_SPLIT);

	/* FICHIERS */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_FICHIERS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_MP3OGG);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_WAV);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")),
				NOTEBOOK_FICHIERS_CONVERSION);

	/* CD-AUDIO */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_CUE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_TITRE_CD);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_TAGS);

	/* DVD-AUDIO */
	gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
			NOTEBOOK_DVD_AUDIO);
	
// while (gtk_events_pending()) gtk_main_iteration(); 

	/* SI app-externe absente, GOTO NOTEBOOK->OPTIONS */
	if (prginit_get_etat () == FALSE && strcmp (Config_User.Version, VERSION) != 0) {

		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGEXTERNES);
	}
	else if (pocheevnt_init_images_xcfa () == TRUE) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")),
				NOTEBOOK_POCHETTE);
	}
	else if (Config_User.Bool_save_pos_notebook == TRUE) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), Config_User.notebook_general);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_expander_cd")), Config_User.notebook_expander_cd);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_in_file")), Config_User.notebook_file);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_options")), Config_User.notebook_options);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_pochette")), Config_User.notebook_pochette);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_logs")), Config_User.notebook_logs);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_app_externes")), Config_User.notebook_app);
	}
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (lookup_widget (wind_main, "checkbutton_pos_onglets")), Config_User.Bool_save_pos_notebook);

	Config_User.BoolNewVersion = FALSE;
	if (strcmp (Config_User.Version, VERSION) != 0) {
		
		Config_User.BoolNewVersion = TRUE;
		
		g_print ("Config_User.Version  = %s\n", Config_User.Version);
		g_print ("VERSION              = %s\n", VERSION);
		g_print ("\n");
		g_free (Config_User.Version);
		Config_User.Version = NULL;
		Config_User.Version = g_strdup (VERSION);
		g_print ("\n");
	}
	
	cdaudio_set_flag_buttons_audio_cd ();
	file_set_flag_buttons_audio_file ();

	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Label_Duree));
	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Progressbar));
	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Button_Cancel_cddb));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (wind_main, "frame185")));

	cdaudio_put_label_status_bar_cd (_DUREE_, _HIDE_, "");
	cdaudio_put_label_status_bar_cd (_TITRE_, _HIDE_, "");
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
	utils_puts_statusbar_global ("");

#ifdef HAVE_LINUX_CDROM_H
	if (Config_User.Bool_directory_by_ioctl)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_ioctl), TRUE);
	else	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia), TRUE);
#else
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (var_options.Adr_radiobutton_ioctl), FALSE);	
#endif
	
	set_computer_information ();
	logs_set_checkbutton_goto_files_import ();

	pocheevnt_init ();
	pochetimer_enable ();
	
	prgnavigator_affiche ();
	prgnavigator_entry_name_navigator_changed ();

	prgaudio_affiche (); 
	prgaudio_entry_name_audio_changed ();
	
	if (fileanalyze_linecommand_exist () == TRUE) {
/*
DEBUG
Bascule vers l'onglet Fichiers
Erreur trouvee et signalee par Guillaume:
	Les fichiers ne s'affichent pas suite un un download depuis le bureau  !!!!
	SOLUCE:
	Forcer le passage sur NOTEBOOK_DVD_AUDIO avant d'aller sur NOTEBOOK_FICHIERS
*/
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), NOTEBOOK_DVD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (lookup_widget (wind_main, "notebook_general")), NOTEBOOK_FICHIERS);
		/*fileanalyze_add_file_to_treeview (_TREEVIEW_ALL_);*/
	}
	
	/*put_display ();*/

	gtk_widget_hide (GTK_WIDGET (lookup_widget (wind_main, "button_annuler_lecture_dvd")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (wind_main, "progressbar_dvd_audio")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (wind_main, "frame_lecture_dvd")));

	options_init ();
	options_set_all_interne ();
	options_set_administrator_of_packets ();

	var_options.ColorLineCommand = COLOR_NONE;

	gtk_expander_set_expanded (GTK_EXPANDER (var_cd.Adr_Expander), Config_User.BoolEtatExpanderCd);
	filexpander_set_label_tag_change ();
	cdexpander_set_sensitive_notebook ();

	Config_User.Bool_Config_Ok = TRUE;

	/* Ready */
	dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Pret ..."));
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Pret ..."));
	utils_puts_statusbar_global (_("Pret ..."));
	split_set_flag_buttons_audio ();
	filetrash_test_trash_is_ok ();
	utils_puts_statusbar_global ("Pret  ;-)");
	showhidetreeview_set_etat_treeview (Config_User.notebook_general, Config_User.notebook_file);
	showhidetreeview_radiobutton_set_PosFieldsName ();
	PlayerExec_init ();
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_file.AdrComboboxNormalise)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd)), FALSE);
	
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "vbox_cue")), TRUE);
		
	splitshuttle_set_adr_redraw (GTK_WIDGET (lookup_widget (wind_main, "hbox_splitshuttle")));
	splitshuttle_set_TimeSongSec (3600);
	splitshuttle_set_func_begin (split_NEW_set_debut);
	splitshuttle_set_func_end (split_NEW_set_fin);
	splitshuttle_set_percent_begin (25.0);
	splitshuttle_set_percent_end (75.0);
	splitshuttle_set_func_WaitPlay (split_NEW_WaitPlay);
	splitshuttle_set_func_StopPlay (split_NEW_StopPlay);	

	gtk_main ();
	
	/* THREAD END
	*/
	gdk_threads_leave ();

	return (EXIT_SUCCESS);
}


