 /*
 * file      : play_alsa.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"

#include <pthread.h>

#include "info_song.h"
#include "split.h"
#include "alsa_audio.h"
#include "play_alsa.h"



static void PlayAlsa_thread (void *arg)
{
	gdouble	Ret;
	gdouble	TRet;
	gint	Sec;
	gdouble	cpt;
	gdouble	PercentBegin = -1.;
	
	VarAlsa.BoolThreadEnd = FALSE;
	
	VarAlsa.buffer = malloc (sizeof(char) * VarAlsa.SizeBuffer);
	
	cpt = 0.0;
	Ret = 0.0;
	TRet = 0.0;
	
	while ((Ret = fread (VarAlsa.buffer, 1, VarAlsa.SizeBuffer, VarAlsa.pFile)) > 0) {
		
		if (VarAlsa.StopPlay == TRUE) break;
		
		TRet +=  Ret;
		
		VarAlsa.Percent = (float)(TRet / (float)VarAlsa.TotalChunckSize) * 100.0;
		Sec = (int)(((float)VarAlsa.Sec * VarAlsa.Percent) / 100.0);
		
		if (VarAlsa.Percent >= VarAlsa.PercentBegin && VarAlsa.Percent <= VarAlsa.PercentEnd) {
			
			// CALCUL DU POURCENTAGE REEL DE LECTURE
			
			if (PercentBegin == -1) PercentBegin = VarAlsa.Percent;
			if (PercentBegin >= 0.0) {
				VarAlsa.PercentSel = VarAlsa.Percent - PercentBegin;
			}
			
			// printf("PercentBegin = %f\n", PercentBegin);
			// printf("VarAlsa.Percent = %f\n", VarAlsa.Percent);
			// printf("VarAlsa.PercentSel =  %f\n", VarAlsa.PercentSel);
			// printf ("%s\n", get_str_sec (Sec));
			
			AlsaAudio_write(VarAlsa.SizeBuffer);
		}
		
		cpt ++;
	}
	
	// printf ("TRet = %f    VarAlsa.TotalChunckSizeTRet  = %d\n", TRet, VarAlsa.TotalChunckSize);
	// printf("VarAlsa.Percent = %f\n", VarAlsa.Percent);
	
	VarAlsa.BoolThreadEnd = TRUE;
	pthread_exit(0);
}


static gint PlayAlsa_timeout (gpointer data)
{
	if (VarAlsa.BoolThreadEnd == TRUE) {
		
		fclose (VarAlsa.pFile);
		gtk_timeout_remove (VarAlsa.HandlerTimeout);
		split_with_mplayer (0.0);
		VarAlsa.StopPlay = FALSE;

		gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
		gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
		gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonPlay), TRUE);
	}
	else {
		split_with_mplayer (VarAlsa.PercentSel);
	}

	return (TRUE);
}


void PlayAlsa_stop (void)
{
	VarAlsa.StopPlay = TRUE;
}


void PlayAlsa_song (gchar *NameFile, gdouble PBegin, gdouble PEnd)
{
#define BLOCK_SIZE 1024
	pthread_t	nmr_tid;
	gshort		nChannels;		// 
	gint		nSampleRate;		// 44100
	gshort		nBitsPerSample;		// 8, 16, 24, ...
	gint		nBitsPerSec;
	gchar		buffer [ BLOCK_SIZE +4 ];
	gint		points;
	gint		nRead;
	gboolean	Bool = FALSE;
	gchar		pbType [ 4 ];
	size_t		len = infosong_get_size_file (NameFile);
	
	// OUVERTURE FICHIER
	
	VarAlsa.pFile = fopen (NameFile, "rb");
	if (VarAlsa.pFile == NULL) {
		printf ("\nImpossible d'ouvrir le fichier : \"%s\"\n\n", NameFile);
		return;
	}
	
	rewind (VarAlsa.pFile);				// INDICATEUR DE FLUX AU DEBUT DU FICHIER
	fseek (VarAlsa.pFile, 4, SEEK_CUR);		// Caractères 'RIFF' [52h 49h 46h 46h] identifiant le format.
	fseek (VarAlsa.pFile, 4, SEEK_CUR);		// Longueur du groupe de données au format WAV = [30h.00h.01h.00h]
	fseek (VarAlsa.pFile, 8, SEEK_CUR);		// Caractères 'WAVEfmt ' identifiant le format WAV.
	fseek (VarAlsa.pFile, 4, SEEK_CUR);		// [10.00.00.00] = 00000010h = 16 = nombre d'octets utilisés après pour définir le format.
	fseek (VarAlsa.pFile, 2, SEEK_CUR);		// [01.00] = 0001h = 1 = numéro de format du fichier (pas de compression, format PCM classique).
	fread (&nChannels, 2, 1, VarAlsa.pFile);	// Nombre de canaux
	fread (&nSampleRate, 4, 1, VarAlsa.pFile);	// Frequence d'echantillonange
	fread (&nBitsPerSec, 4, 1, VarAlsa.pFile);
	// fseek (pFile, 4, SEEK_CUR);			// [11.2B.00.00] = 00002B11h = 11025, nombres d'octets par seconde, ce qui revient au même car un
							// échantillon mesure un octet et l'on est en mono.
	fseek (VarAlsa.pFile, 2, SEEK_CUR);		// [01.00] = 0001h = 1 = Produit du nombre de canaux par le nombre d'octets par échantillon (ici 1x1=1).
	fread (&nBitsPerSample, 2, 1, VarAlsa.pFile);	// Lecture du nombre de bits par echantillon
	
	rewind (VarAlsa.pFile);								// INDICATEUR DE FLUX AU DEBUT DU FICHIER
	fread (buffer, 1, BLOCK_SIZE, VarAlsa.pFile);					// LECTURE
	for (points = 0; points < BLOCK_SIZE; points ++) {
		if (buffer [ points +0 ] == 'd' &&					// CHERCHER LE MOT data
		    buffer [ points +1 ] == 'a' &&
		    buffer [ points +2 ] == 't' &&
		    buffer [ points +3 ] == 'a') {
			rewind (VarAlsa.pFile);						// INDICATEUR DE FLUX AU DEBUT DU FICHIER
			fseek (VarAlsa.pFile, points, SEEK_CUR);			// POSITION SUR 'data'
			do {
				nRead = fread (pbType, 4, 1, VarAlsa.pFile);		// 'data' : annonce l'arrivée des données.
				nRead = fread (&VarAlsa.TotalChunckSize, 4, 1, VarAlsa.pFile);	// [00.00.01.00] = 00010000h = 65536 : taille des données.
				if (pbType[ 0 ] == 'd' &&				// CHERCHER LE MOT data
				    pbType[ 1 ] == 'a' &&
				    pbType[ 2 ] == 't' &&
				    pbType[ 3 ] == 'a') {
					Bool = TRUE;					// OK
					nRead = 0;
					break;						// EXIT DO WHILE
				}
				fseek (VarAlsa.pFile, VarAlsa.TotalChunckSize, SEEK_CUR);
			} while (nRead > 0);
			break;								// EXIT FOR
		}
	}
	
	if (Bool == FALSE) {
		fprintf(stderr, "Bad file WAVE format\n");
		fclose (VarAlsa.pFile);
		return;
	}
	
	// DUREE EN SECONDES DU FICHIER
	
	VarAlsa.Sec = (len -116) / nBitsPerSec;
	VarAlsa.PercentBegin = PBegin;
	VarAlsa.PercentEnd   = PEnd;
	
	// RECTIF PARAMETRE DE FIN
	
	Bool = AlsaAudio_open_device(
			"default",		// const char *audio_dev,		default
			nBitsPerSample,		// int p_bitsPerSample,			8, 16, 24, ...
			nChannels,		// int p_channels,			1, 2, 4, ...
			nSampleRate,		// unsigned int p_samplesPerSec		44100, ...
			&VarAlsa.SizeBuffer	// unsigned int *p_bufferSize,		Taille buffer retournee
			);
	
	if (Bool == TRUE) {
		
		VarAlsa.StopPlay = FALSE;
		VarAlsa.BoolThreadEnd = FALSE;
		pthread_create (&nmr_tid, NULL ,(void *)PlayAlsa_thread, (void *)NULL);
		VarAlsa.HandlerTimeout = gtk_timeout_add (20, PlayAlsa_timeout, 0);
	}
#undef BLOCK_SIZE
}

















