 /*
 * file      : player.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __player_h__
#define __player_h__ 1


typedef enum {
	LIST_PLAY_FROM_NONE = 0,
	LIST_PLAY_FROM_DVD,
	LIST_PLAY_FROM_CD,
	LIST_PLAY_FROM_FILE,
	LIST_PLAY_FROM_SPLIT

} LIST_PLAY_FROM;

typedef enum {
	PUSH_BUTTON_NONE = 0,
	PUSH_BUTTON_PLAY,
	PUSH_BUTTON_PAUSE,
	PUSH_BUTTON_STOP

} PUSH_BUTTON;

typedef struct {
	gchar *str;
} PLAYER_ARGS;

typedef struct {
	gdouble		 BeginPercentTempsActuel;	/* 						*/
	gdouble          PercentTempsActuel;		/* Temps actuel					*/
	guint		 GUINT_TempsTotal;		/* Temps Total					*/
	gdouble          DOUBLE_TempsTotal;		/* Temps Total					*/
	gdouble		 DOUBLE_TempsTotalSection;
	
	PUSH_BUTTON	 BoolPushButton;		/* Le type d'action/bouton			*/
	
	LIST_PLAY_FROM	 ListPlayFrom;			/* From dvd, cd, fichier			*/
	LIST_PLAY_FROM	 OLDListPlayFrom;		/* From dvd, cd, fichier			*/
	
	/*GList		*ParamPlay;*/			/* La liste avec tous les arguments ...		*/
	GList		*ArgsPlay;			/* La liste avec tous les arguments ...		*/
	PLAYER_ARGS	*PlayerArgs;			/* ... pour exec PlayerArgs			*/
	
	gboolean	 BoolThreadActivate;		/* TRUE is activate else FALSE			*/
	pthread_t	 NmrTid;			/* Numero de process du thread			*/
	gboolean	 BoolTimeoutActivate;		/* TRUE is activate else FALSE			*/
	guint		 HandlerTimeout;		/* Numero de process du timeout			*/
	gint		 SignalNumchildren;		/* Synchronisation				*/
	gint		 Tube [ 2 ];			/* Les tickets					*/
	pid_t		 CodeFork;			/* Numero de process pour mplayer		*/
	gboolean	 BoolErreurMplayer;		/* TRUE is erreur else FALSE			*/
	
	gint		 Button;			/* -1, GDK_BUTTON_PRESS, GDK_BUTTON_RELEASE	*/
	
} VAR_PLAYER;

/*
*---------------------------------------------------------------------------
* PLAYER.C
*---------------------------------------------------------------------------
*/

extern VAR_PLAYER VarPlayer;

void Player_button_stop_music_clicked (GtkButton *button);

/* PLAYER ONGLET FICHIER
*/
void Player_set_value_time (gdouble value);

/*
*---------------------------------------------------------------------------
* PLAYER._EXEC.C
*---------------------------------------------------------------------------
*/

// void     PlayerExec_sigchld (gint signum);
// int      PlayerExec_call_exec (PLAYER_ARGS *args, pid_t *p, gint p_output);
// void     PlayerExec_create_fifo (void);
void     PlayerExec_remove_fifo (void);
void     PlayerExec_set_fifo (gchar *str);
void     PlayerExec_fifo_quit (void);
void     PlayerExec_fifo_pause (void);
void     PlayerExec_fifo_get_time_pos (void);
void     PlayerExec_fifo_get_time_length (void);
void     PlayerExec_fifo_seek (gdouble value);
void     PlayerExec_fifo_seek_with_hundr (gdouble value);
// void     PlayerExec_with_mplayer (gdouble percent);
void     PlayerExec_user_to_quit (void);
void     PlayerExec_user_to_pause (void);
void     PlayerExec_user_to_seek (void);
void     PlayerExec_user_to_get_time_pos (void);
gboolean PlayerExec_is_activate (void);
gboolean PlayerExec_is_activate_from_split (void);
void     PlayerExec_set_list (LIST_PLAY_FROM ListPlayFrom, gdouble p_TempsTotalSection, guint p_TempsTotalSurface, GList *p_list);
void     PlayerExec_init (void);
void     PlayerExec_set_time_in_seconds (gdouble TimeSec);


#endif

