 /*
 * file      : poche_dir.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>

#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>
#include "support.h"
#include "global.h"
#include "info_song.h"
#include "config_user.h"
#include "win_pulse.h"

#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <pthread.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

#include "poche.h"
#include "secu.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {					/* allocation pointee par var_analize.glist_analize */
	gchar        *name;				/* Le nom complet du fichier */
	gboolean      bool_rep;				/* TRUE si inclusion de repertoire(s) */
} FILE_IMAGE;

GList *file_image = NULL;

extern int lstat(const char *file_name, struct stat *buf);

gchar   *pptrdir = NULL;
gchar   *nname = NULL;

typedef struct {
	gboolean  CancelClicked;
	gboolean  EndThread;
	gboolean  EndTimeout;
	gboolean  Action;
	gchar    *name;
	guint     timeout;
	pthread_t nmr_tid;
} POCHEDIR_EVENT;

POCHEDIR_EVENT pochedir_event;



/*
*---------------------------------------------------------------------------
* VERIFICATION ET STOCKAGE GLIST OFFICIELLE
*---------------------------------------------------------------------------
*/

gboolean pochedir_make_glist (gchar *filename)
{
	GLIST_POCHETTE *new = NULL;
	guint           num = 0;
	GLIST_POCHETTE *gl = NULL;
	GList          *list = NULL;

	/* PRINT_FUNC_LF(); */
	
	/* test si longueur == ZERO */
	if (infosong_get_size_file (filename) == 0) {
		PRINT_FUNC_LF();
		g_print ("\tTAILLE IMAGE EST ZERO\n");
		infosong_delete_file (filename);
		return (FALSE);
	}

	/* Test le type de fichier */
/*
	if (infosong_file_is (FILE_IS_IMG, filename) != FILE_IS_IMG) {
		PRINT_FUNC_LF();
		g_print ("\tNOT FILE_IS_IMG: %s\n", filename);
		infosong_delete_file (filename);
		return (FALSE);
	}
*/
	/* Test si dupplication de fichier */
	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {
			if (strcmp (gl->name_img, filename) == 0) {
				/*
				PRINT_FUNC_LF();
				g_print ("\tDUPPLICATION DE FICHIER: %s\n", filename);
				*/
				return (FALSE);
			}
		}
		list = g_list_next (list);
	}

	/* Allocation memoire */
	if ((new = (GLIST_POCHETTE *)g_malloc0 (sizeof (GLIST_POCHETTE))) == NULL) {
		PRINT_FUNC_LF();
		g_print ("\tERREUR D'ALLOCATION\n");
		return (FALSE);
	}

	new->name_img = g_strdup (filename);
	/* Numero de l'image.png */
	/*num = 1 + g_list_length (poche.glist);*/
	num = 1;
	/* Trouver un nom de fichier libre */
	while (TRUE) {
		new->name_png = g_strdup_printf ("%s/%03d.png", poche.Path_pochette_png, num);
		if (infosong_file_is_reg (new->name_png) == FALSE) break;
		num ++;
		g_free (new->name_png);
		new->name_png = NULL;
	}

	/* Construction du fichier PNG */
	pocheexec_convert_to_png (filename, new->name_png, "80x80");

	if (poche.glist == NULL) {
		/*
		poche.num_recto_actif = -1;
		poche.num_verso_actif = -1;
		*/
	}

	/* Stocke */
	poche.glist = g_list_append (poche.glist, new);

	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* CREATION ET DESTRUCTION GLIST TEMPORAIRE
*---------------------------------------------------------------------------
*/
gboolean pochedir_create_glist (gchar *filename, gboolean BoolVerifyFile)
{
	FILE_IMAGE *fi = NULL;

	/*PRINT_FUNC_LF();*/
	
	if (BoolVerifyFile == TRUE) {
/*
PRINT_FUNC_LF();
PRINT("BoolVerifyFile = TRUE");
*/
		if (infosong_file_is_reg (filename) && infosong_file_is (FILE_IS_NONE, filename) != FILE_IS_IMG) return (FALSE);
	} else {
		if (infosong_file_is (FILE_IS_NONE, filename) != FILE_IS_IMG) return (FALSE);
	}
	/*
	if (infosong_file_is_reg (filename) && infosong_file_is (FILE_IS_NONE, filename) != FILE_IS_IMG) return (FALSE);
	*/
	fi = g_malloc0 (sizeof (FILE_IMAGE));
	if (!fi) return (FALSE);

	if (BoolVerifyFile == TRUE) {
		fi->bool_rep = infosong_file_is_dir ((gchar *)filename);
	} else {
		fi->bool_rep = FALSE;
	}
	/*
	fi->bool_rep = infosong_file_is_dir ((gchar *)filename);
	*/
	fi->name =  g_strdup (filename);
	file_image = g_list_append (file_image, fi);

	return (TRUE);
}
void pochedir_remove_glist (void)
{
	FILE_IMAGE *fi = NULL;
	GList      *list = NULL;

	/*PRINT_FUNC_LF();*/

	list = g_list_first (file_image);
	while (list) {
		if ((fi = (FILE_IMAGE *)list->data)) {

			if (fi->name) {
				g_free (fi->name);
				fi->name = NULL;
			}
			g_free (fi);
			fi = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (file_image);
	file_image = NULL;
}

/*
*---------------------------------------------------------------------------
* RECHERCHE NON-RECURSIVE
*---------------------------------------------------------------------------
*/

extern char *get_current_dir_name (void);

void pochedir_recherche (gchar *path)
{
	DIR    *dp;
	struct  dirent *entry;
	struct  stat statbuf;
	
	if ((dp = opendir (path)) == NULL) {
		return;
	}
	
	chdir (path);
	/*pptrdir = g_get_current_dir ();*/
	pptrdir = get_current_dir_name ();

	while ((entry = readdir (dp)) != NULL) {
		
		if (pochedir_event.CancelClicked == TRUE) {
			g_print ("DEMANDE D ANNULATION DEPUIS: ");
			PRINT_FUNC_LF();
			break;
		}

		if (strcmp (".", entry->d_name) == 0 || strcmp ("..", entry->d_name) == 0) continue;
		lstat (entry->d_name, &statbuf);
		if (S_ISREG (statbuf.st_mode)) {
			nname = g_strdup_printf ("%s/%s", pptrdir, entry->d_name);
			
			pochedir_create_glist (nname, FALSE);
			
			g_free (nname);
			nname = NULL;
		}
	}

	g_free (pptrdir);
	pptrdir = NULL;
	chdir ("..");
	closedir (dp);
}
/* LES APPELS A LA GLIB NE SONT PAS REENTRANTS DONC PLANTAGE !
*  -----------------------------------------------------------
*/
void pochedir_recherche_non_recursive (gchar *path)
{
	FILE_IMAGE *fi = NULL;
	GList      *list = NULL;
	
	/* PRINT_FUNC_LF(); */

	/* La creation GTK n'est pas permise de puis un thread
	   ---------------------------------------------------
	winpulse_create ();
	winpulse_set_init_pulse ();
	winpulse_set_title ("Chargement des images");
	winpulse_set_labeltitle ("Chargement des images");
	*/
	pochedir_event.name = g_strdup (_("[Recherche des fichiers images]"));
	winpulse_set_labelfile (pochedir_event.name);

	pochedir_event.name = NULL;
	pochedir_event.CancelClicked = FALSE;
	
	/* Lecture des fichiers */
	pochedir_recherche (path);
	
	pochedir_event.Action = TRUE;

	list = g_list_first (file_image);
	while (list) {
		if ((fi = (FILE_IMAGE *)list->data) && fi->bool_rep == FALSE) {

			winpulse_set_labelfile (fi->name);			
			pochedir_make_glist (fi->name);
		}		
		pochedir_event.CancelClicked = winpulse_event_set_close ();
		if (pochedir_event.CancelClicked == TRUE) {
			g_print ("DEMANDE D ANNULATION DEPUIS: ");
			PRINT_FUNC_LF();
			break;
		}
		list = g_list_next (list);
	}
	/*winpulse_close ();*/
	pochedir_remove_glist ();
}

/*
*---------------------------------------------------------------------------
* RECHERCHE RECURSIVE
*---------------------------------------------------------------------------
*/

void pochedir_recherche_recursive (gchar *path)
{
	DIR    *dp;
	struct  dirent *entry;
	struct  stat statbuf;

	/* PRINT_FUNC_LF(); */

	if ((dp = opendir (path)) == NULL) {
		return;
	}
	chdir (path);
	while ((entry = readdir (dp)) != NULL) {
		if (pochedir_event.CancelClicked == TRUE) {
			g_print ("DEMANDE D ANNULATION DEPUIS: ");
			PRINT_FUNC_LF();
			break;
		}

		lstat (entry->d_name, &statbuf);
		if (S_ISDIR (statbuf.st_mode)) {
			if (strcmp (".", entry->d_name) == 0 || strcmp ("..", entry->d_name) == 0) continue;
			pochedir_recherche_recursive (entry->d_name);
		}
		else {
			pptrdir = g_get_current_dir ();
			/*
			char * get_current_dir_name (void)
			*/
			nname = g_strdup_printf ("%s/%s", pptrdir, entry->d_name);
			
			pochedir_create_glist (nname, FALSE);

			g_free (pptrdir);
			pptrdir = NULL;
			g_free (nname);
			nname = NULL;
		}
	}
	chdir ("..");
	closedir (dp);
}

static void pochedir_thread (void *arg)
{
	GList         *list = NULL;
	FILE_IMAGE    *fi = NULL;

	/* test si recherche recursif de repertoires */
	list = g_list_first (file_image);
	while (list) {
		if ((fi = (FILE_IMAGE *)list->data)) {
			if (fi->bool_rep == TRUE) {
				pochedir_recherche_recursive (fi->name);

				if (pochedir_event.CancelClicked == TRUE) {
					g_print ("DEMANDE D ANNULATION DEPUIS: ");
					PRINT_FUNC_LF();
					break;
				}
			}
		}
		list = g_list_next (list);
	}

	/* */
	list = g_list_first (file_image);
	while (list) {
		if ((fi = (FILE_IMAGE *)list->data) && fi->bool_rep == FALSE) {

			if (pochedir_event.name) {
				g_free (pochedir_event.name);
				pochedir_event.name = NULL;
			}
			pochedir_event.name = g_strdup (fi->name);
			pochedir_make_glist (fi->name);
		}

		if (pochedir_event.CancelClicked == TRUE) {
			g_print ("DEMANDE D ANNULATION DEPUIS: ");
			PRINT_FUNC_LF();
			break;
		}

		list = g_list_next (list);
	}
	pochedir_remove_glist ();
	pochedir_event.EndTimeout = TRUE;
	pochedir_event.EndThread = TRUE;

	secu_thread_sub ();
	pthread_exit(0);
}

static gint pochedir_timeout (gpointer data)
{
	if ((pochedir_event.CancelClicked = winpulse_event_set_close ())) {
	}

	if (pochedir_event.name) {
		winpulse_set_labelfile (pochedir_event.name);
		g_free (pochedir_event.name);
		pochedir_event.name = NULL;
	}
	else if (pochedir_event.EndThread == TRUE) {
		gtk_timeout_remove (pochedir_event.timeout);
		pocheevnt_table_add_images ();
		pocheevnt_set_flag_buttons_recto ();
		pocheevnt_set_flag_buttons_verso ();
		winpulse_close ();
	}
	return (TRUE);
}

void pochedir_search (void)
{
	/* PRINT_FUNC_LF(); */
	
	winpulse_create ();
	winpulse_set_init_pulse ();
	winpulse_set_title (_("Chargement des images"));
	winpulse_set_labeltitle (_("Chargement des images"));
	pochedir_event.name = g_strdup (_("[Recherche des fichiers images]"));
	winpulse_set_labelfile (pochedir_event.name);

	pochedir_event.name = NULL;
	pochedir_event.EndThread = FALSE;
	pochedir_event.EndTimeout = FALSE;
	pochedir_event.CancelClicked = FALSE;
	pochedir_event.timeout = gtk_timeout_add (40, pochedir_timeout, 0);
	secu_thread_add ();
	pthread_create (&pochedir_event.nmr_tid, NULL ,(void *)pochedir_thread, (void *)NULL);
}









