 /*
 * file      : prg_init.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"

#include <string.h>

#include "global.h"
#include "cd_audio.h"
#include "file.h"
#include "utils.h"
#include "options.h"
#include "poche.h"
#include "win_info.h"
#include "prg_init.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	NUM_TREE_Nom = 0,
	NUM_TREE_Status,
	NUM_TREE_Action,
	NUM_TREE_ALL_COLUMN
};

enum
{
	PRGEXT_NAME = 0,
	PRGEXT_STATUS,
	PRGEXT_COMMENT,
	PRGEXT_NUM_COLUMN,
	PRGEXT_TOTAL_COLUMN
};


VAR_PRGEXTERN var_prgextern;



PRGINIT PrgInit;



TABLEAU_PRG_EXTERN TableauPrgExtern [ NMR_MAX_TABLEAU ] = {

{"aacplusenc",							// PACKAGEDEBIAN_64
"aacplusenc",							// PACKAGEDEBIAN_32
"aacplusenc",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_aacplusenc,					// FOUND
"aacplusenc_0.17.3_amd64.deb",					// DEPOTDEBIAN_64
"aacplusenc_0.17.3_i386.deb",					// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"abcde",							// PACKAGEDEBIAN_64
"abcde",							// PACKAGEDEBIAN_32
"abcde",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_abcde,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"cdparanoia",							// PACKAGEDEBIAN_64
"cdparanoia",							// PACKAGEDEBIAN_32
"cdparanoia",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_cdparanoia,					// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"checkmp3",							// PACKAGEDEBIAN_64
"checkmp3",							// PACKAGEDEBIAN_32
"mp3check",							// NAME1
"checkmp3",							// NAME2
"mp3_check",							// NAME3
&PrgInit.bool_checkmp3,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"imagemagick",							// PACKAGEDEBIAN_64
"imagemagick",							// PACKAGEDEBIAN_32
"convert",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_convert,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"cuetools",							// PACKAGEDEBIAN_64
"cuetools",							// PACKAGEDEBIAN_32
"cuebreakpoints",						// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_cuetools,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"faac",							// PACKAGEDEBIAN_64
"faac",								// PACKAGEDEBIAN_32
"faac",								// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_faac,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"faad",							// PACKAGEDEBIAN_64
"faad",								// PACKAGEDEBIAN_32
"faad",								// NAME1
"faad2",							// NAME2
"",								// NAME3
&PrgInit.bool_faad,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"flac",							// PACKAGEDEBIAN_64
"flac",								// PACKAGEDEBIAN_32
"flac",								// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_flac,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"icedax",							// PACKAGEDEBIAN_64
"icedax",							// PACKAGEDEBIAN_32
"icedax",							// NAME1
"cdda2wav",							// NAME2
"",								// NAME3
&PrgInit.bool_cdda2wav,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"lame",							// PACKAGEDEBIAN_64
"lame",								// PACKAGEDEBIAN_32
"lame",								// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_lame,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"lsdvd",							// PACKAGEDEBIAN_64
"lsdvd",							// PACKAGEDEBIAN_32
"lsdvd",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_lsdvd,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mac",								// PACKAGEDEBIAN_64
"mac",								// PACKAGEDEBIAN_32
"mac",								// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_ape,						// FOUND
"mac_3.99-4_amd64.deb",						// DEPOTDEBIAN_64
"mac_3.99-4_i386.deb",						// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mpc123",							// PACKAGEDEBIAN_64
"mpc123",							// PACKAGEDEBIAN_32
"mppdec",							// NAME1
"mpc123",							// NAME2
"",								// NAME3
&PrgInit.bool_mpc123_mppdec,					// FOUND
"",								// DEPOTDEBIAN_64
"musepack-decoder_7.1.95z67-2_i386.deb",			// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mppenc",							// PACKAGEDEBIAN_64
"mppenc",							// PACKAGEDEBIAN_32
"mppenc",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_mppenc,						// FOUND
"",								// DEPOTDEBIAN_64
"mppenc_1.16-4_i386.deb",					// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mplayer",							// PACKAGEDEBIAN_64
"mplayer",							// PACKAGEDEBIAN_32
"mplayer",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_mplayer,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mp3gain",							// PACKAGEDEBIAN_64
"mp3gain",							// PACKAGEDEBIAN_32
"mp3gain",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_mp3gain,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mpg321",							// PACKAGEDEBIAN_64
"mpg321",							// PACKAGEDEBIAN_32
"mpg321",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_mpg321,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"mp3splt",							// PACKAGEDEBIAN_64
"mp3splt",							// PACKAGEDEBIAN_32
"mp3splt",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_mp3splt,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"normalize-audio",						// PACKAGEDEBIAN_64
"normalize-audio",						// PACKAGEDEBIAN_32
"normalize-audio",						// NAME1
"normalize",							// NAME2
"",								// NAME3
&PrgInit.bool_normalize,					// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"libnotify-bin",						// PACKAGEDEBIAN_64
"libnotify-bin",						// PACKAGEDEBIAN_32
"notify-send",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_notify_send,					// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"ps2pdf",							// PACKAGEDEBIAN_64
"ps2pdf",							// PACKAGEDEBIAN_32
"ps2pdf",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_ps2pdf,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"shorten",							// PACKAGEDEBIAN_64
"shorten",							// PACKAGEDEBIAN_32
"shorten",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_shorten,						// FOUND
"shorten_3.6.1-1_amd64.deb",					// DEPOTDEBIAN_64
"shorten_3.6.0-1_i386.deb",					// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"shntool",							// PACKAGEDEBIAN_64
"shntool",							// PACKAGEDEBIAN_32
"shntool",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_shntool,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"sox",								// PACKAGEDEBIAN_64
"sox",								// PACKAGEDEBIAN_32
"sox",								// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_sox,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"vorbis-tools",						// PACKAGEDEBIAN_64
"vorbis-tools",							// PACKAGEDEBIAN_32
"oggenc",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_oggenc,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"vorbisgain",							// PACKAGEDEBIAN_64
"vorbisgain",							// PACKAGEDEBIAN_32
"vorbisgain",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_vorbisgain,					// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"wavsplit",							// PACKAGEDEBIAN_64
"wavsplit",							// PACKAGEDEBIAN_32
"wavsplit",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_wavsplit,						// FOUND
"wavsplit_1.1.0-3_amd64.deb",					// DEPOTDEBIAN_64
"wavsplit_1.1.0-3_i386.deb",					// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"wavpack",							// PACKAGEDEBIAN_64
"wavpack",							// PACKAGEDEBIAN_32
"wavpack",							// NAME1
"",								// NAME2
"",								// NAME3
&PrgInit.bool_wavpack,						// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL},								// DESCRIPTION

{"w64codecs",							// PACKAGEDEBIAN_64
"w32codecs",							// PACKAGEDEBIAN_32
"w64codecs",							// NAME1
"w32codecs",							// NAME2
"",								// NAME3
&PrgInit.bool_w32codecs,					// FOUND
"",								// DEPOTDEBIAN_64
"",								// DEPOTDEBIAN_32
NULL,								// NAME TREE-VIEW
NULL,								// PIXBUF TREE-VIEW
NULL}								// DESCRIPTION

};



// LES ELEMENTS DU TREEVIEW

gchar *prginit_get_name (TYPE_PROGINIT TypeEnum)
{
	return ((gchar *)TableauPrgExtern [ TypeEnum ] . PtrName);
}
GdkPixbuf *prginit_get_pixbuf (TYPE_PROGINIT TypeEnum)
{
	return ((GdkPixbuf *)TableauPrgExtern [ TypeEnum ] . Pixbuf);
}
gchar *prginit_get_Description (TYPE_PROGINIT TypeEnum)
{
	return ((gchar *)TableauPrgExtern [ TypeEnum ] . Description);
}
gboolean prginit_elem_is_present (TYPE_PROGINIT TypeEnum)
{
	return ((gboolean)*TableauPrgExtern [ TypeEnum ] . BoolFound);
}
gboolean prginit_elem_is_ready (TYPE_PROGINIT TypeEnum)
{
	return ((gboolean)(TableauPrgExtern [ TypeEnum ] . Pixbuf == var_prgextern.Pixbuf_Selected) ? TRUE : FALSE);
}

void prginit_affiche_glist (void)
{
	gchar		*Name;
	GtkAdjustment	*Adj = NULL;
	gdouble		 AdjValue;
	GtkTreeIter	 iter;
	gint		 index;
	
	/* PRINT_FUNC_LF(); */
	
	// EFFACER LE CONTENU DU TREEVIEW
	
	gtk_list_store_clear (GTK_LIST_STORE (var_prgextern.Adr_List_Store));
	
	// AJUSTEMENT DE LA LISTE
	
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_prgextern.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_prgextern.Adr_scroll), Adj);
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
	
		gtk_list_store_append (var_prgextern.Adr_List_Store, &iter);
		
		if (prginit_elem_is_present (index) == TRUE)
			Name = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", prginit_get_name (index));
		else	Name = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", prginit_get_name (index));
		
		gtk_list_store_set (var_prgextern.Adr_List_Store, &iter,
					PRGEXT_NAME,		Name,
					PRGEXT_STATUS,		prginit_get_pixbuf (index),
					PRGEXT_COMMENT,		prginit_get_Description (index),
					PRGEXT_NUM_COLUMN,	index,	
					-1);

		g_free (Name);
		Name = NULL;
	}
}


gboolean prginit_is_selected (void)
{
	gint		 index;

	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		if (TableauPrgExtern[ index ].Pixbuf == var_prgextern.Pixbuf_Selected) return (TRUE);
	}
	
	return (FALSE);
}

gboolean prginit_set_selected (void)
{
	gint		index;
	gboolean	bool_sel = FALSE;

	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		if (TableauPrgExtern[ index ].Pixbuf == var_prgextern.Pixbuf_Coche) {
			TableauPrgExtern[ index ].Pixbuf = var_prgextern.Pixbuf_Selected;
			bool_sel = TRUE;
		}
	}
	prginit_update_glist ();
	return (bool_sel);
}

gboolean prginit_get_bool_install (void)
{
	gint		index;
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		if (TableauPrgExtern[ index ].Pixbuf == var_prgextern.Pixbuf_Selected) return (TRUE);
	}
	
	return (FALSE);
}
gboolean prginit_is_not_installed (void)
{
	gint		index;
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		if (*TableauPrgExtern[ index ].BoolFound == FALSE) return (TRUE);
	}
	
	return (FALSE);
}

void prginit_print_info (void)
{
	gint	index;
	
	PRINT_FUNC_LF();
	
	g_print ("!------------------------------\n");
	g_print ("! INSTALL      NAME\n");
	g_print ("!------------------------------\n");
	for (index = 0; index < NMR_MAX_TABLEAU; index ++)
		g_print("!  %s   %s\n", (*TableauPrgExtern [ index ] . BoolFound == TRUE) ? "Yes      " : " NO  --> ", TableauPrgExtern [ index ] . PtrName);
	g_print ("!------------------------------\n\n");
}

void prginit_var_default (void)
{
	gint	index;
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		*TableauPrgExtern [ index ] . BoolFound = FALSE;
		TableauPrgExtern [ index ] . PtrName    = NULL;
		TableauPrgExtern [ index ] . Pixbuf     = NULL;
	}
}

void prginit_scan (void)
{
	gint	index;
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		
		// INIT VAR
		
		*TableauPrgExtern [ index ] . BoolFound = FALSE;
		TableauPrgExtern [ index ] . PtrName    = NULL;
		// TableauPrgExtern [ index ] . Pixbuf     = NULL;

		// CHERCHE LE NOM APPROPRIE SUIVANT LA DISTRIBUTION UTILISEE
		
		*TableauPrgExtern [ index ] . BoolFound = utils_scan_by_which (TableauPrgExtern [ index ] . Name1, NULL);
		TableauPrgExtern [ index ] . PtrName = TableauPrgExtern [ index ] .Name1;
		
		if (*TableauPrgExtern [ index ] . BoolFound == FALSE) {
			if (*TableauPrgExtern [ index ] . Name2 != '\0') {
				if ((*TableauPrgExtern [ index ] . BoolFound = utils_scan_by_which (TableauPrgExtern [ index ] . Name2, NULL)) == TRUE) {
					TableauPrgExtern [ index ] . PtrName = TableauPrgExtern [ index ] .Name2;
				}
			}
		}

		if (*TableauPrgExtern [ index ] . BoolFound == FALSE) {
			if (*TableauPrgExtern [ index ] . Name3 != '\0') {
				if ((*TableauPrgExtern [ index ] . BoolFound = utils_scan_by_which (TableauPrgExtern [ index ] . Name3, NULL)) == TRUE) {
					TableauPrgExtern [ index ] . PtrName = TableauPrgExtern [ index ] .Name3;
				}
			}
		}
				
		// CAS: NMR_wXXcodecs
		
		if (index == NMR_wXXcodecs) {
			if (HostConf.BoolCpuIs64Bits == TRUE) {
				TableauPrgExtern [ index ] . PtrName = TableauPrgExtern [ index ] .Name1;
			} else {
				TableauPrgExtern [ index ] . PtrName = TableauPrgExtern [ index ] .Name2;
			}
		}
		
		// FIXER LE PIXBUF SI PAS EN SELECTION
		
		if (TableauPrgExtern [ index ] . Pixbuf != var_prgextern.Pixbuf_Selected) {
			if (*TableauPrgExtern [ index ] . BoolFound == TRUE)
				TableauPrgExtern [ index ] . Pixbuf = var_prgextern.Pixbuf_Ok;
			else	TableauPrgExtern [ index ] . Pixbuf = var_prgextern.Pixbuf_Coche;
		}
	}
	
	prginit_affiche_glist ();
}

gboolean prginit_get_etat (void)
{
	prginit_scan ();
	
	var_prgextern.Bool_Goto_Page_Options =
		PrgInit.bool_cdparanoia &
		PrgInit.bool_cdda2wav &
		PrgInit.bool_flac &
		PrgInit.bool_lame &
		PrgInit.bool_oggenc &
		PrgInit.bool_mpg321 &
		PrgInit.bool_ps2pdf &
		PrgInit.bool_sox &
		PrgInit.bool_normalize &
		PrgInit.bool_checkmp3 &
		PrgInit.bool_faad &
		PrgInit.bool_faac &
		PrgInit.bool_mplayer &
		PrgInit.bool_w32codecs &
		PrgInit.bool_shorten &
		PrgInit.bool_convert &
		PrgInit.bool_wavpack &
		PrgInit.bool_ape &
		PrgInit.bool_lsdvd &
		PrgInit.bool_vorbisgain &
		PrgInit.bool_mp3gain &
		PrgInit.bool_mp3splt &
		PrgInit.bool_wavsplit &
		PrgInit.bool_shntool &
		PrgInit.bool_cuetools &
		PrgInit.bool_aacplusenc;
		// PrgInit.bool_notify_send;
		// PrgInit.bool_abcde;
	
	return (var_prgextern.Bool_Goto_Page_Options);

}


/* Update du treeview
*/
void prginit_update_glist (void)
{

	if (var_prgextern.Adr_Tree_Model == NULL) return;

	prginit_scan ();
	
	prginit_affiche_glist ();
	cdaudio_affiche_glist_audio_cd ();
	file_pixbuf_update_glist_file ();
	file_set_flag_buttons_audio_file ();
	cdaudio_set_flag_buttons_audio_cd ();

	if (var_prgextern.button_selection_globale)
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_selection_globale), prginit_is_not_installed ());
	if(var_prgextern.button_goto_install)
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_goto_install), prginit_get_bool_install ());
}

/* Evenements souris pour le scrolledwindow
*/
gboolean prginit_traite_button_press_event (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	gint		    num;
	
	/* PRINT_FUNC_LF(); */

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_prgextern.Adr_Tree_Model, &iter, PRGEXT_NUM_COLUMN, &num, -1);

	if (gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), NUM_TREE_Status) == column) {
	
		/* position du curseur a l'instant du click */
		if (Pos_X < 18 || Pos_X > 30) return (FALSE);
		if (Pos_Y < 6 || Pos_Y > 18) return (FALSE);
		
		if (TableauPrgExtern[ num ].Pixbuf == var_prgextern.Pixbuf_Selected) {
			TableauPrgExtern[ num ].Pixbuf = var_prgextern.Pixbuf_Coche;
			gtk_list_store_set (var_prgextern.Adr_List_Store, &iter, PRGEXT_STATUS, var_prgextern.Pixbuf_Coche, -1);
		}
		else if (TableauPrgExtern[ num ].Pixbuf == var_prgextern.Pixbuf_Coche) {
			TableauPrgExtern[ num ].Pixbuf = var_prgextern.Pixbuf_Selected;
			gtk_list_store_set (var_prgextern.Adr_List_Store, &iter, PRGEXT_STATUS, var_prgextern.Pixbuf_Selected, -1);
		}
	}

	if (var_prgextern.button_selection_globale)
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_selection_globale), prginit_is_not_installed ());
	if(var_prgextern.button_goto_install)
		gtk_widget_set_sensitive (GTK_WIDGET (var_prgextern.button_goto_install), prginit_get_bool_install ());
	
	return (FALSE);
}

/* Creation du scrolledwindow et des evenements associes
*/
static void prginit_add_columns (GtkTreeView *treeview)
{
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	/*PRINT_FUNC_LF();*/

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) prginit_traite_button_press_event,
			 model);

	/* SIGNAL 'changed'
	*/
	var_prgextern.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	gtk_tree_selection_set_mode (var_prgextern.Adr_Line_Selected, GTK_SELECTION_BROWSE);

	/* PRGEXT_NAME
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
						     renderer,
						     /*"text", PRGEXT_NAME,*/
						     "markup", PRGEXT_NAME,
						     NULL);
	// gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
	// 			   GTK_TREE_VIEW_COLUMN_FIXED);
	// gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 130);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* PRGEXT_STATUS
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Status"),
							renderer,
							"pixbuf", PRGEXT_STATUS,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* PRGEXT_COMMENT
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Action"),
							renderer,
							/*"text", PRGEXT_COMMENT,*/
							"markup", PRGEXT_COMMENT,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 160);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
}

GdkPixbuf *prginit_init_pixbufs_file (char *NameFilePixbuf)
{
	GdkPixbuf *NewPixbuf = NULL;
	GError    *error = NULL;
	gchar     *Pathname_Pixbuf = NULL;

	/* PRINT_FUNC_LF(); */

	Pathname_Pixbuf = utils_get_pathname (NameFilePixbuf);

	/* load pixbuf
	*/
	NewPixbuf = gdk_pixbuf_new_from_file(Pathname_Pixbuf, &error);
 	if (error) {
 		GDK_PIXBUF_ERROR;
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
		g_free (Pathname_Pixbuf);
		Pathname_Pixbuf = NULL;
		return (NULL);
	}

	g_free (Pathname_Pixbuf);
	Pathname_Pixbuf = NULL;

	return (NewPixbuf);
}


void prginit_remove_comment (void)
{
	gint	index;
	
	for (index = 0; index < NMR_MAX_TABLEAU; index ++) {
		g_free (TableauPrgExtern[ index ].Description);
		TableauPrgExtern[ index ].Description = NULL;
	}
}


void prginit_init_comment (void)
{
	TableauPrgExtern[ NMR_aacplusenc ].Description 		= g_strdup (_(" AAC+ encoder"));
	TableauPrgExtern[ NMR_abcde ].Description 		= g_strdup (_(" Recherche les infos d'un cd audio"));
	TableauPrgExtern[ NMR_cdparanoia ].Description 		= g_strdup (_(" Extracteur cd audio"));
	TableauPrgExtern[ NMR_checkmp3 ].Description 		= g_strdup (_(" Cherche des renseignements sur les formats mp3"));
	TableauPrgExtern[ NMR_imagemagick_convert ].Description = g_strdup (_(" [imagemagick] Manipulation de formats d'images"));
	TableauPrgExtern[ NMR_cuetools ].Description 		= g_strdup (_(" Decoupage de fichiers sans decodage"));
	TableauPrgExtern[ NMR_faac ].Description 		= g_strdup (_(" Audio Codeur freeware"));
	TableauPrgExtern[ NMR_faad ].Description 		= g_strdup (_(" MPEG-4 AAC decodeur"));
	TableauPrgExtern[ NMR_flac ].Description 		= g_strdup (_(" Conversion wav : flac / <b><i>METAFLAC DOIT ETRE SUPERIEUR A LA VERSION: 1.1.2</i></b>"));
	TableauPrgExtern[ NMR_icedax ].Description 		= g_strdup (_(" Extracteur cd audio"));
	TableauPrgExtern[ NMR_lame ].Description 		= g_strdup (_(" Conversion wav : mp3"));
	TableauPrgExtern[ NMR_lsdvd ].Description 		= g_strdup (_(" Cherche les informations d'un dvd"));
	TableauPrgExtern[ NMR_mac ].Description 		= g_strdup (_(" Monkey's Audio"));
	TableauPrgExtern[ NMR_mpc123_mppdec ].Description 	= g_strdup (_(" MPC Decodeur"));
	TableauPrgExtern[ NMR_mppenc ].Description 		= g_strdup (_(" MPC Encodeur"));
	TableauPrgExtern[ NMR_mplayer ].Description 		= g_strdup (_(" Lecteur et extracteur"));
	TableauPrgExtern[ NMR_mp3gain ].Description 		= g_strdup (_(" Normaliseur de fichier mp3"));
	TableauPrgExtern[ NMR_mpg321 ].Description 		= g_strdup (_(" Conversion mp3 : wav"));
	TableauPrgExtern[ NMR_mp3splt ].Description 		= g_strdup (_(" Decoupage de fichiers sans decodage"));
	TableauPrgExtern[ NMR_normalize ].Description 		= g_strdup (_(" Normaliseur de fichier wav"));
	TableauPrgExtern[ NMR_libnotify_bin ].Description 	= g_strdup (_(" A program to send desktop notifications"));
	TableauPrgExtern[ NMR_ps2pdf ].Description 		= g_strdup (_(" Conversion  fichier  *.PS vers  *.PDF"));
	TableauPrgExtern[ NMR_shorten ].Description 		= g_strdup (_(" Forte compression au format wave"));
	TableauPrgExtern[ NMR_shntool ].Description		= g_strdup (_(" Decoupage de fichiers sans decodage"));
	TableauPrgExtern[ NMR_sox ].Description 		= g_strdup (_(" Transformation universelle de fichiers son"));
	TableauPrgExtern[ NMR_vorbis_tools_oggenc ].Description = g_strdup (_(" [Vorbis-tools] Conversion wav : ogg"));
	TableauPrgExtern[ NMR_vorbisgain ].Description 		= g_strdup (_(" Normaliseur de fichier ogg"));
	TableauPrgExtern[ NMR_wavsplit ].Description 		= g_strdup (_(" Decoupage de fichiers sans decodage"));
	TableauPrgExtern[ NMR_wavpack ].Description 		= g_strdup (_(" [wavpack] WAVPACK  Hybrid Lossless Audio Compressor"));
	TableauPrgExtern[ NMR_wXXcodecs	].Description 		= g_strdup (_(" Codecs video non supportes par mplayer / <b><i>PAS indispensable</i></b>"));
}

/* Initialisation du scrolledwindow
*/
void prginit_make_scrolledwindow (GtkWidget *widget)
{
	GtkTreeModel *model;
	GtkWidget    *treeview;
	GtkListStore *store;

	/* PRINT_FUNC_LF(); */

	var_prgextern.Pixbuf_Coche     = prginit_init_pixbufs_file ("coche.png");
	var_prgextern.Pixbuf_Selected  = prginit_init_pixbufs_file ("selected.png");
	var_prgextern.Pixbuf_Ok        = prginit_init_pixbufs_file ("prg-ok.png");

	var_prgextern.Adr_scroll = widget;
	var_prgextern.Adr_List_Store =
	store = gtk_list_store_new (PRGEXT_TOTAL_COLUMN,	/* Nombre total de colonnes */
				    G_TYPE_STRING,		/* Name */
				    GDK_TYPE_PIXBUF,		/* Status */
				    G_TYPE_STRING,		/* Commentaire */
				    G_TYPE_INT
				    );
	var_prgextern.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);

	/* add columns to the tree view */
	prginit_add_columns (GTK_TREE_VIEW (treeview));

	prginit_init_comment ();
	prginit_scan ();
	prginit_print_info ();

	gtk_widget_show_all (widget);
}




