 /*
 * file      : prg_navigator.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"

#include <string.h>

#include "global.h"
#include "utils.h"
#include "prg_navigator.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	NUM_TREE_Nom = 0,
	NUM_TREE_Status,
	NUM_TREE_Action,
	NUM_TREE_ALL_COLUMN
};


enum
{
	PRGNAVI_NAME = 0,
	PRGNAVI_STATUS,
	PRGNAVI_COMMENT,
	PRGNAVI_POINTER,
	PRGNAVI_TOTAL_COLUMN
};

VAR_PRGNAVI var_prgnavi;

/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

gboolean prgnavigator_is_find (gchar *name)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name_navi = NULL;
	
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name_navi, -1);
		if (strcmp (name, name_navi) == 0) return (TRUE);
		
		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
	return (FALSE);
}

void prgnavigator_all_deselect (void)
{
	gboolean     valid;
	GtkTreeIter  iter;
	
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_list_store_set (GTK_LIST_STORE (var_prgnavi.Adr_Tree_Model), &iter, PRGNAVI_STATUS, FALSE, -1);
		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
}

gchar *prgnavigator_get_name_is_actived (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name = NULL;
	gboolean      actif;
	
	/* PRINT_FUNC_LF(); */

	if (var_prgnavi.Adr_Tree_Model == NULL) return (NULL);
	
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_STATUS, &actif, -1);
		if (actif) {
			gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name, -1);
			return (name);
		}
		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
	return (NULL);
}

void prgnavigator_test_is_selected (void)
{
	GtkTreeIter   iter;
	
	if (prgnavigator_get_name_is_actived () == NULL) {
		if (gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter)) {
			gtk_list_store_set (GTK_LIST_STORE (var_prgnavi.Adr_Tree_Model), &iter, PRGNAVI_STATUS, TRUE, -1);
		}
	}
}

void prgnavigator_set_name (gchar *name, gchar *param_new_tab, gchar *comment)
{
	GtkTreeIter   iter;
	
	if (prgnavigator_is_find (name) == FALSE) {
		if (utils_scan_by_which (name, NULL)) {
			gtk_list_store_append (var_prgnavi.Adr_List_Store, &iter);
			gtk_list_store_set (var_prgnavi.Adr_List_Store, &iter,
						PRGNAVI_NAME,		name,
						PRGNAVI_STATUS,		FALSE,
						PRGNAVI_COMMENT,	comment,
						PRGNAVI_POINTER,	NULL,
						-1);
		}
	}
}

gboolean prgnavigator_activate (gchar *name)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name_navi = NULL;
	
	if (var_prgnavi.Adr_Tree_Model == NULL) return (FALSE);

	if (name == NULL || *name == '\0') {
		if (gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter)) {
			prgnavigator_all_deselect ();
			gtk_list_store_set (GTK_LIST_STORE (var_prgnavi.Adr_Tree_Model), &iter, PRGNAVI_STATUS, TRUE, -1);
			return (TRUE);
		}
	}
	
	/* all treeview */
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name_navi, -1);
		/* name existe ? */
		if (strcmp (name, name_navi) == 0) {
			prgnavigator_all_deselect ();
			gtk_list_store_set (GTK_LIST_STORE (var_prgnavi.Adr_Tree_Model), &iter, PRGNAVI_STATUS, TRUE, -1);
			return (TRUE);
		}
		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
	
	/**/
	if (gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter)) {
		prgnavigator_all_deselect ();
		gtk_list_store_set (GTK_LIST_STORE (var_prgnavi.Adr_Tree_Model), &iter, PRGNAVI_STATUS, TRUE, -1);
		return (TRUE);
	}
	
	return (FALSE);
}

void prgnavigator_test (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name = NULL;
	gboolean      actif;
	
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name, -1);
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_STATUS, &actif, -1);
		g_print ("%s = %s\n", name, actif  ? "TRUE" : "FALSE");

		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
	g_print ("NAVIGATOR ACTIVED IS: %s\n", prgnavigator_get_name_is_actived ());
}
/*
static void prgnavigator_fixed_toggled (GtkCellRendererToggle *cell, gchar *path_str, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	GtkTreeIter  iter;
	
	prgnavigator_all_deselect ();
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_list_store_set (GTK_LIST_STORE (model), &iter, PRGNAVI_STATUS, TRUE, -1);
	gtk_tree_path_free (path);
	prgnavigator_test ();
}
*/
gboolean prgnavigator_traite_button_press_event (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	gchar              *name = NULL;
	
	/* PRINT_FUNC_LF(); */

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) {
	
		gtk_entry_set_text (GTK_ENTRY (var_prgnavi.Adr_entry_name_navigator), "");
		return (FALSE);
	}

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);

	/* Vider la saisie */
	/*options_set_name_to_entry_ps ("");*/

	/*
	enum
	{
		NUM_TREE_Nom
		NUM_TREE_Status
		NUM_TREE_Action
	};
	*/	
	/*if (strcmp(column->title, "Status") == 0) {*/
	if (gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), NUM_TREE_Status) == column) {

		/* position du curseur a l'instant du click */
		if (Pos_X < 20 || Pos_X > 36) return (FALSE);
		if (Pos_Y < 4 || Pos_Y > 18) return (FALSE);

		prgnavigator_all_deselect ();
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, PRGNAVI_STATUS, TRUE, -1);
	}
	/*else if (strcmp(column->title, "Nom") == 0) {*/
	if (gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), NUM_TREE_Nom) == column) {

		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name, -1);
		gtk_entry_set_text (GTK_ENTRY (var_prgnavi.Adr_entry_name_navigator), name);
	}
	return (FALSE);
}
static void prgnavigator_add_columns (GtkTreeView *treeview)
{
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) prgnavigator_traite_button_press_event,
			 model);
			 
	/* SIGNAL 'changed'
	*/
	var_prgnavi.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	gtk_tree_selection_set_mode (var_prgnavi.Adr_Line_Selected, GTK_SELECTION_BROWSE);

	/* PRGNAVI_NAME */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
						renderer,
						"text", PRGNAVI_NAME,
						NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
						GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 110);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* PRGNAVI_STATUS */
	renderer = gtk_cell_renderer_toggle_new ();
	/*g_signal_connect (renderer, "toggled", G_CALLBACK (prgnavigator_fixed_toggled), model);*/
	gtk_cell_renderer_toggle_set_radio ((GtkCellRendererToggle *)renderer, TRUE);
	g_object_set (renderer, "xalign", 0.5, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Status"),
							renderer,
							"active", PRGNAVI_STATUS,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 60);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* PRGNAVI_COMMENT */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Action"),
							renderer,
							"text", PRGNAVI_COMMENT,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 160);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* PRGNAVI_POINTER */
}

void prgnavigator_make_scrolledwindow (GtkWidget *widget)
{
	GtkTreeModel *model;
	GtkWidget    *treeview;
	GtkListStore *store;

	/* PRINT_FUNC_LF(); */
	/*
	FALSE = 0
	TRUE = 1
	*/
	var_prgnavi.Adr_scroll = widget;
	var_prgnavi.Adr_List_Store =
	store = gtk_list_store_new (PRGNAVI_TOTAL_COLUMN,	/* Nombre total de colonnes */
				    G_TYPE_STRING,		/* Name */
				    G_TYPE_BOOLEAN,		/* Status */
				    G_TYPE_STRING,		/* Commentaire */
				    G_TYPE_POINTER		/* Pointeur sur structure */
				    );
	var_prgnavi.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);

	/* add columns to the tree view */
	prgnavigator_add_columns (GTK_TREE_VIEW (treeview));
			
	gtk_widget_show_all (widget);
}

void prgnavigator_entry_name_navigator_changed (void)
{
	gchar *Name = NULL;
	
	if (var_prgnavi.Adr_entry_name_navigator == NULL) return;
	
	/* PRINT_FUNC_LF(); */
	
	Name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prgnavi.Adr_entry_name_navigator));

	if (*Name == '\0') {
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_add_navigator")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_del_navigator")), FALSE);
	}
	else if (prgnavigator_is_find (Name)) {
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_add_navigator")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_del_navigator")), TRUE);
	}
	else {
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_add_navigator")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "button_del_navigator")), FALSE);
	}
	prgnavigator_test_is_selected ();
}

void prgnavigator_button_add_navigator_clicked (void)
{
	gchar        *name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prgnavi.Adr_entry_name_navigator));
	
	/* PRINT_FUNC_LF(); */
	
	prgnavigator_set_name (name, "", "Navigateur");
	while (gtk_events_pending()) gtk_main_iteration();
	prgnavigator_entry_name_navigator_changed ();
}

void prgnavigator_button_del_navigator_clicked (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_prgnavi.Adr_entry_name_navigator));
	gchar        *name_navi = NULL;
	
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name_navi, -1);
		if (strcmp (name, name_navi) == 0) {
			gtk_list_store_remove (var_prgnavi.Adr_List_Store, &iter);
			break;
		}
		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}
	while (gtk_events_pending()) gtk_main_iteration();
	prgnavigator_entry_name_navigator_changed ();
}

GList *prgnavigator_remove_glist_prog (GList *list)
{
	GList *new = NULL;
	gchar *ptr = NULL;

	new = g_list_first (list);
	while (new) {
		if ((ptr = (gchar*)new->data)) {
			g_free (ptr);
			ptr = NULL;
			new->data = NULL;
		}
		new = g_list_next(new);
	}
	g_list_free (list);
	list = NULL;
	return ((GList*)NULL);

}
GList *prgnavigator_get_glist_prog (GList *list)
{
	GtkTreeIter   iter;
	gboolean      valid;
	gchar        *name_navi = NULL;

	if (var_prgnavi.Adr_Tree_Model == NULL) return ((GList *)NULL);
	
	/* Tous les navigateurs */
	valid = gtk_tree_model_get_iter_first (var_prgnavi.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_prgnavi.Adr_Tree_Model, &iter, PRGNAVI_NAME, &name_navi, -1);
		list = g_list_append (list, g_strdup (name_navi));

		valid = gtk_tree_model_iter_next (var_prgnavi.Adr_Tree_Model, &iter);
	}

	return ((GList *)list);
}

void prgnavigator_affiche (void)
{
	GList *list = NULL;
	gchar *ptr = NULL;
	
	/* Affichage de la liste */
	list = g_list_first (var_prgnavi.List_navi);
	if (list == NULL) {
		prgnavigator_activate ("iceweasel");
		prgnavigator_set_name ("firefox-asher",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("firefox",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("epiphany",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("konqueror",		"",		"Navigateur");
		prgnavigator_set_name ("iceweasel",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("mozilla",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("mozilla-firefox",	"--new-tab",	"Navigateur");
		prgnavigator_set_name ("galeon",		"--new-tab",	"Navigateur");
		prgnavigator_set_name ("opera",			"--new-tab",	"Navigateur");
		/* g_print ("NAVIGATOR ACTIVED IS: %s\n\n", prgnavigator_get_name_is_actived ()); */
	}
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			prgnavigator_set_name (ptr, "", "Navigateur");
		}
		
		list = g_list_next(list);
	}
	/* Selection du navigateur */
	prgnavigator_activate (var_prgnavi.Navi_actif);
	
	/* Suppressions de la liste */
	list = g_list_first (var_prgnavi.List_navi);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			g_free (ptr);
			ptr = NULL;
			list->data = NULL;
		}
		list = g_list_next(list);
	}
	g_list_free (var_prgnavi.List_navi);
	var_prgnavi.List_navi = NULL;

	/* Suppressions navigateur actif */	
	g_free (var_prgnavi.Navi_actif);
	var_prgnavi.Navi_actif = NULL;
}










