 /*
 * file      : process.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
 
#include <gtk/gtk.h>
#include <pthread.h>
#include "support.h"
#include "info_song.h"
#include "global.h"
#include "fileselect.h"
#include "process.h"


/*
*---------------------------------------------------------------------------
* VARIABLE
*---------------------------------------------------------------------------
*/
VAR_PROCESS var_process = {
	0,	/* handler_timeout	*/
	TRUE,	/* bool_read_access	*/
	TRUE	/* bool_action_is_ready	*/
	};


/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

/*
gint process_get_nbr_process_for_xcfa (void)
{
	FILE	*fp = NULL;
#define MAX_CARS 255
	gchar	 buf   [ MAX_CARS +1 ];
	
	infosong_delete_file (XCFA_NBR_PROCESS);
	system ("ps -ef | awk '{ print $8 }' | grep xcfa | wc -l > /tmp/nbr_process_xcfa.txt");
	fp = fopen (XCFA_NBR_PROCESS, "r");
	fgets (buf, MAX_CARS, fp);
	fclose (fp);
	infosong_delete_file (XCFA_NBR_PROCESS);
#undef MAX_CARS
	return (atoi(buf));
}
*/
static gint level_timeout_do (gpointer data)
{
#define MAX_CARS 2048
	FILE	*fp = NULL;
	gchar	buf   [ MAX_CARS +1 ];
	gchar	*ptr = NULL;

	if (var_process.bool_read_access == TRUE) {
		if ((fp = fopen (XCFA_PROCESS, "r")) != NULL) {
			fgets (buf, MAX_CARS, fp);
			fclose (fp);
			
			/* IF NOT ACCESS THEN RON-RON ENDIF */
			if (var_process.bool_read_access == FALSE) sleep (1);
			if (var_process.bool_read_access == FALSE) return (TRUE);
			
			if (atoi(buf) == 1) {
				if ((fp = fopen (XCFA_PROCESS, "r")) != NULL) {
					fgets (buf, MAX_CARS, fp);
					fclose (fp);
					
					/* Test */
					if (var_process.bool_read_access == FALSE) return (TRUE);
					
					if (atoi(buf) == 1) {
						
						/* Test */
						if (var_process.bool_read_access == FALSE) return (TRUE);
						
						fp = fopen (XCFA_FILE_LOAD, "r");
						while (fgets (buf, MAX_CARS, fp) != NULL) {
							
							if  ((ptr = strchr (buf, '\n'))) *ptr = '\0';
							fileselect_set_glist_from_str (buf);
							
						}
						fclose (fp);
						infosong_delete_file (XCFA_FILE_LOAD);
						infosong_delete_file (XCFA_PROCESS);
						
						var_process.bool_action_is_ready = TRUE;
						
						fileanalyze_add_file_to_treeview_ (_TREEVIEW_ALL_, FALSE);
						
						gtk_timeout_remove (var_process.handler_timeout);
						return (TRUE);
					}
				}
			}
		}
	}
	
#undef MAX_CARS
	return (TRUE);
}


/*  See
 *    static void fileanalyze_thread_do_verif_analyze_file (void *arg)
 *    in: file_analyze.c
 */
void process_goto_timeout (void)
{
	var_process.bool_action_is_ready = FALSE;
	var_process.handler_timeout = gtk_timeout_add (10, level_timeout_do, 0);
}


gboolean process_bool_action_is_ready (void)
{
	return (var_process.bool_action_is_ready);
}

