 /*
 * file    : tags_flac.c
 * project : xcfa
 * with    : Gtk-2
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 * 2003,2004,2005,2006,2007,2008,2009 Claude Bulin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include "support.h"

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/



/*
*---------------------------------------------------------------------------
* FILE IS FLAC ?
*---------------------------------------------------------------------------
*/
gboolean tagsflac_file_is_flac (gchar *namefile)
{
	FILE        *fp = NULL;
	size_t       lenread = 0;
	gchar       *buf = NULL;
	gint         cpt;
	gboolean     bool_signature = FALSE;
	
	/*PRINT_FUNC_LF();*/

	buf = (gchar *)g_malloc0 (sizeof(gchar) * 5124);
	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (buf, 1, 5120, fp);
		fclose (fp);
	}
	
	for (cpt = 0; cpt < 5120; cpt ++) {
		if (buf [ cpt + 0 ] == 0x66 &&	/* 'f' */
		    buf [ cpt + 1 ] == 0x4c &&	/* 'L' */
		    buf [ cpt + 2 ] == 0x61 &&	/* 'a' */
		    buf [ cpt + 3 ] == 0x43) {	/* 'C' */
		    bool_signature = TRUE;
		    break;
		}
	}
	g_free (buf);
	buf = NULL;

	return (bool_signature);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/

/*
void tagsflac_get_tag (TAGS *tags, gchar *namefile)
{
	gchar     *buf = NULL;
	FILE      *fp = NULL;
	size_t     lenread = 0;
	gint       cpt;
	gint       i;
	gboolean   bool = FALSE;
	gchar     *PtrMotClef = NULL;
	gchar     *PtrDef = NULL;
	gchar     *Ptr = NULL;

	buf = (gchar *)g_malloc0 (sizeof (gchar) * (4096 + 1024));
	if (buf == NULL) {
		g_print ("BUF EST NULL\n");
		return;
	}

	fp = fopen (namefile, "r");
	lenread = fread (buf, 1, 4096, fp);
	fclose (fp);

	for (cpt = 0; cpt < 4096; cpt ++) {
		if (buf[cpt +0] == 'r' &&
		    buf[cpt +1] == 'e' &&
		    buf[cpt +2] == 'f' &&
		    buf[cpt +3] == 'e' &&
		    buf[cpt +4] == 'r' &&
		    buf[cpt +5] == 'e' &&
		    buf[cpt +6] == 'n' &&
		    buf[cpt +7] == 'c' &&
		    buf[cpt +8] == 'e' &&
		    buf[cpt +9] == ' ' &&
		    buf[cpt +10] == 'l' &&
		    buf[cpt +11] == 'i' &&
		    buf[cpt +12] == 'b' &&
		    buf[cpt +13] == 'F' &&
		    buf[cpt +14] == 'L' &&
		    buf[cpt +15] == 'A' &&
		    buf[cpt +16] == 'C') {
			bool = TRUE;
			break;
		}
	}

	if (bool == TRUE) {

		cpt += 16;

		while (cpt < 4096 ) {

			if (buf[cpt] == '=') {

				for (i = cpt; i > 0 && buf[i] != '\0'; i--);
				i++;
				buf [cpt] = '\0';

				PtrMotClef = g_strdup (&buf [i]);

				cpt ++;
				i = cpt;
				while (buf[i+1] != '\0') i ++;
				buf [i] =  '\0';

				PtrDef = g_strdup (&buf [cpt]);

				for (Ptr = PtrMotClef; *Ptr; Ptr ++)
					*Ptr = g_ascii_toupper (*Ptr);

				if (!strcmp (PtrMotClef, "TITLE")) {
					tags->Title = g_strdup (PtrDef);
				} else if (!strcmp (PtrMotClef, "ARTIST")) {
					tags->Artist = g_strdup (PtrDef);
				} else if (!strcmp (PtrMotClef, "ALBUM")) {
					tags->Album = g_strdup (PtrDef);
				} else if (!strcmp (PtrMotClef, "DATE")) {
					tags->Year = g_strdup (PtrDef);
					tags->IntYear = atoi (tags->Year);
				} else if (!strcmp (PtrMotClef, "TRACKNUMBER")) {
					tags->Number = g_strdup (PtrDef);
					tags->IntNumber = atoi (PtrDef);
				} else if (!strcmp (PtrMotClef, "GENRE")) {
					tags->Genre    = g_strdup (PtrDef);
					tags->IntGenre = infosong_get_genre_by_value (PtrDef);
				} else if (!strcmp (PtrMotClef, "DESCRIPTION")) {
					tags->Description = g_strdup (PtrDef);
					tags->Comment = g_strdup (PtrDef);
				}

				g_free (PtrMotClef);	PtrMotClef = NULL;
				g_free (PtrDef);	PtrDef = NULL;
			}

			cpt ++;
		}
	}

	g_free (buf);
	buf = NULL;

	if (!tags->Artist)	tags->Artist      = g_strdup ("");
	if (!tags->Album)	tags->Album       = g_strdup ("");
	if (!tags->Number)	tags->Number      = g_strdup ("");
	if (!tags->Genre)	tags->Genre       = g_strdup ("");
	if (!tags->Year)	tags->Year        = g_strdup ("");
	if (!tags->Comment)	tags->Comment     = g_strdup ("");
	if (!tags->Description)	tags->Description = g_strdup ("");
}
*/

INFO_FLAC *tagsflac_remove_info (INFO_FLAC *info)
{
	if (info) {
		g_free (info->namefile);
		g_free (info->time);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_FLAC *)NULL);
}

INFO_FLAC *tagsflac_get_info (DETAIL *detail, gchar *namefile)
{
	TagLib_File  *file;
	TagLib_Tag   *tag;
	INFO_FLAC    *ptrinfo = NULL;
	const TagLib_AudioProperties *properties;
	gint          seconds;
	gint          minutes;

	ptrinfo = (INFO_FLAC *)g_malloc0 (sizeof (INFO_FLAC));
	if (ptrinfo == NULL) return (NULL);
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	
	if ((file = taglib_file_new (namefile))) {
	
		taglib_set_strings_unicode(FALSE);
		tag = taglib_file_tag(file);
		properties = taglib_file_audioproperties(file);
		
		ptrinfo->tags->Title     = g_strdup (taglib_tag_title(tag));
		ptrinfo->tags->Artist    = g_strdup (taglib_tag_artist(tag));
		ptrinfo->tags->Album     = g_strdup (taglib_tag_album(tag));
		ptrinfo->tags->IntYear   = taglib_tag_year(tag);
		ptrinfo->tags->Year      = g_strdup_printf ("%d", ptrinfo->tags->IntYear);
		ptrinfo->tags->Comment   = g_strdup (taglib_tag_comment(tag));
		ptrinfo->tags->IntNumber = taglib_tag_track(tag);
		ptrinfo->tags->Number    = g_strdup_printf ("%d", ptrinfo->tags->IntNumber);
		ptrinfo->tags->Genre     = g_strdup (taglib_tag_genre(tag));
		ptrinfo->tags->IntGenre  = infosong_get_genre_by_value (ptrinfo->tags->Genre);

		ptrinfo->SecTime =  taglib_audioproperties_length(properties);

		if (detail != NULL) {
			detail->ValuePlay.SecTime = ptrinfo->SecTime;
		}

		ptrinfo->ValueMark.SecTime    = taglib_audioproperties_length(properties);
		ptrinfo->ValueMark.ValueMarkA = 0.0;
		ptrinfo->ValueMark.ValueMarkB = 100.0;
		ptrinfo->ValueMark.Value = 0.0;
		
		seconds = taglib_audioproperties_length(properties) % 60;
		minutes = (taglib_audioproperties_length(properties) - seconds) / 60;

		ptrinfo->namefile = g_strdup (namefile);
		ptrinfo->time     = g_strdup_printf ("%02d:%02d", minutes, seconds);

		/*
		printf("title   - \"%s\"\n", taglib_tag_title(tag));
		printf("artist  - \"%s\"\n", taglib_tag_artist(tag));
		printf("album   - \"%s\"\n", taglib_tag_album(tag));
		printf("year    - \"%i\"\n", taglib_tag_year(tag));
		printf("comment - \"%s\"\n", taglib_tag_comment(tag));
		printf("track   - \"%i\"\n", taglib_tag_track(tag));
		printf("genre   - \"%s\"\n", taglib_tag_genre(tag));
		printf("-- AUDIO --\n");
		printf("bitrate     - %i\n", taglib_audioproperties_bitrate(properties));
		printf("sample rate - %i\n", taglib_audioproperties_samplerate(properties));
		printf("channels    - %i\n", taglib_audioproperties_channels(properties));
		printf("length      - %i:%02i\n", minutes, seconds);
		*/
		taglib_tag_free_strings();
		taglib_file_free (file);
	}

	return (ptrinfo);
}


