 /*
 * file      : win_control.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>
#include "support.h"
#include "global.h"
#include "win_control.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {

	GtkWidget *Adr_win;
	gchar     *NameWin;

} WIN_CONTROL;

GList *glist_win_control = NULL;


/*
*---------------------------------------------------------------------------
* GESTION DES FENETRES OUVERTES DANS UNE LISTE
*---------------------------------------------------------------------------
*/

void wincontrol_print (gchar *title, WIN_CONTROL *win)
{
	/* PRINT_FUNC_LF(); */
return;
	g_print ("%s\n", title);
	if (win != NULL) {
		g_print ("\tNameWin = %s\n", win->NameWin);
		g_print ("\tAdresse = %p\n", win->Adr_win);
	}
	g_print ("\tTOTAL PILE FENETRES = %d\n", g_list_length (glist_win_control));
}

/* Supprime tous les elements de la liste ET la liste qui prendra la valeur NULL
*/
void wincontrol_remove (void)
{
	GList       *list = NULL;
	WIN_CONTROL *win = NULL;

	/* PRINT_FUNC_LF(); */

	list = g_list_first (glist_win_control);
	while (list) {
		if ((win = (WIN_CONTROL *)list->data)) {
			win->Adr_win = NULL;
			if (win->NameWin) {
				g_free (win->NameWin);
				win->NameWin = NULL;
			}
			g_free (win);
			win = NULL;
			list->data = NULL;
		}
		list = g_list_next(list);
	}
	g_list_free (glist_win_control);
	glist_win_control = NULL;
	
	wincontrol_print ("REMOVE ALL PILE", NULL);
}

/* Ajoute 'Adr_win' a la liste
*  Si 'Adr_win' n'est pas la fenetre Maitre, il est possible d'activer les
*  flags 'bool_transient' et 'bool_modal'
*/
void wincontrol_set_adr (GtkWidget *Adr_win, gchar *NameWin, gboolean bool_transient, gboolean bool_modal)
{
	WIN_CONTROL *win = NULL;
	guint        nbr = g_list_length (glist_win_control);

	/* PRINT_FUNC_LF(); */

	if (Adr_win != wind_main && (bool_transient || bool_modal) && nbr > 0) {

		win = (WIN_CONTROL *)g_list_nth_data (glist_win_control, nbr -1);

		if (bool_transient) {
			gtk_window_set_transient_for (GTK_WINDOW(Adr_win), GTK_WINDOW(win->Adr_win));
			/*g_print ("\tgtk_window_set_transient_for (\n");*/
		}
		if (bool_modal) {
			gtk_window_set_modal (GTK_WINDOW (Adr_win), TRUE);
			/*g_print ("\tgtk_window_set_modal (\n");*/
		}
	}
	win = (WIN_CONTROL *)g_malloc0 (sizeof (WIN_CONTROL));
	win->Adr_win = Adr_win;
	win->NameWin = g_strdup (NameWin);
	glist_win_control = g_list_append (glist_win_control, win);

	wincontrol_print ("EMPILE", win);
}

/* Supprime les dernier element dans la liste
*/
void wincontrol_remove_last (void)
{
	GList       *list = g_list_last (glist_win_control);
	WIN_CONTROL *win  = (WIN_CONTROL *)list->data;

	/* PRINT_FUNC_LF(); */

	wincontrol_print ("DETRUIT", win);
	
	if (win) {
		if (win->NameWin) {
			g_free (win->NameWin);
			win->NameWin = NULL;
		}
		g_free (win);
		win = NULL;
	}
	list->data = NULL;
	glist_win_control = g_list_remove_link (glist_win_control, list);

	wincontrol_print ("RESTE", win);
}

GtkWidget *wincontrol_get_last_adr (void)
{
	GList       *list = g_list_last (glist_win_control);
	WIN_CONTROL *win  = (WIN_CONTROL *)list->data;
	
	if (win) {
		return ((GtkWidget *)win->Adr_win);
	}
	return ((GtkWidget *)NULL);
}

GtkWidget *wincontrol_get_adr_with_name (gchar *p_NameWin)
{
	GList       *list = NULL;
	WIN_CONTROL *win  = NULL;
	
	/* PRINT_FUNC_LF(); */
	
	list = g_list_last (glist_win_control);
	while (list) {
		if ((win = (WIN_CONTROL *)list->data) != NULL) {
			if (strcmp (win->NameWin, p_NameWin) == 0) {
				return ((GtkWidget *)list);
			}
		}
		list = g_list_previous (list);
	}
	
	return ((GtkWidget *)NULL);
}


/* Supprime les dernier element dans la liste
*/
void wincontrol_remove_with_name (gchar *p_NameWin)
{
	GList       *list = NULL;
	WIN_CONTROL *win  = NULL;
	
	/* PRINT_FUNC_LF(); */

	wincontrol_print ("DETRUIT", win);
	
	list = g_list_last (glist_win_control);
	while (list) {
		if ((win = (WIN_CONTROL *)list->data) != NULL) {
			if (strcmp (win->NameWin, p_NameWin) == 0) {
				g_free (win->NameWin);
				win->NameWin = NULL;
				list->data = NULL;
				glist_win_control = g_list_remove_link (glist_win_control, list);
				break;
			}
		}
		list = g_list_previous (list);
	}

	wincontrol_print ("RESTE", win);
}













