 /*
 * file      : cd_paranoia.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gprintf.h>

#include <string.h>
#include <string.h>
#include <stdlib.h>

#include "utils.h"
#include "global.h"
#include "secu.h"
#include "cd_audio.h"
#include "cdtoc.h"
#include "get.h"
#include "cd_cue.h"


/*---------------------------------------------------
 * -   Original Routines for calculating disc-id   -
 * -   see "cddb.howto" for copyright              -
 *---------------------------------------------------
 * Retourne l'identifiant du cd
 *
 * cdparanoia_cddb_sum ()
 * cdparanoia_cddb_discid ()
 */
unsigned int cdparanoia_get_sum (gint n)
{
	unsigned int ret;

	ret = 0;
	while (n > 0) {
		ret += (n % 10);
		n /= 10;
	}
	return ret;
}

unsigned long cdparanoia_get_discid (void)
{
	unsigned int piste = 0;
	unsigned int t = 0;
	unsigned int n = 0;

	/*PRINT_FUNC_LF();*/
	while (piste < CdToc->TotalTracks) {
		n = n + cdparanoia_get_sum ((CdToc->TimeTrack [ piste ].SumMin * 60) + CdToc->TimeTrack[ piste ].SumSec);
		piste ++;
	}

	t = ((CdToc->TimeTrack[ CdToc->TotalTracks ].SumMin * 60) + CdToc->TimeTrack[ CdToc->TotalTracks ].SumSec) -
					((CdToc->TimeTrack[ 0 ].SumMin * 60) + CdToc->TimeTrack[ 0 ].SumSec);

	/* Copyright WSPse
	* eMail: wsp@gmx.de
	*
	* These are the routines for cdrom I/O-handling
	* Last updated: 20/11/99
	* Updated: 2000/06/24 (BSD routines by Scott Aaron Bamford)
	*          2001/01/07 (64bit-support for CDDB-ID)
	*
	* changed for 64-bit compatibilty
	* Matthias Hensler, 2001/01/07
	*/
	return ((n % 0xff) << 24 | t << 8 |CdToc->TotalTracks) & 0xffffffff;
}


gint cdparanoia_get_total_tracks (gchar *buffer)
{
	gchar  **Larrbuf = NULL;
	gint     i;
	gint     piste;
	gchar    *ptr;

	Larrbuf = g_strsplit(buffer, "\n", 0);

	for (i=0; Larrbuf[i]; i++) {
		if (strstr (Larrbuf[i], "TOTAL")) {
			i --;
			break;
		}
	}
	ptr = Larrbuf[i];
	while (*ptr == ' ') ptr ++;
	piste = atoi (ptr);
	g_strfreev(Larrbuf);
	return (piste);
}

/* Prend les infos de base, allocmem, stock et retour
 *
 * RETURN
 *    0  OK
 *    1  PROBLEME D'ALLOCATION MEMOIRE
 *    2  CD-ROM AUDIO ABSENT DU LECTEUR
 *    3  LE CD DANS LECTEUR N'EST PAS UN CD-AUDIO
 */
gint cdparanoia_read_toc (void)
{
	gchar        *Lerr = NULL;
	gchar       **Larrbuf = NULL;
	gint          i;
	gchar        *ptr = NULL;
	gint          piste;
	gint          add = 0;
	GString      *gstr = NULL;

	/*PRINT_FUNC_LF();*/

	gstr = get_with_cdparanoia (EnteteCD.NameCD_Device);
	Lerr = gstr->str;
	if (*Lerr) {

		/* gestion erreur disc */
		if (strstr (Lerr, "Unable to open")) {
			g_print ("\nCD NON AUDIO OU ABSENT DANS LE LECTEUR\n");
			/*g_free(Lout);*/
			/*g_free(Lerr);*/
			g_string_free (gstr, TRUE);
			Lerr = NULL;
			return (2);
		}

		/* alloc mem */
		CdToc = (CD_TOC *)g_malloc0 (sizeof (CD_TOC));
		if (!CdToc) {
			g_string_free (gstr, TRUE);
			Lerr = NULL;
			return (1);
		}
		/* cherche total pistes et alloc mem */
		CdToc->TotalTracks = cdparanoia_get_total_tracks (Lerr);
		CdToc->TimeTrack = (TIME_CD *)g_malloc0 (sizeof (TIME_CD) * (CdToc->TotalTracks + 5));
		if (!CdToc) {
			cdtoc_deallocate_cd_toc ();
			g_string_free (gstr, TRUE);
			Lerr = NULL;
			return (1);
		}

/*g_print ("Lerr=\n%s\n",Lerr);*/
		/*cdcue_read_toc_with_cdparanoia (Lerr, CdToc->TotalTracks);*/
		cdcue_set_base_ioctl (Lerr, CdToc->TotalTracks);

		/* decoupage du texte en lignes */
		Larrbuf = g_strsplit(Lerr, "\n", 0);

		/* debut du texte */
		for (i=0; Larrbuf[i]; i++) {
			if (strstr (Larrbuf[i], "===")) {
				i ++;
				break;
			}
		}

		for (piste = 0; Larrbuf[i]; i++, piste ++) {

			/* calcul la fin et quitte la boucle */
			if (strstr (Larrbuf[i], "TOTAL")) {
				ptr = Larrbuf[i];
				/* minutes */
				while (*ptr != '[') ptr ++;
				ptr ++;
				CdToc->TT_Min =
				CdToc->TimeTrack[ piste ].Min =
				CdToc->TimeTrack[ piste ].SumMin = atoi (ptr);
				/* secondes */
				while (*ptr != ':') ptr ++;
				ptr ++;
				CdToc->TT_Sec =
				CdToc->TimeTrack[ piste ].Sec =
				CdToc->TimeTrack[ piste ].SumSec = atoi (ptr);
				CdToc->TimeTrack[ piste ].SumSec += add;
				/* centiemmes */
				while (*ptr != '.') ptr ++;
				ptr ++;
				CdToc->TimeTrack[ piste ].Cent =
				CdToc->TimeTrack[ piste ].SumCent = atoi (ptr);
				CdToc->TimeTrack[ piste ].SumCent += CdToc->TimeTrack[ piste ].SumMin * 60 * 75;
				CdToc->TimeTrack[ piste ].SumCent += CdToc->TimeTrack[ piste ].SumSec * 75;

				/*
				g_print ("PARA: piste[%02d]  %02d:%02d.%02d   %02d:%02d.%02d\n",
					piste,
					CdToc->TimeTrack[ piste ].Min, CdToc->TimeTrack[ piste ].Sec, CdToc->TimeTrack[ piste ].Cent,
					CdToc->TimeTrack[ piste ].SumMin, CdToc->TimeTrack[ piste ].SumSec, CdToc->TimeTrack[ piste ].SumCent
					);
				*/
				break;
			}

			/* Cherche les minutes, secondes et centiemes reelles de chaque piste
			   ******************************************************************
			   track        length               begin        copy pre ch
			   ==================================================================
			   1.    24257 [05:23.32]        0 [00:00.00]    no   no  2
			   2.    10425 [02:19.00]    24257 [05:23.32]    no   no  2
			               [xx:xx.xx]
			*/
			/* minute */
			ptr = Larrbuf[i];
			while (*ptr == ' ') ptr ++;
			while (*ptr != '[') ptr ++;
			ptr ++;
			CdToc->TimeTrack[ piste ].Min = atoi (ptr);
			/* secondes */
			while (*ptr != ':') ptr ++;
			ptr ++;
			CdToc->TimeTrack[ piste ].Sec = atoi (ptr);
			/* centiemes */
			while (*ptr != '.') ptr ++;
			ptr ++;
			CdToc->TimeTrack[ piste ].Cent = atoi (ptr);

			/* Cherche le ch des piste
			   ***********************
			   track        length               begin        copy pre ch
			   ==================================================================
			   1.    24257 [05:23.32]        0 [00:00.00]    no   no  2
			   2.    10425 [02:19.00]    24257 [05:23.32]    no   no  2
			                                                         [x]
			*/
			if (add == 0) {
				ptr = strrchr (Larrbuf[i], ' ');
				ptr ++;
				add = atoi (ptr);
			}

			/* Cherche les minutes, secondes et centiemes de chaque piste
			   ***********************************************************
			   track        length               begin        copy pre ch
			   ==================================================================
			   1.    24257 [05:23.32]        0 [00:00.00]    no   no  2
			   2.    10425 [02:19.00]    24257 [05:23.32]    no   no  2
			                                   [xx:xx.xx]
			*/
			/* minute */
			ptr = strrchr (Larrbuf[i], '[');
			ptr ++;
			CdToc->TimeTrack[ piste ].SumMin = atoi (ptr);
			/* secondes */
			while (*ptr != ':') ptr ++;
			ptr ++;
			CdToc->TimeTrack[ piste ].SumSec = atoi (ptr);
			CdToc->TimeTrack[ piste ].SumSec += add;
			/* centiemes */
			while (*ptr != '.') ptr ++;
			ptr ++;
			CdToc->TimeTrack[ piste ].SumCent = atoi (ptr);
			CdToc->TimeTrack[ piste ].SumCent += CdToc->TimeTrack[ piste ].SumMin * 60 * 75;
			CdToc->TimeTrack[ piste ].SumCent += CdToc->TimeTrack[ piste ].SumSec * 75;

			/*
			g_print ("PARA: piste[%02d]  %02d:%02d.%02d   %02d:%02d.%02d\n",
					piste,
					CdToc->TimeTrack[ piste ].Min, CdToc->TimeTrack[ piste ].Sec, CdToc->TimeTrack[ piste ].Cent,
					CdToc->TimeTrack[ piste ].SumMin, CdToc->TimeTrack[ piste ].SumSec, CdToc->TimeTrack[ piste ].SumCent
					);
			*/
		}
		g_strfreev(Larrbuf);

		CdToc->Num_ID_CD = (unsigned long)cdparanoia_get_discid ();
		g_sprintf (CdToc->Str_ID_CD, "%08lx", CdToc->Num_ID_CD);
		/*
		g_print ("CdToc->Num_ID_CD = %08lx\n", CdToc->Num_ID_CD);
		g_print ("CdToc->Str_ID_CD = %s\n", CdToc->Str_ID_CD);
		*/
	}

	g_string_free (gstr, TRUE);
	Lerr = NULL;
	return (0);
}

