 /*
 * file      : dvd_audio_extract.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#include "global.h"
#include "file.h"
#include "scan_cd.h"
#include "config_user.h"
#include "fileselect.h"
#include "win_info.h"
#include "options.h"
#include "dvd_audio.h"
#include "conv.h"
#include "prg_init.h"
#include "info_song.h"
#include "logs.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {

	gboolean	bool_end_pthread;
	guint		Handler_Timeout;

	gboolean	bool_halt;
	gboolean	bool_update;

	gint		total_file;
	gint		file_active;
	gboolean	bool_mess;

	gboolean	bool_err_log;

	gboolean	BoolListIsPeakAlbum;
	gint		TTNormPeak;			/* Nombre total de Peak			*/
	gint		TTNormPeakCollectif;		/* Nombre total de Peak Collectif	*/
	
} VAR_DVDEXTRACT;

VAR_DVDEXTRACT VarDvdextract;


/*
*---------------------------------------------------------------------------
* EXTERN
*---------------------------------------------------------------------------
*/

extern int kill (pid_t pid, int sig);




/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

void dvdaudioextract_halt (void)
{
	VarDvdextract.bool_halt = TRUE;

	if (conv.code_fork_conv > -1) {
		kill (conv.code_fork_conv, SIGKILL);
		conv.code_fork_conv = -1;
	}
}

void dvdaudioextract_get_total_extraction (void)
{
	GList *list = NULL;
	gchar *ptr = NULL;

	VarDvdextract.total_file = 0;

	list = g_list_first (GlistDvdExtract);
	while (list) {

		if ((ptr = (gchar *)list->data)) {
			VarDvdextract.total_file ++;
		}
		list = g_list_next (list);
	}
}

void dvdaudioextract_linecommand (GList *p_list)
{
	GList   *list = NULL;
	GString *gstr = g_string_new (NULL);
	
	list = g_list_first (p_list);
	while (list) {
		
		g_string_append_printf (gstr, "%s ", (gchar *)list->data);
		list = g_list_next (list);
	}
	g_print ("%s\n\n", gstr->str);
	g_string_free (gstr, TRUE);
}

gchar *dvdaudioextract_get_name_in_list (GList *p_list)
{
	GList    *list = NULL;
	gchar    *ptr = NULL;
	
	list = g_list_first (p_list);
	while (list) {
		if ((ptr = (gchar *)list->data)) {
			if (strstr (ptr, "pcm:file=")) {
				
				return ((gchar *)ptr);
			}
		}
		list = g_list_next(list);
	}
	return ((gchar *)NULL);
}

void *dvdaudioextract_pthread (void *data)
{
	GList           *listOne = NULL;
	NEW_DVD_EXTRACT *StructDvdExtract = NULL;
	/*gint             value_fix;*/
	
	VarDvdextract.bool_end_pthread = FALSE;
	
	listOne = g_list_first (GlistDvdExtract);
	while (listOne) {
		if ((StructDvdExtract = (NEW_DVD_EXTRACT *)listOne->data)) {
			
			if (VarDvdextract.bool_halt == TRUE) break;

			VarDvdextract.file_active ++;
			VarDvdextract.bool_mess = TRUE;

			g_print ("****** Pathname **********************\n");
			g_print ("%s\n", StructDvdExtract->Path);
			g_print ("**************************************\n");
			g_print ("\n");
			dvdaudioextract_linecommand ((GList *)StructDvdExtract->list);
			
			conv.ArgConv = conv_alloc_arg ((GList *)StructDvdExtract->list);
			if (conv_exec (FALSE, MPLAYER_AUDIO_TO_WAV, (GList *)StructDvdExtract->list, "NEW:-> MPLAYER_AUDIO_TO_WAV") == TRUE) {
								
				VarDvdextract.bool_update = TRUE;
				StructDvdExtract->Var->EtatChoix = _COCHE_;
				/* PEAK
				*/
				if (StructDvdExtract->Var->EtatNormalise == TRUE && VarDvdextract.BoolListIsPeakAlbum == FALSE) {
				
					VarDvdextract.TTNormPeak ++;
					
					GList	*ListNorm = NULL;
					
					ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
					ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
					ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
					// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
					ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
					ListNorm = g_list_append (ListNorm, g_strdup ("--peak"));
					ListNorm = g_list_append (ListNorm, g_strdup ("--"));
					ListNorm = g_list_append (ListNorm, g_strdup_printf ("\"%s\"", StructDvdExtract->Path));

					/*NbrList = conv_g_list_length (ListNorm, &NbrList);*/
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Peak");
					ListNorm = filelc_remove_glist (ListNorm);
					
					PRINT("TRAITEMENT NORMALISE  PEAK  OK");
					
					StructDvdExtract->Var->EtatNormalise = FALSE;
					VarDvdextract.bool_update = TRUE;
				}
			}
			else {
				gchar *ptr = NULL;
				
				g_print ("\n");
				g_print ("---------------------------\n");
				g_print ("SORTIE PAR: Audio: no sound\n");
				g_print ("---------------------------\n");
				g_print ("\n");
				var_dvdaudio.bool_err = 3;
				
				if ((ptr = strrchr (dvdaudioextract_get_name_in_list ((GList *)StructDvdExtract->list), '/'))) {
					g_print ("%s\n", dvdaudioextract_get_name_in_list ((GList *)StructDvdExtract->list));
					ptr ++;
					g_print ("%s\n", ptr);
					
					logs_writeln_datas ("[Erreur extraction DVD] Audio: no sound");
					logs_writeln_datas (ptr);
					logs_writeln_datas ("---------------");
					
					VarDvdextract.bool_err_log = TRUE;
				}

			}
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			if (VarDvdextract.bool_halt == TRUE) {
				infosong_delete_file (StructDvdExtract->Path);
				g_print ("\n\nARRET PAR L'UTILISATEUR.\n\tSuppression du fichier\n\t[%s]\n", StructDvdExtract->Path);
				break;
			}
		}
		listOne = g_list_next (listOne);
	}
	
	if (VarDvdextract.BoolListIsPeakAlbum == TRUE) {
	listOne = g_list_first (GlistDvdExtract);
	while (listOne) {
		if ((StructDvdExtract = (NEW_DVD_EXTRACT *)listOne->data)) {
			
			if (VarDvdextract.bool_halt == TRUE) break;
			
			/* PEAK ALBUM
			*/
			if (StructDvdExtract->Var->EtatNormalise == TRUE) {

				VarDvdextract.TTNormPeakCollectif ++;
				if (var_dvdaudio.TTNormPeakCollectif == VarDvdextract.TTNormPeakCollectif) {
					
					GList		*ListNorm = NULL;
					GList		*List = NULL;
					NEW_DVD_EXTRACT *StructExtract = NULL;

					/* -- CHERCHER LA MOYENNE PEAK */
					
					ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
					ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
					ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
					// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
					ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
					ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
					
					/* -- AJOUTER LA LISTE DES FICHIERS  */
					
					List = g_list_first (GlistDvdExtract);
					while (List) {
						if ((StructExtract = (NEW_DVD_EXTRACT *)List->data) && StructExtract->EtatNormalise == TRUE) {
							ListNorm = g_list_append (ListNorm, g_strdup_printf ("%s", StructExtract->Path));
						}
						List = g_list_next(List);
					}
					
					/* NbrList = conv_g_list_length (ListNorm, &NbrList); */
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, NORMALISE_GET_LEVEL, ListNorm, "NORMALISE_GET_LEVEL TEST -> PEAK/GROUP");
					ListNorm = filelc_remove_glist (ListNorm);
					
					/* -- APPLIQUER LA MOYENNE PEAK-GROUP  */
					
					ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
					ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
					ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
					// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
					ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
					ListNorm = g_list_append (ListNorm, g_strdup_printf ("--gain=%fdB", conv.value_PEAK_RMS_GROUP_ARGS));
					
					/* -- AJOUTER LA LISTE DES FICHIERS   */
					
					List = g_list_first (GlistDvdExtract);
					while (List) {
						if ((StructExtract = (NEW_DVD_EXTRACT *)List->data) && StructExtract->EtatNormalise == TRUE) {
							ListNorm = g_list_append (ListNorm, g_strdup_printf ("\"%s\"", StructExtract->Path));
							StructExtract->Var->EtatNormalise = FALSE;
						}
						List = g_list_next(List);
					}
					
					/* -- NORMALISATION PEAK-GROUP    */
					
					/* NbrList = conv_g_list_length (ListNorm, &NbrList); */
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> PEAK/GROUP");
					ListNorm = filelc_remove_glist (ListNorm);
					
					PRINT("TRAITEMENT NORMALISE  PEAK_COLLECTIF  OK");
					
					VarDvdextract.bool_update = TRUE;
				}
			}
		}
		listOne = g_list_next (listOne);
	}
	}
	
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	
	close(conv.tube_conv [ 0 ]);
	VarDvdextract.bool_end_pthread = TRUE;
	pthread_exit (0);
}


static gint dvdaudioextract_Timeout_Update (gpointer data)
{
	float val;

	val = gtk_progress_get_value(GTK_PROGRESS(var_dvdaudio.Adr_progressbar_dvd));
	val = val >= 100.0 ? 0.0 : val;
	gtk_progress_set_value(GTK_PROGRESS(var_dvdaudio.Adr_progressbar_dvd), val + 0.01);

	if (VarDvdextract.bool_update) {
		VarDvdextract.bool_update = FALSE;
		dvdaudio_update ();

	}
	if (VarDvdextract.bool_end_pthread == TRUE) {

		NEW_DVD_EXTRACT *StructDvdExtract = NULL;
		GList           *listOne = NULL;
		GList           *listTwo = NULL;
		gchar           *ptr = NULL;
		
		gtk_timeout_remove (VarDvdextract.Handler_Timeout);

		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame106")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame107")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("scrolledwindow_dvd_audio")), TRUE);

		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame_lecture_dvd")));
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("button_annuler_lecture_dvd")));
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("progressbar_dvd_audio")));

		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame187")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame109")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame110")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame184")));
		
		g_print ("Suppression des structures\n");
		listOne = g_list_first (GlistDvdExtract);
		while (listOne) {
			if ((StructDvdExtract = (NEW_DVD_EXTRACT *)listOne->data)) {
				
				listTwo = g_list_first (StructDvdExtract->list);
				while (listTwo) {
					if ((ptr = (gchar *)listTwo->data)) {
						g_free (ptr);
						ptr = NULL;
						listTwo->data = NULL;
					}
					listTwo = g_list_next (listTwo);
				}
				g_free (StructDvdExtract->Path);
				StructDvdExtract->Path = NULL;
				g_list_free (StructDvdExtract->list);
				StructDvdExtract->list = NULL;
				g_free (StructDvdExtract);
				StructDvdExtract = NULL;
				listOne->data = NULL;
				
			}
			listOne = g_list_next (listOne);
		}
		g_list_free (GlistDvdExtract);
		GlistDvdExtract = NULL;

		if (VarDvdextract.bool_err_log == TRUE) {
			// logs_set_datas_system ();
			// if (logs_get_checkbutton_goto_files_import () == TRUE) {
			// 	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			// 			NOTEBOOK_LOGS);
			// 		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_logs")),
			// 				NOTEBOOK_LOGS_FILE_IMPORT);
			// }
		}
		
		if (VarDvdextract.bool_halt == TRUE) {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Arret d'extraction DVD par l'utilisateur"));
		}
		dvdaudio_set_flag_buttons_dvd ();
		conv_set_struct_not_used ();
	}
	else if (VarDvdextract.bool_mess == TRUE) {

		gchar *str = NULL;

		VarDvdextract.bool_mess = FALSE;
		str = g_strdup_printf (_("Extraction%s DVD en cours: %d / %d"),
					VarDvdextract.total_file > 1 ?_("s") : "",
					VarDvdextract.file_active,
					VarDvdextract.total_file);
		dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
		g_free (str);
		str = NULL;
	}

	return (TRUE);
}

void dvdaudioextract_dvd_to_file (void)
{
	pthread_t nmr_tid;

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame106")), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame107")), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("scrolledwindow_dvd_audio")), FALSE);

	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame187")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame109")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame110")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame184")));
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("button_annuler_lecture_dvd")));
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("progressbar_dvd_audio")));
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame_lecture_dvd")));

	conv_reset_struct ();
	conv_set_type_oper (_EXTRACT_);
	VarDvdextract.bool_halt = FALSE;
	VarDvdextract.total_file = 0;
	VarDvdextract.file_active = 0;
	VarDvdextract.bool_mess = FALSE;
	dvdaudioextract_get_total_extraction ();
	VarDvdextract.bool_mess = TRUE;
	VarDvdextract.bool_err_log = FALSE;
	VarDvdextract.TTNormPeak = 0;
	VarDvdextract.TTNormPeakCollectif = 0;
	VarDvdextract.bool_update = TRUE;
	VarDvdextract.BoolListIsPeakAlbum = dvdaudio_get_value_normalise_dvd () == 0 ? TRUE : FALSE;
	
	gtk_progress_bar_pulse (GTK_PROGRESS_BAR (var_dvdaudio.Adr_progressbar_dvd));
	gtk_progress_set_value(GTK_PROGRESS((GtkWidget*)var_dvdaudio.Adr_progressbar_dvd), 0.0);
	gtk_progress_set_activity_mode (GTK_PROGRESS((GtkWidget*)var_dvdaudio.Adr_progressbar_dvd), TRUE);
	dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Extraction des pistes. Veuillez patienter ..."));
	VarDvdextract.bool_end_pthread = FALSE;
	VarDvdextract.Handler_Timeout = gtk_timeout_add (100, dvdaudioextract_Timeout_Update, 0);

	pthread_create (&nmr_tid, NULL ,(void *)dvdaudioextract_pthread, (void *)NULL);
	/* DEBUG */
	pthread_detach (nmr_tid);
}














