 /*
 * file      : poche_timer.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>

#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <pthread.h>

#include "global.h"
#include "info_song.h"
#include "config_user.h"
#include "poche.h"
#include "secu.h"
#include "cursor.h"


/*
*---------------------------------------------------------------------------
* EXTERN
*---------------------------------------------------------------------------
*/


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/


typedef struct {
	gboolean  Enable;		/* TRUE: le timer peut etre active	*/
	gboolean  ThreadActif;		/* TRUE: le thread est actif		*/
	gboolean  TimeoutActif;		/* TRUE: le timer est actif		*/
	gboolean  TimerCount;		/* TRUE: Decompte de secondes		*/
	gint      Count;		/* Compteur				*/
	pthread_t nmr_tid;		/* Handler du thread			*/
	guint     timeout;		/* Handler du timer			*/

	gboolean  GenPostScript;	/* Generation de code			*/
	gboolean  PrintImage;		/* Affichage de l'image			*/
	gboolean  FlagsRecto;		/* Set etats flags recto		*/
	gboolean  FlagsVerso;		/* Set etats flags verso		*/
} POCHETIMER_EVENT;

#define POCHETIMER_TIMER 5

POCHETIMER_EVENT pochetimer_event = {FALSE, FALSE, FALSE, FALSE};



/*
*---------------------------------------------------------------------------
* FONCTIONS
*---------------------------------------------------------------------------
*/

static void pochetimer_thread (void *arg)
{
	if (pochetimer_event.GenPostScript == TRUE) pochegen_gen_code_postscript ();

	pochetimer_event.ThreadActif = FALSE;
	secu_thread_sub ();
	pthread_exit(0);
}

static gint pochetimer_timeout (gpointer data)
{
	if (pochetimer_event.TimerCount == TRUE) {
		pochetimer_event.Count --;
		if (pochetimer_event.Count <= 0) {
		
			cursor_set_watch ();
			pocheevnt_set_flag (FALSE);
			/* while (gtk_events_pending()) gtk_main_iteration(); */

			if (pochetimer_event.GenPostScript == TRUE) pochegen_gen_code_postscript ();
			if (pochetimer_event.PrintImage == TRUE)    pochegen_affiche_image ();
			if (pochetimer_event.FlagsRecto == TRUE)    pocheevnt_set_flag_buttons_recto ();
			if (pochetimer_event.FlagsVerso == TRUE)    pocheevnt_set_flag_buttons_verso ();
			
			pochetimer_event.TimerCount = FALSE;
			pochetimer_event.TimeoutActif = FALSE;
			pochetimer_event.GenPostScript = FALSE;
			pochetimer_event.PrintImage = FALSE;
			pochetimer_event.FlagsRecto = FALSE;
			pochetimer_event.FlagsVerso = FALSE;

			cursor_set_old ();
			pocheevnt_set_flag (TRUE);
			
			gtk_timeout_remove (pochetimer_event.timeout);
		}
	}
	else if (pochetimer_event.ThreadActif == FALSE) {

		if (pochetimer_event.PrintImage == TRUE) pochegen_affiche_image ();
		if (pochetimer_event.FlagsRecto == TRUE) pocheevnt_set_flag_buttons_recto ();
		if (pochetimer_event.FlagsVerso == TRUE) pocheevnt_set_flag_buttons_verso ();

		pochetimer_event.TimerCount = FALSE;
		pochetimer_event.TimeoutActif = FALSE;
		pochetimer_event.GenPostScript = FALSE;
		pochetimer_event.PrintImage = FALSE;
		pochetimer_event.FlagsRecto = FALSE;
		pochetimer_event.FlagsVerso = FALSE;

		pocheevnt_set_flag (TRUE);
		cursor_set_old ();
		
		gtk_timeout_remove (pochetimer_event.timeout);
	}
	return TRUE;
}

void pochetimer_action (PTIMER_ACTION TimerEnable, PTIMER_ACTION GenPostScript, PTIMER_ACTION PrintImage, PTIMER_ACTION FlagsRecto, PTIMER_ACTION FlagsVerso)
{
	// PRINT_FUNC_LF();

	if (pochetimer_event.Enable == FALSE) return;

	if (GenPostScript == PTIMER_DISABLE)	pochetimer_event.GenPostScript = FALSE;
	if (PrintImage == PTIMER_DISABLE)	pochetimer_event.PrintImage = FALSE;
	if (FlagsRecto == PTIMER_DISABLE)	pochetimer_event.FlagsRecto = FALSE;
	if (FlagsVerso == PTIMER_DISABLE)	pochetimer_event.FlagsVerso = FALSE;

	if (GenPostScript == GENPOSTSCRIPT)	pochetimer_event.GenPostScript = TRUE;
	if (PrintImage == PRINTIMAGE)		pochetimer_event.PrintImage = TRUE;
	if (FlagsRecto == FLAGSRECTO)		pochetimer_event.FlagsRecto = TRUE;
	if (FlagsVerso == FLAGSVERSO)		pochetimer_event.FlagsVerso = TRUE;

	if (TimerEnable == PTIMER_ENABLE) {
		pochetimer_event.TimerCount = TRUE;
	}
	
	if (pochetimer_event.TimerCount == TRUE) {
		
		pochetimer_event.Count = 4;
		
		if (pochetimer_event.TimeoutActif == FALSE) {
			pochetimer_event.TimeoutActif = TRUE;
			pochetimer_event.timeout = gtk_timeout_add (500, pochetimer_timeout, 0);
		}
		
	}
	else if (pochetimer_event.ThreadActif == FALSE && pochetimer_event.TimeoutActif == FALSE) {

		pochetimer_event.TimeoutActif = TRUE;
		pochetimer_event.ThreadActif = TRUE;

		cursor_set_watch ();
		pocheevnt_set_flag (FALSE);
		
		secu_thread_add ();
		pthread_create (&pochetimer_event.nmr_tid, NULL ,(void *)pochetimer_thread, (void *)NULL);
		pochetimer_event.timeout = gtk_timeout_add (500, pochetimer_timeout, 0);
	}
}

void pochetimer_enable (void)
{
	pochetimer_event.Enable = TRUE;
}
/*
void pochetimer_disable (void)
{
	pochetimer_event.Enable = FALSE;
}
void pochetimer_set_maxwait (gint maxwait)
{
	if (maxwait <= 0) maxwait = POCHETIMER_TIMER;
	else if (maxwait > POCHETIMER_TIMER) maxwait = POCHETIMER_TIMER;
	pochetimer_event.maxwait = maxwait;
}
*/











