 /*
 * file      : popup.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "global.h"
#include "poche.h"
#include "file.h"
#include "utils.h"
#include "popup.h"
#include "dvd_audio.h"
#include "prg_audio.h"



/* INTERNATIONALISATION DE DATAS DEPUIS LES STRUCTURES :
 *	http://chl.be/glmf/www.linuxmag-france.org/old/lm5/inter.html
 */
#define gettext_noop(x) (x) 

/*
*---------------------------------------------------------------------------
* POPUP POCHEEVENT
*---------------------------------------------------------------------------
*/

void on_centrer_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/*gboolean is_recto = (gboolean)user_data;*/
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	
	/*PRINT_FUNC_LF();*/
	/*g_print ("\t%s\n", is_recto ? "EST LE RECTO" : "EST LE VERSO");*/
	pocheevnt_action_popup (is_recto, 0);

}
void on_centrer_horizontal_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/*gboolean is_recto = (gboolean)user_data;*/
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	
	/*PRINT_FUNC_LF();*/
	/*g_print ("\t%s\n", is_recto ? "EST LE RECTO" : "EST LE VERSO");*/
	pocheevnt_action_popup (is_recto, 1);
}
void on_centrer_vertical_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	/*gboolean is_recto = (gboolean)user_data;*/
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	
	/*PRINT_FUNC_LF();*/
	/*g_print ("\t%s\n", is_recto ? "EST LE RECTO" : "EST LE VERSO");*/
	pocheevnt_action_popup (is_recto, 2);
}

void popup_for_pocheevent (gboolean bool_recto)
{
	GtkWidget *menu;
	GtkWidget *centrer;
	GtkWidget *centrer_horizontal;
	GtkWidget *centrer_vertical;

	/*PRINT_FUNC_LF();*/
	
	menu = gtk_menu_new ();
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);

	centrer = gtk_menu_item_new_with_mnemonic (_(" Centrer"));
	gtk_widget_show (centrer);
	gtk_container_add (GTK_CONTAINER (menu), centrer);

	centrer_horizontal = gtk_menu_item_new_with_mnemonic (_(" Centrer horizontal "));
	gtk_widget_show (centrer_horizontal);
	gtk_container_add (GTK_CONTAINER (menu), centrer_horizontal);

	centrer_vertical = gtk_menu_item_new_with_mnemonic (_(" Centrer vertical"));
	gtk_widget_show (centrer_vertical);
	gtk_container_add (GTK_CONTAINER (menu), centrer_vertical);

	g_signal_connect ((gpointer) centrer, "activate", G_CALLBACK (on_centrer_activate), GINT_TO_POINTER(bool_recto));
	g_signal_connect ((gpointer) centrer_horizontal, "activate", G_CALLBACK (on_centrer_horizontal_activate), GINT_TO_POINTER(bool_recto));
	g_signal_connect ((gpointer) centrer_vertical, "activate", G_CALLBACK (on_centrer_vertical_activate), GINT_TO_POINTER(bool_recto));

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	GLADE_HOOKUP_OBJECT (menu, centrer, "centrer");
	GLADE_HOOKUP_OBJECT (menu, centrer_horizontal, "centrer_horizontal");
	GLADE_HOOKUP_OBJECT (menu, centrer_vertical, "centrer_vertical");
	
	/* gtk_widget_show (menu); */
	  
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);
}


void on_popup_for_player (GtkMenuItem *menuitem, gpointer user_data)
{
	gchar *PName = user_data;

	// PRINT_FUNC_LF();
	PRINT("At the request of @Zarer, choosing a player from a popup");
	g_print("\tPlayer = %s\n", PName);
	
	prgaudio_activate (PName);
}
void popup_for_player (void)
{
	GtkWidget	*menu;
	GtkWidget	*widget;
	GList		*list = NULL;
	PRGAUDIO_SAVE	*PrgAudioSave = NULL;
	
	// PRINT_FUNC_LF();
	
	menu = gtk_menu_new ();
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);

	list = prgaudio_get_glist_prog (list);
	while (list) {
		if ((PrgAudioSave = (PRGAUDIO_SAVE *)list->data)) {
			widget = gtk_menu_item_new_with_mnemonic (PrgAudioSave->Name);
			gtk_widget_show (widget);
			gtk_container_add (GTK_CONTAINER (menu), widget);
			g_signal_connect ((gpointer) widget, "activate", G_CALLBACK (on_popup_for_player), PrgAudioSave->Name);
		}
		list = g_list_next(list);
	}

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	
	list = prgaudio_remove_glist_prog (list);
	
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);
}

/*
*---------------------------------------------------------------------------
* POPUP DVD
*---------------------------------------------------------------------------
*/
/*
void popup_for_action (GtkMenuItem *menuitem, gpointer user_data)
{
	gint channel = (gint)user_data;
	
	dvdaudio_set_new_channels (channel);
}

void popup_for_dvd (void)
{
	GtkWidget *menu;
	GtkWidget *ch1;
	GtkWidget *ch2;
	GtkWidget *ch3;
	
	menu = gtk_menu_new ();
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);


	ch1 = gtk_menu_item_new_with_mnemonic (_(" Original"));
	gtk_widget_show (ch1);
	gtk_container_add (GTK_CONTAINER (menu), ch1);

	ch2 = gtk_menu_item_new_with_mnemonic (_(" 2ch: stereo"));
	gtk_widget_show (ch2);
	gtk_container_add (GTK_CONTAINER (menu), ch2);

	ch3 = gtk_menu_item_new_with_mnemonic (_(" 6ch: surround 5.1"));
	gtk_widget_show (ch3);
	gtk_container_add (GTK_CONTAINER (menu), ch3);
	
	g_signal_connect ((gpointer) ch1, "activate", G_CALLBACK (popup_for_action), (gpointer)1);
	g_signal_connect ((gpointer) ch2, "activate", G_CALLBACK (popup_for_action), (gpointer)2);
	g_signal_connect ((gpointer) ch3, "activate", G_CALLBACK (popup_for_action), (gpointer)6);
	
	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	GLADE_HOOKUP_OBJECT (menu, ch1, " Original");
	GLADE_HOOKUP_OBJECT (menu, ch2, " 2ch: stereo");
	GLADE_HOOKUP_OBJECT (menu, ch3, " 6ch: surround 5.1");
	
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);
}
*/

typedef struct {
	DETAIL      *detail;
	FIC         *fic;
	AUDIO       *Audio;
	TYPE_FILE_IS type_file_is;
	
	GtkWidget   *Image_dbfs_no;
	GtkWidget   *Image_dbfs_choice;
	GtkWidget   *Image_dbfs_yes;
	GtkWidget   *GlobalImage_dbfs_no;
	GtkWidget   *GlobalImage_dbfs_choice;
	GtkWidget   *GlobalImage_dbfs_yes;
	
	GtkWidget   *Image_mix_no;
	GtkWidget   *Image_mix_choice;
	GtkWidget   *Image_mix_yes;
	GtkWidget   *GlobalImage_mix_no;
	GtkWidget   *GlobalImage_mix_choice;
	GtkWidget   *GlobalImage_mix_yes;
} VAR_POPUP;

VAR_POPUP VarPopup;

typedef struct {
	gboolean   Show;
	gint       Type;
	gint       Val;
	gint       Call;
} MENU_VAL;

typedef struct {
	GtkWidget *Widget;
	gchar     *Title;
	MENU_VAL   Op;
} POP_MENU;

/*
-----------------------------
Désélection globale
Désélection verticale
Désélection horizontale
-----------------------
Sélection verticale
Sélection horizontale
-----------------------
Sélection EXPERT verticale
EXPERT de sélection horizontale
----------------------------- 
*/

#define CASE_POP_MENU_FICHERS 0
#define MAX_POP_MENU_FICHERS 9
POP_MENU PopMenuFichiers [ MAX_POP_MENU_FICHERS ] = {
/*
 Widget    Title                                         Show   Type Val Call
*/
{NULL, gettext_noop("   Deselection globale"),			{TRUE,   0,   0,  CASE_POP_MENU_FICHERS}},
{NULL, gettext_noop("   Deselection verticale"),		{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +1}},
{NULL, gettext_noop("   Deselection horizontale"),		{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +2}},
{NULL, gettext_noop("   ---"),					{FALSE, -1,   0, -1}},
{NULL, gettext_noop("   Selection verticale"),			{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +3}},
{NULL, gettext_noop("   Selection Expert verticale"),		{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +4}},
{NULL, gettext_noop("   ---"),					{FALSE ,-1,   0, -1}},
{NULL, gettext_noop("   Selection horizontale"),		{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +5}},
{NULL, gettext_noop("   Selection Expert horizontale  "),	{TRUE,   0,   0,  CASE_POP_MENU_FICHERS +6}}
};

#define CASE_POP_MENU_CD 10
#define MAX_POP_MENU_CD 9
POP_MENU PopMenuCD [ MAX_POP_MENU_CD ] = {
/*
 Widget    Title                                	 Show   Type Val Call
*/
{NULL, gettext_noop("   Deselection globale"),			{TRUE,    0,   0, CASE_POP_MENU_CD}},
{NULL, gettext_noop("   Deselection verticale"),		{TRUE,    0,   0, CASE_POP_MENU_CD +1}},
{NULL, gettext_noop("   Deselection horizontale"),		{TRUE,    0,   0, CASE_POP_MENU_CD +2}},
{NULL, gettext_noop("   ---"),					{FALSE,  -1,   0, -1}},
{NULL, gettext_noop("   Selection verticale"),			{TRUE,    0,   0, CASE_POP_MENU_CD +3}},
{NULL, gettext_noop("   Selection Expert verticale"),		{TRUE,    0,   0, CASE_POP_MENU_CD +4}},
{NULL, gettext_noop("   ---"),					{FALSE,  -1,   0, -1}},
{NULL, gettext_noop("   Selection horizontale"),		{TRUE,    0,   0, CASE_POP_MENU_CD +5}},
{NULL, gettext_noop("   Selection Expert horizontale  "),	{TRUE,    0,   0, CASE_POP_MENU_CD +6}}
};

#define CASE_POP_MENU_NORMALISE_CD 200
#define MAX_POP_MENU_NORMALISE_CD 3
POP_MENU PopMenuNormaliseCD [ MAX_POP_MENU_NORMALISE_CD ] = {
/*
 Widget    Title                               	         Show   Type Val Call
*/
{NULL, gettext_noop("   Deselection verticale    "),		{TRUE,    0,   0, CASE_POP_MENU_NORMALISE_CD +0}},
{NULL, gettext_noop("   ---"),					{FALSE,  -1,   0, -1}},
{NULL, gettext_noop("   Selection verticale  "),		{TRUE,    0,   0, CASE_POP_MENU_NORMALISE_CD +1}}
};



#define CASE_POP_MENU_NORMALISE_DVD 300
#define MAX_POP_MENU_NORMALISE_DVD 3
POP_MENU PopMenuNormaliseDVD [ MAX_POP_MENU_NORMALISE_DVD ] = {
/*
 Widget    Title                                         Show   Type Val Call
*/
{NULL, gettext_noop("   Deselection verticale    "),		{TRUE,    0,   0, CASE_POP_MENU_NORMALISE_DVD +0}},
{NULL, gettext_noop("   ---"),					{FALSE,  -1,   0, -1}},
{NULL, gettext_noop("   Selection verticale  "),		{TRUE,    0,   0, CASE_POP_MENU_NORMALISE_DVD +1}}
};



/*#define NEWMAX_POP_MENU_NORMALISATION 90

#define INDI_CHOIX_NORMALISATION_RMS		402
#define INDI_CHOIX_NORMALISATION_RMS_GROUPE	422
#define INDI_NORMALISATION_SCAN			439
#define INDI_NORMALISATION_PEAK			440
#define INDI_NORMALISATION_PEAK_GROUPE		441
#define INDI_NORMALISATION_RMS			442
#define INDI_NORMALISATION_RMS_GROUPE		443
#define INDI_NORMALISATION_DESELECT		444
#define GLOBAL_CHOIX_NORMALISATION_RMS		447
#define GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE	467
#define GLOBAL_NORMALISATION_SCAN		484
#define GLOBAL_NORMALISATION_PEAK		485
#define GLOBAL_NORMALISATION_PEAK_GROUPE	486
#define GLOBAL_NORMALISATION_RMS		487
#define GLOBAL_NORMALISATION_RMS_GROUPE		488
#define GLOBAL_NORMALISATION_DESELECT		489

POP_MENU NEWPopMenuNormalisation [ NEWMAX_POP_MENU_NORMALISATION ] = {

{NULL, "---SELECTION INDIVIDUEL---------------",	{FALSE,   -2,   0, -1}},
{NULL, "   Choix niveau de RMS",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS   ",				{TRUE,    -4,  -6, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  7 dBFS",					{TRUE,    -4,  -7, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  8 dBFS",					{TRUE,    -4,  -8, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  9 dBFS",					{TRUE,    -4,  -9, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 10 dBFS",					{TRUE,    -4, -10, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 11 dBFS",					{TRUE,    -4, -11, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 12 dBFS",					{TRUE,    -4, -12, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 13 dBFS",					{TRUE,    -4, -13, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 14 dBFS",					{TRUE,    -4, -14, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 15 dBFS",					{TRUE,    -4, -15, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 16 dBFS",					{TRUE,    -4, -16, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 17 dBFS",					{TRUE,    -4, -17, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 18 dBFS",					{TRUE,    -4, -18, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 19 dBFS",					{TRUE,    -4, -19, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 20 dBFS",					{TRUE,    -4, -20, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 21 dBFS",					{TRUE,    -4, -21, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 22 dBFS",					{TRUE,    -4, -22, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 23 dBFS",					{TRUE,    -4, -23, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 24 dBFS",					{TRUE,    -4, -24, INDI_CHOIX_NORMALISATION_RMS}},
{NULL, "   Choix niveau de RMS/GROUPE",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS",					{TRUE,    -5,  -6, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  7 dBFS",					{TRUE,    -5,  -7, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  8 dBFS",					{TRUE,    -5,  -8, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  9 dBFS",					{TRUE,    -5,  -9, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 10 dBFS",					{TRUE,    -5, -10, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 11 dBFS",					{TRUE,    -5, -11, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 12 dBFS",					{TRUE,    -5, -12, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 13 dBFS",					{TRUE,    -5, -13, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 14 dBFS",					{TRUE,    -5, -14, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 15 dBFS",					{TRUE,    -5, -15, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 16 dBFS",					{TRUE,    -5, -16, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 17 dBFS",					{TRUE,    -5, -17, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 18 dBFS",					{TRUE,    -5, -18, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 19 dBFS",					{TRUE,    -5, -19, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 20 dBFS",					{TRUE,    -5, -20, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 21 dBFS",					{TRUE,    -5, -21, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 22 dBFS",					{TRUE,    -5, -22, INDI_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   Scan",					{TRUE,     0,   0, INDI_NORMALISATION_SCAN}},
{NULL, "   PEAK",					{TRUE,     0,   0, INDI_NORMALISATION_PEAK}},
{NULL, "   PEAK/GROUPE",				{TRUE,     0,   0, INDI_NORMALISATION_PEAK_GROUPE}},
{NULL, "   RMS",					{TRUE,     0,   0, INDI_NORMALISATION_RMS}},
{NULL, "   RMS/GROUPE",					{TRUE,     0,   0, INDI_NORMALISATION_RMS_GROUPE}},
{NULL, "   Deselection",				{TRUE,     0,   0, INDI_NORMALISATION_DESELECT}},

{NULL, "---SELECTION GLOBALE------------------",	{FALSE,   -2,   0, -1}},
{NULL, "   Choix niveau de RMS",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS   ",				{TRUE,    -6,  -6, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  7 dBFS",					{TRUE,    -6,  -7, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  8 dBFS",					{TRUE,    -6,  -8, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   -  9 dBFS",					{TRUE,    -6,  -9, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 10 dBFS",					{TRUE,    -6, -10, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 11 dBFS",					{TRUE,    -6, -11, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 12 dBFS",					{TRUE,    -6, -12, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 13 dBFS",					{TRUE,    -6, -13, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 14 dBFS",					{TRUE,    -6, -14, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 15 dBFS",					{TRUE,    -6, -15, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 16 dBFS",					{TRUE,    -6, -16, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 17 dBFS",					{TRUE,    -6, -17, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 18 dBFS",					{TRUE,    -6, -18, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 19 dBFS",					{TRUE,    -6, -19, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 20 dBFS",					{TRUE,    -6, -20, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 21 dBFS",					{TRUE,    -6, -21, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 22 dBFS",					{TRUE,    -6, -22, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 23 dBFS",					{TRUE,    -6, -23, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   - 24 dBFS",					{TRUE,    -6, -24, GLOBAL_CHOIX_NORMALISATION_RMS}},
{NULL, "   Choix niveau de RMS/GROUPE",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS",					{TRUE,    -7,  -6, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  7 dBFS",					{TRUE,    -7,  -7, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  8 dBFS",					{TRUE,    -7,  -8, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  9 dBFS",					{TRUE,    -7,  -9, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 10 dBFS",					{TRUE,    -7, -10, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 11 dBFS",					{TRUE,    -7, -11, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 12 dBFS",					{TRUE,    -7, -12, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 13 dBFS",					{TRUE,    -7, -13, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 14 dBFS",					{TRUE,    -7, -14, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 15 dBFS",					{TRUE,    -7, -15, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 16 dBFS",					{TRUE,    -7, -16, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 17 dBFS",					{TRUE,    -7, -17, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 18 dBFS",					{TRUE,    -7, -18, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 19 dBFS",					{TRUE,    -7, -19, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 20 dBFS",					{TRUE,    -7, -20, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 21 dBFS",					{TRUE,    -7, -21, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 22 dBFS",					{TRUE,    -7, -22, GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE}},
{NULL, "   Scan",					{TRUE,     0,   0, GLOBAL_NORMALISATION_SCAN}},
{NULL, "   PEAK",					{TRUE,     0,   0, GLOBAL_NORMALISATION_PEAK}},
{NULL, "   PEAK/GROUPE",				{TRUE,     0,   0, GLOBAL_NORMALISATION_PEAK_GROUPE}},
{NULL, "   RMS",					{TRUE,     0,   0, GLOBAL_NORMALISATION_RMS}},
{NULL, "   RMS/GROUPE",					{TRUE,     0,   0, GLOBAL_NORMALISATION_RMS_GROUPE}},
{NULL, "   Deselection",				{TRUE,     0,   0, GLOBAL_NORMALISATION_DESELECT}}
};
*/

/*
#define CASE_POP_MENU_NORMALISATION_RMS 20
#define CASE_POP_MENU_NORMALISATION_RMS_GROUPE 21
#define CASE_POP_MENU_NORMALISATION 22
#define MAX_POP_MENU_NORMALISATION 45
POP_MENU PopMenuNormalisation [ MAX_POP_MENU_NORMALISATION ] = {
{NULL, "   Choix niveau de RMS",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS   ",				{TRUE,    -4,  -6, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   -  7 dBFS",					{TRUE,    -4,  -7, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   -  8 dBFS",					{TRUE,    -4,  -8, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   -  9 dBFS",					{TRUE,    -4,  -9, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 10 dBFS",					{TRUE,    -4, -10, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 11 dBFS",					{TRUE,    -4, -11, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 12 dBFS",					{TRUE,    -4, -12, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 13 dBFS",					{TRUE,    -4, -13, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 14 dBFS",					{TRUE,    -4, -14, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 15 dBFS",					{TRUE,    -4, -15, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 16 dBFS",					{TRUE,    -4, -16, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 17 dBFS",					{TRUE,    -4, -17, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 18 dBFS",					{TRUE,    -4, -18, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 19 dBFS",					{TRUE,    -4, -19, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 20 dBFS",					{TRUE,    -4, -20, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 21 dBFS",					{TRUE,    -4, -21, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 22 dBFS",					{TRUE,    -4, -22, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 23 dBFS",					{TRUE,    -4, -23, CASE_POP_MENU_NORMALISATION_RMS}},
{NULL, "   - 24 dBFS",					{TRUE,    -4, -24, CASE_POP_MENU_NORMALISATION_RMS}},

{NULL, "   Choix niveau de RMS/GROUPE",			{TRUE,    -3,   0, -1}},
{NULL, "   -  6 dBFS",					{TRUE,    -5,  -6, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  7 dBFS",					{TRUE,    -5,  -7, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  8 dBFS",					{TRUE,    -5,  -8, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   -  9 dBFS",					{TRUE,    -5,  -9, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 10 dBFS",					{TRUE,    -5, -10, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 11 dBFS",					{TRUE,    -5, -11, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 12 dBFS",					{TRUE,    -5, -12, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 13 dBFS",					{TRUE,    -5, -13, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 14 dBFS",					{TRUE,    -5, -14, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 15 dBFS",					{TRUE,    -5, -15, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 16 dBFS",					{TRUE,    -5, -16, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 17 dBFS",					{TRUE,    -5, -17, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 18 dBFS",					{TRUE,    -5, -18, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 19 dBFS",					{TRUE,    -5, -19, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 20 dBFS",					{TRUE,    -5, -20, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 21 dBFS",					{TRUE,    -5, -21, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},
{NULL, "   - 22 dBFS",					{TRUE,    -5, -22, CASE_POP_MENU_NORMALISATION_RMS_GROUPE}},

{NULL, "---SELECTION VERTICALE----------------",	{FALSE,   -2,   0, -1}},
{NULL, "   RMS",					{TRUE,     0,   0, CASE_POP_MENU_NORMALISATION}},
{NULL, "   PEAK",					{TRUE,     0,   0, CASE_POP_MENU_NORMALISATION +1}},
{NULL, "   RMS/GROUPE",					{TRUE,     0,   0, CASE_POP_MENU_NORMALISATION +2}},
{NULL, "   PEAK/GROUPE",				{TRUE,     0,   0, CASE_POP_MENU_NORMALISATION +3}},

{NULL, "   ---",					{FALSE,   -1,   0, -1}},
{NULL, "   Deselection verticale",			{TRUE,     0,   0, CASE_POP_MENU_NORMALISATION +4}}
};
*/

#define CASE_POP_MENU_REPLAYGAIN 30
#define MAX_POP_MENU_REPLAYGAIN 6
POP_MENU PopMenuReplayGain[ MAX_POP_MENU_REPLAYGAIN ] = {
/*
 Widget    Title                         Type Val Call
*/
{NULL, gettext_noop("---SELECTION VERTICALE-----"),		{FALSE,    -2,   0, -1}},
{NULL, gettext_noop("   Deselection verticale   "),		{TRUE,      0,   0, CASE_POP_MENU_REPLAYGAIN +0}},
{NULL, gettext_noop("   ---"),					{FALSE,    -1,   0, -1}},
{NULL, gettext_noop("   Selection PISTE         "),		{TRUE,      0,   0, CASE_POP_MENU_REPLAYGAIN +1}},
{NULL, gettext_noop("   Selection ALBUM         "),		{TRUE,      0,   0, CASE_POP_MENU_REPLAYGAIN +2}},
{NULL, gettext_noop("   Selection NETTOYER      "),		{TRUE,      0,   0, CASE_POP_MENU_REPLAYGAIN +3}}
};

#define CASE_POP_MENU_TRASH 40
#define MAX_POP_MENU_TRASH 3
POP_MENU PopMenuTrash[ MAX_POP_MENU_TRASH ] = {
/*
 Widget    Title                         Type Val Call
*/
{NULL, gettext_noop("---MENU TRASH--------------"),		{FALSE,    -2,   0, -1}},
{NULL, gettext_noop("   Deselection verticale"),		{TRUE,      0,   0, CASE_POP_MENU_TRASH}},
{NULL, gettext_noop("   Selection verticale   "),		{TRUE,      0,   0, CASE_POP_MENU_TRASH +1}}
};


#define CASE_POP_MENU_FREQUENCE_CELL_HERTZ 50
#define CASE_POP_MENU_FREQUENCE_COL_HERTZ 60
#define MAX_POP_MENU_FREQUENCE 22
POP_MENU PopMenuFrequence[ MAX_POP_MENU_FREQUENCE ] = {
/*
 Widget    Title                         Type Val Call
*/
{NULL, gettext_noop("   Cellule"),				{TRUE,     -3,       0, -1}},
{NULL, gettext_noop("    8000  Hertz   "),			{TRUE,    -10,    8000, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   22000  Hertz   "),			{TRUE,    -10,   22000, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   32000  Hertz   "),			{TRUE,    -10,   32000, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   44056  Hertz   "),			{TRUE,    -10,   44056, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   44100  Hertz   "),			{TRUE,    -10,   44100, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   48000  Hertz   "),			{TRUE,    -10,   48000, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   88200  Hertz   "),			{TRUE,    -10,   88200, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   96000  Hertz   "),			{TRUE,    -10,   96000, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,       0, -1}},
{NULL, gettext_noop("   Valeur d'origine   "),			{TRUE,    -10,      -1, CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},

{NULL, gettext_noop("   Colonne"),				{TRUE,     -3,       0, -1}},
{NULL, gettext_noop("    8000  Hertz   "),			{TRUE,    -10,    8000, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   22000  Hertz   "),			{TRUE,    -10,   22000, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   32000  Hertz   "),			{TRUE,    -10,   32000, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   44056  Hertz   "),			{TRUE,    -10,   44056, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   44100  Hertz   "),			{TRUE,    -10,   44100, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   48000  Hertz   "),			{TRUE,    -10,   48000, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   88200  Hertz   "),			{TRUE,    -10,   88200, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   96000  Hertz   "),			{TRUE,    -10,   96000, CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,       0, -1}},
{NULL,gettext_noop( "   Valeur d'origine   "),			{TRUE,    -10,      -1, CASE_POP_MENU_FREQUENCE_COL_HERTZ}}


};

#define CASE_POP_MENU_PISTE_CELL 70
#define CASE_POP_MENU_PISTE_COL 80
#define MAX_POP_MENU_PISTE 14
POP_MENU PopMenuPiste[ MAX_POP_MENU_PISTE ] = {
/*
 Widget    Title                         Type Val Call
*/
{NULL, gettext_noop("   Cellule"),				{TRUE,     -3,   0, -1}},
{NULL, gettext_noop("   1  piste"),				{TRUE,    -10,   1, CASE_POP_MENU_PISTE_CELL}},
{NULL, gettext_noop("   2  pistes"),				{TRUE,    -10,   2, CASE_POP_MENU_PISTE_CELL}},
{NULL, gettext_noop("   4  pistes"),				{TRUE,    -10,   4, CASE_POP_MENU_PISTE_CELL}},
{NULL, gettext_noop("   6  pistes"),				{TRUE,    -10,   6, CASE_POP_MENU_PISTE_CELL}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,   0, -1}},
{NULL, gettext_noop("   Valeur d'origine   "),			{TRUE,    -10,  -1, CASE_POP_MENU_PISTE_CELL}},

{NULL, gettext_noop("   Colonne"),				{TRUE,     -3,   0, -1}},
{NULL, gettext_noop("   1  piste"),				{TRUE,    -10,   1, CASE_POP_MENU_PISTE_COL}},
{NULL, gettext_noop("   2  pistes"),				{TRUE,    -10,   2, CASE_POP_MENU_PISTE_COL}},
{NULL, gettext_noop("   4  pistes"),				{TRUE,    -10,   4, CASE_POP_MENU_PISTE_COL}},
{NULL, gettext_noop("   6  pistes"),				{TRUE,    -10,   6, CASE_POP_MENU_PISTE_COL}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,   0, -1}},
{NULL, gettext_noop("   Valeur d'origine   "),			{TRUE,    -10,  -1, CASE_POP_MENU_PISTE_COL }}

};

#define CASE_POP_MENU_QUANTIFICATION_CELL 90
#define CASE_POP_MENU_QUANTIFICATION_COL 100
#define MAX_POP_MENU_QUANTIFICATION 16
POP_MENU PopMenuQuantification[ MAX_POP_MENU_QUANTIFICATION ] = {
/*
 Widget    Title                         Type Val Call
*/
{NULL, gettext_noop("   Cellule"),				{TRUE,     -3,    0, -1}},
{NULL, gettext_noop("    8  bits"),				{TRUE,    -10,    8, CASE_POP_MENU_QUANTIFICATION_CELL}},
{NULL, gettext_noop("   16  bits"),				{TRUE,    -10,   16, CASE_POP_MENU_QUANTIFICATION_CELL}},
{NULL, gettext_noop("   24  bits"),				{TRUE,    -10,   24, CASE_POP_MENU_QUANTIFICATION_CELL}},
{NULL, gettext_noop("   32  bits"),				{TRUE,    -10,   32, CASE_POP_MENU_QUANTIFICATION_CELL}},
{NULL, gettext_noop("   64  bits"),				{TRUE,    -10,   64, CASE_POP_MENU_QUANTIFICATION_CELL}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,    0, -1}},
{NULL, gettext_noop("   Valeur d'origine   "),			{TRUE,    -10,   -1, CASE_POP_MENU_QUANTIFICATION_CELL}},

{NULL, gettext_noop("   Colonne"),				{TRUE,     -3,    0, -1}},
{NULL, gettext_noop("    8  bits"),				{TRUE,    -10,    8, CASE_POP_MENU_QUANTIFICATION_COL}},
{NULL, gettext_noop("   16  bits"),				{TRUE,    -10,   16, CASE_POP_MENU_QUANTIFICATION_COL}},
{NULL, gettext_noop("   24  bits"),				{TRUE,    -10,   24, CASE_POP_MENU_QUANTIFICATION_COL}},
{NULL, gettext_noop("   32  bits"),				{TRUE,    -10,   32, CASE_POP_MENU_QUANTIFICATION_COL}},
{NULL, gettext_noop("   64  bits"),				{TRUE,    -10,   64, CASE_POP_MENU_QUANTIFICATION_COL}},
{NULL, gettext_noop("   --------------------"),			{FALSE,   -10,    0, -1}},
{NULL, gettext_noop("   Valeur d'origine   "),			{TRUE,    -10,   -1, CASE_POP_MENU_QUANTIFICATION_COL}}

};





GtkWidget *popup_init_pixbufs_file (char *NameFilePixbuf)
{
	GdkPixbuf  *NewPixbuf = NULL;
	GError     *error = NULL;
	gchar      *Pathname_Pixbuf = NULL;
	GtkWidget  *Image = NULL;
	
	Pathname_Pixbuf = utils_get_pathname (NameFilePixbuf);
	NewPixbuf = gdk_pixbuf_new_from_file(Pathname_Pixbuf, &error);
 	if (error) {
 		GDK_PIXBUF_ERROR;
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
		g_free (Pathname_Pixbuf);
		Pathname_Pixbuf = NULL;
		return (NULL);
	}
	g_free (Pathname_Pixbuf);
	Pathname_Pixbuf = NULL;
	Image = gtk_image_new_from_pixbuf (NewPixbuf);
	return (Image);
}

void popup_init_pixbufs (void)
{
	/* ATTENTION
		La meme image ne peut etre assignee dans des popups differents sous
		peine de plantage
	*/
	/* */
	VarPopup.Image_dbfs_no     = popup_init_pixbufs_file ("dbfs-no.png");
	VarPopup.Image_dbfs_choice = popup_init_pixbufs_file ("dbfs-choice.png");
	VarPopup.Image_dbfs_yes    = popup_init_pixbufs_file ("dbfs-yes.png");
	/* */
	VarPopup.GlobalImage_dbfs_no     = popup_init_pixbufs_file ("global-dbfs-no.png");
	VarPopup.GlobalImage_dbfs_choice = popup_init_pixbufs_file ("global-dbfs-choice.png");
	VarPopup.GlobalImage_dbfs_yes    = popup_init_pixbufs_file ("global-dbfs-yes.png");
	/* */
	VarPopup.Image_mix_no     = popup_init_pixbufs_file ("mix-no.png");
	VarPopup.Image_mix_choice = popup_init_pixbufs_file ("mix-choice.png");
	VarPopup.Image_mix_yes    = popup_init_pixbufs_file ("mix-yes.png");
	/* */
	VarPopup.GlobalImage_mix_no     = popup_init_pixbufs_file ("global-mix-no.png");
	VarPopup.GlobalImage_mix_choice = popup_init_pixbufs_file ("global-mix-choice.png");
	VarPopup.GlobalImage_mix_yes    = popup_init_pixbufs_file ("global-mix-yes.png");
}

void popup_callback_file (GtkMenuItem *menuitem, gpointer user_data)
{
	MENU_VAL *Op = (MENU_VAL *)user_data;
	
	/*
	PRINT_FUNC_LF();
	g_print ("Op->Type=%d, Op->Val=%d, Op->Call=%d\n", Op->Type, Op->Val, Op->Call);
	*/
	switch (Op->Call) {
	
	/* PopMenuFichiers
	*/
	case CASE_POP_MENU_FICHERS :
		file_all_deselect ();
		break;
	case CASE_POP_MENU_FICHERS +1 :
		file_select_or_deselect_verticaly (VarPopup.type_file_is, ETAT_PRG_NONE);
		break;
	case CASE_POP_MENU_FICHERS +2 :
		file_select_or_deselect_horizontal (VarPopup.detail, ETAT_PRG_NONE);
		break;
	case CASE_POP_MENU_FICHERS +3 :
		file_select_or_deselect_verticaly (VarPopup.type_file_is, ETAT_SELECT);
		break;
	case CASE_POP_MENU_FICHERS +4 :
		file_select_or_deselect_verticaly (VarPopup.type_file_is, ETAT_SELECT_EXPERT);
		break;
	case CASE_POP_MENU_FICHERS +5 :
		file_select_or_deselect_horizontal (VarPopup.detail, ETAT_SELECT);
		break;
	case CASE_POP_MENU_FICHERS +6 :
		file_select_or_deselect_horizontal (VarPopup.detail, ETAT_SELECT_EXPERT);
		break;
	
	/* PopMenuCD
	*/
	case CASE_POP_MENU_CD +0 :
		cdaudio_deselect_all_flags_extract ();
		break;
	case CASE_POP_MENU_CD +1 :
		cdaudio_de_select_verticaly_all_flags_extract (FALSE, FALSE, VarPopup.type_file_is);
		break;
	case CASE_POP_MENU_CD +2 :
		cdaudio_de_select_horizontaly_all_flags_extract (VarPopup.Audio, FALSE, FALSE);
		break;
	case CASE_POP_MENU_CD +3 :
		cdaudio_de_select_verticaly_all_flags_extract (TRUE, FALSE, VarPopup.type_file_is);
		break;
	case CASE_POP_MENU_CD +4 :
		cdaudio_de_select_verticaly_all_flags_extract (TRUE, TRUE, VarPopup.type_file_is);
		break;
	case CASE_POP_MENU_CD +5 :
		cdaudio_de_select_horizontaly_all_flags_extract (VarPopup.Audio, TRUE, FALSE);
		break;
	case CASE_POP_MENU_CD +6 :
		cdaudio_de_select_horizontaly_all_flags_extract (VarPopup.Audio, TRUE, TRUE);
		break;
	

	/* PopUp menu normalise CD
	*/
	case CASE_POP_MENU_NORMALISE_CD +0:
		cdaudio_change_all_flags_normalise_verticaly (FALSE);
		break;
	case CASE_POP_MENU_NORMALISE_CD +1:
		cdaudio_change_all_flags_normalise_verticaly (TRUE);
		break;


	/* PopUp menu normalise DVD
	*/
	case CASE_POP_MENU_NORMALISE_DVD +0:
		dvdaudio_set_flag_normalise (FALSE);
		break;
	case CASE_POP_MENU_NORMALISE_DVD +1:
		dvdaudio_set_flag_normalise (TRUE);
		break;

	
	/* NOUVEAU PopMenuNormalisation
	*/
	/*
	case INDI_CHOIX_NORMALISATION_RMS :
		VarPopup.fic->BoolNewString = TRUE;
		file_set_new_value_dbfs (Op->Val, FALSE);
		break;
	case INDI_CHOIX_NORMALISATION_RMS_GROUPE :
		VarPopup.fic->BoolNewString = TRUE;
		file_set_new_value_dbfs_mix (Op->Val, FALSE);
		break;
	case INDI_NORMALISATION_SCAN :
		VarPopup.fic->Etat_Scan = ETAT_SCAN_DEMANDE;
		FileScanDB_action (FALSE);
		break;
	case INDI_NORMALISATION_PEAK :
		break;
	case INDI_NORMALISATION_PEAK_GROUPE :
		break;
	case INDI_NORMALISATION_RMS :
		break;
	case INDI_NORMALISATION_RMS_GROUPE :
		break;
	case INDI_NORMALISATION_DESELECT :
		break;
	case GLOBAL_CHOIX_NORMALISATION_RMS :
		file_set_new_value_dbfs (Op->Val, TRUE);
		break;
	case GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE :
		file_set_new_value_dbfs_mix (Op->Val, TRUE);
		break;
	case GLOBAL_NORMALISATION_SCAN :
		FileScanDB_action (TRUE);
		break;
	case GLOBAL_NORMALISATION_PEAK :
		break;
	case GLOBAL_NORMALISATION_PEAK_GROUPE :
		break;
	case GLOBAL_NORMALISATION_RMS :
		break;
	case GLOBAL_NORMALISATION_RMS_GROUPE :
		break;
	case GLOBAL_NORMALISATION_DESELECT :
		break;
	*/
	
	/* PopMenuNormalisation
	*/
	/*
	case CASE_POP_MENU_NORMALISATION_RMS :
		VarPopup.fic->BoolNewString = TRUE;
		file_set_new_value_dbfs (Op->Val, FALSE);
		break;
	case CASE_POP_MENU_NORMALISATION_RMS_GROUPE :
		VarPopup.fic->BoolNewString = TRUE;
		file_set_new_value_dbfs_mix (Op->Val, FALSE);
		break;
	case CASE_POP_MENU_NORMALISATION :
		file_select_or_deselect_vertical_normalise (NORM_RMS_FIX);
		break;
	case CASE_POP_MENU_NORMALISATION +1 :
		file_select_or_deselect_vertical_normalise (NORM_PEAK);
		break;
	case CASE_POP_MENU_NORMALISATION +2 :
		file_select_or_deselect_vertical_normalise (NORM_RMS_MIX_ALBUM);
		break;
	case CASE_POP_MENU_NORMALISATION +3 :
		file_select_or_deselect_vertical_normalise (NORM_PEAK_ALBUM);
		break;
	case CASE_POP_MENU_NORMALISATION +4 :
		file_select_or_deselect_vertical_normalise (NORM_RMS_FIX);
		break;
	*/
	
	/* PopMenuReplayGain
	*/
	case CASE_POP_MENU_REPLAYGAIN +0 :
		/* g_print ("MENU REPLAYGAIN: Deselection verticale\n"); */
		file_select_or_deselect_vertical_replaygain (RPG_ATTENTE);
		break;
	case CASE_POP_MENU_REPLAYGAIN +1 :
		/* g_print ("MENU REPLAYGAIN: Selection PISTE\n"); */
		/* Vertical
		ETAT_REPLAYGAIN
			RPG_NONE
			RPG_ATTENTE
			RPG_PISTE
			RPG_ALBUM
			RPG_EFFACER
		 */
		file_select_or_deselect_vertical_replaygain (RPG_PISTE);
		break;
	case CASE_POP_MENU_REPLAYGAIN +2 :
		/* g_print ("MENU REPLAYGAIN: Selection ALBUM\n"); */
		file_select_or_deselect_vertical_replaygain (RPG_ALBUM);
		break;
	case CASE_POP_MENU_REPLAYGAIN +3 :
		/* g_print ("MENU REPLAYGAIN: Selection NETTOYER\n"); */
		file_select_or_deselect_vertical_replaygain (RPG_EFFACER);
		break;
	
	/* PopMenuTrash
	*/
	case CASE_POP_MENU_TRASH :
		file_select_or_deselect_vertical_trash (FALSE);
		break;
	case CASE_POP_MENU_TRASH +1 :
		file_select_or_deselect_vertical_trash (TRUE);
		break;
	
	/* PopMenuFrequence	
	*/
/*
typedef enum {
	_CEIL_
	_COLUMN_
	_DEFAULT_CEIL_
	_DEFAULT_COLUMN_
} TYPE_CEIL_WAV;
*/
	case CASE_POP_MENU_FREQUENCE_CELL_HERTZ :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_CEIL_, 1, -1, -1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_CEIL_, Op->Val, -1, -1);
		}
		break;

	case CASE_POP_MENU_FREQUENCE_COL_HERTZ :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_COLUMN_, 1, -1, -1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_COLUMN_, Op->Val, -1, -1);
		}
		break;
	
	/* PopMenuPiste
	*/
	case CASE_POP_MENU_PISTE_CELL :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_CEIL_, -1, 1, -1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_CEIL_, -1, Op->Val, -1);
		}
		break;
	
	case CASE_POP_MENU_PISTE_COL :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_COLUMN_, -1, 1, -1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_COLUMN_, -1, Op->Val, -1);
		}
		break;
	
	
	/* PopMenuQuantification
	*/
	case CASE_POP_MENU_QUANTIFICATION_CELL :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_CEIL_, -1, -1, 1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_CEIL_, -1, -1, Op->Val);
		}
		break;
	
	case CASE_POP_MENU_QUANTIFICATION_COL :
		if (Op->Val == -1) {
			file_convert_set_change_parameters_is_selected (_DEFAULT_COLUMN_, -1, -1, 1);
		}
		else {
			file_convert_set_change_parameters_is_selected (_COLUMN_, -1, -1, Op->Val);
		}
		break;
	
	}
}

void popup_make_popup (POP_MENU *p_popup, gint nbr_op)
{
	GtkWidget *menu = NULL;
	GtkWidget *Attach = NULL;
	GtkWidget *SubMenu = NULL;
	gint       cpt = 0;
	gint       val = -10;
	
	popup_init_pixbufs ();
	
	if (VarPopup.detail != NULL) {
		if (VarPopup.detail->type_infosong_file_is == FILE_IS_WAV) {
			INFO_WAV *info = (INFO_WAV *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if (VarPopup.detail->type_infosong_file_is == FILE_IS_OGG) {
			INFO_OGG *info = (INFO_OGG *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if (VarPopup.detail->type_infosong_file_is == FILE_IS_MP3) {
			INFO_MP3 *info = (INFO_MP3 *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
	}
	
	menu = gtk_menu_new ();	
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);

	for (cpt = 0; cpt < nbr_op; cpt ++) {
		if (p_popup[ cpt ].Op.Type > -1) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -1) {
			p_popup[ cpt ].Widget = gtk_separator_menu_item_new ();
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -2) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -3) {
			Attach = p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
			
			SubMenu = gtk_menu_new ();
			gtk_menu_item_set_submenu (GTK_MENU_ITEM (p_popup[ cpt ].Widget), SubMenu);
		}
		else if (p_popup[ cpt ].Op.Type == -4) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (VarPopup.Image_dbfs_yes);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_dbfs_yes);
			}
			else if (p_popup[ cpt ].Op.Val == -24) {
				gtk_widget_show (VarPopup.Image_dbfs_no);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_dbfs_no);
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (VarPopup.Image_dbfs_choice);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_dbfs_choice);
			}
		}
		else if (p_popup[ cpt ].Op.Type == -5) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (VarPopup.Image_dbfs_yes);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_mix_yes);
			}
			else if (p_popup[ cpt ].Op.Val == -22) {
				gtk_widget_show (VarPopup.Image_dbfs_no);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_mix_no);
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (VarPopup.Image_dbfs_choice);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.Image_mix_choice);
			}
		}
		
		else if (p_popup[ cpt ].Op.Type == -6) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_yes);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_dbfs_yes);
			}
			else if (p_popup[ cpt ].Op.Val == -24) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_no);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_dbfs_no);
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_choice);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_dbfs_choice);
			}
		}
		
		else if (p_popup[ cpt ].Op.Type == -7) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_yes);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_mix_yes);
			}
			else if (p_popup[ cpt ].Op.Val == -22) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_no);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_mix_no);
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (VarPopup.GlobalImage_dbfs_choice);
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), VarPopup.GlobalImage_mix_choice);
			}
		}
		
		else if (p_popup[ cpt ].Op.Type == -10) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
		}
		
		gtk_widget_set_sensitive (p_popup[ cpt ].Widget, p_popup[ cpt ].Op.Show);
	}

	for (cpt = 0; cpt < nbr_op; cpt ++) {
		g_signal_connect ((gpointer) p_popup[ cpt ].Widget, "activate",
					G_CALLBACK (popup_callback_file),
					(gpointer)&p_popup[ cpt ].Op);
	}

	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	for (cpt = 0; cpt < nbr_op; cpt ++) {
		GLADE_HOOKUP_OBJECT (menu, p_popup[ cpt ].Widget, p_popup[ cpt ].Title);
	}

	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);	
}

/*
void popup_file_Normalisation (DETAIL *detail, gboolean BoolAllIsNormalised, gboolean BoolIsSelected)
{
	VarPopup.detail = detail;
	VarPopup.fic = (FIC *)detail->fic;
	
	NEWPopMenuNormalisation[ INDI_CHOIX_NORMALISATION_RMS -401 ].Op.Show          = VarPopup.fic->Etat_Scan && VarPopup.fic->Etat_Normalise == NORM_RMS_FIX;
	NEWPopMenuNormalisation[ INDI_CHOIX_NORMALISATION_RMS_GROUPE -401 ].Op.Show   = VarPopup.fic->Etat_Scan && VarPopup.fic->Etat_Normalise == NORM_RMS_MIX_ALBUM;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_SCAN -400 ].Op.Show               = VarPopup.fic->Etat_Scan ? FALSE : TRUE;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_PEAK -400 ].Op.Show               = TRUE;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_PEAK_GROUPE -400 ].Op.Show        = TRUE;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_RMS -400 ].Op.Show                = VarPopup.fic->Etat_Scan;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_RMS_GROUPE -400 ].Op.Show         = VarPopup.fic->Etat_Scan;
	NEWPopMenuNormalisation[ INDI_NORMALISATION_DESELECT -400 ].Op.Show           = VarPopup.fic->Etat_Normalise != NORM_NONE;
	
	NEWPopMenuNormalisation[ GLOBAL_CHOIX_NORMALISATION_RMS -401 ].Op.Show        = BoolAllIsNormalised && VarPopup.fic->Etat_Normalise == NORM_RMS_FIX;
	NEWPopMenuNormalisation[ GLOBAL_CHOIX_NORMALISATION_RMS_GROUPE -401 ].Op.Show = BoolAllIsNormalised && VarPopup.fic->Etat_Normalise == NORM_RMS_MIX_ALBUM;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_SCAN -400 ].Op.Show             = BoolAllIsNormalised ? FALSE : TRUE;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_PEAK -400 ].Op.Show             = TRUE;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_PEAK_GROUPE -400 ].Op.Show      = TRUE;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_RMS -400 ].Op.Show              = BoolAllIsNormalised;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_RMS_GROUPE -400 ].Op.Show       = BoolAllIsNormalised;
	NEWPopMenuNormalisation[ GLOBAL_NORMALISATION_DESELECT -400 ].Op.Show         = BoolIsSelected;
	
	popup_make_popup (NEWPopMenuNormalisation, NEWMAX_POP_MENU_NORMALISATION);
}
*/

void popup_cd (AUDIO *Audio, TYPE_FILE_IS TypeFileIs)
{
	VarPopup.detail       = (DETAIL *)NULL;
	VarPopup.fic          = (FIC *)NULL;
	VarPopup.type_file_is = TypeFileIs;
	VarPopup.Audio        = Audio;
	popup_make_popup (PopMenuCD, MAX_POP_MENU_CD);
}
void popup_normalise_cd (void)
{
	/*PRINT_FUNC_LF();*/
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;
	popup_make_popup (PopMenuNormaliseCD, MAX_POP_MENU_NORMALISE_CD);
}
void popup_normalise_dvd (void)
{
	/*PRINT_FUNC_LF();*/
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;
	popup_make_popup (PopMenuNormaliseDVD, MAX_POP_MENU_NORMALISE_DVD);
}

void popup_file (DETAIL *detail, TYPE_FILE_IS TypeFileIs)
{
	VarPopup.detail = detail;
	VarPopup.fic          = (FIC *)detail->fic;
	VarPopup.type_file_is = TypeFileIs;
	popup_make_popup (PopMenuFichiers, MAX_POP_MENU_FICHERS);
}

void popup_file_ReplayGain (DETAIL *detail)
{
	VarPopup.detail = detail;
	VarPopup.fic    = (FIC *)detail->fic;
	
	PopMenuReplayGain[ 3 ].Op.Show = TRUE;
	if (VarPopup.detail->type_infosong_file_is == FILE_IS_FLAC) {
		PopMenuReplayGain[ 3 ].Op.Show = FALSE;
	}
	
	popup_make_popup (PopMenuReplayGain, MAX_POP_MENU_REPLAYGAIN);
}


void popup_trash (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;
	
	popup_make_popup (PopMenuTrash, MAX_POP_MENU_TRASH);
}

void popup_frequence (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;

	popup_make_popup (PopMenuFrequence, MAX_POP_MENU_FREQUENCE);
}

void popup_piste (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;

	popup_make_popup (PopMenuPiste, MAX_POP_MENU_PISTE);
}

void popup_quantification (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	VarPopup.fic    = (FIC *)NULL;

	popup_make_popup (PopMenuQuantification, MAX_POP_MENU_QUANTIFICATION);
}

/*
void popup_make_popup_TST (void)
{
	GtkWidget *menu;
	GtkWidget *SubMenu;
	GtkWidget *OPSubMenu;
	GtkWidget *OPMenu;
	
	
	popup_init_pixbufs ();
	
	menu = gtk_menu_new ();	
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);

	OPMenu = gtk_menu_item_new_with_mnemonic ("UN");
	gtk_widget_show (OPMenu);
	gtk_container_add (GTK_CONTAINER (menu), OPMenu);

	OPMenu = gtk_separator_menu_item_new ();
	gtk_widget_show (OPMenu);
	gtk_container_add (GTK_CONTAINER (menu), OPMenu);
	gtk_widget_set_sensitive (OPMenu, FALSE);
		
	OPMenu = gtk_menu_item_new_with_mnemonic ("DEUX");
	gtk_widget_show (OPMenu);
	gtk_container_add (GTK_CONTAINER (menu), OPMenu);

	SubMenu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (OPMenu), SubMenu);

	OPSubMenu = gtk_image_menu_item_new_with_mnemonic ("FILS UN");
	gtk_widget_show (OPSubMenu);
	gtk_container_add (GTK_CONTAINER (SubMenu), OPSubMenu);
	
	gtk_widget_show (VarPopup.Image_dbfs_yes);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (OPSubMenu), VarPopup.Image_dbfs_yes);

	OPSubMenu = gtk_image_menu_item_new_with_mnemonic ("FILS DEUX");
	gtk_widget_show (OPSubMenu);
	gtk_container_add (GTK_CONTAINER (SubMenu), OPSubMenu);
	
	gtk_widget_show (VarPopup.Image_dbfs_no);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (OPSubMenu), VarPopup.Image_dbfs_no);
	
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);	
}
*/

/*
	VarPopup.Image_dbfs_no     = popup_init_pixbufs_file ("dbfs-no.png");
	VarPopup.Image_dbfs_choice = popup_init_pixbufs_file ("dbfs-choice.png");
	VarPopup.Image_dbfs_yes    = popup_init_pixbufs_file ("dbfs-yes.png");
*/












