 /*
 * file    : tags_dts.c
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"



/*
*---------------------------------------------------------------------------
* FILE IS DTS ?
*---------------------------------------------------------------------------
*/
/*
$ file *
	audio.dts:    data
*/

/*
*---------------------------------------------------------------------------
* REMOVE HEADER
*---------------------------------------------------------------------------
*/
INFO_DTS *tagsdts_remove_info (INFO_DTS *info)
{
	if (info) {
		g_free (info->namefile);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_DTS *)NULL);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/
INFO_DTS *tagsdts_get_info (gchar *namefile)
{
	INFO_DTS     *ptrinfo = NULL;

	ptrinfo = (INFO_DTS *)g_malloc0 (sizeof (INFO_DTS));
	if (ptrinfo == NULL) return (NULL);

	ptrinfo->namefile = g_strdup (namefile);

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	tags_set (namefile, ptrinfo->tags);

	return ((INFO_DTS *)ptrinfo);
}











