 /*
 * file      : utils.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __utils_h__
#define __utils_h__ 1
#include "file.h"

typedef struct {
	GList		*list_prg_not_found;		/* Liste des programmes absents */
	GtkWidget	*AdrLabelStatusbarGlobal;
} VAR_UTILS;

extern VAR_UTILS var_utils;
void utils_puts_statusbar_global (gchar *mess_label_status);


void      utils_set_default_icone_xcfa (GtkWidget *win);
gboolean  utils_scan_by_which (gchar *Name_Prg, gchar **Pathname_Prg);
gchar    *utils_get_str_date (void);
gchar    *utils_get_str_time (void);
gchar    *sc_chomp(gchar *Astr);
gpointer  get_combo_value(GtkWidget *Acombo);
gint      get_combo_intvalue(GtkWidget *Acombo);
gchar    *get_combo_value_pos(GtkWidget *Acombo, gint Apos);
gint      utils_hexa_to_int (gchar *s);
void      utils_infos_ordi (void);
gchar    *utils_get_infos_ordi (gboolean bool_uname, gboolean bool);
gboolean  utils_new_strcmp (gchar *src, gchar *dest);
gchar    *utils_get_pathname (gchar *file);
// void      utils_clear_elements_combobox (GtkWidget *widget);
void utils_clear_elements_combobox (GtkComboBox *widget);

gboolean  utils_set_prg_not_found (gchar *name, gboolean bool_prg);
void      utils_remove_prg_not_found (void);
gboolean  utils_put_error_statusbar (gboolean is_file);

void      utils_set_mess_from_file_ETAT_SELECTION (ETAT_SELECTION etat, gboolean BoolRepIdentique);
void      utils_set_mess_from_file_ETAT_NORMALISE (DETAIL *Detail, FIC *fic, ETAT_NORMALISE etat, gboolean BoolRepIdentique);
void      utils_set_mess_from_file_ETAT_PLAY (ETAT_PLAY_FILE etat);
void      utils_set_mess_from_file_ETAT_REPLAYGAIN (ETAT_REPLAYGAIN etat, gboolean BoolRepIdentique);
void      utils_set_mess_from_cd_ETAT_SELECTION_CD (ETAT_SELECTION_CD etat);
void      utils_set_mess_from_cd_ETAT_PLAY_CD (ETAT_PLAY_CD etat);
void      utils_set_mess_from_cd_ETAT_NORMALISE_CD (ETAT_NORMALISE_CD EtatNormalise);
void      utils_set_mess_from_file_ETAT_TRASH (ETAT_TRASH_FILE etat);

void      utils_time_start (void);
void      utils_time_end (gchar *Def);

gchar    *utils_convert_to_utf8 (const gchar *string);
gchar    *utils_convert_from_utf8 (const char *string);
gchar    *utils_convert_string (const gchar *string, gboolean bool);

void      utils_add_datas_on_disk (gchar *data);
gchar    *utils_get_datas_on_disk (void);

gboolean  utils_test_write (gchar *path);
gchar    *utils_create_temporary_rep (gchar *path_tmprep);
gchar    *utils_remove_temporary_rep (gchar *path_tmprep);

GList    *utils_clear_list (GList *p_list);


//
//
//
void		 utils_remove_combo (void);
GtkListStore	*utils_alloc_combo (GtkComboBox *p_combo);

#endif

