 /*
 * file      : lib/combo.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * BaseBuild - Creation d'une base de programmation en langage C de type GNU avec les autotools
 * GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>

#include "lib.h"


typedef struct {
	GtkComboBox	*combo;
	gboolean	 Bool;
} ALLOC;

GList *ListAlloc = NULL;


// REMOVE ALLOC COMBO
// 
void libcombo_remove (void)
{
	GList	*list = NULL;
	ALLOC	*New = NULL;
	gint	 NbList = 0;
	
	list = g_list_first (ListAlloc);
	while (list) {
		if (NULL != (New = (ALLOC *)list->data)) {
			g_free (New);
			New = NULL;
			list->data = NULL;
			
			NbList ++;
		}
		list = g_list_next (list);
	}
	g_list_free (ListAlloc);
	ListAlloc = NULL;
	g_print ("\tRemove: %d\n", NbList);
}
// ALLOC COMBO
// 
void libcombo_alloc (GtkComboBox *p_combo)
{
	GtkListStore	*store = NULL;
	GtkCellRenderer *renderer = NULL;
	GList		*list = NULL;
	ALLOC		*New = NULL;
	gboolean	 BoolInListe = FALSE;
	
	// CHERCHE SI PAS DANS LA LISTE
	list = g_list_first (ListAlloc);
	while (list) {
		if ((New = (ALLOC *)list->data) != NULL) {
			if (New->combo == p_combo) {
				BoolInListe = TRUE;
				break;
			}
		}
		list = g_list_next (list);
	}
	// SI PAS DANS LA LISTE ALORS INSERTION
	if (BoolInListe == FALSE) {
		New = (ALLOC *)g_malloc0 (sizeof(ALLOC));
		New->combo = p_combo;
		New->Bool  = FALSE;
		ListAlloc = g_list_append (ListAlloc, New);
	}
	
	// RECUP OU CREATION DE store
	list = g_list_first (ListAlloc);
	while (list) {
		if ((New = (ALLOC *)list->data) != NULL) {
			if (New->combo == p_combo) {
				if (New->Bool == FALSE) {
					store = gtk_list_store_new (1, G_TYPE_STRING);
					gtk_combo_box_set_model (GTK_COMBO_BOX(p_combo), GTK_TREE_MODEL(store));
					renderer = gtk_cell_renderer_text_new ();
					gtk_cell_layout_pack_start (GTK_CELL_LAYOUT(p_combo), renderer, TRUE);
					gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT(p_combo), renderer, "text", 0, NULL);
					New->Bool = TRUE;
				}
				else {
					store = GTK_LIST_STORE (gtk_combo_box_get_model(p_combo));
					gtk_list_store_clear (store);
				}
				break;
			}
		}
		list = g_list_next (list);
	}
}
// OPTIONS REMOVE COMBO
// 	libcombo_remove_options (GTK_COMBO_BOX ());
// 
void libcombo_remove_options (GtkComboBox *p_combo)
{
	gint	Index;
	
	while (TRUE) {
		Index = gtk_combo_box_get_active (GTK_COMBO_BOX (p_combo));		
		if (Index == -1) break;
		gtk_combo_box_remove_text (GTK_COMBO_BOX (p_combo), Index);
		
		gtk_combo_box_set_active (GTK_COMBO_BOX (p_combo), 0);
	}
}

