#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>


#define FILENAME  "phone.def"
#define MAXIMUM   15000


char *photab1 = " 1qaz2wsxedcrfv5tgbyhn";  /* tuvwxyz{|}~  5 bits: 22 */
char *photab2 = " ujm";			   /*                                       2 bits: 4  */
char *photab3 = " 8ik,9ol.0p;/-";	   /*                   4 bits: 14 */
char *photab4 = " 7634";		   /*                                     3 bits: 5  */


typedef struct {
    u_short pho_code, num;
    u_char  *ch;
} PHO_Code;

PHO_Code  pc[MAXIMUM];


int main(int argc, char **argv)
{
    FILE     *fp;
    char      buf[100];

    u_char    ch[2];
    u_short   pho_code, num_code=0, cpar[2];

    u_int     i, j;
    PHO_Code  tmp;


    if((fp=fopen(FILENAME, "rt")) == NULL) {
	fprintf(stderr, "Error: Cannot open the source file: %s\n", FILENAME);
	exit(1);
    }

    while(fgets(buf, 99, fp) != NULL) {
	pho_code = 0;

	for(i=0; i<22 && photab1[i]!=buf[0]; i++);
	if(i < 22)
	    pho_code = (i << 9);
	else
	    fprintf(stderr, "err on photab1!\n");

	for(i=0; i<4 && photab2[i]!=buf[1]; i++);
	if(i < 4)
	    pho_code |= (i << 7);
	else
	    fprintf(stderr, "err on photab2!\n");

	for(i=0; i<14 && photab3[i]!=buf[2]; i++);
	if(i < 14)
	    pho_code |= (i << 3);
	else
	    fprintf(stderr, "err on photab3!\n");

	for(i=0; i<5 && photab4[i]!=buf[3]; i++);
	if(i < 5)
	    pho_code |= i;
	else
	    fprintf(stderr, "err on photab4!\n");

	if(num_code >= MAXIMUM) {
	    fprintf(stderr, "Error: The table is too small\n");
	    exit(1);
	}
	if(num_code > 0 && pc[num_code-1].pho_code == pho_code)
	    pc[num_code-1].num ++;
	else {
	    pc[num_code].pho_code = pho_code;
	    pc[num_code].num ++;
	    num_code ++;
	}
    }

    rewind(fp);
    for(i=0; i<num_code; i++) {
	pc[i].ch = (u_char *)calloc(pc[i].num*2, sizeof(u_char));
	if(pc[i].ch == NULL) {
	    fprintf(stderr, "Error: Not enough memory!\n");
	    exit(1);
	}

	for(j=0; j<pc[i].num; j++) {
	    if(fgets(buf, 99, fp) == NULL)
		fprintf(stderr, "counting error!!\n");
	    pc[i].ch[j*2]   = buf[5];
	    pc[i].ch[j*2+1] = buf[6];
	}
    }
    fclose(fp);
    printf("Number of pho_code is: %d\n", num_code);

    for(i=0; i<num_code; i++) {            /* sorting */
	for(j=i+1; j<num_code; j++) {
	    if(pc[i].pho_code > pc[j].pho_code) {
		tmp.pho_code = pc[i].pho_code;
		tmp.num = pc[i].num;
		tmp.ch = pc[i].ch;

		pc[i].pho_code = pc[j].pho_code;
		pc[i].num = pc[j].num;
		pc[i].ch = pc[j].ch;

		pc[j].pho_code = tmp.pho_code;
		pc[j].num = tmp.num;
		pc[j].ch = tmp.ch;
	    }
	}
    }

    if((fp=fopen("pho.tab", "wb")) == NULL) {
	fprintf(stderr, "Error: Cannot write the table.\n");
	exit(1);
    }
    fwrite("PH", sizeof(u_char), 2, fp);
    pho_code = num_code*2;
    fwrite(&pho_code, sizeof(u_short), 1, fp);

    cpar[1] = 0;
    for(i=0; i<num_code; i++) {
	cpar[0] = pc[i].pho_code;
	fwrite(cpar, sizeof(u_short), 2, fp);
	cpar[1] += (pc[i].num*2);    /* this is the offset */
    }
    for(i=0; i<num_code; i++)
	fwrite(pc[i].ch, sizeof(u_char), pc[i].num*2, fp);

    fclose(fp);

    return  0;
}
