#include "XCPolygon.h"
#include "XCPoint.h"

#undef QUERY_CODE
#define QUERY_CODE XCLINEOBJ_QUERY_CODE

BEGIN_XC_IMPL(XCPolygon)

STDMETHODIMP XCPolygon_get_point(IXCPolygon *This, int index, IXCPoint **pt)
{
	HRESULT hres;
	long handle;
	XCPoint *p;

	if ((hres = IXCPolygon_get_object_handle(This, &handle)) != S_OK)
		return ECODE(XC_E_HANDLE);
	if (index < 0 || index >= TOPOLY(&handle)->number)
		return ECODE(XC_E_OUTOFRANGE);

	p = (XCPoint*)make_XCPoint();
	IXCPolygon_QueryInterface(This, &IID_IXCObject, &p->object);
	p->pt = TOPOLY(&handle)->points+index;

	IXCPoint_QueryInterface(&p->iface, &IID_IXCPoint, (void**)pt);

	return S_OK;
}

STDMETHODIMP XCPolygon_append(IXCPolygon *This, int x, int y)
{
	XPoint newpoint;
	HRESULT hres;
	long handle;

	if ((hres = IXCPolygon_get_object_handle(This, &handle)) != S_OK)
		return hres;
	newpoint.x = x;
	newpoint.y = y;
	poly_add_point(TOPOLY(&handle), &newpoint);
	IXCPolygon_update(This, 1);

	return S_OK;
}

XCLINEOBJ_VTBL_BEGIN(XCPolygon)
	XCPolygon_get_point,
	XCPolygon_append,
XCLINEOBJ_VTBL_END()

END_XC_IMPL(XCPolygon)
