#-----------------------------------------------------------------
# Procedures to help with label generation (label autoincrement)
#-----------------------------------------------------------------

# autoincrement the first number found in the text of the indicated
# label(s).  Use argument "amount" to decrement, or increment by 10,
# etc.
#
# example:   xcircuit::textincrement [select get]

proc xcircuit::textincrement {handle {amount 1}} {
   foreach h $handle {
      if {[element $h type] == "Label"} {
         set tlist [join [label $h list]]
         set tlen [llength $tlist]
         for {set i 0} {$i < $tlen} {incr i} {
	    set t [lindex $tlist $i]
            set esc [lindex $t 0]
            if {$esc == "Text"} {
	       set ltext [lindex $t 1]
	       set num [regexp -inline {[+-]*[[:digit:]]+} $ltext]
	       if {$num != ""} {
	          incr num $amount
	          regsub {[+-]*[[:digit:]]+} $ltext $num ltext
	          set t [lreplace $t 1 1 $ltext]
	          set tlist [lreplace $tlist $i $i $t]
	          label $h replace $tlist
	          break
	       }
	    }
	 }
      }
   }
}


proc xcircuit::autoincr {{value 1}} {
   set s [select get]
   set e [eventmode]
   if {$e != "text" && $e != "etext" } {
      if {[llength $s] > 0} {
         xcircuit::textincrement $s $value
         select $s
         refresh
      } else {
	 error "no selection"
      }
   } else {
      error "no auto-incr in text mode"
   }
}

#-----------------------------------------------------------------
