/*
 * SPCA505 chip based cameras initialization data
 *
 */
#ifndef SPCA505_INIT_H
#define SPCA505_INIT_H

/*
 * Data to initialize a SPCA505. Common to the CCD and external modes
 */
static __u16 spca505_init_data[][3]=
{
  /* line       bmRequest,value,index */
  /* 1819 */ { SPCA50X_REG_GLOBAL,SPCA50X_GMISC3_SAA7113RST,SPCA50X_GLOBAL_MISC3 }, /* Sensor reset */
  /* 1822 */ { SPCA50X_REG_GLOBAL,0x0,SPCA50X_GLOBAL_MISC3 },
  /* 1825 */ { SPCA50X_REG_GLOBAL,0x0,SPCA50X_GLOBAL_MISC1 }, /* Block USB reset */
  /* 1828 */ { SPCA50X_REG_GLOBAL,SPCA50X_GMISC0_IDSEL,SPCA50X_GLOBAL_MISC0 },

  /* 1831 */ { 0x5,0x1,0x10 }, /* Maybe power down some stuff */
  /* 1834 */ { 0x5,0xf,0x11 },

  /* Setup internal CCD  ? */
  /* 1837 */ { 0x6,0x10,0x8 },
  /* 1840 */ { 0x6,0x0,0x9 },
  /* 1843 */ { 0x6,0x0,0x0a },
  /* 1846 */ { 0x6,0x0,0x0b },
  /* 1849 */ { 0x6,0x10,0xc },
  /* 1852 */ { 0x6,0x0,0xd },
  /* 1855 */ { 0x6,0x0,0xe },
  /* 1858 */ { 0x6,0x0,0xf },
  /* 1861 */ { 0x6,0x10,0x10 },
  /* 1864 */ { 0x6,0x2,0x11 },
  /* 1867 */ { 0x6,0x0,0x12 },
  /* 1870 */ { 0x6,0x4,0x13 },
  /* 1873 */ { 0x6,0x2,0x14 },
  /* 1876 */ { 0x6,0x8a,0x51 },
  /* 1879 */ { 0x6,0x40,0x52 },
  /* 1882 */ { 0x6,0xb6,0x53 },
  /* 1885 */ { 0x6,0x3d,0x54 },
  { 0,0,0 }
};

/*
 * Data to initialize the camera using the internal CCD
 */
static __u16 spca505_open_data_ccd[][3]=
{
  /* line       bmRequest,value,index */
  /* Internal CCD data set */
  /* 1891 */ { 0x3,0x4,0x1 }, /* This could be a reset */
  /* 1894 */ { 0x3,0x0,0x1 },

  /* Setup compression and image registers. 0x6 and 0x7 seem to be
     related to H&V hold, and are resolution mode specific */
  /* 1897 */ { 0x4,0x10,0x1 }, /* DIFF(0x50), was (0x10) */
  /* 1900 */ { 0x4,0x0,0x4 },
  /* 1903 */ { 0x4,0x0,0x5 },
  /* 1906 */ { 0x4,0x20,0x6 },
  /* 1909 */ { 0x4,0x20,0x7 },

  /* 1912 */ { 0x8,0xa,0x0 }, /* DIFF (0x4a), was (0xa) */

  /* 1915 */ { 0x5,0x0,0x10 },
  /* 1918 */ { 0x5,0x0,0x11 },
  /* 1921 */ { 0x5,0x0,0x0 }, /* DIFF not written */
  /* 1924 */ { 0x5,0x0,0x1 }, /* DIFF not written */
  /* 1927 */ { 0x5,0x0,0x2 }, /* DIFF not written */
  /* 1930 */ { 0x5,0x0,0x3 }, /* DIFF not written */
  /* 1933 */ { 0x5,0x0,0x4 }, /* DIFF not written */
  /* 1936 */ { 0x5,0x80,0x5 }, /* DIFF not written */
  /* 1939 */ { 0x5,0xe0,0x6 }, /* DIFF not written */
  /* 1942 */ { 0x5,0x20,0x7 }, /* DIFF not written */
  /* 1945 */ { 0x5,0xa0,0x8 }, /* DIFF not written */
  /* 1948 */ { 0x5,0x0,0x12 }, /* DIFF not written */
  /* 1951 */ { 0x5,0x2,0xf}, /* DIFF not written */
  /* 1954 */ { 0x5,0x10,0x46 }, /* DIFF not written */
  /* 1957 */ { 0x5,0x8,0x4a }, /* DIFF not written */

  /* 1960 */ { 0x3,0x8,0x3 },
			     /* DIFF (0x3,0x28,0x3) */
  /* 1963 */ { 0x3,0x8,0x1 },
  /* 1966 */ { 0x3,0xc,0x3 }, /* DIFF not written */
  /* 1969 */ { 0x3,0x21,0x0 }, /* DIFF (0x39) */

  /* Extra block copied from init to hopefully ensure CCD is in a sane state */
  /* 1837 */ { 0x6,0x10,0x8 },
  /* 1840 */ { 0x6,0x0,0x9 },
  /* 1843 */ { 0x6,0x0,0x0a },
  /* 1846 */ { 0x6,0x0,0x0b },
  /* 1849 */ { 0x6,0x10,0xc },
  /* 1852 */ { 0x6,0x0,0xd },
  /* 1855 */ { 0x6,0x0,0xe },
  /* 1858 */ { 0x6,0x0,0xf },
  /* 1861 */ { 0x6,0x10,0x10 },
  /* 1864 */ { 0x6,0x2,0x11 },
  /* 1867 */ { 0x6,0x0,0x12 },
  /* 1870 */ { 0x6,0x4,0x13 },
  /* 1873 */ { 0x6,0x2,0x14 },
  /* 1876 */ { 0x6,0x8a,0x51 },
  /* 1879 */ { 0x6,0x40,0x52 },
  /* 1882 */ { 0x6,0xb6,0x53 },
  /* 1885 */ { 0x6,0x3d,0x54 },
  /* End of extra block */

  /* 1972 */ { 0x6,0x3f,0x1 }, /* Block skipped */
  /* 1975 */ { 0x6,0x10,0x2 },
  /* 1978 */ { 0x6,0x64,0x7 },
  /* 1981 */ { 0x6,0x10,0x8 },
  /* 1984 */ { 0x6,0x0,0x9 },
  /* 1987 */ { 0x6,0x0,0xa },
  /* 1990 */ { 0x6,0x0,0xb },
  /* 1993 */ { 0x6,0x10,0xc },
  /* 1996 */ { 0x6,0x0,0xd },
  /* 1999 */ { 0x6,0x0,0xe },
  /* 2002 */ { 0x6,0x0,0xf },
  /* 2005 */ { 0x6,0x10,0x10 },
  /* 2008 */ { 0x6,0x2,0x11 },
  /* 2011 */ { 0x6,0x0,0x12 },
  /* 2014 */ { 0x6,0x4,0x13 },
  /* 2017 */ { 0x6,0x2,0x14 },
  /* 2020 */ { 0x6,0x8a,0x51 },
  /* 2023 */ { 0x6,0x40,0x52 },
  /* 2026 */ { 0x6,0xb6,0x53 },
  /* 2029 */ { 0x6,0x3d,0x54 },
  /* 2032 */ { 0x6,0x60,0x57 },
  /* 2035 */ { 0x6,0x20,0x58 },
  /* 2038 */ { 0x6,0x15,0x59 },
  /* 2041 */ { 0x6,0x5,0x5a },

  /* 2044 */ { 0x5,0x1,0xc0 },
  /* 2047 */ { 0x5,0x10,0xcb },
  /* 2050 */ { 0x5,0x80,0xc1 }, /* */
  /* 2053 */ { 0x5,0x0,0xc2 }, /* 4 was 0 */
  /* 2056 */ { 0x5,0x0,0xca },
  /* 2059 */ { 0x5,0x80,0xc1 }, /*  */
  /* 2062 */ { 0x5,0x4,0xc2 },
  /* 2065 */ { 0x5,0x0,0xca },
  /* 2068 */ { 0x5,0x0,0xc1 }, /*  */
  /* 2071 */ { 0x5,0x0,0xc2 },
  /* 2074 */ { 0x5,0x0,0xca },
  /* 2077 */ { 0x5,0x40,0xc1 }, /* */
  /* 2080 */ { 0x5,0x17,0xc2 },
  /* 2083 */ { 0x5,0x0,0xca },
  /* 2086 */ { 0x5,0x80,0xc1 }, /* */
  /* 2089 */ { 0x5,0x6,0xc2 },
  /* 2092 */ { 0x5,0x0,0xca },
  /* 2095 */ { 0x5,0x80,0xc1 }, /* */
  /* 2098 */ { 0x5,0x4,0xc2 },
  /* 2101 */ { 0x5,0x0,0xca },

  /* 2104 */ { 0x3,0x4c,0x3 },
  /* 2107 */ { 0x3,0x18,0x1 },

  /* 2110 */ { 0x6,0x70,0x51 },
  /* 2113 */ { 0x6,0xbe,0x53 },
  /* 2116 */ { 0x6,0x71,0x57 },
  /* 2119 */ { 0x6,0x20,0x58 },
  /* 2122 */ { 0x6,0x5,0x59 },
  /* 2125 */ { 0x6,0x15,0x5a },

  /* 2128 */ { 0x4,0x0,0x8 }, /* Compress = OFF (0x1 to turn on) */
  /* 2131 */ { 0x4,0x12,0x9 },
  /* 2134 */ { 0x4,0x21,0xa },
  /* 2137 */ { 0x4,0x10,0xb },
  /* 2140 */ { 0x4,0x21,0xc },
  /* 2143 */ { 0x4,0x5,0x0 }, /* was 5 (Image Type ? )*/
  /* 2146 */ { 0x4,0x0,0x1 },

  /* 2149 */ { 0x6,0x3f,0x1 },

  /* 2152 */ { 0x4,0x0,0x4 },
  /* 2155 */ { 0x4,0x0,0x5 },
  /* 2158 */ { 0x4,0x40,0x6 },
  /* 2161 */ { 0x4,0x40,0x7 },

  /* 2164 */ { 0x6,0x1c,0x17 },
  /* 2167 */ { 0x6,0xe2,0x19 },
  /* 2170 */ { 0x6,0x1c,0x1b },
  /* 2173 */ { 0x6,0xe2,0x1d },
  /* 2176 */ { 0x6,0xaa,0x1f },
  /* 2179 */ { 0x6,0x70,0x20 },

  /* 2182 */ { 0x5,0x1,0x10 },
  /* 2185 */ { 0x5,0x0,0x11 },
  /* 2188 */ { 0x5,0x1,0x0 },
  /* 2191 */ { 0x5,0x5,0x1 },
  /* 2194 */ { 0x5,0x0,0xc1 }, /* */
  /* 2197 */ { 0x5,0x0,0xc2 },
  /* 2200 */ { 0x5,0x0,0xca },

  /* 2203 */ { 0x6,0x70,0x51 },
  /* 2206 */ { 0x6,0xbe,0x53 },
  {0,0,0}
};
#if 0
/*
 * Data to initialize the camera in external video mode
 */
static __u16 spca505_open_data_ext[][3]= {
  /* line       bmRequest,value,index */
  /* External video input dataset */
  /* 0808 */ { 0x3,0x4,0x1 },
  /* 0809 */ { 0x3,0x0,0x1 },

  /* 0810 */ { 0x4,0x50,0x1 },
  /* 0811 */ { 0x4,0x0,0x4 },
  /* 0812 */ { 0x4,0xa,0x5 },
  /* 0813 */ { 0x4,0x20,0x6 },
  /* 0814 */ { 0x4,0x20,0x7 },

  /* 0815 */ { 0x8,0x4a,0x0 },

  /* 0816 */ { 0x5,0x0,0x10 },
  /* 0817 */ { 0x5,0x0,0x11 },

  /* 0818 */ { 0x3,0x8,0x3 },
  /* 0819 */ { 0x3,0x28,0x3 },
  /* 0820 */ { 0x3,0x8,0x1 },
  /* 0821 */ { 0x3,0x39,0x0 },

  /* 0822 */ { 0x5,0x1,0xc0 },
  /* 0823 */ { 0x5,0x10,0xcb },
  /* 0824 */ { 0x5,0x80,0xc1 },
  /* 0825 */ { 0x5,0x5,0xc2 },
  /* 0826 */ { 0x5,0x0,0xca },
  /* 0827 */ { 0x5,0x0,0xc1 },
  /* 0828 */ { 0x5,0x1,0xc2 },
  /* 0829 */ { 0x5,0x0,0xca },
  /* 0830 */ { 0x5,0x1,0x10 },
  /* 0831 */ { 0x5,0xf,0x11 },

  { 0,0,0 }

};

/*
 * Additional data needed to initialze the camera in external mode
 */
static __u16 spca505_open_data2[][3]=
{
  /* line       bmRequest,value,index */
  /* 1384 */ { 0x3,0x68,0x3 },
  /* 1385 */ { 0x3,0x10,0x1 },
  /* 1386 */ { 0x8,0x4a,0x0 },
  /* 1387 */ { 0x4,0x0,0x8 }, /* was 1 COMPRESSION ENABLE !*/
  /* 1388 */ { 0x4,0x12,0x9 }, /* Think these are the compression registers */
  /* 1389 */ { 0x4,0x21,0xa },
  /* 1390 */ { 0x4,0x10,0xb },
  /* 1391 */ { 0x4,0x21,0xc },
  /* 1392 */ { 0x4,0x5,0x0 }, /* This may be the picture type code (5=160x120 as YUV4:2:0) */
  /* 1393 */ { 0x4,0x0,0x1 },
  /* 1394 */ { 0x6,0x3f,0x1 },
  /* 1395 */ { 0x4,0x0,0x4 },
  /* 1396 */ { 0x4,0xa,0x5 },
  /* 1397 */ { 0x4,0x40,0x6 }, /* was 40 */
  /* 1398 */ { 0x4,0x40,0x7 }, /* was 50 */
  /* 1399 */ { 0x4,0x2,0x5 },
  /* 1400 */ { 0x4,0x0,0x4 },
  {0,0,0}
};
#endif
/*
   Made by Tomasz Zablocki (skalamandra@poczta.onet.pl)
 * SPCA505b chip based cameras initialization data
 *
 */
 #define initial_brightness 0x0  //0x0(white)-0xff(black) 
/*
 * Data to initialize a SPCA505. Common to the CCD and external modes
 */
static __u16 spca505b_init_data[][3]=
{
//start

{0x02,0x00,0x00},//init 
{0x02,0x00,0x01},
{0x02,0x00,0x02},
{0x02,0x00,0x03},
{0x02,0x00,0x04},
{0x02,0x00,0x05},
{0x02,0x00,0x06},
{0x02,0x00,0x07},
{0x02,0x00,0x08},
{0x02,0x00,0x09},
{0x03,0x00,0x00},
{0x03,0x00,0x01},
{0x03,0x00,0x02},
{0x03,0x00,0x03},
{0x03,0x00,0x04},
{0x03,0x00,0x05},
{0x03,0x00,0x06},
{0x04,0x00,0x00},
{0x04,0x00,0x02},
{0x04,0x00,0x04},
{0x04,0x00,0x05},
{0x04,0x00,0x06},
{0x04,0x00,0x07},
{0x04,0x00,0x08},
{0x04,0x00,0x09},
{0x04,0x00,0x0a},
{0x04,0x00,0x0b},
{0x04,0x00,0x0c},
{0x07,0x00,0x00},
{0x07,0x00,0x03},
{0x08,0x00,0x00},
{0x08,0x00,0x01},
{0x08,0x00,0x02},
{0x00,0x01,0x00},
{0x00,0x01,0x01},
{0x00,0x01,0x34},
{0x00,0x01,0x35},
{0x06,0x18,0x08},
{0x06,0xfc,0x09},
{0x06,0xfc,0x0a},
{0x06,0xfc,0x0b},
{0x06,0x18,0x0c},
{0x06,0xfc,0x0d},
{0x06,0xfc,0x0e},
{0x06,0xfc,0x0f},
{0x06,0x18,0x10},
{0x06,0xfe,0x12},
{0x06,0x00,0x11},
{0x06,0x00,0x14},
{0x06,0x00,0x13},
{0x06,0x28,0x51},
{0x06,0xff,0x53},
{0x02,0x00,0x08},

{0x03,0x00,0x03},
{0x03,0x10,0x03},

  { 0,0,0 }
};


/*
 * Data to initialize the camera using the internal CCD
 */
static __u16 spca505b_open_data_ccd[][3]=
{

//{0x02,0x00,0x00},

{0x03,0x04,0x01},//rst
{0x03,0x00,0x01},
{0x03,0x00,0x00},
{0x03,0x21,0x00},
{0x03,0x00,0x04},
{0x03,0x00,0x03},
{0x03,0x18,0x03},
{0x03,0x08,0x01},
{0x03,0x1c,0x03},
{0x03,0x5c,0x03},
{0x03,0x5c,0x03},
{0x03,0x18,0x01},

//same as 505
{0x04,0x10,0x01},
{0x04,0x00,0x04},
{0x04,0x00,0x05},
{0x04,0x20,0x06},
{0x04,0x20,0x07},

{0x08,0x0a,0x00},

{0x05,0x00,0x10},
{0x05,0x00,0x11},
{0x05,0x00,0x12},
{0x05,0x6f,0x00},
{0x05,initial_brightness>>6,0x00},
{0x05,initial_brightness<<2,0x01},
{0x05,0x00,0x02},
{0x05,0x01,0x03},
{0x05,0x00,0x04},
{0x05,0x03,0x05},
{0x05,0xe0,0x06},
{0x05,0x20,0x07},
{0x05,0xa0,0x08},
{0x05,0x00,0x12},
{0x05,0x02,0x0f},
{0x05,128,0x14},//max exposure off (0=on)     
{0x05,0x01,0xb0},
{0x05,0x01,0xbf},
{0x03,0x02,0x06},
{0x05,0x10,0x46},
{0x05,0x08,0x4a},

{0x06,0x00,0x01},
{0x06,0x10,0x02},
{0x06,0x64,0x07},
{0x06,0x18,0x08},
{0x06,0xfc,0x09},
{0x06,0xfc,0x0a},
{0x06,0xfc,0x0b},
{0x04,0x00,0x01},
{0x06,0x18,0x0c},
{0x06,0xfc,0x0d},
{0x06,0xfc,0x0e},
{0x06,0xfc,0x0f},
{0x06,0x11,0x10},//contrast
{0x06,0x00,0x11},
{0x06,0xfe,0x12},
{0x06,0x00,0x13},
{0x06,0x00,0x14},
{0x06,0x9d,0x51},
{0x06,0x40,0x52},
{0x06,0x7c,0x53},
{0x06,0x40,0x54},
{0x06,0x02,0x57},
{0x06,0x03,0x58},
{0x06,0x15,0x59},
{0x06,0x05,0x5a},
{0x06,0x03,0x56},
{0x06,0x02,0x3f},
{0x06,0x00,0x40},
{0x06,0x39,0x41},
{0x06,0x69,0x42},
{0x06,0x87,0x43},
{0x06,0x9e,0x44},
{0x06,0xb1,0x45},
{0x06,0xbf,0x46},
{0x06,0xcc,0x47},
{0x06,0xd5,0x48},
{0x06,0xdd,0x49},
{0x06,0xe3,0x4a},
{0x06,0xe8,0x4b},
{0x06,0xed,0x4c},
{0x06,0xf2,0x4d},
{0x06,0xf7,0x4e},
{0x06,0xfc,0x4f},
{0x06,0xff,0x50},

{0x05,0x01,0xc0},
{0x05,0x10,0xcb},
{0x05,0x40,0xc1},
{0x05,0x4,0xc2},
{0x05,0x00,0xca},
{0x05,0x40,0xc1},
{0x05,0x09,0xc2},
{0x05,0x00,0xca},
{0x05,0xc0,0xc1},
{0x05,0x09,0xc2},
{0x05,0x00,0xca},
{0x05,0x40,0xc1},
{0x05,0x59,0xc2},
{0x05,0x00,0xca},
{0x04,0x00,0x01},
{0x05,0x80,0xc1},
{0x05,0xec,0xc2},
{0x05,0x0,0xca},

{0x06,0x02,0x57},
{0x06,0x01,0x58},
{0x06,0x15,0x59},
{0x06,0x0a,0x5a},
{0x06,0x01,0x57},
{0x06,0x8a,0x03},
{0x06,0x0a,0x6c},
{0x06,0x30,0x01},
{0x06,0x20,0x02},
{0x06,0x00,0x03},

{0x05,0x8c,0x25},

{0x06,0x4d,0x51},//maybe saturation (4d)
{0x06,0x84,0x53},//making green (84)
{0x06,0x0,0x57},//sharpness (1)
{0x06,0x18,0x08},
{0x06,0xfc,0x09},
{0x06,0xfc,0x0a},
{0x06,0xfc,0x0b},
{0x06,0x18,0x0c},//maybe hue (18)
{0x06,0xfc,0x0d},
{0x06,0xfc,0x0e},
{0x06,0xfc,0x0f},
{0x06,0x18,0x10},//maybe contrast (18)

{0x05,0x01,0x02},

{0x04,0x0,0x08},//compression
{0x04,0x12,0x09},
{0x04,0x21,0x0a},
{0x04,0x10,0x0b},
{0x04,0x21,0x0c},
{0x04,0x1d,0x00},//imagetype (1d)
{0x04,0x41,0x01},//hardware snapcontrol 
		 

{0x04,0x00,0x04},
{0x04,0x00,0x05},
{0x04,0x10,0x06},
{0x04,0x10,0x07},
{0x04,0x40,0x06},
{0x04,0x40,0x07},
{0x04,0x00,0x04},
{0x04,0x00,0x05},

{0x06,0x1c,0x17},
{0x06,0xe2,0x19},
{0x06,0x1c,0x1b},
{0x06,0xe2,0x1d},
{0x06,0x5f,0x1f},
{0x06,0x32,0x20},

{0x05,initial_brightness>>6,0x00},
{0x05,initial_brightness<<2,0x01},
{0x05,0x06,0xc1},
{0x05,0x58,0xc2},
{0x05,0x0,0xca},
{0x05,0x0,0x11},
{0,0,0}
};

#endif /* SPCA505_INIT_H */
//eof
