#!/bin/sh
#### 
# This script will get executed on the managed node (The node on which
# the new VM is being provisioned.)
# This script 
#    - creates the disk(s) 
#    - fetches the kernel and ramdisk from kernel_src and ramdisk_src 
#      if not already available.
#
# Feel free to copy/customize it for your environment.
#
# author : jd_jedi@users.sourceforge.net
#
###


# parse the command line parameters
while getopts i:s:p:x:l:c: o
do case "$o" in
	x)	vm_config="$OPTARG";;
	p)	param_file="$OPTARG";;
	s)	store="$OPTARG";;
	i)	image_name="$OPTARG";;
	c)	image_conf="$OPTARG";;
	l)	log_file="$OPTARG";;
	esac
done

common_loc=$store/common
image_root=$store/$image_name
custom_loc=$store/custom_scripts
image_custom_loc=$store/$image_name/custom_scripts

# source common files
source $common_loc/defs
source $common_loc/functions

log_msg "$0 starting"
log_msg "vm_config" $vm_config
log_msg "param_file" $param_file
log_msg "store" $store
log_msg "log_file"  $log_file


# source the image store specific file 
# some variables would get overwritten by vm config or params by user
# down the line
if [ -f "$image_conf" ]; then
   source_python_config $image_conf
fi

log_msg "custom_list" $custom_list

# source the vm config variables 
source_python_config $vm_config

# source additional params passed by UI
source $param_file

# check that we got all the params
set > /tmp/set_output

# create a list from the disk directive
disk_list=`python <<EOF
exec "disk=$disk"
disks = ""
for d in disk:
    disks +=  "%s " %d
print disks
EOF
`
echo $disk_list
# for each disk assume it to be created
# assumes that the disk size is given with a variable <device>_disk_size
# for example for device hda, hda_disk_size is expected.
#
for l in $disk_list
do
   frag=`echo $l  | $SED -e "s/\(.*\):\(.*\),\(.*\),\(.*\)/d_type=\\1 d_name=\\2 d_dev=\\3 d_mode=\\4/"`
   eval $frag

   d_dev=`echo $d_dev | $SED s/ioemu://g`
   #if [ "$d_mode" = "r" ]; then
   #     log_msg "Not creating read only disk $d_name"
   #	continue	
   #fi	

   is_cdrom=`echo ${d_dev} | $GREP -i cdrom`
   if [ -n "$is_cdrom" ]; then
      log_msg "Skipping cdrom entry : ${d_dev}" 
      continue
   fi

   d_create_var=${d_dev}_disk_create
   d_create=${!d_create_var}

   if [ -z "$d_create" ]; then
      log_msg "Skipping : $d_create_var not set for $d_dev."
      continue
   fi
   
   if [ "$d_create" != "yes" ]; then
      log_msg "Skipping : $d_create_var not set to 'yes' for $d_dev."
      continue
   fi

   d_size_var=${d_dev}_disk_size
   d_size=${!d_size_var}

   if [ -z "$d_size" ]; then
       log_msg "Disk size not specified for $d_dev. Exiting." 	
       exit 1
   fi

   # if disk type is specified it use it.
   disk_type_var=${d_dev}_disk_type
   disk_type=${!disk_type_var}

   if [ -n "$disk_type" ]; then
       d_type=$disk_type
   fi

   log_msg "create_disk $d_type $d_name $d_size "
   create_disk $d_type $d_name $d_size 
done
unset frag d_type d_name d_dev d_mode d_size_var d_size d_create_var d_create

# fetch the kernel and ramdisk 
#$MKDIR -p `dirname $kernel`
#$MKDIR -p `dirname $ramdisk`

#fetch_file $kernel_src $kernel
#if [ ! "$?" = "0" ]; then
#   log_msg "Error getting kernel $kernel_src to $kernel" 
#   exit 1
#fi

#fetch_file $ramdisk_src $ramdisk
#if [ ! "$?" = "0" ]; then
#   log_msg "Error getting ramdisk $ramdisk_src to $ramdisk" 
#   exit 1
#fi

log_msg "$0 completed."

