/*
 *	xeno_style_images.c
 *
 *	size of old xeno_images.o was 165728/14792 bytes unstripped/stripped
 *	size of new xeno_images.o is 165460/11948 bytes unstripped/stripped
 */

#include "xeno_style_images.h"

typedef enum {
	XENO_STYLE_IMAGE_MASK_CIRCLE_15,
	XENO_STYLE_IMAGE_MASK_CIRCLE_13,
	XENO_STYLE_IMAGE_MASK_CIRCLE_11,
	
	XENO_STYLE_IMAGE_MASK_CIRCLE_7,
	XENO_STYLE_IMAGE_MASK_CIRCLE_6,
	XENO_STYLE_IMAGE_MASK_CIRCLE_5,
	
	XENO_STYLE_IMAGE_MASK_CHECK_7,
	XENO_STYLE_IMAGE_MASK_CHECK_9,
	XENO_STYLE_IMAGE_MASK_CHECK_11,
	
	XENO_STYLE_IMAGE_MASK_NOTEBOOK_CORNER,
	XENO_STYLE_IMAGE_MASK_NOTEBOOK_TAB,
	
	XENO_STYLE_IMAGE_MASK_DIMPLE,
	
	XENO_STYLE_IMAGE_MASK_TRIANGLE,
	
	XENO_STYLE_IMAGE_MASK_LAST,
	
	XENO_STYLE_IMAGE_MASK_NONE,
} XenoStyleImageMaskType;

typedef struct {
	XenoImage				images[4];			/* one for each thickness: 0..4 */
	gushort					width;
	gushort					height;
	XenoPenType				bg_pen_type;
	XenoStateType			state_type;
	XenoStyleImageMaskType	mask_type;
} XenoStyleImage;

typedef struct {
	const XenoStyleImage	*variants;
	guchar					n_variants;
	
	GtkShadowType			shadow_type;
	GtkStateType			state_type;
} XenoStyleImageSet;

typedef struct {
	guint8	pen_type, state_type;
} XenoShadowPen;

typedef XenoShadowPen	XenoShadowRing[3];

typedef struct {
	guint8			thickness;
	XenoShadowRing	rings[3];
} XenoShadowData;

typedef struct {
	guint8			thin;
	XenoShadowRing	thin_ring[1];
	
	guint8			medium;
	XenoShadowRing	medium_ring[2];
	
	guint8			thick;
	XenoShadowRing	thick_ring[3];
	
	gint			max_thickness;
} XenoShadowSet;


/*
 *	Radio buttons
 *
 *	top15,bot15 .. top7,bot7
 *	base11, base9, base7				base9 is made for bg6
 *	bg11, bg9, bg7, bg6, bg5			bg6 is 7x7 pixels, but extends half pixels
 *	
 *	Unusual combinations of size and thickness may use top/bot combinations instead of
 *	base or bg. This is to save memory. We already use a few K.
 */

/* Alpha */
const static guchar circle_top15_alpha[15*15] = {
	0x00,0x00,0x00,0x04,0x5d,0xb8,0xec,0xfa,0xd6,0x97,0x44,0x02,0x00,0x00,0x00,
	0x00,0x00,0x27,0xd0,0xbe,0x53,0x16,0x00,0x00,0x1e,0x72,0x82,0x15,0x00,0x00,
	0x00,0x27,0xe6,0x64,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x71,0x11,0x00,
	0x04,0xd0,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4d,0x01,
	0x5d,0xbe,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,0x18,
	0xb8,0x53,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
	0xec,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,
	0xfa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
	0xd6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x97,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x44,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x15,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x11,0x4d,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x01,0x18,0x20,0x14,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const static guchar circle_bot15_alpha[15*15] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x15,0x21,0x18,0x01,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x4e,0x11,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x71,0x16,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x83,0x02,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x73,0x45,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x97,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd7,
	0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfa,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0xec,
	0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x53,0xb8,
	0x18,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xbe,0x5d,
	0x01,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0xd0,0x04,
	0x00,0x11,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x64,0xe6,0x27,0x00,
	0x00,0x00,0x16,0x83,0x73,0x1f,0x00,0x00,0x16,0x53,0xbe,0xd0,0x27,0x00,0x00,
	0x00,0x00,0x00,0x02,0x45,0x97,0xd7,0xfa,0xec,0xb8,0x5d,0x04,0x00,0x00,0x00
};

const static guchar circle_top13_alpha[13*13] = {
	0x00,0x00,0x00,0x41,0xac,0xe9,0xf9,0xd0,0x88,0x2e,0x00,0x00,0x00,
	0x00,0x04,0x9b,0xdb,0x63,0x1a,0x00,0x00,0x24,0x83,0x58,0x02,0x00,
	0x00,0x9b,0xb5,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x35,0x42,0x00,
	0x41,0xdb,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x13,
	0xac,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x23,
	0xe9,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,
	0xf9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
	0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x88,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x2e,0x83,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x58,0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x02,0x42,0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x13,0x23,0x17,0x03,0x00,0x00,0x00,0x00,0x00,0x00
};

const static guchar circle_bot13_alpha[13*13] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x18,0x23,0x13,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x35,0x43,0x02,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x35,0x58,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0x2e,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x89,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd1,
	0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfa,
	0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1a,0xe9,
	0x23,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x63,0xac,
	0x13,0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0xdb,0x41,
	0x00,0x43,0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0xb5,0x9b,0x00,
	0x00,0x02,0x58,0x84,0x25,0x00,0x00,0x1a,0x63,0xdb,0x9b,0x04,0x00,
	0x00,0x00,0x00,0x2e,0x89,0xd1,0xfa,0xe9,0xac,0x41,0x00,0x00,0x00
};

const static guchar circle_top11_alpha[11*11] = {
	0x00,0x00,0x23,0x9c,0xe5,0xf8,0xc8,0x75,0x17,0x00,0x00,
	0x00,0x4a,0xea,0x7b,0x20,0x00,0x00,0x2f,0x85,0x25,0x00,
	0x23,0xea,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x59,0x0b,
	0x9c,0x7b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,
	0xe5,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,
	0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
	0xc8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x75,0x2f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x17,0x85,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x25,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0b,0x25,0x1c,0x03,0x00,0x00,0x00,0x00,0x00
};

const static guchar circle_bot11_alpha[11*11] = {
	0x00,0x00,0x00,0x00,0x00,0x04,0x1d,0x26,0x0c,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5a,0x25,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x86,0x17,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x76,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc9,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,
	0x1d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xe5,
	0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7b,0x9c,
	0x0c,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,0x36,0xea,0x23,
	0x00,0x25,0x86,0x30,0x00,0x00,0x20,0x7b,0xea,0x4a,0x00,
	0x00,0x00,0x17,0x76,0xc9,0xf9,0xe5,0x9c,0x23,0x00,0x00
};

const static guchar circle_top9_alpha[9*9] = {
	0x00,0x0a,0x84,0xdf,0xf7,0xbc,0x5c,0x06,0x00,
	0x0a,0xc9,0xa6,0x29,0x00,0x00,0x46,0x64,0x04,
	0x84,0xa6,0x01,0x00,0x00,0x00,0x00,0x05,0x27,
	0xdf,0x29,0x00,0x00,0x00,0x00,0x00,0x00,0x22,
	0xf7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,
	0xbc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x5c,0x46,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x06,0x64,0x05,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x04,0x27,0x22,0x04,0x00,0x00,0x00,0x00
};

const static guchar circle_bot9_alpha[9*9] = {
	0x00,0x00,0x00,0x00,0x05,0x23,0x27,0x04,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x65,0x06,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x47,0x5c,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xbd,
	0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf7,
	0x23,0x00,0x00,0x00,0x00,0x00,0x00,0x29,0xdf,
	0x27,0x06,0x00,0x00,0x00,0x00,0x01,0xa6,0x84,
	0x04,0x65,0x47,0x00,0x00,0x29,0xa6,0xc9,0x0a,
	0x00,0x06,0x5c,0xbd,0xf7,0xdf,0x84,0x0a,0x00
};

const static guchar circle_top7_alpha[7*7] = {
	0x00,0x59,0xd6,0xf5,0xaa,0x37,0x00,
	0x59,0xdc,0x3b,0x00,0x00,0x5c,0x21,
	0xd6,0x3b,0x00,0x00,0x00,0x00,0x2b,
	0xf5,0x00,0x00,0x00,0x00,0x00,0x06,
	0xaa,0x00,0x00,0x00,0x00,0x00,0x00,
	0x37,0x5c,0x00,0x00,0x00,0x00,0x00,
	0x00,0x21,0x2b,0x06,0x00,0x00,0x00
};

const static guchar circle_bot7_alpha[7*7] = {
	0x00,0x00,0x00,0x06,0x2c,0x21,0x00,
	0x00,0x00,0x00,0x00,0x00,0x5d,0x38,
	0x00,0x00,0x00,0x00,0x00,0x00,0xaa,
	0x06,0x00,0x00,0x00,0x00,0x00,0xf5,
	0x2c,0x00,0x00,0x00,0x00,0x3b,0xd6,
	0x21,0x5d,0x00,0x00,0x3b,0xdc,0x59,
	0x00,0x38,0xaa,0xf5,0xd6,0x59,0x00
};

const static guchar circle_ring11_alpha[11*11] = {
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00,
	0x00,0x4a,0xea,0x7b,0x20,0x03,0x20,0x7b,0xea,0x4a,0x00,
	0x23,0xea,0x36,0x00,0x00,0x00,0x00,0x00,0x36,0xea,0x23,
	0x9c,0x7b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7b,0x9c,
	0xe5,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xe5,
	0xfd,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xfd,
	0xe5,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xe5,
	0x9c,0x7b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7b,0x9c,
	0x23,0xea,0x36,0x00,0x00,0x00,0x00,0x00,0x36,0xea,0x23,
	0x00,0x4a,0xea,0x7b,0x20,0x03,0x20,0x7b,0xea,0x4a,0x00,
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00
};

const static guchar circle_ring9_6_alpha[9*9] = {
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00,
	0x0a,0xc9,0xfd,0xb0,0x83,0xb0,0xfd,0xc9,0x0a,
	0x84,0xfd,0x4e,0x00,0x00,0x00,0x4e,0xfd,0x84,
	0xdf,0xb0,0x00,0x00,0x00,0x00,0x00,0xb0,0xdf,
	0xfc,0x83,0x00,0x00,0x00,0x00,0x00,0x83,0xfc,
	0xdf,0xb0,0x00,0x00,0x00,0x00,0x00,0xb0,0xdf,
	0x84,0xfd,0x4e,0x00,0x00,0x00,0x4e,0xfd,0x84,
	0x0a,0xc9,0xfd,0xb0,0x83,0xb0,0xfd,0xc9,0x0a,
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00
};

const static guchar circle_ring7_alpha[7*7] = {
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00,
	0x59,0xdc,0x3b,0x05,0x3b,0xdc,0x59,
	0xd6,0x3b,0x00,0x00,0x00,0x3b,0xd6,
	0xfb,0x05,0x00,0x00,0x00,0x05,0xfb,
	0xd6,0x3b,0x00,0x00,0x00,0x3b,0xd6,
	0x59,0xdc,0x3b,0x05,0x3b,0xdc,0x59,
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00
};

const static guchar circle_solid11_alpha[11*11] = {
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00,
	0x00,0x4a,0xf4,0xff,0xff,0xff,0xff,0xff,0xf4,0x4a,0x00,
	0x23,0xf4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf4,0x23,
	0x9c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9c,
	0xe5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe5,
	0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,
	0xe5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe5,
	0x9c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9c,
	0x23,0xf4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf4,0x23,
	0x00,0x4a,0xf4,0xff,0xff,0xff,0xff,0xff,0xf4,0x4a,0x00,
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00
};

const static guchar circle_solid9_alpha[9*9] = {
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00,
	0x0a,0xc9,0xff,0xff,0xff,0xff,0xff,0xc9,0x0a,
	0x84,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x84,
	0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,
	0xfc,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfc,
	0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,
	0x84,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x84,
	0x0a,0xc9,0xff,0xff,0xff,0xff,0xff,0xc9,0x0a,
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00
};

const static guchar circle_solid7_alpha[7*7] = {
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00,
	0x59,0xfe,0xff,0xff,0xff,0xfe,0x59,
	0xd6,0xff,0xff,0xff,0xff,0xff,0xd6,
	0xfb,0xff,0xff,0xff,0xff,0xff,0xfb,
	0xd6,0xff,0xff,0xff,0xff,0xff,0xd6,
	0x59,0xfe,0xff,0xff,0xff,0xfe,0x59,
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00
};

const static guchar circle_solid7_6_alpha[7*7] = {
	0x00,0x02,0x4f,0x7c,0x4f,0x02,0x00,
	0x02,0xb1,0xff,0xff,0xff,0xb1,0x02,
	0x4f,0xff,0xff,0xff,0xff,0xff,0x4f,
	0x7c,0xff,0xff,0xff,0xff,0xff,0x7c,
	0x4f,0xff,0xff,0xff,0xff,0xff,0x4f,
	0x02,0xb1,0xff,0xff,0xff,0xb1,0x02,
	0x00,0x02,0x4f,0x7c,0x4f,0x02,0x00
};

const static guchar circle_solid6_alpha[6*6] = {
	0x07,0x92,0xf0,0xf0,0x92,0x07,
	0x92,0xff,0xff,0xff,0xff,0x92,
	0xf0,0xff,0xff,0xff,0xff,0xf0,
	0xf0,0xff,0xff,0xff,0xff,0xf0,
	0x92,0xff,0xff,0xff,0xff,0x92,
	0x07,0x92,0xf0,0xf0,0x92,0x07
};

const static guchar circle_solid5_alpha[5*5] = {
	0x22,0xc4,0xfa,0xc4,0x22,
	0xc4,0xff,0xff,0xff,0xc4,
	0xfa,0xff,0xff,0xff,0xfa,
	0xc4,0xff,0xff,0xff,0xc4,
	0x22,0xc4,0xfa,0xc4,0x22
};

/* Bitmap */
const static guchar circle_top15_bitmap[2*15] = {
	0x07,0xc0,
	0x18,0x30,
	0x20,0x00,
	0x40,0x00,
	0x40,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x40,0x00,
	0x40,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00
};
const static guchar circle_bot15_bitmap[2*15] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x04,
	0x00,0x04,
	0x00,0x02,
	0x00,0x02,
	0x00,0x02,
	0x00,0x02,
	0x00,0x02,
	0x00,0x04,
	0x00,0x04,
	0x00,0x08,
	0x18,0x30,
	0x07,0xc0
};
const static guchar circle_mid15_bitmap[2*15] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x80,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x20,0x00,
	0x00,0x00,
	0x00,0x00
};

const static guchar circle_top13_bitmap[2*13] = {
	0x0f,0x80,
	0x30,0x60,
	0x40,0x00,
	0x40,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x40,0x00,
	0x40,0x00,
	0x00,0x00,
	0x00,0x00
};
const static guchar circle_bot13_bitmap[2*13] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x10,
	0x00,0x10,
	0x00,0x08,
	0x00,0x08,
	0x00,0x08,
	0x00,0x08,
	0x00,0x08,
	0x00,0x10,
	0x00,0x10,
	0x30,0x60,
	0x0f,0x80
};
const static guchar circle_mid13_bitmap[2*13] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00
};
const static guchar circle_ring13_bitmap[2*13] = {
	0x0f,0x80,
	0x30,0x60,
	0x40,0x10,
	0x40,0x10,
	0x80,0x08,
	0x80,0x08,
	0x80,0x08,
	0x80,0x08,
	0x80,0x08,
	0x40,0x10,
	0x40,0x10,
	0x30,0x60,
	0x0f,0x80
};

const static guchar circle_top11_bitmap[2*11] = {
	0x1f,0x00,
	0x60,0x80,
	0x40,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x40,0x00,
	0x00,0x00,
	0x00,0x00
};
const static guchar circle_bot11_bitmap[2*11] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x40,
	0x00,0x20,
	0x00,0x20,
	0x00,0x20,
	0x00,0x20,
	0x00,0x20,
	0x00,0x40,
	0x20,0xc0,
	0x1f,0x00
};
const static guchar circle_mid11_bitmap[2*11] = {
	0x00,0x00,
	0x00,0x40,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x40,0x00,
	0x00,0x00
};
const static guchar circle_ring11_bitmap[2*11] = {
	0x1f,0x00,
	0x60,0xc0,
	0x40,0x40,
	0x80,0x20,
	0x80,0x20,
	0x80,0x20,
	0x80,0x20,
	0x80,0x20,
	0x40,0x40,
	0x60,0xc0,
	0x1f,0x00
};
const static guchar circle_solid11_bitmap[2*11] = {
	0x1f,0x00,
	0x7f,0xc0,
	0x7f,0xc0,
	0xff,0xe0,
	0xff,0xe0,
	0xff,0xe0,
	0xff,0xe0,
	0xff,0xe0,
	0x7f,0xc0,
	0x7f,0xc0,
	0x1f,0x00
};

const static guchar circle_top9_bitmap[2*9] = {
	0x3e,0x00,
	0x40,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x80,0x00,
	0x00,0x00,
	0x00,0x00
};
const static guchar circle_bot9_bitmap[2*9] = {
	0x00,0x00,
	0x00,0x00,
	0x00,0x80,
	0x00,0x80,
	0x00,0x80,
	0x00,0x80,
	0x00,0x80,
	0x01,0x00,
	0x3e,0x00
};
const static guchar circle_mid9_bitmap[2*9] = {
	0x00,0x00,
	0x01,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x00,0x00,
	0x40,0x00,
	0x00,0x00
};
const static guchar circle_ring9_bitmap[2*9] = {
	0x3e,0x00,
	0x41,0x00,
	0x80,0x80,
	0x80,0x80,
	0x80,0x80,
	0x80,0x80,
	0x80,0x80,
	0x41,0x00,
	0x3e,0x00
};
const static guchar circle_solid9_bitmap[2*9] = {
	0x3e,0x00,
	0x7f,0x00,
	0xff,0x80,
	0xff,0x80,
	0xff,0x80,
	0xff,0x80,
	0xff,0x80,
	0x7f,0x00,
	0x3e,0x00
};

const static guchar circle_top7_bitmap[7] = {
	0x78,
	0xc0,
	0x80,
	0x80,
	0x80,
	0x00,
	0x00
};
const static guchar circle_bot7_bitmap[7] = {
	0x00,
	0x00,
	0x02,
	0x02,
	0x02,
	0x06,
	0x3c
};
const static guchar circle_mid7_bitmap[7] = {
	0x04,
	0x06,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x40
};
const static guchar circle_ring7_bitmap[7] = {
	0x7c,
	0xc6,
	0x82,
	0x82,
	0x82,
	0xc6,
	0x7c
};
const static guchar circle_solid7_bitmap[7] = {
	0x7c,
	0xfe,
	0xfe,
	0xfe,
	0xfe,
	0xfe,
	0x7c
};
const static guchar circle_solid6_bitmap[6] = {
	0x78,
	0xfc,
	0xfc,
	0xfc,
	0xfc,
	0x78
};

const static guchar circle_ring9_5_bitmap[2*9] = {
	0x3e,0x00,
	0x7f,0x00,
	0xe3,0x80,
	0xc1,0x80,
	0xc1,0x80,
	0xc1,0x80,
	0xe3,0x80,
	0x7f,0x00,
	0x3e,0x00
};
const static guchar circle_solid7_5_bitmap[7] = {
	0x00,
	0x38,
	0x7c,
	0x7c,
	0x7c,
	0x38,
	0x00
};
const static guchar circle_solid5_bitmap[5] = {
	0x70,
	0xf8,
	0xf8,
	0xf8,
	0x70
};


/* Radio button layers size 15 */
const static XenoImageLayer radio_bg15_3_layers[10] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_top13_bitmap,	1,1,13,13,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	1,1,13,13,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	1,1,13,13,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	2,2,11,11,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	2,2,11,11,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	2,2,11,11,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_solid9_alpha,	circle_solid9_bitmap,	3,3,9,9,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base15_3_layers[11] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_top13_bitmap,	1,1,13,13,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	1,1,13,13,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	1,1,13,13,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	2,2,11,11,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	2,2,11,11,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	2,2,11,11,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	3,3,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	4,4,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg15_2_layers[7] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_top13_bitmap,	1,1,13,13,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	1,1,13,13,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	1,1,13,13,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_solid11_alpha,	circle_solid11_bitmap,	2,2,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base15_2_layers[9] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_top13_bitmap,	1,1,13,13,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	1,1,13,13,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	1,1,13,13,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_ring11_alpha,	circle_ring11_bitmap,	2,2,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	3,3,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	4,4,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg15_1_layers[6] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_ring13_bitmap,	1,1,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					1,1,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_solid11_alpha,	circle_ring11_bitmap,	2,2,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base15_1_layers[7] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_ring13_bitmap,	1,1,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					1,1,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring11_alpha,	circle_ring11_bitmap,	2,2,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid9_alpha,	circle_solid9_bitmap,	3,3,9,9,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg15_0_layers[6] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_ring13_bitmap,	1,1,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					1,1,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_solid11_alpha,	circle_solid11_bitmap,	2,2,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base15_0_layers[7] = {
	{ circle_top15_alpha,	circle_top15_bitmap,	0,0,15,15,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_bot15_alpha,	circle_bot15_bitmap,	0,0,15,15,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ NULL,					circle_mid15_bitmap,	0,0,15,15,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_top13_alpha,	circle_ring13_bitmap,	1,1,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					1,1,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring11_alpha,	circle_ring11_bitmap,	2,2,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid9_alpha,	circle_solid9_bitmap,	3,3,9,9,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

/* Radio button layers size 13 */
const static XenoImageLayer radio_bg13_3_layers[10] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	1,1,11,11,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		2,2,9,9,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		2,2,9,9,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		2,2,9,9,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_solid7_alpha,	circle_solid7_bitmap,	3,3,7,7,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base13_3_layers[11] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	1,1,11,11,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		2,2,9,9,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		2,2,9,9,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		2,2,9,9,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_ring7_alpha,	circle_ring7_bitmap,	3,3,7,7,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid5_alpha,	circle_solid5_bitmap,	4,4,5,5,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg13_2_layers[7] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	1,1,11,11,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_solid9_alpha,	circle_solid9_bitmap,	2,2,9,9,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base13_2_layers[8] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,	circle_top11_bitmap,	1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	1,1,11,11,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	2,2,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	3,3,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg13_1_layers[4] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_solid11_alpha,	circle_solid11_bitmap,	1,1,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base13_1_layers[6] = {
	{ circle_top13_alpha,	circle_top13_bitmap,	0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	circle_bot13_bitmap,	0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid13_bitmap,	0,0,13,13,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_ring11_alpha,	circle_ring11_bitmap,	1,1,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	2,2,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	3,3,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg13_0_layers[3] = {
	{ circle_top13_alpha,	circle_ring13_bitmap,	0,0,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					0,0,13,13,	XENO_PEN_BG,  XENO_STATE_CURRENT },
	{ circle_solid11_alpha,	circle_solid11_bitmap,	1,1,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base13_0_layers[5] = {
	{ circle_top13_alpha,	circle_ring13_bitmap,	0,0,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,	NULL,					0,0,13,13,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring11_alpha,	circle_ring11_bitmap,	1,1,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	2,2,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	3,3,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

/* Radio button layers size 11 */
const static XenoImageLayer radio_bg11_3_layers[10] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		1,1,9,9,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		1,1,9,9,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		1,1,9,9,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top7_alpha,	circle_top7_bitmap,		2,2,7,7,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot7_alpha,	circle_bot7_bitmap,		2,2,7,7,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid7_bitmap,		2,2,7,7,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_solid5_alpha,	circle_solid5_bitmap,	3,3,5,5,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base11_3_layers[10] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		1,1,9,9,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		1,1,9,9,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		1,1,9,9,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_top7_alpha,	circle_top7_bitmap,		2,2,7,7,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot7_alpha,	circle_bot7_bitmap,		2,2,7,7,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ NULL,					circle_mid7_bitmap,		2,2,7,7,	XENO_PEN_MID2,XENO_STATE_CURRENT },
	{ circle_solid5_alpha,	circle_solid5_bitmap,	3,3,5,5,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg11_2_layers[7] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		1,1,9,9,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		1,1,9,9,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		1,1,9,9,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_solid7_alpha,	circle_solid7_bitmap,	2,2,7,7,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base11_2_layers[8] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_top9_alpha,	circle_top9_bitmap,		1,1,9,9,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,	circle_bot9_bitmap,		1,1,9,9,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ NULL,					circle_mid9_bitmap,		1,1,9,9,	XENO_PEN_MID1,XENO_STATE_CURRENT },
	{ circle_ring7_alpha,	circle_ring7_bitmap,	2,2,7,7,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid5_alpha,	circle_solid5_bitmap,	3,3,5,5,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg11_1_layers[4] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_solid9_alpha,	circle_solid9_bitmap,	1,1,9,9,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base11_1_layers[5] = {
	{ circle_top11_alpha,	circle_top11_bitmap,	0,0,11,11,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,	circle_bot11_bitmap,	0,0,11,11,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ NULL,					circle_mid11_bitmap,	0,0,11,11,	XENO_PEN_MID0,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	1,1,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	2,2,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};

const static XenoImageLayer radio_bg11_0_layers[1] = {
	{ circle_solid11_alpha,	circle_solid11_bitmap,	0,0,11,11,	XENO_PEN_BG,  XENO_STATE_CURRENT }
};
const static XenoImageLayer radio_base11_0_layers[3] = {
	{ circle_ring11_alpha,	circle_ring11_bitmap,	0,0,11,11,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_ring9_6_alpha,	circle_ring9_5_bitmap,	1,1,9,9,	XENO_PEN_BASE,XENO_STATE_CURRENT },
	{ circle_solid7_6_alpha,circle_solid7_5_bitmap,	2,2,7,7,	XENO_PEN_BASE,XENO_STATE_SELECTED }
};


/* Radio button images */
const static XenoStyleImage radio_bg_images[3] = {
	{
		{
		  { radio_bg11_0_layers,1,	11,11 },
		  { radio_bg11_1_layers,4,	11,11 },
		  { radio_bg11_2_layers,7,	11,11 },
		  { radio_bg11_3_layers,10,	11,11 }
		},
		11, 11,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_11
	}, {
		{
		  {	radio_bg13_0_layers,3,	13,13 },
		  {	radio_bg13_1_layers,4,	13,13 },
		  { radio_bg13_2_layers,7,	13,13 },
		  { radio_bg13_3_layers,10,	13,13 }
		},
		13, 13,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_13
	}, {
		{
		  {	radio_bg15_0_layers,6,	15,15 },
		  {	radio_bg15_1_layers,6,	15,15 },
		  { radio_bg15_2_layers,7,	15,15 },
		  { radio_bg15_3_layers,10,	15,15 }
		},
		15, 15,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_15
	}
};

const static XenoStyleImage radio_base_images[3] = {
	{
		{
		  { radio_base11_0_layers,3, 11,11 },
		  { radio_base11_1_layers,5, 11,11 },
		  { radio_base11_2_layers,8, 11,11 },
		  { radio_base11_3_layers,10,11,11 }
		},
		11, 11,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_11
	}, {
		{
		  {	radio_base13_0_layers,5, 13,13 },
		  {	radio_base13_1_layers,6, 13,13 },
		  { radio_base13_2_layers,8, 13,13 },
		  { radio_base13_3_layers,11,13,13 }
		},
		13, 13,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_13
	}, {
		{
		  {	radio_base15_0_layers,7, 15,15 },
		  {	radio_base15_1_layers,7, 15,15 },
		  { radio_base15_2_layers,9, 15,15 },
		  { radio_base15_3_layers,11,15,15 }
		},
		15, 15,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_CIRCLE_15
	}
};


/*
 *	Radio menu item
 */

const static XenoImageLayer radio_item7_layers[1] = {
	{ circle_solid7_alpha,	circle_solid7_bitmap,	0,0,7,7, XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoImageLayer radio_item6_layers[1] = {
	{ circle_solid6_alpha,	circle_solid6_bitmap,	0,0,6,6, XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoImageLayer radio_item5_layers[1] = {
	{ circle_solid5_alpha,	circle_solid5_bitmap,	0,0,5,5, XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoStyleImage radio_item_images[3] = {
	{
		{
		  {	radio_item5_layers,1, 5,5 },
		  {	radio_item5_layers,1, 5,5 },
		  {	radio_item5_layers,1, 5,5 },
		  {	radio_item5_layers,1, 5,5 }
		},
		5, 5,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CIRCLE_5
	}, {
		{
		  {	radio_item6_layers,1, 6,6 },
		  {	radio_item6_layers,1, 6,6 },
		  {	radio_item6_layers,1, 6,6 },
		  {	radio_item6_layers,1, 6,6 }
		},
		6, 6,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CIRCLE_6
	}, {
		{
		  {	radio_item7_layers,1, 7,7 },
		  {	radio_item7_layers,1, 7,7 },
		  {	radio_item7_layers,1, 7,7 },
		  {	radio_item7_layers,1, 7,7 }
		},
		7, 7,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CIRCLE_7
	}
};


/*
 *	Checkmarks
 */

const static guchar check7_alpha[7*7] = {
	0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,
	0x00,0x00,0x00,0x00,0x7f,0xff,0x00,
	0x00,0x00,0x00,0x40,0xff,0x40,0x00,
	0x00,0x00,0x00,0xc0,0xc0,0x00,0x00,
	0xc0,0xc0,0x7f,0xff,0x40,0x00,0x00,
	0x40,0xff,0xff,0xc0,0x00,0x00,0x00,
	0x00,0x7f,0xff,0x40,0x00,0x00,0x00
};

const static guchar check9_alpha[9*9] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x40,
	0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0x7f,0x00,
	0x00,0x00,0x00,0x00,0x55,0xff,0xc0,0x00,0x00,
	0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,
	0xff,0xc0,0x00,0xff,0xff,0x7f,0x00,0x00,0x00,
	0xc0,0xff,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,
	0x55,0xff,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,
	0x00,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0x00
};

const static guchar check11_alpha[11*11] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0xff,0xff,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x40,0xff,0xc0,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x40,0xff,0x7f,0x00,0x00,0x00,0x00,
	0xc0,0xff,0x40,0x00,0xc0,0xff,0x00,0x00,0x00,0x00,0x00,
	0xc0,0xff,0xff,0x7f,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,
	0x00,0xc0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xc0,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00
};

const static guchar check7_bitmap[7] = {
	0x02, 0x06, 0x0c, 0x58, 0x70, 0x60, 0x40
};

const static guchar check_fg9_bitmap[2*9] = {
	0x00,0x80,
	0x01,0x80,
	0x03,0x00,
	0x06,0x00,
	0x4c,0x00,
	0x58,0x00,
	0x70,0x00,
	0x60,0x00,
	0x40,0x00
};
const static guchar check_in9_bitmap[7] = {
	0x02, 0x04, 0x88, 0x90, 0x20, 0x40, 0x80
};

const static guchar check11_bitmap[2*11] = {
	0x00,0x40,
	0x00,0xc0,
	0x01,0xc0,
	0x03,0x80,
	0x67,0x00,
	0x6e,0x00,
	0x7c,0x00,
	0x78,0x00,
	0x70,0x00,
	0x60,0x00,
	0x40,0x00
};



const static XenoImageLayer check7_layer[1] = {
	{ check7_alpha,	check7_bitmap,	0,0,7,7,	XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoImageLayer check9_layers[2] = {
	{ check9_alpha,	check_fg9_bitmap,	0,0,9,9,	XENO_PEN_FG,XENO_STATE_CURRENT },
	{ NULL,			check_in9_bitmap,	2,2,7,7,	XENO_PEN_FG,XENO_STATE_INSENSITIVE }
};

const static XenoImageLayer check11_layer[1] = {
	{ check11_alpha,check11_bitmap,		0,0,11,11,	XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoStyleImage check_base_images[3] = {
	{
		{
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 }
		},
		7, 7,
		XENO_PEN_BASE,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_7
	}, {
		{
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 }
		},
		9, 9,
		XENO_PEN_BASE,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_9
	}, {
		{
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 }
		},
		11, 11,
		XENO_PEN_BASE,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_11
	}
};

const static XenoStyleImage check_bg_images[3] = {
	{
		{
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 },
		  {	check7_layer,1, 7,7 }
		},
		7, 7,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_7
	}, {
		{
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 },
		  {	check9_layers,2, 9,9 }
		},
		9, 9,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_9
	}, {
		{
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 },
		  {	check11_layer,1, 11,11 }
		},
		11, 11,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_CHECK_11
	}
};


/*
 *	Notebook tab corners and edges
 *
 *	There are four types of lines, slope 1:3 (angle == arctan(1/3))
 *	at each pixel row, a pixel thin 1:3-sloping line spans 1.05409255339 pixels
 *	
 *	xfacing	strength			 line sum	pixel sum
 *	nw		1.0					0x10c		0xff
 *	ne		arctan(1/3) / (pi/2) 0x37		0x35
 *	sw		1.0 - ne			0xd5		0xca
 *	se		0.0					0x00		0x00
 *
 */

const static guchar notebook_corner_bg0_alpha[13*13] = {
	0x00,0x00,0x00,0x41,0xac,0xe9,0xf9,0xe9,0xac,0x41,0x00,0x00,0x00,
	0x00,0x04,0x9b,0xfe,0xff,0x00,0x00,0x00,0xff,0xfe,0x9b,0x04,0x00,
	0x00,0x9b,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x9b,0x00,
	0x41,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x41,
	0xac,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xac,
	0xe9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,
	0xf9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf9,
	0xe9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe9,
	0xac,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xac,
	0x41,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x41,
	0x00,0x9b,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x9b,0x00,
	0x00,0x04,0x9b,0xfe,0xff,0x00,0x00,0x00,0xff,0xfe,0x9b,0x04,0x00,
	0x00,0x00,0x00,0x41,0xac,0xe9,0xf9,0xe9,0xac,0x41,0x00,0x00,0x00,
};

const static guchar notebook_corner_bg1_alpha[11*11] = {
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00,
	0x00,0x4a,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x4a,0x00,
	0x23,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x23,
	0x9c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9c,
	0xe5,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,
	0xfd,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfd,
	0xe5,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,
	0x9c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9c,
	0x23,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x23,
	0x00,0x4a,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x4a,0x00,
	0x00,0x00,0x23,0x9c,0xe5,0xfd,0xe5,0x9c,0x23,0x00,0x00
};

const static guchar notebook_corner_bg2_alpha[9*9] = {
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00,
	0x0a,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x0a,
	0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,
	0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,
	0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,
	0xdf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,
	0x84,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,
	0x0a,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0x0a,
	0x00,0x0a,0x84,0xdf,0xfc,0xdf,0x84,0x0a,0x00
};

const static guchar notebook_corner_bg3_alpha[7*7] = {
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00,
	0x59,0xff,0x00,0x00,0x00,0xff,0x59,
	0xd6,0x00,0x00,0x00,0x00,0x00,0xd6,
	0xfb,0x00,0x00,0x00,0x00,0x00,0xfb,
	0xd6,0x00,0x00,0x00,0x00,0x00,0xd6,
	0x59,0xff,0x00,0x00,0x00,0xff,0x59,
	0x00,0x59,0xd6,0xfb,0xd6,0x59,0x00
};

#if XENO_CONFIG_TRIANGULAR_TABS
const static guchar notebook_edge_bg0_alpha[12*12] = {
	0x00,0x55,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x55,0x00,
	0x00,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xaa,0x00,
	0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,
	0x55,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x55,
	0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xaa,
	0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
																 
	0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
	0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xaa,
	0x55,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x55,
	0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,
	0x00,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xaa,0x00,
	0x00,0x55,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x55,0x00
};
const static guchar notebook_edge_top0_alpha[12*12] = {
	0x00,0x55,0xb7,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x11,0x00,
	0x00,0xaa,0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x24,0x00,
	0x00,0xff,0x0d,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x35,0x00,
	0x55,0xb7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x11,
	0xaa,0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x24,
	0xff,0x0d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x35,
	
	0xca,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x86,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x44,0x91,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xca,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x86,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x44,0x91,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const static guchar notebook_edge_bot0_alpha[12*12] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x91,0x44,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4f,0x86,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0xca,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x91,0x44,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4f,0x86,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0xca,

	0x35,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0xff,
	0x24,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x62,0xaa,
	0x11,0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb7,0x55,
	0x00,0x35,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0xff,0x00,
	0x00,0x24,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x62,0xaa,0x00,
	0x00,0x11,0x26,0x00,0x00,0x00,0x00,0x00,0x00,0xb7,0x55,0x00
};                                                               

const static guchar notebook_edge_bg1_alpha[10*12] = {
	0x00,0x48,0xff,0x00,0x00,0x00,0x00,0xff,0x48,0x00,
	0x00,0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,0x00,
	0x00,0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0xf2,0x00,
	0x48,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x48,
	0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,
	0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf2,
	   												     
	0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf2,
	0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,
	0x48,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x48,
	0x00,0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0xf2,0x00,
	0x00,0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,0x00,
	0x00,0x48,0xff,0x00,0x00,0x00,0x00,0xff,0x48,0x00
};
const static guchar notebook_edge_top1_alpha[10*12] = {
	0x00,0x48,0xc4,0x00,0x00,0x00,0x00,0x28,0x0f,0x00,
	0x00,0x9d,0x5f,0x00,0x00,0x00,0x00,0x15,0x22,0x00,
	0x00,0xf2,0x1a,0x00,0x00,0x00,0x00,0x04,0x33,0x00,
	0x48,0xc4,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x0f,
	0x9d,0x6f,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0x22,
	0xf2,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x33,
	   												    
	0xbf,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7b,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x39,0x9c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xbf,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x7b,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x39,0x9c,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const static guchar notebook_edge_bot1_alpha[10*12] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9c,0x39,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5a,0x7b,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0xbf,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9c,0x39,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5a,0x7b,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0xbf,
	
	0x33,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x1a,0xf2,
	0x22,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x6f,0x9d,
	0x0f,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0xc4,0x48,
	0x00,0x33,0x04,0x00,0x00,0x00,0x00,0x1a,0xf2,0x00,
	0x00,0x22,0x15,0x00,0x00,0x00,0x00,0x5f,0x9d,0x00,
	0x00,0x0f,0x28,0x00,0x00,0x00,0x00,0xc4,0x48,0x00
};

const static guchar notebook_edge_bg2_alpha[8*12] = {
	0x00,0x3b,0xff,0x00,0x00,0xff,0x3b,0x00,
	0x00,0x90,0x00,0x00,0x00,0x00,0x90,0x00,
	0x00,0xe5,0x00,0x00,0x00,0x00,0xe5,0x00,
	0x3b,0xff,0x00,0x00,0x00,0x00,0xff,0x3b,
	0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x90,
	0xe5,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,
	  										  	 
	0xe5,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,
	0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x90,
	0x3b,0xff,0x00,0x00,0x00,0x00,0xff,0x3b,
	0x00,0xe5,0x00,0x00,0x00,0x00,0xe5,0x00,
	0x00,0x90,0x00,0x00,0x00,0x00,0x90,0x00,
	0x00,0x3b,0xff,0x00,0x00,0xff,0x3b,0x00
};
const static guchar notebook_edge_top2_alpha[8*12] = {
	0x00,0x3b,0xd1,0x00,0x00,0x2a,0x0d,0x00,
	0x00,0x90,0x7c,0x00,0x00,0x17,0x20,0x00,
	0x00,0xe5,0x27,0x00,0x00,0x06,0x31,0x00,
	0x3b,0xd1,0x00,0x00,0x00,0x00,0x2a,0x0d,
	0x90,0x7c,0x00,0x00,0x00,0x00,0x17,0x20,
	0xe5,0x27,0x00,0x00,0x00,0x00,0x06,0x31,
	  										   	
	0xb4,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
	0x70,0x65,0x00,0x00,0x00,0x00,0x00,0x00,
	0x2e,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xb4,0x21,0x00,0x00,0x00,0x00,0x00,
	0x00,0x70,0x65,0x00,0x00,0x00,0x00,0x00,
	0x00,0x2e,0xa7,0x00,0x00,0x00,0x00,0x00
};
const static guchar notebook_edge_bot2_alpha[8*12] = {
	0x00,0x00,0x00,0x00,0x00,0xa7,0x2e,0x00,
	0x00,0x00,0x00,0x00,0x00,0x65,0x70,0x00,
	0x00,0x00,0x00,0x00,0x00,0x21,0xb4,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xa7,0x2e,
	0x00,0x00,0x00,0x00,0x00,0x00,0x65,0x70,
	0x00,0x00,0x00,0x00,0x00,0x00,0x21,0xb4,
	
	0x31,0x06,0x00,0x00,0x00,0x00,0x27,0xe5,
	0x20,0x17,0x00,0x00,0x00,0x00,0x7c,0x90,
	0x0d,0x2a,0x00,0x00,0x00,0x00,0xd1,0x3b,
	0x00,0x31,0x06,0x00,0x00,0x27,0xe5,0x00,
	0x00,0x20,0x17,0x00,0x00,0x7c,0x90,0x00,
	0x00,0x0d,0x2a,0x00,0x00,0xd1,0x3b,0x00
};

const static guchar notebook_edge_bg3_alpha[6*12] = {
	0x00,0x2e,0xff,0xff,0x2e,0x00,
	0x00,0x83,0x00,0x00,0x83,0x00,
	0x00,0xd8,0x00,0x00,0xd8,0x00,	
	0x2e,0xff,0x00,0x00,0xff,0x2e,
	0x83,0x00,0x00,0x00,0x00,0x83,
	0xd8,0x00,0x00,0x00,0x00,0xd8,
	
	0xd8,0x00,0x00,0x00,0x00,0xd8,
	0x83,0x00,0x00,0x00,0x00,0x83,
	0x2e,0xff,0x00,0x00,0xff,0x2e,
	0x00,0xd8,0x00,0x00,0xd8,0x00,	
	0x00,0x83,0x00,0x00,0x83,0x00,
	0x00,0x2e,0xff,0xff,0x2e,0x00
};
#endif

const static XenoImageLayer notebook_tab0_layers[] = {
	{ notebook_corner_bg0_alpha,NULL, 0,0,13,13,	XENO_PEN_BG,XENO_STATE_CURRENT },
  #if XENO_CONFIG_TRIANGULAR_TABS
	{ notebook_edge_bg0_alpha,	NULL, 13,0,25,13,	XENO_PEN_BG,XENO_STATE_CURRENT },
  #endif
};
const static XenoImageLayer notebook_tab1_layers[] = {
	{ circle_top13_alpha,		NULL, 0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,		NULL, 0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ notebook_corner_bg1_alpha,NULL, 1,1,11,11,	XENO_PEN_BG,XENO_STATE_CURRENT },
  #if XENO_CONFIG_TRIANGULAR_TABS
	{ notebook_edge_top0_alpha,	NULL, 13,0,12,12,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ notebook_edge_bot0_alpha,	NULL, 13,0,12,12,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ notebook_edge_bg1_alpha,	NULL, 14,0,10,12,	XENO_PEN_BG,XENO_STATE_CURRENT }
  #endif
};
const static XenoImageLayer notebook_tab2_layers[] = {
	{ circle_top13_alpha,		NULL, 0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,		NULL, 0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,		NULL, 1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,		NULL, 1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ notebook_corner_bg2_alpha,NULL, 2,2,9,9,	XENO_PEN_BG,XENO_STATE_CURRENT },
  #if XENO_CONFIG_TRIANGULAR_TABS
	{ notebook_edge_top0_alpha,	NULL, 13,0,12,12,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ notebook_edge_bot0_alpha,	NULL, 13,0,12,12,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ notebook_edge_top1_alpha,	NULL, 14,0,10,12,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ notebook_edge_bot1_alpha,	NULL, 14,0,10,12,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ notebook_edge_bg2_alpha,	NULL, 15,0,8,12,	XENO_PEN_BG,XENO_STATE_CURRENT }
  #endif
};
const static XenoImageLayer notebook_tab3_layers[] = {
	{ circle_top13_alpha,		NULL, 0,0,13,13,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ circle_bot13_alpha,		NULL, 0,0,13,13,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ circle_top11_alpha,		NULL, 1,1,11,11,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ circle_bot11_alpha,		NULL, 1,1,11,11,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ circle_top9_alpha,		NULL, 2,2,9,9,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ circle_bot9_alpha,		NULL, 2,2,9,9,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ notebook_corner_bg3_alpha,NULL, 3,3,7,7,	XENO_PEN_BG,XENO_STATE_CURRENT },
  #if XENO_CONFIG_TRIANGULAR_TABS
	{ notebook_edge_top0_alpha,	NULL, 13,0,12,12,	XENO_PEN_TOP0,XENO_STATE_CURRENT },
	{ notebook_edge_bot0_alpha,	NULL, 13,0,12,12,	XENO_PEN_BOT0,XENO_STATE_CURRENT },
	{ notebook_edge_top1_alpha,	NULL, 14,0,10,12,	XENO_PEN_TOP1,XENO_STATE_CURRENT },
	{ notebook_edge_bot1_alpha,	NULL, 14,0,10,12,	XENO_PEN_BOT1,XENO_STATE_CURRENT },
	{ notebook_edge_top2_alpha,	NULL, 15,0,8,12,	XENO_PEN_TOP2,XENO_STATE_CURRENT },
	{ notebook_edge_bot2_alpha,	NULL, 15,0,8,12,	XENO_PEN_BOT2,XENO_STATE_CURRENT },
	{ notebook_edge_bg3_alpha,	NULL, 16,0,6,12,	XENO_PEN_BG,XENO_STATE_CURRENT }
  #endif
};

const static XenoStyleImage notebook_images[] = {
  #if XENO_CONFIG_TRIANGULAR_TABS
	{
		{
		  {	notebook_tab0_layers,2,	 25,13 },
		  { notebook_tab1_layers,6,  25,13 },
		  { notebook_tab2_layers,10, 25,13 },
		  { notebook_tab3_layers,14, 25,13 }
		},
		25, 13,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_NOTEBOOK_TAB
	}
  #else
	{
		{
		  {	notebook_tab0_layers,1, 13,13 },
		  { notebook_tab1_layers,3, 13,13 },
		  { notebook_tab2_layers,5, 13,13 },
		  { notebook_tab3_layers,7, 13,13 }
		},
		13, 13,
		XENO_PEN_BG|XENO_PEN_PARENT,XENO_STATE_NORMAL,
		XENO_STYLE_IMAGE_MASK_NOTEBOOK_CORNER
	}
  #endif
};


/*
 *	Dimples
 */

const static guchar dimple_in_black_alpha[6*6] = {
	0x07,0x92,0xf0,0xd2,0x5f,0x03,
	0x92,0xf3,0xbd,0x87,0x5e,0x3c,
	0xf0,0xbd,0x7c,0x2b,0x18,0x00,
	0xd2,0x87,0x2b,0x00,0x00,0x1d,
	0x5f,0x5e,0x18,0x00,0x00,0x00,
	0x03,0x3c,0x1d,0x00,0x00,0x00
};

const static guchar dimple_in_white_alpha[4*4] = {
	0x00,0x09,0x12,0x1d,
	0x09,0x36,0x88,0xf0,
	0x12,0x88,0xff,0x92,
	0x1d,0xf0,0x92,0x07
};

/*
concentric circles:
	0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xf3,0xbd,0xab,0xbd,0xf3,
	0xff,0xbd,0x7c,0x57,0x7c,0xff,
	0xff,0xab,0x57,0x00,0x57,0xab,
	0xff,0xbd,0x7c,0x57,0x7c,0xbd,
	0xff,0xf3,0xff,0xab,0xbd,0xf3,

angle:
	0x07,0x92,0xf0,0xd2,0x5f,0x03,
	0x92,0xff,0xff,0xca,0x7f,0x32,
	0xf0,0xff,0xff,0x7f,0x33,0x1d,
	0xd2,0xca,0x7f,0x00,0x00,0x00,
	0x5f,0x7f,0x33,0x00,0x00,0x00,
	0x03,0x32,0x1d,0x00,0x00,0x00

old:
const static guchar dimple_in_black[6*6] = {
	0x00,0x7f,0xff,0xff,0x7f,0x00,
	0x7f,0xff,0xb3,0x8d,0x8d,0x48,
	0xff,0xb3,0x8d,0x55,0x1b,0x1b,
	0xff,0x8d,0x55,0x1b,0x00,0x00,
	0x7f,0x8d,0x1b,0x00,0x00,0x00,
	0x00,0x48,0x1b,0x00,0x00,0x00
};

const static guchar dimple_in_white[3*3] = {
	0x00,0xff,0xff,
	0xff,0xff,0x7f,
	0xff,0x7f,0x00
};
*/

const static guchar dimple_out_black_alpha[6*6] = {
	0x00,0x00,0x00,0x1b,0x48,0x00,
	0x00,0x00,0x00,0x1b,0x8d,0x7f,
	0x00,0x00,0x1b,0x55,0x8d,0xff,
	0x1b,0x1b,0x55,0x8d,0xb3,0xff,
	0x48,0x8d,0x8d,0xb3,0xff,0x7f,
	0x00,0x7f,0xff,0xff,0x7f,0x00
};

const static guchar dimple_out_white_alpha[3*3] = {
	0x00,0x7f,0xff,
	0x7f,0xff,0xff,
	0xff,0xff,0x00
};

const static guchar dimple_in_black_bitmap[6] = {
	0x30,
	0x40,
	0x80,
	0x80,
	0x00,
	0x00
};
const static guchar dimple_in_dark_bitmap[6] = {
	0x48,
	0xbc,
	0x60,
	0x40,
	0xc0,
	0x40
};
const static guchar dimple_in_light_bitmap[4] = {
	0x00,
	0x20,
	0x40,
	0x00
};
const static guchar dimple_in_white_bitmap[4] = {
	0x00,
	0x10,
	0x30,
	0x60
};

const static guchar dimple_out_white_bitmap[3] = {
	0x00,
	0x40,
	0x00,
};
const static guchar dimple_out_light_bitmap[4] = {
	0x60,
	0xa0,
	0xc0,
	0x00,
};
const static guchar dimple_out_dark_bitmap[6] = {
	0x08,
	0x0c,
	0x08,
	0x18,
	0xf4,
	0x48
};
const static guchar dimple_out_black_bitmap[6] = {
	0x00,
	0x00,
	0x04,
	0x04,
	0x08,
	0x30
};

const static XenoImageLayer dimple_in_layers[4] = {
	{ dimple_in_black_alpha,	dimple_in_black_bitmap,	0,0,6,6, XENO_PEN_BLACK,XENO_STATE_CURRENT },
	{ NULL,						dimple_in_dark_bitmap,	0,0,6,6, XENO_PEN_DARK,	XENO_STATE_CURRENT },
	{ NULL,						dimple_in_light_bitmap,	2,2,4,4, XENO_PEN_LIGHT,XENO_STATE_CURRENT },
	{ dimple_in_white_alpha,	dimple_in_white_bitmap,	2,2,4,4, XENO_PEN_WHITE,XENO_STATE_CURRENT }
};

const static XenoImageLayer dimple_out_layers[4] = {
	{ dimple_out_white_alpha,	dimple_out_white_bitmap,0,0,3,3, XENO_PEN_WHITE,XENO_STATE_CURRENT },
	{ NULL,						dimple_out_light_bitmap,0,0,4,4, XENO_PEN_LIGHT,XENO_STATE_CURRENT },
	{ NULL,						dimple_out_dark_bitmap,	0,0,6,6, XENO_PEN_DARK,	XENO_STATE_CURRENT },
	{ dimple_out_black_alpha,	dimple_out_black_bitmap,0,0,6,6, XENO_PEN_BLACK,XENO_STATE_CURRENT },
};

const static XenoStyleImage dimple_in_image[1] = {
	{
		{
		  {	dimple_in_layers,4, 6,6 },
		  {	dimple_in_layers,4, 6,6 },
		  {	dimple_in_layers,4, 6,6 },
		  {	dimple_in_layers,4, 6,6 }
		},
		6, 6,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_DIMPLE
	}
};

const static XenoStyleImage dimple_out_image[1] = {
	{
		{
		  {	dimple_out_layers,4, 6,6 },
		  {	dimple_out_layers,4, 6,6 },
		  {	dimple_out_layers,4, 6,6 },
		  {	dimple_out_layers,4, 6,6 }
		},
		6, 6,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_DIMPLE
	}
};


/*
 *	Triangles
 */

/*
const static guchar amigatriangle_horiz_alpha[60*32] = {
	0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x7f,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x7f,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x7f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x7f,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x7f,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x7f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};
*/

const static guchar triangle_alpha[58*58] = {
	0x96,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x96,
	0xff,0xff,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x02,
	0xff,0xff,0xff,0xda,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x6e,0x00,
	0xff,0xff,0xff,0xff,0xff,0xb2,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xda,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xda,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x47,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x47,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xb2,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xcf,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xa8,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8b,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8b,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x64,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9d,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xa8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe2,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xba,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x93,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xba,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x59,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe2,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9d,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0xff,0xff,0xff,0xff,0xff,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0xe2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xa8,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0xff,0xff,0xff,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xcf,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xba,0xff,0xba,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0xff,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0xff,0xff,0xff,0xff,0xb2,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x96,
	0xff,0xff,0xff,0xda,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6e,0xff,0xff,
	0xff,0xff,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x47,0xda,0xff,0xff,0xff,
	0x96,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xb2,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8b,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0xff,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xba,0xff,0xba,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xcf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0xff,0xff,0xff,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0xa8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe2,0xff,0xff,0xff,0xe2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0xff,0xff,0xff,0xff,0xff,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x59,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x9d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x9d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xc5,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0xe2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x59,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x59,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0xba,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xec,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0xba,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x4e,0xe2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xa8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x9d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0xcf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xcf,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0xc5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0x64,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x59,0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x00,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x00,0x8b,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x15,0xa8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0x1f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xcf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x00,0xb2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xb2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0x47,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x47,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8b,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x00,0x00,0xda,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xda,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xb2,0xff,0xff,0xff,0xff,0xff,
	0x00,0x6e,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x6e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x47,0xda,0xff,0xff,0xff,
	0x02,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6e,0xff,0xff,
	0x96,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x96,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x96
};


const static XenoImageLayer triangle_layers[1] = {
	{ triangle_alpha,NULL, 0,0,58,58, XENO_PEN_FG,XENO_STATE_CURRENT }
};

const static XenoStyleImage triangle_image[1] = {
	{
		{
		  {	triangle_layers,1, 58,58 },
		  {	triangle_layers,1, 58,58 },
		  {	triangle_layers,1, 58,58 },
		  {	triangle_layers,1, 58,58 }
		},
		58, 58,
		XENO_PEN_BG,XENO_STATE_CURRENT,
		XENO_STYLE_IMAGE_MASK_TRIANGLE
	}
};



/*
 *	The XenoImage structures
 */

const XenoStyleImageSet xeno_style_images[XENO_STYLE_IMAGE_END] = {
	/* Radio button */
	{ radio_bg_images,3,	GTK_SHADOW_OUT,	GTK_STATE_NORMAL },
	{ radio_bg_images,3,	GTK_SHADOW_OUT,	GTK_STATE_PRELIGHT },
	{ radio_bg_images,3,	GTK_SHADOW_OUT,	GTK_STATE_INSENSITIVE },
	{ radio_base_images,3,	GTK_SHADOW_IN,	GTK_STATE_NORMAL },
	{ radio_base_images,3,	GTK_SHADOW_IN,	GTK_STATE_PRELIGHT },
	{ radio_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_INSENSITIVE },
	{ radio_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_ACTIVE },
	
	/* Check button */
	{ check_base_images,3,	GTK_SHADOW_IN,	GTK_STATE_NORMAL },
	{ check_base_images,3,	GTK_SHADOW_IN,	GTK_STATE_PRELIGHT },
	{ check_base_images,3,	GTK_SHADOW_IN,	GTK_STATE_INSENSITIVE },
	{ check_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_ACTIVE },
	
	/* Radio menu item */
	{ radio_item_images,3,	GTK_SHADOW_IN,	GTK_STATE_NORMAL },
	{ radio_item_images,3,	GTK_SHADOW_IN,	GTK_STATE_PRELIGHT },
	{ radio_item_images,3,	GTK_SHADOW_IN,	GTK_STATE_INSENSITIVE },
	
	/* Checkmark menu item image */
	{ check_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_NORMAL },
	{ check_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_PRELIGHT },
	{ check_bg_images,3,	GTK_SHADOW_IN,	GTK_STATE_INSENSITIVE },
	
	/* Notebook tab edges */
	{ notebook_images,1,	GTK_SHADOW_OUT,	GTK_STATE_NORMAL },
	{ notebook_images,1,	GTK_SHADOW_OUT,	GTK_STATE_ACTIVE },
	{ notebook_images,1,	GTK_SHADOW_OUT,	GTK_STATE_INSENSITIVE },
	
	/* Dimples */           
	{ dimple_in_image,1,	GTK_SHADOW_IN,	GTK_STATE_NORMAL },
	{ dimple_in_image,1,	GTK_SHADOW_IN,	GTK_STATE_PRELIGHT },
	{ dimple_in_image,1,	GTK_SHADOW_IN,	GTK_STATE_INSENSITIVE },
	
	{ dimple_out_image,1,	GTK_SHADOW_OUT,	GTK_STATE_NORMAL },
	{ dimple_out_image,1,	GTK_SHADOW_OUT,	GTK_STATE_PRELIGHT },
	{ dimple_out_image,1,	GTK_SHADOW_OUT,	GTK_STATE_INSENSITIVE },
	
	/* Equiangular triangle */
	{ triangle_image,1,		GTK_SHADOW_OUT,	GTK_STATE_NORMAL },
	{ triangle_image,1,		GTK_SHADOW_OUT,	GTK_STATE_PRELIGHT },
	{ triangle_image,1,		GTK_SHADOW_OUT,	GTK_STATE_INSENSITIVE },
	{ triangle_image,1,		GTK_SHADOW_IN,	GTK_STATE_ACTIVE }
};


/*
 *	Shadows
 */

#define D			{ XENO_PEN_DARK, XENO_STATE_CURRENT }
#define L			{ XENO_PEN_LIGHT,XENO_STATE_CURRENT }
#define M			{ XENO_PEN_MID, XENO_STATE_CURRENT }
#define W			{ XENO_PEN_WHITE, XENO_STATE_CURRENT }
#define B			{ XENO_PEN_BLACK, XENO_STATE_CURRENT }
#define	G			{ XENO_PEN_BG, XENO_STATE_CURRENT }

#define DN			{ XENO_PEN_DARK, XENO_STATE_NORMAL }
#define LN			{ XENO_PEN_LIGHT, XENO_STATE_NORMAL }
#define MN			{ XENO_PEN_MID, XENO_STATE_NORMAL }
#define WN			{ XENO_PEN_WHITE, XENO_STATE_NORMAL }
#define BN			{ XENO_PEN_BLACK, XENO_STATE_NORMAL }
#define	GN			{ XENO_PEN_BG, XENO_STATE_NORMAL }

#define PD			{ XENO_PEN_DARK|XENO_PEN_PARENT, XENO_STATE_CURRENT }
#define PL			{ XENO_PEN_LIGHT|XENO_PEN_PARENT, XENO_STATE_CURRENT }
#define PM			{ XENO_PEN_MID|XENO_PEN_PARENT, XENO_STATE_CURRENT }
#define PW			{ XENO_PEN_WHITE|XENO_PEN_PARENT, XENO_STATE_CURRENT }
#define PB			{ XENO_PEN_BLACK|XENO_PEN_PARENT, XENO_STATE_CURRENT }
#define PG			{ XENO_PEN_BG|XENO_PEN_PARENT, XENO_STATE_CURRENT }

#define PDN			{ XENO_PEN_DARK|XENO_PEN_PARENT, XENO_STATE_NORMAL }
#define PLN			{ XENO_PEN_LIGHT|XENO_PEN_PARENT, XENO_STATE_NORMAL }
#define PMN			{ XENO_PEN_MID|XENO_PEN_PARENT, XENO_STATE_NORMAL }
#define PWN			{ XENO_PEN_WHITE|XENO_PEN_PARENT, XENO_STATE_NORMAL }
#define PBN			{ XENO_PEN_BLACK|XENO_PEN_PARENT, XENO_STATE_NORMAL }
#define PGN			{ XENO_PEN_BG|XENO_PEN_PARENT, XENO_STATE_NORMAL }

#define RB			{ XENO_PEN_PURE_BLACK, XENO_STATE_CURRENT }
#define RW			{ XENO_PEN_PURE_WHITE, XENO_STATE_CURRENT }

#define NONE		{ XENO_PEN_BG, XENO_STATE_CURRENT }
#define EMPTY1		{ { NONE, NONE, NONE } }
#define EMPTY2		{ { NONE, NONE, NONE }, { NONE, NONE, NONE } }
#define EMPTY3		{ { NONE, NONE, NONE }, { NONE, NONE, NONE }, { NONE, NONE, NONE } }

const XenoShadowSet xeno_style_shadows[XENO_SHADOW_LAST] = {
	/* XENO_SHADOW_ETCHED_(IN|OUT) */
	{
		1, { { B,	B,	B  } },
		2, { { PD, PL, PM }, { L,	D,	M } },
		3, { { PD, PL, PM }, {	B,	B,	B }, {	L,	D,	M } },
		3
	}, {
		1, { { B,	B,	B  } },
		2, { { PL, PD, PM }, { D,	L,	M } },
		3, { { PL, PD, PM }, { G,	G,	G }, {	D,	L,	M } },
		3
	},
	
	/* XENO_SHADOW_XENO_(IN|OUT) */
	{
		1, { { PDN,PLN,PMN } },
		2, { { PDN,PLN,PMN }, { PBN,PWN,PDN } },
		3, { { PDN,PLN,PMN }, { PBN,PWN,PDN }, { RB, RW, PD } },
		2
	}, {
		1, { { L,  D,  M,  } },
		2, { { W,  B,  M,  }, { L,  D,	M } },
		3, { { RW, RB, M,  }, { W,  B,	M }, { L,  D,  M } },
		2
	},
	
	/* XENO_SHADOW_THIN_(IN|OUT) */
 	{
		1, { { D, L, M } },
		2, { { D, L, M }, { G, G, G } },
		3, { { D, L, M }, { G, G, G }, { G, G, G } },
		1
	}, {
		1, { { L, D, M } },
		2, { { L, D, M }, { G, G, G } },
		3, { { L, D, M }, { G, G, G }, { G, G, G } },
		1
	},
	
	/* XENO_SHADOW_NEXT_(IN|OUT) */
	{
		1, { { PB, PW, PG } },
		2, { { PD, PW, PD }, { PB, PG, PB } },
		3, { { PD, PW, PD }, { PB, PG, PB }, { PG, PG, PG } },
		2
	}, {
		1, { { W, B, B  } },
		2, { { W, B, D  }, { G, D, D } },
		3, { { W, D, PG }, { W, B, B }, { G, D, D } },
		2
	},
	
	/* XENO_SHADOW_BUTTON_IN, XENO_SHADOW_NOTE */
	{
		1, { { B, D, B } },
		2, { { B, D, B }, { D, G, D } },
		3, { { B, D, B }, { D, G, D }, { G, G, G } },
		2
	}, {
		1, { { D, B, D } },
		2, { { D, B, D }, { G, G, G } },
		3, { { B, B, B }, { G, B, B }, { G, G, G } },
		1
	},
	
	/* XENO_SHADOW_BLACK_(IN|OUT) */
	{
		1, { { RB, RB, RB } },
		2, { { PD, PL, PM }, { RB, RB, RB } },
		3, { { PD, PL, PM }, { RB, RB, RB }, { { XENO_PEN_DARK,XENO_STATE_ACTIVE }, { XENO_PEN_LIGHT,XENO_STATE_ACTIVE }, { XENO_PEN_MID,XENO_STATE_ACTIVE } } },
		3
	}, {
		1, { { B, RB, B } },
		2, { { B, RB, B }, { L, D, M } },
		3, { { B, RB, B }, { W, D, M }, { L, M, G } },
		3
	}
};


/*
 *	Shadow code
 */

static const XenoShadowData *
xeno_shadow_data (GtkStyle		 *style,
				  XenoShadowType shadow_type,
				  GtkStateType	 state_type)
{
	const static guint8 null = { 0 };
	const XenoShadowSet	 *shadow_set;
	const guint8		 *data;
	
	XenoRcData		*rc_data;
	XenoShadowType	xeno_shadow_type;
	gint thickness;
	
	thickness = MIN(XENO_STYLE_XTHICKNESS(style), XENO_STYLE_YTHICKNESS(style));
	if (thickness == 0)
		return (const XenoShadowData *)&null;
	
	xeno_shadow_type = shadow_type;
	if (xeno_shadow_type == XENO_SHADOW_NONE) {
		return (const XenoShadowData *)&null;
	} else if (xeno_shadow_type <= XENO_SHADOW_OUT) {
		rc_data = XENO_STYLE_RC_DATA(style);
		if (rc_data != NULL)
			xeno_shadow_type = ((shadow_type == XENO_SHADOW_IN) ? rc_data->shadow_in : rc_data->shadow_out)[state_type];
	}
	
	shadow_set = &xeno_style_shadows[xeno_shadow_type - XENO_SHADOW_ETCHED_IN];
	thickness = MIN(thickness, shadow_set->max_thickness);
	if (thickness == 1) {
		data = &shadow_set->thin;
	} else if (thickness == 3) {
		data = &shadow_set->thick;
	} else {
		data = &shadow_set->medium;
	}
	return (const XenoShadowData *)data;
}

void
xeno_shadow_init (XenoShadow		*shadow,
				  GtkStyle			*style,
				  GdkWindow			*window,
				  GtkStateType		state_type,
				  XenoShadowType	shadow_type,
				  GdkRectangle		*area,
				  GtkWidget			*widget)
{
	const XenoShadowData *data;
	XenoStyleData	*style_data;
	GtkStyle		*style2, *style_use;
	GdkGC			*gc;
	GtkStateType	state2, state_use;
	gint			i, j;
	XenoPenType		pen_type;
	
	style2 = style;
	state2 = GTK_STATE_NORMAL;
	if (widget != NULL && widget->parent != NULL) {
		style2 = widget->parent->style;
		state2 = widget->parent->state;
	}
	
	if (state_type == GTK_STATE_INSENSITIVE || state2 == GTK_STATE_INSENSITIVE)
		state_type = state2 = GTK_STATE_INSENSITIVE;
	
	data = xeno_shadow_data (style, shadow_type, state_type);
	
	for (i = 0; i < data->thickness; ++i) {
		for (j = 0; j < 3; ++j) {
			pen_type  = data->rings[i][j].pen_type;
			state_use = data->rings[i][j].state_type;
			style_use = style;
			
			if (pen_type & XENO_PEN_PARENT) {
				style_use = style2;
				pen_type &= ~XENO_PEN_PARENT;
			}
			
			if (state_use == (GtkStateType)XENO_STATE_CURRENT) {
				state_use = state_type;
			} else if (state_type == GTK_STATE_INSENSITIVE || state2 == GTK_STATE_INSENSITIVE) {
				state_use = GTK_STATE_INSENSITIVE;
			}
			state_use &= XENO_STATE_GTK_MASK;
			
			switch (pen_type) {
			  case XENO_PEN_WHITE:
				if ((style_data = XENO_STYLE_DATA(style_use)) != NULL) {
					if ((gc = style_data->white_gc[state_use]) != NULL)
						break;
				}
			  case XENO_PEN_PURE_WHITE:
				gc = style_use->white_gc;
				break;
				
			  case XENO_PEN_BLACK:
				if ((style_data = XENO_STYLE_DATA(style_use)) != NULL) {
					if ((gc = style_data->black_gc[state_use]) != NULL)
						break;
				}
			  case XENO_PEN_PURE_BLACK:
				gc = style_use->black_gc;
				break;
				
			  case XENO_PEN_FG:
				gc = style_use->fg_gc[state_use];
				break;
			  case XENO_PEN_BASE:
				gc = style_use->base_gc[state_use];
				break;
			  case XENO_PEN_TEXT:
				gc = style_use->text_gc[state_use];
				break;
			  case XENO_PEN_LIGHT:
				gc = style_use->light_gc[state_use];
				break;
			  case XENO_PEN_DARK:
				gc = style_use->dark_gc[state_use];
				break;
			  case XENO_PEN_MID:
				gc = style_use->mid_gc[state_use];
				break;
			  case XENO_PEN_BG:
				gc = style_use->bg_gc[state_use];
				break;
			  default:
				gc = NULL;
			}
			shadow->ring[i].gc[j] = gc;
		}
	}
	
	if (area && data->thickness > 0) {
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_TOP], area);
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_BOTTOM], area);
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_CORNER], area);
		if (data->thickness > 1) {
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_TOP], area);
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_BOTTOM], area);
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_CORNER], area);
			if (data->thickness > 2) {
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_TOP], area);
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_BOTTOM], area);
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_CORNER], area);
			}
		}
	}
	shadow->thickness = data->thickness;
}

void
xeno_shadow_done (XenoShadow	*shadow,
				  GdkRectangle	*area)
{
	g_return_if_fail (shadow != NULL);
	
	if (area && shadow->thickness > 0) {
		if (shadow->thickness > 1) {
			if (shadow->thickness > 2) {
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_CORNER], NULL);
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_BOTTOM], NULL);
				gdk_gc_set_clip_rectangle (shadow->ring[2].gc[XENO_SHADOW_GC_TOP], NULL);
			}
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_CORNER], NULL);
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_BOTTOM], NULL);
			gdk_gc_set_clip_rectangle (shadow->ring[1].gc[XENO_SHADOW_GC_TOP], NULL);
		}
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_CORNER], NULL);
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_BOTTOM], NULL);
		gdk_gc_set_clip_rectangle (shadow->ring[0].gc[XENO_SHADOW_GC_TOP], NULL);
	}
}


/*
 *	Image caching and remapping
 */

typedef struct {
	XenoPixmapMask	*mask;
	gint			ref_count;
} XenoStyleImageMask;

static XenoStyleImageMask xeno_style_image_masks[XENO_STYLE_IMAGE_MASK_LAST] = {
	{ NULL, 0 }, { NULL, 0 }, { NULL, 0 }, { NULL, 0 },
	{ NULL, 0 }, { NULL, 0 }, { NULL, 0 }, { NULL, 0 },
	{ NULL, 0 }, { NULL, 0 }, { NULL, 0 }, { NULL, 0 }
};

void
xeno_style_mask_unref (XenoStyleImageType image_type,
					   guint			  variant_type)
{
	const XenoStyleImageSet	*set;
	XenoStyleImageMaskType	mask_type;
	XenoStyleImageMask		*mask;
	
	set = &xeno_style_images[image_type];
	variant_type %= set->n_variants;
	mask_type = set->variants[variant_type].mask_type;
	
	if (mask_type != XENO_STYLE_IMAGE_MASK_NONE) {
		mask = &xeno_style_image_masks[mask_type];
		if (--mask->ref_count <= 0) {
			xeno_pixmap_mask_unref (mask->mask);
			mask->mask = NULL;
			mask->ref_count = 0;
		}
	}
}

static void
xeno_style_color (GtkStyle		*style,
				  GtkStyle		*parent_style,
				  GtkStateType	state_type,
				  GtkShadowType	shadow_type,
				  XenoPenType	pen_type,
				  XenoColor		*color)
{
	XenoStyleData	*style_data;
	const GdkColor	*gdk_color;
	
	if (pen_type & XENO_PEN_PARENT) {
		style = parent_style;
		pen_type &= ~XENO_PEN_PARENT;
	}
	
	if (pen_type >= XENO_PEN_TOP0) {
		const XenoShadowData *shadow_data;
		XenoStateType new_state_type;
		gint r, i;
		
		shadow_data = xeno_shadow_data (style, shadow_type, state_type);
		
		pen_type -= XENO_PEN_TOP0;
		r = pen_type & 0x03;
		i = (pen_type >> 2) & 0x03;
		
		if (r < shadow_data->thickness) {
			pen_type       = shadow_data->rings[r][i].pen_type;
			new_state_type = shadow_data->rings[r][i].state_type;
			
			if (pen_type & XENO_PEN_PARENT) {
				style = parent_style;
				pen_type &= ~XENO_PEN_PARENT;
			}
			if (pen_type >= XENO_PEN_TOP0) {
				g_warning ("recursive shadow color\n");
				pen_type = XENO_PEN_FILL;
			} else
			
			if (new_state_type != XENO_STATE_CURRENT && state_type != XENO_STATE_INSENSITIVE)
				state_type = new_state_type;
		} else {
			pen_type = XENO_PEN_FILL;
		}
	}
	
	if (pen_type == XENO_PEN_FILL)
		pen_type = XENO_PEN_BG;
	
	switch (pen_type) {
	  /* GTK colors */
	  case XENO_PEN_FG:
		gdk_color = style->fg;
		break;
		
	  case XENO_PEN_BG:
		gdk_color = style->bg;
		break;
		
	  case XENO_PEN_BASE:
		gdk_color = style->base;
		break;
		
	  case XENO_PEN_TEXT:
		gdk_color = style->text;
		break;
		
	  default:
		/* Calculated colors */
		style_data = XENO_STYLE_DATA(style);
		switch (pen_type) {
		  case XENO_PEN_WHITE:
			if (style_data != NULL) {
				*color = style_data->white[state_type];
				return;
			}
		  case XENO_PEN_PURE_WHITE:
			*color = xeno_color_white;
			return;
			
		  case XENO_PEN_BLACK:
			if (style_data != NULL) {
				*color = style_data->black[state_type];
				return;
			}
		  case XENO_PEN_PURE_BLACK:
			*color = xeno_color_black;
			return;
			
		  case XENO_PEN_LIGHT:
			if (style_data != NULL) {
				xeno_color_from_gdk (color, &style->bg[state_type]);
				xeno_color_blend (color, &style_data->white[state_type], XENO_STYLE_RC_DATA(style)->shine[state_type] - 1.0F, color);
				return;
			}
			gdk_color = style->light;
			break;
			
		  case XENO_PEN_DARK:
			if (style_data != NULL) {
				xeno_color_from_gdk (color, &style->bg[state_type]);
				xeno_color_blend (color, &style_data->black[state_type], 1.0 - XENO_STYLE_RC_DATA(style)->shade[state_type], color);
				return;
			}
			gdk_color = style->dark;
			break;
			
		  case XENO_PEN_MID:
			gdk_color = style->mid;
			break;
		}
	}
	xeno_color_from_gdk (color, &gdk_color[state_type]);
}


typedef struct {
	XenoStyle		*style;
	GtkStyle		*parent_style;
	GtkStateType	state_type;
	GtkShadowType	shadow_type;
} XenoPixmapContext;

static void
xeno_style_pen_callback	(guint		pen_type,
						 guint		state_type,
						 XenoColor	*color,
						 gpointer	user_data)
{
	XenoPixmapContext *context;
	
	context = (XenoPixmapContext *)user_data;
	
	xeno_style_color (context->style, context->parent_style, 
					  (state_type == XENO_STATE_CURRENT && state_type != XENO_STATE_INSENSITIVE) ? context->state_type : state_type,
					  context->shadow_type, pen_type, color);
}

XenoPixmap *
xeno_style_pixmap_get	(XenoStyle			*style,
						 GtkStyle			*parent_style,
						 XenoStyleImageType	image_type,
						 guint				variant_type,
						 XenoPixmapMask		**mask_p)
{
	XenoPixmapContext		context;
	const XenoStyleImageSet	*set;
	const XenoStyleImage	*variant;
	const XenoImage			*image;
	XenoStyleData			*data;
	XenoImageBuffer			*buffer;
	XenoPixmap				*pixmap;
	XenoStyleImageMask		*mask;
	XenoStyleImageMaskType	mask_type;
	XenoColor				bg_color;
	
	g_return_val_if_fail (style != NULL, NULL);
	g_return_val_if_fail (parent_style != NULL, NULL);
	g_return_val_if_fail (XENO_STYLE_IS_XENO(style), NULL);
	
	set = &xeno_style_images[image_type];
	variant = &set->variants[variant_type % set->n_variants];
	mask_type = variant->mask_type;
	if (mask_type != XENO_STYLE_IMAGE_MASK_NONE) {
		mask = &xeno_style_image_masks[mask_type];
	} else {
		mask = NULL;
	}
	
	context.style		 = style;
	context.parent_style = parent_style;
	context.state_type	 = set->state_type;
	context.shadow_type  = set->shadow_type;
	
	data = XENO_STYLE_DATA (style);
	pixmap = data->pixmaps[image_type];
	if (!pixmap) {
		image = &variant->images[XENO_STYLE_THICKNESS(style)];
		buffer = xeno_image_buffer_new (image->width, image->height);
		if (buffer) {
			xeno_image_render (image, buffer, 0, 0, xeno_style_pen_callback, (gpointer)&context);
			
			xeno_style_color (style, parent_style,
							  (variant->state_type == XENO_STATE_CURRENT) ? set->state_type : variant->state_type,
							  set->shadow_type, variant->bg_pen_type, &bg_color);
			
			data->pixmaps[image_type] = pixmap = xeno_image_buffer_render (buffer, &bg_color);
			if (mask) {
				if (mask->mask == NULL)
					mask->mask = xeno_image_buffer_render_mask (buffer);
				
				if (mask->mask != NULL)
					mask->ref_count += 1;
			}
		}
	}
	
	if (mask_p) {
		if (mask) {
			*mask_p = mask->mask;
		} else {
			*mask_p = NULL;
		}
	}
	
	return pixmap;
}

/* end */

