/*
 *  Xeukleides  version 1.0.1 
 *  Copyright (c) Christian Obrecht 2000-2004
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gtk/gtk.h>
#include "types.h"
#include "geometry.h"
#include "parser.tab.h"

extern symrec *tracevar;

extern double tracebegin;

extern int noframe, boxmode, Width, Height;

extern int strokes;

extern GtkWidget *drawing_area;

extern GdkPixmap *pixmap;

extern GdkGC *solid_gc, *dotted_gc, *dashed_gc;

extern GdkFont *font;

extern GdkColor black_col, darkgray_col, gray_col, lightgray_col, white_col,
    red_col, green_col, blue_col, cyan_col, magenta_col, yellow_col;

extern interrec inter_table[10][2];

GdkPoint points[1000];

void warning (char *);

int yyerror (char *);

double X1, Y1, X2, Y2, Unit, r, R, X_off, Y_off;

int X (double x)
{
    return (int) (X_off + Unit * (x - X1));
}

int Y (double y)
{
    return (int) (Y_off + Unit * (Y2 - y));
}

void frame (double x1, double y1, double x2, double y2, int flag)
{
    double w, h;

    noframe = 0;
    boxmode = flag;
    w = x2 - x1;
    h = y2 - y1;
    if (Width * h > Height * w) {
	Unit = Height / h;
	R = Height * .0875;
	r = h * .0875;
	if (boxmode) {
	    X1 = x1;
	    Y1 = y1;
	    X2 = x2;
	    Y2 = y2;
	    X_off = (Width - w * Unit) / 2;
	    Y_off = 0;
	}
	else {
	    X1 = x1 - (Width / Unit - w) / 2;
	    Y1 = y1;
	    X2 = x2 + (Width / Unit - w) / 2;
	    Y2 = y2;
	    X_off = 0;
	    Y_off = 0;
	}
    }
    else {
	Unit = Width / w;
	R = Width * .07;
	r = w * .07;
	if (boxmode) {
	    X1 = x1;
	    Y1 = y1;
	    X2 = x2;
	    Y2 = y2;
	    X_off = 0;
	    Y_off = (Height - h * Unit) / 2;
	}
	else {
	    X1 = x1;
	    Y1 = y1 - (Height / Unit - h) / 2;
	    X2 = x2;
	    Y2 = y2 + (Height / Unit - h) / 2;
	    X_off = 0;
	    Y_off = 0;
	}
    }
}

void default_frame (void)
{
    if (noframe)
	frame (-2, -2, 8, 6, 0);
}

void draw_stripes (void)
{
    gdk_gc_set_foreground (solid_gc, &gray_col);
    if (X_off) {
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, 0, 0, (int) X_off,
			    Height);
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, Width - (int) X_off, 0,
			    Width, Height);
    }
    else {
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, 0, 0, Width, (int) Y_off);
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, 0, Height - (int) Y_off,
			    Width, Height);
    }
}

void setcolor_flag (int flag)
{
    GdkColor col;

    switch (flag) {
    case BLACK:
	col = black_col;
	break;
    case DARKGRAY:
	col = darkgray_col;
	break;
    case GRAY:
	col = gray_col;
	break;
    case LIGHTGRAY:
	col = lightgray_col;
	break;
    case WHITE:
	col = white_col;
	break;
    case RED:
	col = red_col;
	break;
    case GREEN:
	col = green_col;
	break;
    case BLUE:
	col = blue_col;
	break;
    case CYAN:
	col = cyan_col;
	break;
    case MAGENTA:
	col = magenta_col;
	break;
    case YELLOW:
	col = yellow_col;
    }

    gdk_gc_set_foreground (solid_gc, &col);
    gdk_gc_set_foreground (dotted_gc, &col);
    gdk_gc_set_foreground (dashed_gc, &col);
}

void change_font (char *lfd)
{
    GdkFont *fnt;
    fnt = gdk_font_load (lfd);
    if (fnt == NULL)
	warning ("unable to alloc font.");
    else
	font = fnt;
}

void draw_point (_point * A, int flag)
{
    default_frame ();
    switch (flag) {
    case DOT:
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, X (A->x) - 2,
			    Y (A->y) - 1, 5, 3);
	gdk_draw_line (pixmap, solid_gc, X (A->x) - 1, Y (A->y) - 2,
		       X (A->x) + 1, Y (A->y) - 2);
	gdk_draw_line (pixmap, solid_gc, X (A->x) - 1, Y (A->y) + 2,
		       X (A->x) + 1, Y (A->y) + 2);
	break;
    case DISC:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (A->x) - 2,
		      Y (A->y) - 2, 4, 4, 0, 23040);
	break;
    case BOX:
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, X (A->x) - 2,
			    Y (A->y) - 2, 5, 5);
	break;
    case CROSS:
	gdk_draw_line (pixmap, solid_gc, X (A->x) - 2, Y (A->y) - 2,
		       X (A->x) + 2, Y (A->y) + 2);
	gdk_draw_line (pixmap, solid_gc, X (A->x) - 2, Y (A->y) + 2,
		       X (A->x) + 2, Y (A->y) - 2);
	break;
    case PLUS:
	gdk_draw_line (pixmap, solid_gc, X (A->x) - 3, Y (A->y), X (A->x) + 3,
		       Y (A->y));
	gdk_draw_line (pixmap, solid_gc, X (A->x), Y (A->y) - 3, X (A->x),
		       Y (A->y) + 3);
    }
}

GdkGC *gc (int flag)
{
    switch (flag) {
    case FULL:
	return solid_gc;
    case DOTTED:
	return dotted_gc;
    case DASHED:
	return dashed_gc;
    }
    return solid_gc;
}

void draw_vector (_vector * v, _point * A, int flag)
{
    double a, x, y;
    default_frame ();
    a = V_angle (v);
    x = A->x + v->x;
    y = A->y + v->y;
    gdk_draw_line (pixmap, gc (flag), X (A->x), Y (A->y), X (x), Y (y));
    gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		   X (x + .15 * Cos (a + 155)), Y (y + .15 * Sin (a + 155)));
    gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		   X (x + .15 * Cos (a - 155)), Y (y + .15 * Sin (a - 155)));
}

void draw_line (_line * l, int flag1, int flag2)
{
    double x1, y1, x2, y2, m;

    default_frame ();
    if (ZERO (Sin (l->angle))) {
	x1 = X1;
	y1 = l->y;
	x2 = X2;
	y2 = l->y;
    }
    else if (ZERO (Cos (l->angle))) {
	x1 = l->x;
	y1 = Y1;
	x2 = l->x;
	y2 = Y2;
    }
    else {
	m = Tan (l->angle);
	x1 = (Y1 - l->y) / m + l->x;
	y1 = Y1;
	if (x1 < X1) {
	    x1 = X1;
	    y1 = m * (X1 - l->x) + l->y;
	}
	if (x1 > X2) {
	    x1 = X2;
	    y1 = m * (X2 - l->x) + l->y;
	}
	x2 = (Y2 - l->y) / m + l->x;
	y2 = Y2;
	if (x2 < X1) {
	    x2 = X1;
	    y2 = m * (X1 - l->x) + l->y;
	}
	if (x2 > X2) {
	    x2 = X2;
	    y2 = m * (X2 - l->x) + l->y;
	}
    }
    switch (flag2) {
    case HALFLINE:
	if (l->angle >= 0) {
	    x1 = l->x;
	    y1 = l->y;
	}
	else {
	    x2 = l->x;
	    y2 = l->y;
	}
	break;
    case BACKHALFLINE:
	if (l->angle >= 0) {
	    x2 = l->x;
	    y2 = l->y;
	}
	else {
	    x1 = l->x;
	    y1 = l->y;
	}
    }
    if ((x1 >= X1) && (x2 <= X2) && (y1 >= Y1) && (y2 <= Y2))
	gdk_draw_line (pixmap, gc (flag1), X (x1), Y (y1), X (x2), Y (y2));
}

void draw_stroke (double x1, double y1, double x2, double y2,
		  int flag1, int flag2)
{
    double a;
    default_frame ();
    gdk_draw_line (pixmap, gc (flag1), X (x1), Y (y1), X (x2),
		   Y (y2));
    a = angle (x2 - x1, y2 - y1);
    if (flag2 == ARROW || flag2 == DOUBLEARROW) {
	gdk_draw_line (pixmap, solid_gc, X (x2), Y (y2),
		       X (x2 + .15 * Cos (a + 155)),
		       Y (y2 + .15 * Sin (a + 155)));
	gdk_draw_line (pixmap, solid_gc, X (x2), Y (y2),
		       X (x2 + .15 * Cos (a - 155)),
		       Y (y2 + .15 * Sin (a - 155)));
    }
    if (flag2 == BACKARROW || flag2 == DOUBLEARROW) {
	gdk_draw_line (pixmap, solid_gc, X (x1), Y (y1),
		       X (x1 + .15 * Cos (a + 25)),
		       Y (y1 + .15 * Sin (a + 25)));
	gdk_draw_line (pixmap, solid_gc, X (x1), Y (y1),
		       X (x1 + .15 * Cos (a - 25)),
		       Y (y1 + .15 * Sin (a - 25)));
    }
}


void draw_segment (_segment * s, int flag1, int flag2)
{
    draw_stroke (s->x1, s->y1, s->x2, s->y2, flag1, flag2);
}

void draw_circle (_circle * c, int flag)
{
    int d;

    default_frame ();
    d = (int) (2 * Unit * c->radius);
    gdk_draw_arc (pixmap, gc (flag), FALSE, X (c->x - c->radius),
		  Y (c->y + c->radius), d, d, 0, 23040);
}

void draw_arc (_circle * c, double a1, double a2, int flag1, int flag2)
{
    int d;
    double l, r, x, y;

    default_frame ();
    r = c->radius;
    d = (int) (2 * Unit * r);
    l = a2 - a1;
    gdk_draw_arc (pixmap, gc (flag1), FALSE, X (c->x - r), Y (c->y + r),
		  d, d, 64 * a1, 64 * ((l > 0) ? l : (360 + l)));
    if (flag2 == ARROW || flag2 == DOUBLEARROW) {
	x = c->x + r * Cos (a2);
	y = c->y + r * Sin (a2);
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * Cos (a2 - 65)),
		       Y (y + .15 * Sin (a2 - 65)));
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * Cos (a2 - 115)),
		       Y (y + .15 * Sin (a2 - 115)));
    }
    if (flag2 == BACKARROW || flag2 == DOUBLEARROW) {
	x = c->x + r * Cos (a1);
	y = c->y + r * Sin (a1);
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * Cos (a1 + 65)),
		       Y (y + .15 * Sin (a1 + 65)));
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * Cos (a1 + 115)),
		       Y (y + .15 * Sin (a1 + 115)));
    }
}

void draw_parabola_arc (_conic * C, double min, double max, int flag)
{
    double c0, s0, d, t, x, y, i, b, e;
    int n;
    GdkGC *tmp;
    GdkPoint pts[100];

    tmp = gc (flag);
    c0 = Cos (C->d);
    s0 = Sin (C->d);

    d = sqrt (pow ((X1 + X2) / 2 - C->x, 2) + pow ((Y1 + Y2) / 2 - C->y, 2)) +
	sqrt (pow (X2 - X1, 2) + pow (Y2 - Y1, 2));
    Snd_degree (&x, &x, 4 * C->a * C->a, 1, -d * d);
    t = sqrt (fabs (x));
    b = (min < -t) ? -t : min;
    e = (max > t) ? t : max;
    i = (e - b) / 99;
    x = b;

    for (n = 0; n < 100; n++) {
	y = 2 * C->a * x * x;
	pts[n].x = X (C->x + x * c0 - y * s0);
	pts[n].y = Y (C->y + x * s0 + y * c0);
	x += i;
    }

    gdk_draw_lines (pixmap, tmp, pts, 100);
}

void draw_ellipse_arc (_conic * C, double min, double max, int flag)
{
    double c0, s0, c, s, z, i;
    int n;
    GdkGC *tmp;
    GdkPoint pts[200];

    tmp = gc (flag);
    c0 = Cos (C->d);
    s0 = Sin (C->d);
    i = (max - min) / 199;
    z = min;

    for (n = 0; n < 200; n++) {
	c = C->a * cos (z);
	s = C->b * sin (z);
	pts[n].x = X (C->x + c * c0 - s * s0);
	pts[n].y = Y (C->y + c * s0 + s * c0);
	z += i;
    }

    gdk_draw_lines (pixmap, tmp, pts, 200);
}

void draw_hyperbola_arc (_conic * C, double b, double e, int flag)
{
    double c0, s0, c, s, i, z;
    int n;
    GdkGC *tmp;
    GdkPoint pts[100];

    tmp = gc (flag);
    c0 = Cos (C->d);
    s0 = Sin (C->d);
    i = (e - b) / 99;
    z = b;
    for (n = 0; n < 100; n++) {
	c = C->a / cos (z);
	s = C->b * tan (z);
	pts[n].x = X (C->x + c * c0 - s * s0);
	pts[n].y = Y (C->y + c * s0 + s * c0);
	z += i;
    }

    gdk_draw_lines (pixmap, tmp, pts, 100);
}

void draw_conic_arc (_conic * C, double first, double last, int flag)
{
    double min, max, d, t, b, e;
    default_frame ();
    if (first < last) {
	min = first;
	max = last;
    }
    else {
	min = last;
	max = first;
    }
    switch (C->kind) {
    case PARABOLA:
	draw_parabola_arc (C, min, max, flag);
	break;
    case ELLIPSE:
	draw_ellipse_arc (C, min, max, flag);
	break;
    case HYPERBOLA:
	d = sqrt (pow ((X1 + X2) / 2 - C->x, 2) +
		  pow ((Y1 + Y2) / 2 - C->y, 2)) + sqrt (pow (X2 - X1, 2)
		  + pow (Y2 - Y1, 2));
	if (C->a < d) {
	    t = atan (sqrt
		      ((d * d - C->a * C->a) / (C->a * C->a +
						C->b * C->b))) / 2 + M_PI_4;
	    b = (min < -t) ? (-t) : min;
	    e = (t < max) ? t : max;
	    if (b < e)
		draw_hyperbola_arc (C, b, e, flag);
	    b = (min < -t + M_PI) ? (-t + M_PI) : min;
	    e = (t + M_PI < max) ? (t + M_PI) : max;
	    if (b < e)
		draw_hyperbola_arc (C, b, e, flag);
	}
    }
}

void draw_conic (_conic * C, int flag)
{
    double d, t;
    default_frame ();
    switch (C->kind) {
    case PARABOLA:
	draw_parabola_arc (C, -OMEGA, OMEGA, flag);
	break;
    case ELLIPSE:
	draw_ellipse_arc (C, 0, 2 * M_PI, flag);
	break;
    case HYPERBOLA:
	d = sqrt (pow ((X1 + X2) / 2 - C->x, 2) +
		  pow ((Y1 + Y2) / 2 - C->y, 2)) + sqrt (pow (X2 - X1, 2)
		  + pow (Y2 - Y1, 2));
	if (C->a < d) {
	    t = atan (sqrt
		      ((d * d - C->a * C->a) / (C->a * C->a +
						C->b * C->b))) / 2 + M_PI_4;
	    draw_hyperbola_arc (C, -t, t, flag);
	    draw_hyperbola_arc (C, -t + M_PI, t + M_PI, flag);
	}
    }
}

void draw_digon(_point* A, _point* B, int flag1, int flag2)
{
    draw_stroke (A->x, A->y, B->x, B->y, flag1, flag2);
}

void draw_triangle (_point * A, _point * B, _point * C, int flag)
{
    GdkGC *tmp;
    default_frame ();
    tmp = gc (flag);
    gdk_draw_line (pixmap, tmp, X (A->x), Y (A->y), X (B->x), Y (B->y));
    gdk_draw_line (pixmap, tmp, X (B->x), Y (B->y), X (C->x), Y (C->y));
    gdk_draw_line (pixmap, tmp, X (C->x), Y (C->y), X (A->x), Y (A->y));
}

void draw_quadrilateral (_point * A, _point * B, _point * C, _point * D,
			 int flag)
{
    GdkGC *tmp;
    default_frame ();
    tmp = gc (flag);
    gdk_draw_line (pixmap, tmp, X (A->x), Y (A->y), X (B->x), Y (B->y));
    gdk_draw_line (pixmap, tmp, X (B->x), Y (B->y), X (C->x), Y (C->y));
    gdk_draw_line (pixmap, tmp, X (C->x), Y (C->y), X (D->x), Y (D->y));
    gdk_draw_line (pixmap, tmp, X (D->x), Y (D->y), X (A->x), Y (A->y));
}

void draw_pentagon (_point * A, _point * B, _point * C, _point * D,
		    _point * E, int flag)
{
    GdkGC *tmp;
    default_frame ();
    tmp = gc (flag);
    gdk_draw_line (pixmap, tmp, X (A->x), Y (A->y), X (B->x), Y (B->y));
    gdk_draw_line (pixmap, tmp, X (B->x), Y (B->y), X (C->x), Y (C->y));
    gdk_draw_line (pixmap, tmp, X (C->x), Y (C->y), X (D->x), Y (D->y));
    gdk_draw_line (pixmap, tmp, X (D->x), Y (D->y), X (E->x), Y (E->y));
    gdk_draw_line (pixmap, tmp, X (E->x), Y (E->y), X (A->x), Y (A->y));
}

void draw_hexagon (_point * A, _point * B, _point * C, _point * D, _point * E,
		   _point * F, int flag)
{
    GdkGC *tmp;
    default_frame ();
    tmp = gc (flag);
    gdk_draw_line (pixmap, tmp, X (A->x), Y (A->y), X (B->x), Y (B->y));
    gdk_draw_line (pixmap, tmp, X (B->x), Y (B->y), X (C->x), Y (C->y));
    gdk_draw_line (pixmap, tmp, X (C->x), Y (C->y), X (D->x), Y (D->y));
    gdk_draw_line (pixmap, tmp, X (D->x), Y (D->y), X (E->x), Y (E->y));
    gdk_draw_line (pixmap, tmp, X (E->x), Y (E->y), X (F->x), Y (F->y));
    gdk_draw_line (pixmap, tmp, X (F->x), Y (F->y), X (A->x), Y (A->y));
}

void draw_P_label (char *s, _point * A, double l, double a)
{
    default_frame ();
    gdk_draw_string (pixmap, font, solid_gc,
		     X (A->x + l * Cos (a)) - gdk_string_width (font, s) / 2,
		     Y (A->y + l * Sin (a)) + gdk_string_height (font, s) / 2,
		     s);
}

void draw_S_label (char *s, _segment * sg, double l, double a)
{
    default_frame ();
    gdk_draw_string (pixmap, font, solid_gc,
		     X ((sg->x1 + sg->x2) / 2 + l * Cos (a)) -
		     gdk_string_width (font, s) / 2,
		     Y ((sg->y1 + sg->y2) / 2 + l * Sin (a)) +
		     gdk_string_height (font, s) / 2, s);
}

void draw_P_N (double v, char *s, _point * A, double l, double a)
{
    char *tmp;

    default_frame ();
    tmp = (char *) malloc (64);
    snprintf (tmp, 63, s, v);
    gdk_draw_string (pixmap, font, solid_gc,
		     X (A->x + l * Cos (a)) - gdk_string_width (font, tmp) / 2,
		     Y (A->y + l * Sin (a)) + gdk_string_height (font, tmp) / 2,
		     tmp);
    free (tmp);
}

void draw_S_N (double v, char *s, _segment * sg, double l, double a)
{
    char *tmp;

    default_frame ();
    tmp = (char *) malloc (64);
    snprintf (tmp, 63, s, v);
    gdk_draw_string (pixmap, font, solid_gc,
		     X ((sg->x1 + sg->x2) / 2 + l * Cos (a)) -
		     gdk_string_width (font, tmp) / 2,
		     Y ((sg->y1 + sg->y2) / 2 + l * Sin (a)) +
		     gdk_string_height (font, tmp) / 2, tmp);
    free (tmp);
}

void draw_P_NN (double v1, double v2, char *s, _point * A, double l, double a)
{
    char *tmp;

    default_frame ();
    tmp = (char *) malloc (64);
    snprintf (tmp, 63, s, v1, v2);
    gdk_draw_string (pixmap, font, solid_gc,
		     X (A->x + l * Cos (a)) - gdk_string_width (font, tmp) / 2,
		     Y (A->y + l * Sin (a)) + gdk_string_height (font, tmp) / 2,
		     tmp);
    free (tmp);
}

void draw_S_NN (double v1, double v2, char *s, _segment * sg, double l,
		double a)
{
    char *tmp;

    default_frame ();
    tmp = (char *) malloc (64);
    snprintf (tmp, 63, s, v1, v2);
    gdk_draw_string (pixmap, font, solid_gc,
		     X ((sg->x1 + sg->x2) / 2 + l * Cos (a)) -
		     gdk_string_width (font, tmp) / 2,
		     Y ((sg->y1 + sg->y2) / 2 + l * Sin (a)) +
		     gdk_string_height (font, tmp) / 2, tmp);
    free (tmp);
}

void mark_S (_segment * sg, int flag, double sr)
{
    double x, y, a, c, s;

    default_frame ();

    x = (sg->x1 + sg->x2) / 2;
    y = (sg->y1 + sg->y2) / 2;
    a = S_angle (sg);
    s = .15 * Sin (a) * r * sr;
    c = .15 * Cos (a) * r * sr;
    switch (flag) {
    case SIMPLE:
	gdk_draw_line (pixmap, solid_gc, X (x - s), Y (y + c), X (x + s),
		       Y (y - c));
	break;
    case DOUBLE:
	gdk_draw_line (pixmap, solid_gc, X (x - s - .2 * c),
		       Y (y + c - .2 * s), X (x + s - .2 * c),
		       Y (y - c - .2 * s));
	gdk_draw_line (pixmap, solid_gc, X (x - s + .2 * c),
		       Y (y + c + .2 * s), X (x + s + .2 * c),
		       Y (y - c + .2 * s));
	break;
    case TRIPLE:
	gdk_draw_line (pixmap, solid_gc, X (x - s - .4 * c),
		       Y (y + c - .4 * s), X (x + s - .4 * c),
		       Y (y - c - .4 * s));
	gdk_draw_line (pixmap, solid_gc, X (x - s), Y (y + c), X (x + s),
		       Y (y - c));
	gdk_draw_line (pixmap, solid_gc, X (x - s + .4 * c),
		       Y (y + c + .4 * s), X (x + s + .4 * c),
		       Y (y - c + .4 * s));
	break;
    case CROSS:
	gdk_draw_line (pixmap, solid_gc, X (x - .7 * (s + c)),
		       Y (y + .7 * (c - s)), X (x + .7 * (s + c)),
		       Y (y - .7 * (c - s)));
	gdk_draw_line (pixmap, solid_gc, X (x - .7 * (s - c)),
		       Y (y + .7 * (c + s)), X (x + .7 * (s - c)),
		       Y (y - .7 * (c + s)));
    }
}

void mark_A (_point * A, _point * B, _point * C, int flag, double sr)
{
    double x, y, a1, a2, a, l, s, t, S;
    gint Xc, Yc;

    default_frame ();

    x = B->x;
    y = B->y;
    a1 = angle (A->x - x, A->y - y);
    a2 = angle (C->x - x, C->y - y);
    a = (a1 + a2) / 2 - ((a1 > a2) ? 180 : 0);
    l = a2 - a1;
    s = sr * r;
    t = .5 * s;
    S = sr * R;

    switch (flag) {
    case DOT:
	Xc = X (x + .175 * s * (Cos (a1) + Cos (a2)));
	Yc = Y (y + .175 * s * (Sin (a1) + Sin (a2)));
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, Xc - 2, Yc - 1, 5, 3);
	gdk_draw_line (pixmap, solid_gc, Xc - 1, Yc - 2, Xc + 1, Yc - 2);
	gdk_draw_line (pixmap, solid_gc, Xc - 1, Yc + 2, Xc + 1, Yc + 2);

    case SIMPLE:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t), Y (y + t),
		      S, S, 64 * a1, 64 * ((l > 0) ? l : (360 + l)));
	break;
    case DOUBLE:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t - .05 * r),
		      Y (y + t + .05 * r), S + .1 * R, S + .1 * R, 64 * a1,
		      64 * ((l > 0) ? l : (360 + l)));
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t + .05 * r),
		      Y (y + t - .05 * r), S - .1 * R, S - .1 * R, 64 * a1,
		      64 * ((l > 0) ? l : (360 + l)));
	break;
    case TRIPLE:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t + .08 * r),
		      Y (y + t - .08 * r), S - .16 * R, S - .16 * R, 64 * a1,
		      64 * ((l > 0) ? l : (360 + l)));
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t), Y (y + t), S, S,
		      64 * a1, 64 * ((l > 0) ? l : (360 + l)));
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t - .08 * r),
		      Y (y + t + .08 * r), S - .16 * R, S - .16 * R, 64 * a1,
		      64 * ((l > 0) ? l : (360 + l)));
	break;
    case ARROW:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t), Y (y + t),
		      S, S, 64 * a1, 64 * ((l > 0) ? l : (360 + l)));
	x += t * Cos (a2);
	y += t * Sin (a2);
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * r * Cos (a2 - 55)),
		       Y (y + .15 * r * Sin (a2 - 55)));
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * r * Cos (a2 - 135)),
		       Y (y + .15 * r * Sin (a2 - 135)));
	break;
    case BACKARROW:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t), Y (y + t),
		      S, S, 64 * a1, 64 * ((l > 0) ? l : (360 + l)));
	x += t * Cos (a1);
	y += t * Sin (a1);
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * r * Cos (a1 + 55)),
		       Y (y + .15 * r * Sin (a1 + 55)));
	gdk_draw_line (pixmap, solid_gc, X (x), Y (y),
		       X (x + .15 * r * Cos (a1 + 135)),
		       Y (y + .15 * r * Sin (a1 + 135)));
	break;
    case DASHED:
	gdk_draw_arc (pixmap, solid_gc, FALSE, X (x - t), Y (y + t),
		      S, S, 64 * a1, 64 * ((l > 0) ? l : (360 + l)));
	gdk_draw_line (pixmap, solid_gc, X (x + (t - .075 * r) * Cos (a)),
		       Y (y + (t - .075 * r) * Sin (a)),
		       X (x + (t + .075 * r) * Cos (a)),
		       Y (y + (t + .075 * r) * Sin (a)));
	break;
    case DOTTED:
	Xc = X (x + .175 * s * (Cos (a1) + Cos (a2)));
	Yc = Y (y + .175 * s * (Sin (a1) + Sin (a2)));
	gdk_draw_rectangle (pixmap, solid_gc, TRUE, Xc - 2, Yc - 1, 5, 3);
	gdk_draw_line (pixmap, solid_gc, Xc - 1, Yc - 2, Xc + 1, Yc - 2);
	gdk_draw_line (pixmap, solid_gc, Xc - 1, Yc + 2, Xc + 1, Yc + 2);

    case RIGHT:
	gdk_draw_line (pixmap, solid_gc, X (x + .35 * s * Cos (a1)),
		       Y (y + .35 * s * Sin (a1)),
		       X (x + .35 * s * (Cos (a1) + Cos (a2))),
		       Y (y + .35 * s * (Sin (a1) + Sin (a2))));
	gdk_draw_line (pixmap, solid_gc,
		       X (x + .35 * s * (Cos (a1) + Cos (a2))),
		       Y (y + .35 * s * (Sin (a1) + Sin (a2))),
		       X (x + .35 * s * Cos (a2)),
		       Y (y + .35 * s * Sin (a2)));
    }
}

void add_point (_point * A, int ind, int flag)
{
    static int num = 0;
    static int last = -1;
    GdkGC *tmp;

    default_frame ();
    
    if (ind == last || ind >= strokes) return;
    if (fabs (A->x) < 1e6 && fabs (A->y) < 1e6) {
	points[num].x = X (A->x);
	points[num].y = Y (A->y);
	num++;
	last = ind;
    }
    else {
	tmp = gc (flag);
	gdk_draw_lines (pixmap, tmp, points, num);
	num = 0;
    };

    if (ind == strokes - 1) {
	tmp = gc (flag);
	gdk_draw_lines (pixmap, tmp, points, num);
	num = 0;
	tracevar->object.number = tracebegin;
    }
}
