/*
 *
 * Copyright 2004 by Kenan Esau <kenan.esau@conan.de>, Baltmannsweiler, 
 * Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of copyright holders not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  The copyright holders
 * make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


#ifndef _evtouch_H_
#define _evtouch_H_


#ifdef EVDBG
#define DBGOUT(lvl, ...) (xf86ErrorFVerb(lvl, __VA_ARGS__))
#else 
#define DBGOUT(lvl, ...)
#endif

/******************************************************************************
 *  Definitions
 *  structs, typedefs, #defines, enums
 *****************************************************************************/
#define EV_ROTATE_NONE 0
#define EV_ROTATE_CW   1
#define EV_ROTATE_CCW  2
#define EV_ROTATE_UD   3

#define EV_AXIS_MIN_RES       0
#define EV_AXIS_MAX_RES       1024
#define EV_PAN_BORDER         12

#define EV_TIMEOUT            500

#define EV_MAX_BUTTONS        5

#define TOUCHED 0x01
#define X_COORD 0x02
#define Y_COORD 0x04
#define LB_STAT 0x08  /* LB up / down */
#define RB_STAT 0x10  /* RB up / down (both needed for 3-btn emu) */

#define BTN_PRESS   1
#define BTN_RELEASE 0

typedef struct _BtnActionRec
{
        int do_it;  /* if != 0 -> commit action */
        int action; /* button-press (1) or -release (0) */
} BtnAction, *BtnActionPtr;

typedef struct _EVTouchPrivateRec
{
        int diff[9][2];
        int min_x;  /* Minimum x reported by calibration        */
        int max_x;  /* Maximum x                    */
        int min_y;  /* Minimum y reported by calibration        */
        int max_y;  /* Maximum y                    */

        int min_rel_x;  /* Minimum x reported by calibration        */
        int max_rel_x;  /* Maximum x                    */
        int min_rel_y;  /* Minimum y reported by calibration        */
        int max_rel_y;  /* Maximum y                    */

        int drag_timer;
        Bool emulate3;
        int emulate3_timeout;
        OsTimerPtr emulate3_timer;
        Bool emulate3_timer_expired;
        Bool buttonless;

        unsigned char pressed_btn_stat;

        int calibrate;
        int fifo;  /*fd of the fifo used for communication with the calibration programm*/
        int timebase;

        int cur_x;
        int cur_y;
        int raw_x;
        int raw_y;
        /* pointers to the current viewport coordinates */
        int *pViewPort_X0;    /* Min X */
        int *pViewPort_X1;    /* Max X */
        int *pViewPort_Y0;    /* Min Y */
        int *pViewPort_Y1;    /* Max Y */
        int virtual;          /* virtual=1 indicates that there is a virtual screen */
        int rotate;           /* 90 deg CW, -90 deg CCW, default is 0 */
        Bool swap_y;           /* swap the y axis */
        Bool swap_x;           /* swap the x axis */
        int x;                /* x in screen coords */
        int y;                /* y in screen coords */
        int phys_width;       /* Physical X-Resolution */
        int phys_height;      /* Physical Y-Resolution */

        int untouch_time;
        int touch_time;
        int touch_x;
        int touch_y;
        int last_touch_x;
        int last_touch_y;
        unsigned char touch_flags; /* 1 - touched, 2 - x-coord received
                                      4 - y-coord received */
        BtnActionPtr btn_actions;
        int btn_count;    /* how many buttons does the device support */
        Bool pan_viewport;

        int button_number;   /* which button to report */
        int reporting_mode;   /* TS_Raw or TS_Scaled */

        int screen_num;    /* Screen associated with the device */
        int screen_width;   /* Width of the associated X screen  */
        int screen_height;   /* Height of the screen              */
        
        XISBuffer *buffer;
        struct input_event ev; /* packet being/just read */
        
        int packeti;    /* index into packet */
        Bool cs7flag;
        Bool binary_pkt;   /* indicates packet was a binary touch */

        int bin_byte;    /* bytes recieved in binary packet */

        LibTouchRecPtr libtouch;
        LocalDevicePtr local;
} EVTouchPrivateRec, *EVTouchPrivatePtr;


/******************************************************************************
 *  Declarations
 *****************************************************************************/

#ifdef LOG_RAW_PACKET
#define EVTouchDumpPacketToLog(priv) ( xf86ErrorFVerb(2, "EVTOUCHPCKT type=0x%02x code=0x%02x value=0x%02x\n",                                       priv->ev.type, priv->ev.code, priv->ev.value ) )
#else
#define EVTouchDumpPacketToLog(priv)
#endif

void trigger_sm(EVTouchPrivatePtr priv);

/* 
 *    DO NOT PUT ANYTHING AFTER THIS ENDIF
 */
#endif
